/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;

public class ResourceKeyArgument<T>
implements ArgumentType<ResourceKey<T>> {
    private static final Collection<String> a = Arrays.asList("foo", "foo:bar", "012");
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(featureType -> IChatBaseComponent.b("commands.place.feature.invalid", featureType));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(structureType -> IChatBaseComponent.b("commands.place.structure.invalid", structureType));
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(templatePoolType -> IChatBaseComponent.b("commands.place.jigsaw.invalid", templatePoolType));
    private static final DynamicCommandExceptionType e = new DynamicCommandExceptionType(recipe -> IChatBaseComponent.b("recipe.notFound", recipe));
    private static final DynamicCommandExceptionType f = new DynamicCommandExceptionType(advancement -> IChatBaseComponent.b("advancement.advancementNotFound", advancement));
    final ResourceKey<? extends IRegistry<T>> g;

    public ResourceKeyArgument(ResourceKey<? extends IRegistry<T>> registryKey) {
        this.g = registryKey;
    }

    public static <T> ResourceKeyArgument<T> a(ResourceKey<? extends IRegistry<T>> registryKey) {
        return new ResourceKeyArgument<T>(registryKey);
    }

    public static <T> ResourceKey<T> a(CommandContext<CommandListenerWrapper> context, String argument, ResourceKey<IRegistry<T>> registryKey, DynamicCommandExceptionType exception) throws CommandSyntaxException {
        ResourceKey resourceKey = (ResourceKey)context.getArgument(argument, ResourceKey.class);
        Optional<ResourceKey<T>> optional = resourceKey.d(registryKey);
        return optional.orElseThrow(() -> exception.create((Object)resourceKey.a()));
    }

    private static <T> IRegistry<T> a(CommandContext<CommandListenerWrapper> context, ResourceKey<? extends IRegistry<T>> registryKey) {
        return ((CommandListenerWrapper)context.getSource()).l().ba().f(registryKey);
    }

    private static <T> Holder.c<T> b(CommandContext<CommandListenerWrapper> context, String argument, ResourceKey<IRegistry<T>> registryKey, DynamicCommandExceptionType exception) throws CommandSyntaxException {
        ResourceKey registryKey1 = ResourceKeyArgument.a(context, argument, registryKey, exception);
        return (Holder.c)ResourceKeyArgument.a(context, registryKey).a(registryKey1).orElseThrow(() -> exception.create((Object)registryKey1.a()));
    }

    public static Holder.c<WorldGenFeatureConfigured<?, ?>> a(CommandContext<CommandListenerWrapper> context, String argument) throws CommandSyntaxException {
        return ResourceKeyArgument.b(context, argument, Registries.aL, b);
    }

    public static Holder.c<Structure> b(CommandContext<CommandListenerWrapper> context, String argument) throws CommandSyntaxException {
        return ResourceKeyArgument.b(context, argument, Registries.be, c);
    }

    public static Holder.c<WorldGenFeatureDefinedStructurePoolTemplate> c(CommandContext<CommandListenerWrapper> context, String argument) throws CommandSyntaxException {
        return ResourceKeyArgument.b(context, argument, Registries.bf, d);
    }

    public static RecipeHolder<?> d(CommandContext<CommandListenerWrapper> context, String argument) throws CommandSyntaxException {
        CraftingManager recipeManager = ((CommandListenerWrapper)context.getSource()).l().aI();
        ResourceKey<IRecipe<?>> registryKey = ResourceKeyArgument.a(context, argument, Registries.bv, e);
        return recipeManager.b(registryKey).orElseThrow(() -> e.create((Object)registryKey.a()));
    }

    public static AdvancementHolder e(CommandContext<CommandListenerWrapper> context, String argument) throws CommandSyntaxException {
        ResourceKey registryKey = ResourceKeyArgument.a(context, argument, Registries.bu, f);
        AdvancementHolder advancementHolder = ((CommandListenerWrapper)context.getSource()).l().aD().a(registryKey.a());
        if (advancementHolder == null) {
            throw f.create((Object)registryKey.a());
        }
        return advancementHolder;
    }

    public ResourceKey<T> a(StringReader reader) throws CommandSyntaxException {
        MinecraftKey resourceLocation = MinecraftKey.a(reader);
        return ResourceKey.a(this.g, resourceLocation);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        CompletableFuture<Suggestions> completableFuture;
        Object object = context.getSource();
        if (object instanceof ICompletionProvider) {
            ICompletionProvider sharedSuggestionProvider = (ICompletionProvider)object;
            completableFuture = sharedSuggestionProvider.a(this.g, ICompletionProvider.a.b, builder, context);
        } else {
            completableFuture = builder.buildFuture();
        }
        return completableFuture;
    }

    public Collection<String> getExamples() {
        return a;
    }

    public static class net.minecraft.commands.arguments.ResourceKeyArgument$a<T>
    implements ArgumentTypeInfo<ResourceKeyArgument<T>, a> {
        @Override
        public void a(a template, PacketDataSerializer buffer) {
            buffer.b(template.b);
        }

        @Override
        public a a(PacketDataSerializer buffer) {
            return new a(buffer.r());
        }

        @Override
        public void a(a template, JsonObject json) {
            json.addProperty("registry", template.b.a().toString());
        }

        @Override
        public a a(ResourceKeyArgument<T> argument) {
            return new a(argument.g);
        }

        public final class a
        implements ArgumentTypeInfo.a<ResourceKeyArgument<T>> {
            final ResourceKey<? extends IRegistry<T>> b;

            a(ResourceKey<? extends IRegistry<T>> registryKey) {
                this.b = registryKey;
            }

            public ResourceKeyArgument<T> a(CommandBuildContext context) {
                return new ResourceKeyArgument(this.b);
            }

            @Override
            public ArgumentTypeInfo<ResourceKeyArgument<T>, ?> a() {
                return a.this;
            }
        }
    }
}

