/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ResourceOrIdArgument<T>
implements ArgumentType<Holder<T>> {
    private static final Collection<String> b = List.of("foo", "foo:bar", "012", "{}", "true");
    public static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(object -> IChatBaseComponent.b("argument.resource_or_id.failed_to_parse", object));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.resource_or_id.invalid"));
    private static final MojangsonParser<?> d = MojangsonParser.a(DynamicOpsNBT.a);
    private final HolderLookup.a e;
    private final boolean f;
    private final Codec<Holder<T>> g;

    protected ResourceOrIdArgument(CommandBuildContext registryLookup, ResourceKey<IRegistry<T>> registryKey, Codec<Holder<T>> codec) {
        this.e = registryLookup;
        this.f = registryLookup.a(registryKey).isPresent();
        this.g = codec;
    }

    public static c a(CommandBuildContext context) {
        return new c(context);
    }

    public static Holder<LootTable> a(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ResourceOrIdArgument.d(context, name);
    }

    public static a b(CommandBuildContext context) {
        return new a(context);
    }

    public static Holder<LootItemFunction> b(CommandContext<CommandListenerWrapper> context, String name) {
        return ResourceOrIdArgument.d(context, name);
    }

    public static b c(CommandBuildContext context) {
        return new b(context);
    }

    public static Holder<LootItemCondition> c(CommandContext<CommandListenerWrapper> context, String name) {
        return ResourceOrIdArgument.d(context, name);
    }

    private static <T> Holder<T> d(CommandContext<CommandListenerWrapper> context, String name) {
        return (Holder)context.getArgument(name, Holder.class);
    }

    @Nullable
    public Holder<T> a(StringReader reader) throws CommandSyntaxException {
        return this.a(reader, d);
    }

    @Nullable
    private <O> Holder<T> a(StringReader reader, MojangsonParser<O> parser) throws CommandSyntaxException {
        RegistryOps<O> registryOps = this.e.a(parser.a());
        Dynamic<O> dynamic = ResourceOrIdArgument.a(registryOps, parser, reader);
        return !this.f ? null : (Holder)this.g.parse(dynamic).getOrThrow(string -> a.createWithContext((ImmutableStringReader)reader, string));
    }

    @VisibleForTesting
    static <T> Dynamic<T> a(DynamicOps<T> ops, MojangsonParser<T> tagParser, StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        T object = tagParser.b(reader);
        if (ResourceOrIdArgument.b(reader)) {
            return new Dynamic<T>(ops, object);
        }
        reader.setCursor(cursor);
        MinecraftKey resourceLocation = MinecraftKey.a(reader);
        if (ResourceOrIdArgument.b(reader)) {
            return new Dynamic<Object>(ops, ops.createString(resourceLocation.toString()));
        }
        reader.setCursor(cursor);
        throw c.createWithContext((ImmutableStringReader)reader);
    }

    private static boolean b(StringReader reader) {
        return !reader.canRead() || reader.peek() == ' ';
    }

    public Collection<String> getExamples() {
        return b;
    }

    public static class c
    extends ResourceOrIdArgument<LootTable> {
        protected c(CommandBuildContext context) {
            super(context, Registries.br, LootTable.e);
        }
    }

    public static class a
    extends ResourceOrIdArgument<LootItemFunction> {
        protected a(CommandBuildContext context) {
            super(context, Registries.bs, LootItemFunctions.d);
        }
    }

    public static class b
    extends ResourceOrIdArgument<LootItemCondition> {
        protected b(CommandBuildContext context) {
            super(context, Registries.bt, LootItemCondition.f);
        }
    }
}

