/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.coordinates.ArgumentParserPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;

public class ArgumentVectorPosition
implements IVectorPosition {
    public static final char a = '^';
    private final double b;
    private final double c;
    private final double d;

    public ArgumentVectorPosition(double left, double up, double forwards) {
        this.b = left;
        this.c = up;
        this.d = forwards;
    }

    @Override
    public Vec3D a(CommandListenerWrapper source) {
        Vec2F rotation = source.k();
        Vec3D vec3 = source.m().a(source);
        float cos = MathHelper.b((rotation.k + 90.0f) * ((float)Math.PI / 180));
        float sin = MathHelper.a((rotation.k + 90.0f) * ((float)Math.PI / 180));
        float cos1 = MathHelper.b(-rotation.j * ((float)Math.PI / 180));
        float sin1 = MathHelper.a(-rotation.j * ((float)Math.PI / 180));
        float cos2 = MathHelper.b((-rotation.j + 90.0f) * ((float)Math.PI / 180));
        float sin2 = MathHelper.a((-rotation.j + 90.0f) * ((float)Math.PI / 180));
        Vec3D vec31 = new Vec3D(cos * cos1, sin1, sin * cos1);
        Vec3D vec32 = new Vec3D(cos * cos2, sin2, sin * cos2);
        Vec3D vec33 = vec31.c(vec32).c(-1.0);
        double d2 = vec31.d * this.d + vec32.d * this.c + vec33.d * this.b;
        double d1 = vec31.e * this.d + vec32.e * this.c + vec33.e * this.b;
        double d22 = vec31.f * this.d + vec32.f * this.c + vec33.f * this.b;
        return new Vec3D(vec3.d + d2, vec3.e + d1, vec3.f + d22);
    }

    @Override
    public Vec2F b(CommandListenerWrapper source) {
        return Vec2F.a;
    }

    @Override
    public boolean a() {
        return true;
    }

    @Override
    public boolean b() {
        return true;
    }

    @Override
    public boolean c() {
        return true;
    }

    public static ArgumentVectorPosition a(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        double _double = ArgumentVectorPosition.a(reader, cursor);
        if (reader.canRead() && reader.peek() == ' ') {
            reader.skip();
            double _double1 = ArgumentVectorPosition.a(reader, cursor);
            if (reader.canRead() && reader.peek() == ' ') {
                reader.skip();
                double _double2 = ArgumentVectorPosition.a(reader, cursor);
                return new ArgumentVectorPosition(_double, _double1, _double2);
            }
            reader.setCursor(cursor);
            throw ArgumentVec3.a.createWithContext((ImmutableStringReader)reader);
        }
        reader.setCursor(cursor);
        throw ArgumentVec3.a.createWithContext((ImmutableStringReader)reader);
    }

    private static double a(StringReader reader, int start) throws CommandSyntaxException {
        if (!reader.canRead()) {
            throw ArgumentParserPosition.a.createWithContext((ImmutableStringReader)reader);
        }
        if (reader.peek() != '^') {
            reader.setCursor(start);
            throw ArgumentVec3.b.createWithContext((ImmutableStringReader)reader);
        }
        reader.skip();
        return reader.canRead() && reader.peek() != ' ' ? reader.readDouble() : 0.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof ArgumentVectorPosition)) return false;
        ArgumentVectorPosition localCoordinates = (ArgumentVectorPosition)other;
        if (this.b != localCoordinates.b) return false;
        if (this.c != localCoordinates.c) return false;
        if (this.d != localCoordinates.d) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.b, this.c, this.d);
    }
}

