/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector;

import com.google.common.primitives.Doubles;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionRange;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.options.PlayerSelector;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class ArgumentParserSelector {
    public static final char a = '@';
    private static final char o = '[';
    private static final char p = ']';
    public static final char b = '=';
    private static final char q = ',';
    public static final char c = '!';
    public static final char d = '#';
    private static final char r = 'p';
    private static final char s = 'a';
    private static final char t = 'r';
    private static final char u = 's';
    private static final char v = 'e';
    private static final char w = 'n';
    public static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.invalid"));
    public static final DynamicCommandExceptionType f = new DynamicCommandExceptionType(type -> IChatBaseComponent.b("argument.entity.selector.unknown", type));
    public static final SimpleCommandExceptionType g = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.selector.not_allowed"));
    public static final SimpleCommandExceptionType h = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.selector.missing"));
    public static final SimpleCommandExceptionType i = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.options.unterminated"));
    public static final DynamicCommandExceptionType j = new DynamicCommandExceptionType(value -> IChatBaseComponent.b("argument.entity.options.valueless", value));
    public static final BiConsumer<Vec3D, List<? extends Entity>> k = (pos, entities) -> entities.sort((entity1, entity2) -> Doubles.compare((double)entity1.g((Vec3D)pos), (double)entity2.g((Vec3D)pos)));
    public static final BiConsumer<Vec3D, List<? extends Entity>> l = (pos, entities) -> entities.sort((entity1, entity2) -> Doubles.compare((double)entity2.g((Vec3D)pos), (double)entity1.g((Vec3D)pos)));
    public static final BiConsumer<Vec3D, List<? extends Entity>> m = (pos, entities) -> Collections.shuffle(entities);
    public static final BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> n = (builder, consumer) -> builder.buildFuture();
    private final StringReader x;
    private final boolean y;
    private int z;
    private boolean A;
    private boolean B;
    private CriterionConditionValue.DoubleRange C = CriterionConditionValue.DoubleRange.c;
    private CriterionConditionValue.IntegerRange D = CriterionConditionValue.IntegerRange.c;
    @Nullable
    private Double E;
    @Nullable
    private Double F;
    @Nullable
    private Double G;
    @Nullable
    private Double H;
    @Nullable
    private Double I;
    @Nullable
    private Double J;
    private CriterionConditionRange K = CriterionConditionRange.a;
    private CriterionConditionRange L = CriterionConditionRange.a;
    private final List<Predicate<Entity>> M = new ArrayList<Predicate<Entity>>();
    private BiConsumer<Vec3D, List<? extends Entity>> N = EntitySelector.b;
    private boolean O;
    @Nullable
    private String P;
    private int Q;
    @Nullable
    private UUID R;
    private BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> S = n;
    private boolean T;
    private boolean U;
    private boolean V;
    private boolean W;
    private boolean X;
    private boolean Y;
    private boolean Z;
    private boolean aa;
    @Nullable
    private EntityTypes<?> ab;
    private boolean ac;
    private boolean ad;
    private boolean ae;
    private boolean af;

    public ArgumentParserSelector(StringReader reader, boolean allowSelectors) {
        this.x = reader;
        this.y = allowSelectors;
    }

    public static <S> boolean a(S suggestionProvider) {
        ICompletionProvider sharedSuggestionProvider;
        if (suggestionProvider instanceof CommandListenerWrapper) {
            CommandListenerWrapper stack = (CommandListenerWrapper)suggestionProvider;
            return stack.bypassSelectorPermissions || stack.hasPermission(2, "minecraft.command.selector");
        }
        return suggestionProvider instanceof ICompletionProvider && (sharedSuggestionProvider = (ICompletionProvider)suggestionProvider).c(2);
    }

    public EntitySelector a() {
        AxisAlignedBB aabb;
        if (this.H == null && this.I == null && this.J == null) {
            if (this.C.b().isPresent()) {
                double d2 = this.C.b().get();
                aabb = new AxisAlignedBB(-d2, -d2, -d2, d2 + 1.0, d2 + 1.0, d2 + 1.0);
            } else {
                aabb = null;
            }
        } else {
            aabb = this.a(this.H == null ? 0.0 : this.H, this.I == null ? 0.0 : this.I, this.J == null ? 0.0 : this.J);
        }
        Function<Vec3D, Vec3D> function = this.E == null && this.F == null && this.G == null ? vec3 -> vec3 : vec3 -> new Vec3D(this.E == null ? vec3.d : this.E, this.F == null ? vec3.e : this.F, this.G == null ? vec3.f : this.G);
        return new EntitySelector(this.z, this.A, this.B, List.copyOf(this.M), this.C, function, aabb, this.N, this.O, this.P, this.R, this.ab, this.af);
    }

    private AxisAlignedBB a(double sizeX, double sizeY, double sizeZ) {
        boolean flag = sizeX < 0.0;
        boolean flag1 = sizeY < 0.0;
        boolean flag2 = sizeZ < 0.0;
        double d2 = flag ? sizeX : 0.0;
        double d1 = flag1 ? sizeY : 0.0;
        double d22 = flag2 ? sizeZ : 0.0;
        double d3 = (flag ? 0.0 : sizeX) + 1.0;
        double d4 = (flag1 ? 0.0 : sizeY) + 1.0;
        double d5 = (flag2 ? 0.0 : sizeZ) + 1.0;
        return new AxisAlignedBB(d2, d1, d22, d3, d4, d5);
    }

    private void I() {
        if (this.K != CriterionConditionRange.a) {
            this.M.add(this.a(this.K, Entity::dN));
        }
        if (this.L != CriterionConditionRange.a) {
            this.M.add(this.a(this.L, Entity::dL));
        }
        if (!this.D.c()) {
            this.M.add(entity -> entity instanceof EntityPlayer && this.D.d(((EntityPlayer)entity).cf));
        }
    }

    private Predicate<Entity> a(CriterionConditionRange angleBounds, ToDoubleFunction<Entity> angleFunction) {
        double d2 = MathHelper.h(angleBounds.b() == null ? 0.0f : angleBounds.b().floatValue());
        double d1 = MathHelper.h(angleBounds.c() == null ? 359.0f : angleBounds.c().floatValue());
        return entity -> {
            double d3 = MathHelper.d(angleFunction.applyAsDouble((Entity)entity));
            return d2 > d1 ? d3 >= d2 || d3 <= d1 : d3 >= d2 && d3 <= d1;
        };
    }

    protected void parseSelector(boolean overridePermissions) throws CommandSyntaxException {
        block10: {
            this.af = !overridePermissions;
            this.S = this::d;
            if (!this.x.canRead()) {
                throw h.createWithContext((ImmutableStringReader)this.x);
            }
            int cursor = this.x.getCursor();
            char c2 = this.x.read();
            switch (c2) {
                case 'a': {
                    this.z = Integer.MAX_VALUE;
                    this.A = false;
                    this.N = EntitySelector.b;
                    this.a(EntityTypes.bT);
                    break block10;
                }
                default: {
                    this.x.setCursor(cursor);
                    throw f.createWithContext((ImmutableStringReader)this.x, (Object)("@" + c2));
                }
                case 'e': {
                    this.z = Integer.MAX_VALUE;
                    this.A = true;
                    this.N = EntitySelector.b;
                    break;
                }
                case 'n': {
                    this.z = 1;
                    this.A = true;
                    this.N = k;
                    break;
                }
                case 'p': {
                    this.z = 1;
                    this.A = false;
                    this.N = k;
                    this.a(EntityTypes.bT);
                    break block10;
                }
                case 'r': {
                    this.z = 1;
                    this.A = false;
                    this.N = m;
                    this.a(EntityTypes.bT);
                    break block10;
                }
                case 's': {
                    this.z = 1;
                    this.A = true;
                    this.O = true;
                    break block10;
                }
            }
            this.M.add(Entity::bJ);
        }
        this.S = this::e;
        if (this.x.canRead() && this.x.peek() == '[') {
            this.x.skip();
            this.S = this::f;
            this.d();
        }
    }

    protected void c() throws CommandSyntaxException {
        if (this.x.canRead()) {
            this.S = this::c;
        }
        int cursor = this.x.getCursor();
        String string = this.x.readString();
        try {
            this.R = UUID.fromString(string);
            this.A = true;
        }
        catch (IllegalArgumentException var4) {
            if (string.isEmpty() || string.length() > 16) {
                this.x.setCursor(cursor);
                throw e.createWithContext((ImmutableStringReader)this.x);
            }
            this.A = false;
            this.P = string;
        }
        this.z = 1;
    }

    protected void d() throws CommandSyntaxException {
        this.S = this::g;
        this.x.skipWhitespace();
        while (this.x.canRead() && this.x.peek() != ']') {
            this.x.skipWhitespace();
            int cursor = this.x.getCursor();
            String string = this.x.readString();
            PlayerSelector.a modifier = PlayerSelector.a(this, string, cursor);
            this.x.skipWhitespace();
            if (!this.x.canRead() || this.x.peek() != '=') {
                this.x.setCursor(cursor);
                throw j.createWithContext((ImmutableStringReader)this.x, (Object)string);
            }
            this.x.skip();
            this.x.skipWhitespace();
            this.S = n;
            modifier.handle(this);
            this.x.skipWhitespace();
            this.S = this::h;
            if (!this.x.canRead()) continue;
            if (this.x.peek() != ',') {
                if (this.x.peek() == ']') break;
                throw i.createWithContext((ImmutableStringReader)this.x);
            }
            this.x.skip();
            this.S = this::g;
        }
        if (!this.x.canRead()) {
            throw i.createWithContext((ImmutableStringReader)this.x);
        }
        this.x.skip();
        this.S = n;
    }

    public boolean e() {
        this.x.skipWhitespace();
        if (this.x.canRead() && this.x.peek() == '!') {
            this.x.skip();
            this.x.skipWhitespace();
            return true;
        }
        return false;
    }

    public boolean f() {
        this.x.skipWhitespace();
        if (this.x.canRead() && this.x.peek() == '#') {
            this.x.skip();
            this.x.skipWhitespace();
            return true;
        }
        return false;
    }

    public StringReader g() {
        return this.x;
    }

    public void a(Predicate<Entity> predicate) {
        this.M.add(predicate);
    }

    public void h() {
        this.B = true;
    }

    public CriterionConditionValue.DoubleRange i() {
        return this.C;
    }

    public void a(CriterionConditionValue.DoubleRange distance) {
        this.C = distance;
    }

    public CriterionConditionValue.IntegerRange j() {
        return this.D;
    }

    public void a(CriterionConditionValue.IntegerRange level) {
        this.D = level;
    }

    public CriterionConditionRange k() {
        return this.K;
    }

    public void a(CriterionConditionRange rotX) {
        this.K = rotX;
    }

    public CriterionConditionRange l() {
        return this.L;
    }

    public void b(CriterionConditionRange rotY) {
        this.L = rotY;
    }

    @Nullable
    public Double m() {
        return this.E;
    }

    @Nullable
    public Double n() {
        return this.F;
    }

    @Nullable
    public Double o() {
        return this.G;
    }

    public void a(double x2) {
        this.E = x2;
    }

    public void b(double y2) {
        this.F = y2;
    }

    public void c(double z2) {
        this.G = z2;
    }

    public void d(double deltaX) {
        this.H = deltaX;
    }

    public void e(double deltaY) {
        this.I = deltaY;
    }

    public void f(double deltaZ) {
        this.J = deltaZ;
    }

    @Nullable
    public Double p() {
        return this.H;
    }

    @Nullable
    public Double q() {
        return this.I;
    }

    @Nullable
    public Double r() {
        return this.J;
    }

    public void a(int maxResults) {
        this.z = maxResults;
    }

    public void a(boolean includesEntities) {
        this.A = includesEntities;
    }

    public BiConsumer<Vec3D, List<? extends Entity>> s() {
        return this.N;
    }

    public void a(BiConsumer<Vec3D, List<? extends Entity>> order) {
        this.N = order;
    }

    public EntitySelector t() throws CommandSyntaxException {
        return this.parse(false);
    }

    public EntitySelector parse(boolean overridePermissions) throws CommandSyntaxException {
        this.Q = this.x.getCursor();
        this.S = this::b;
        if (this.x.canRead() && this.x.peek() == '@') {
            if (!this.y) {
                throw g.createWithContext((ImmutableStringReader)this.x);
            }
            this.x.skip();
            this.parseSelector(overridePermissions);
        } else {
            this.c();
        }
        this.I();
        return this.a();
    }

    private static void a(SuggestionsBuilder builder) {
        builder.suggest("@p", (Message)IChatBaseComponent.c("argument.entity.selector.nearestPlayer"));
        builder.suggest("@a", (Message)IChatBaseComponent.c("argument.entity.selector.allPlayers"));
        builder.suggest("@r", (Message)IChatBaseComponent.c("argument.entity.selector.randomPlayer"));
        builder.suggest("@s", (Message)IChatBaseComponent.c("argument.entity.selector.self"));
        builder.suggest("@e", (Message)IChatBaseComponent.c("argument.entity.selector.allEntities"));
        builder.suggest("@n", (Message)IChatBaseComponent.c("argument.entity.selector.nearestEntity"));
    }

    private CompletableFuture<Suggestions> b(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        consumer.accept(builder);
        if (this.y) {
            ArgumentParserSelector.a(builder);
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> c(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        SuggestionsBuilder suggestionsBuilder = builder.createOffset(this.Q);
        consumer.accept(suggestionsBuilder);
        return builder.add(suggestionsBuilder).buildFuture();
    }

    private CompletableFuture<Suggestions> d(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        SuggestionsBuilder suggestionsBuilder = builder.createOffset(builder.getStart() - 1);
        ArgumentParserSelector.a(suggestionsBuilder);
        builder.add(suggestionsBuilder);
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> e(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest(String.valueOf('['));
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> f(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest(String.valueOf(']'));
        PlayerSelector.a(this, builder);
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> g(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        PlayerSelector.a(this, builder);
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> h(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest(String.valueOf(','));
        builder.suggest(String.valueOf(']'));
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> i(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest(String.valueOf('='));
        return builder.buildFuture();
    }

    public boolean u() {
        return this.O;
    }

    public void a(BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> suggestionHandler) {
        this.S = suggestionHandler;
    }

    public CompletableFuture<Suggestions> a(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        return this.S.apply(builder.createOffset(this.x.getCursor()), consumer);
    }

    public boolean v() {
        return this.T;
    }

    public void b(boolean hasNameEquals) {
        this.T = hasNameEquals;
    }

    public boolean w() {
        return this.U;
    }

    public void c(boolean hasNameNotEquals) {
        this.U = hasNameNotEquals;
    }

    public boolean x() {
        return this.V;
    }

    public void d(boolean isLimited) {
        this.V = isLimited;
    }

    public boolean y() {
        return this.W;
    }

    public void e(boolean isSorted) {
        this.W = isSorted;
    }

    public boolean z() {
        return this.X;
    }

    public void f(boolean hasGamemodeEquals) {
        this.X = hasGamemodeEquals;
    }

    public boolean A() {
        return this.Y;
    }

    public void g(boolean hasGamemodeNotEquals) {
        this.Y = hasGamemodeNotEquals;
    }

    public boolean B() {
        return this.Z;
    }

    public void h(boolean hasTeamEquals) {
        this.Z = hasTeamEquals;
    }

    public boolean C() {
        return this.aa;
    }

    public void i(boolean hasTeamNotEquals) {
        this.aa = hasTeamNotEquals;
    }

    public void a(EntityTypes<?> type) {
        this.ab = type;
    }

    public void D() {
        this.ac = true;
    }

    public boolean E() {
        return this.ab != null;
    }

    public boolean F() {
        return this.ac;
    }

    public boolean G() {
        return this.ad;
    }

    public void j(boolean hasScores) {
        this.ad = hasScores;
    }

    public boolean H() {
        return this.ae;
    }

    public void k(boolean hasAdvancements) {
        this.ae = hasAdvancements;
    }
}

