/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.base.MoreObjects;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.stream.IntStream;
import javax.annotation.concurrent.Immutable;
import net.minecraft.SystemUtils;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.LevelHeightAccessor;

@Immutable
public class BaseBlockPosition
implements Comparable<BaseBlockPosition> {
    public static final Codec<BaseBlockPosition> g = Codec.INT_STREAM.comapFlatMap(vec3i -> SystemUtils.a(vec3i, 3).map(positions -> new BaseBlockPosition(positions[0], positions[1], positions[2])), vec3i -> IntStream.of(vec3i.u(), vec3i.v(), vec3i.w()));
    public static final StreamCodec<ByteBuf, BaseBlockPosition> h = StreamCodec.a(ByteBufCodecs.h, BaseBlockPosition::u, ByteBufCodecs.h, BaseBlockPosition::v, ByteBufCodecs.h, BaseBlockPosition::w, BaseBlockPosition::new);
    public static final BaseBlockPosition i = new BaseBlockPosition(0, 0, 0);
    protected int a;
    protected int b;
    protected int c;

    public static Codec<BaseBlockPosition> v(int maxOffset) {
        return g.validate(vec3i -> Math.abs(vec3i.u()) < maxOffset && Math.abs(vec3i.v()) < maxOffset && Math.abs(vec3i.w()) < maxOffset ? DataResult.success((Object)vec3i) : DataResult.error(() -> "Position out of range, expected at most " + maxOffset + ": " + String.valueOf(vec3i)));
    }

    public BaseBlockPosition(int x2, int y2, int z2) {
        this.a = x2;
        this.b = y2;
        this.c = z2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof BaseBlockPosition)) return false;
        BaseBlockPosition vec3i = (BaseBlockPosition)other;
        if (this.u() != vec3i.u()) return false;
        if (this.v() != vec3i.v()) return false;
        if (this.w() != vec3i.w()) return false;
        return true;
    }

    public final int hashCode() {
        return (this.v() + this.w() * 31) * 31 + this.u();
    }

    public int i(BaseBlockPosition other) {
        if (this.v() == other.v()) {
            return this.w() == other.w() ? this.u() - other.u() : this.w() - other.w();
        }
        return this.v() - other.v();
    }

    public final int u() {
        return this.a;
    }

    public final int v() {
        return this.b;
    }

    public final int w() {
        return this.c;
    }

    protected BaseBlockPosition u(int x2) {
        this.a = x2;
        return this;
    }

    protected BaseBlockPosition t(int y2) {
        this.b = y2;
        return this;
    }

    protected BaseBlockPosition s(int z2) {
        this.c = z2;
        return this;
    }

    public BaseBlockPosition c(int dx, int dy, int dz) {
        return dx == 0 && dy == 0 && dz == 0 ? this : new BaseBlockPosition(this.u() + dx, this.v() + dy, this.w() + dz);
    }

    public BaseBlockPosition f(BaseBlockPosition vector) {
        return this.c(vector.u(), vector.v(), vector.w());
    }

    public BaseBlockPosition e(BaseBlockPosition vector) {
        return this.c(-vector.u(), -vector.v(), -vector.w());
    }

    public BaseBlockPosition o(int scalar) {
        if (scalar == 1) {
            return this;
        }
        return scalar == 0 ? i : new BaseBlockPosition(this.u() * scalar, this.v() * scalar, this.w() * scalar);
    }

    public BaseBlockPosition q() {
        return this.n(1);
    }

    public BaseBlockPosition n(int distance) {
        return this.b(EnumDirection.b, distance);
    }

    public BaseBlockPosition p() {
        return this.m(1);
    }

    public BaseBlockPosition m(int distance) {
        return this.b(EnumDirection.a, distance);
    }

    public BaseBlockPosition o() {
        return this.l(1);
    }

    public BaseBlockPosition l(int distance) {
        return this.b(EnumDirection.c, distance);
    }

    public BaseBlockPosition n() {
        return this.k(1);
    }

    public BaseBlockPosition k(int distance) {
        return this.b(EnumDirection.d, distance);
    }

    public BaseBlockPosition m() {
        return this.j(1);
    }

    public BaseBlockPosition j(int distance) {
        return this.b(EnumDirection.e, distance);
    }

    public BaseBlockPosition l() {
        return this.i(1);
    }

    public BaseBlockPosition i(int distance) {
        return this.b(EnumDirection.f, distance);
    }

    public BaseBlockPosition b(EnumDirection direction) {
        return this.b(direction, 1);
    }

    public BaseBlockPosition b(EnumDirection direction, int distance) {
        return distance == 0 ? this : new BaseBlockPosition(this.u() + direction.j() * distance, this.v() + direction.k() * distance, this.w() + direction.l() * distance);
    }

    public BaseBlockPosition b(EnumDirection.EnumAxis axis, int amount) {
        if (amount == 0) {
            return this;
        }
        int i2 = axis == EnumDirection.EnumAxis.a ? amount : 0;
        int i1 = axis == EnumDirection.EnumAxis.b ? amount : 0;
        int i22 = axis == EnumDirection.EnumAxis.c ? amount : 0;
        return new BaseBlockPosition(this.u() + i2, this.v() + i1, this.w() + i22);
    }

    public BaseBlockPosition d(BaseBlockPosition vector) {
        return new BaseBlockPosition(this.v() * vector.w() - this.w() * vector.v(), this.w() * vector.u() - this.u() * vector.w(), this.u() * vector.v() - this.v() * vector.u());
    }

    public boolean a(BaseBlockPosition vector, double distance) {
        return this.j(vector) < MathHelper.k(distance);
    }

    public boolean a(IPosition position, double distance) {
        return this.b(position) < MathHelper.k(distance);
    }

    public double j(BaseBlockPosition vector) {
        return this.d(vector.u(), vector.v(), vector.w());
    }

    public double b(IPosition position) {
        return this.c(position.a(), position.b(), position.c());
    }

    public double c(double x2, double y2, double z2) {
        double d2 = (double)this.u() + 0.5 - x2;
        double d1 = (double)this.v() + 0.5 - y2;
        double d22 = (double)this.w() + 0.5 - z2;
        return d2 * d2 + d1 * d1 + d22 * d22;
    }

    public double d(double x2, double y2, double z2) {
        double d2 = (double)this.u() - x2;
        double d1 = (double)this.v() - y2;
        double d22 = (double)this.w() - z2;
        return d2 * d2 + d1 * d1 + d22 * d22;
    }

    public int k(BaseBlockPosition vector) {
        float f2 = Math.abs(vector.u() - this.u());
        float f1 = Math.abs(vector.v() - this.v());
        float f22 = Math.abs(vector.w() - this.w());
        return (int)(f2 + f1 + f22);
    }

    public int l(BaseBlockPosition vector) {
        int abs = Math.abs(this.u() - vector.u());
        int abs1 = Math.abs(this.v() - vector.v());
        int abs2 = Math.abs(this.w() - vector.w());
        return Math.max(Math.max(abs, abs1), abs2);
    }

    public int a(EnumDirection.EnumAxis axis) {
        return axis.a(this.a, this.b, this.c);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.u()).add("y", this.v()).add("z", this.w()).toString();
    }

    public String x() {
        return this.u() + ", " + this.v() + ", " + this.w();
    }

    public final boolean isInsideBuildHeightAndWorldBoundsHorizontal(LevelHeightAccessor levelHeightAccessor) {
        return this.u() >= -30000000 && this.w() >= -30000000 && this.u() < 30000000 && this.w() < 30000000 && !levelHeightAccessor.e(this.v());
    }
}

