/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.ResourceKey;

public class LayeredRegistryAccess<T> {
    private final List<T> a;
    private final List<IRegistryCustom.Dimension> b;
    private final IRegistryCustom.Dimension c;

    public LayeredRegistryAccess(List<T> keys) {
        this(keys, SystemUtils.a(() -> {
            Object[] frozens = new IRegistryCustom.Dimension[keys.size()];
            Arrays.fill(frozens, IRegistryCustom.b);
            return Arrays.asList(frozens);
        }));
    }

    private LayeredRegistryAccess(List<T> keys, List<IRegistryCustom.Dimension> values) {
        this.a = List.copyOf(keys);
        this.b = List.copyOf(values);
        this.c = new IRegistryCustom.c(LayeredRegistryAccess.a(values.stream())).e();
    }

    private int d(T key) {
        int index = this.a.indexOf(key);
        if (index == -1) {
            throw new IllegalStateException("Can't find " + String.valueOf(key) + " inside " + String.valueOf(this.a));
        }
        return index;
    }

    public IRegistryCustom.Dimension a(T key) {
        int layerIndexOrThrow = this.d(key);
        return this.b.get(layerIndexOrThrow);
    }

    public IRegistryCustom.Dimension b(T key) {
        int layerIndexOrThrow = this.d(key);
        return this.a(0, layerIndexOrThrow);
    }

    public IRegistryCustom.Dimension c(T key) {
        int layerIndexOrThrow = this.d(key);
        return this.a(layerIndexOrThrow, this.b.size());
    }

    private IRegistryCustom.Dimension a(int startIndex, int endIndex) {
        return new IRegistryCustom.c(LayeredRegistryAccess.a(this.b.subList(startIndex, endIndex).stream())).e();
    }

    public LayeredRegistryAccess<T> a(T key, IRegistryCustom.Dimension ... values) {
        return this.a(key, Arrays.asList(values));
    }

    public LayeredRegistryAccess<T> a(T key, List<IRegistryCustom.Dimension> values) {
        int layerIndexOrThrow = this.d(key);
        if (values.size() > this.b.size() - layerIndexOrThrow) {
            throw new IllegalStateException("Too many values to replace");
        }
        ArrayList<IRegistryCustom.Dimension> list = new ArrayList<IRegistryCustom.Dimension>();
        for (int i2 = 0; i2 < layerIndexOrThrow; ++i2) {
            list.add(this.b.get(i2));
        }
        list.addAll(values);
        while (list.size() < this.b.size()) {
            list.add(IRegistryCustom.b);
        }
        return new LayeredRegistryAccess<T>(this.a, list);
    }

    public IRegistryCustom.Dimension a() {
        return this.c;
    }

    private static Map<ResourceKey<? extends IRegistry<?>>, IRegistry<?>> a(Stream<? extends IRegistryCustom> accesses) {
        HashMap map = new HashMap();
        accesses.forEach(access -> access.a().forEach(registry -> {
            if (map.put(registry.a(), registry.b()) != null) {
                throw new IllegalStateException("Duplicated registry " + String.valueOf(registry.a()));
            }
        }));
        return map;
    }
}

