/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.cauldron;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.event.block.CauldronLevelChangeEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;

public interface CauldronInteraction {
    public static final Map<String, a> a = new Object2ObjectArrayMap();
    public static final Codec<a> b = Codec.stringResolver(a::a, a::get);
    public static final a c = CauldronInteraction.a("empty");
    public static final a d = CauldronInteraction.a("water");
    public static final a e = CauldronInteraction.a("lava");
    public static final a f = CauldronInteraction.a("powder_snow");

    public static a a(String name) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        map.defaultReturnValue((state, level, pos, player, hand, stack, hitDirection) -> EnumInteractionResult.f);
        a interactionMap = new a(name, (Map<Item, CauldronInteraction>)map);
        a.put(name, interactionMap);
        return interactionMap;
    }

    public EnumInteractionResult interact(IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, ItemStack var6, EnumDirection var7);

    public static void a() {
        Map<Item, CauldronInteraction> map = c.b();
        CauldronInteraction.a(map);
        map.put(Items.tt, (state, level, pos, player, hand, stack, hitDirection) -> {
            PotionContents potionContents = stack.a(DataComponents.R);
            if (potionContents != null && potionContents.a(Potions.a)) {
                if (!level.C) {
                    if (!LayeredCauldronBlock.changeLevel(level, pos, Blocks.fT.m(), player, CauldronLevelChangeEvent.ChangeReason.BOTTLE_EMPTY, false)) {
                        return EnumInteractionResult.a;
                    }
                    Item item = stack.h();
                    player.a(hand, ItemLiquidUtil.a(stack, player, new ItemStack(Items.ts)));
                    player.a(StatisticList.W);
                    player.b(StatisticList.c.b(item));
                    level.a(null, pos, SoundEffects.cB, SoundCategory.e, 1.0f, 1.0f);
                    level.a(null, GameEvent.z, pos);
                }
                return EnumInteractionResult.a;
            }
            return EnumInteractionResult.f;
        });
        Map<Item, CauldronInteraction> map1 = d.b();
        CauldronInteraction.a(map1);
        map1.put(Items.ro, (state, level, pos, player, hand, stack, hitDirection) -> CauldronInteraction.fillBucket(state, level, pos, player, hand, stack, new ItemStack(Items.rp), blockState -> blockState.c(LayeredCauldronBlock.f) == 3, SoundEffects.dj, hitDirection));
        map1.put(Items.ts, (state, level, pos, player, hand, stack, hitDirection) -> {
            if (!level.C) {
                if (!LayeredCauldronBlock.lowerFillLevel(state, level, pos, player, CauldronLevelChangeEvent.ChangeReason.BOTTLE_FILL)) {
                    return EnumInteractionResult.a;
                }
                Item item = stack.h();
                player.a(hand, ItemLiquidUtil.a(stack, player, PotionContents.a(Items.tt, Potions.a)));
                player.a(StatisticList.W);
                player.b(StatisticList.c.b(item));
                level.a(null, pos, SoundEffects.cC, SoundCategory.e, 1.0f, 1.0f);
                level.a(null, GameEvent.y, pos);
            }
            return EnumInteractionResult.a;
        });
        map1.put(Items.tt, (state, level, pos, player, hand, stack, hitDirection) -> {
            if (state.c(LayeredCauldronBlock.f) == 3) {
                return EnumInteractionResult.f;
            }
            PotionContents potionContents = stack.a(DataComponents.R);
            if (potionContents != null && potionContents.a(Potions.a)) {
                if (!level.C) {
                    if (!LayeredCauldronBlock.changeLevel(level, pos, (IBlockData)state.a(LayeredCauldronBlock.f), player, CauldronLevelChangeEvent.ChangeReason.BOTTLE_EMPTY, false)) {
                        return EnumInteractionResult.a;
                    }
                    player.a(hand, ItemLiquidUtil.a(stack, player, new ItemStack(Items.ts)));
                    player.a(StatisticList.W);
                    player.b(StatisticList.c.b(stack.h()));
                    level.a(null, pos, SoundEffects.cB, SoundCategory.e, 1.0f, 1.0f);
                    level.a(null, GameEvent.z, pos);
                }
                return EnumInteractionResult.a;
            }
            return EnumInteractionResult.f;
        });
        map1.put(Items.qp, CauldronInteraction::dyedItemIteration);
        map1.put(Items.qo, CauldronInteraction::dyedItemIteration);
        map1.put(Items.qn, CauldronInteraction::dyedItemIteration);
        map1.put(Items.qm, CauldronInteraction::dyedItemIteration);
        map1.put(Items.vU, CauldronInteraction::dyedItemIteration);
        map1.put(Items.pf, CauldronInteraction::dyedItemIteration);
        map1.put(Items.wa, CauldronInteraction::bannerInteraction);
        map1.put(Items.wh, CauldronInteraction::bannerInteraction);
        map1.put(Items.wp, CauldronInteraction::bannerInteraction);
        map1.put(Items.wl, CauldronInteraction::bannerInteraction);
        map1.put(Items.wm, CauldronInteraction::bannerInteraction);
        map1.put(Items.wj, CauldronInteraction::bannerInteraction);
        map1.put(Items.wn, CauldronInteraction::bannerInteraction);
        map1.put(Items.wd, CauldronInteraction::bannerInteraction);
        map1.put(Items.wi, CauldronInteraction::bannerInteraction);
        map1.put(Items.wf, CauldronInteraction::bannerInteraction);
        map1.put(Items.wc, CauldronInteraction::bannerInteraction);
        map1.put(Items.wb, CauldronInteraction::bannerInteraction);
        map1.put(Items.wg, CauldronInteraction::bannerInteraction);
        map1.put(Items.wk, CauldronInteraction::bannerInteraction);
        map1.put(Items.wo, CauldronInteraction::bannerInteraction);
        map1.put(Items.we, CauldronInteraction::bannerInteraction);
        map1.put(Items.jH, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jO, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jW, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jS, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jT, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jQ, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jU, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jK, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jP, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jM, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jJ, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jI, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jN, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jR, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jV, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jL, CauldronInteraction::shulkerBoxInteraction);
        Map<Item, CauldronInteraction> map2 = e.b();
        map2.put(Items.ro, (state, level, pos, player, hand, stack, hitDirection) -> CauldronInteraction.fillBucket(state, level, pos, player, hand, stack, new ItemStack(Items.rq), blockState -> true, SoundEffects.dm, hitDirection));
        CauldronInteraction.a(map2);
        Map<Item, CauldronInteraction> map3 = f.b();
        map3.put(Items.ro, (state, level, pos, player, hand, stack, hitDirection) -> CauldronInteraction.fillBucket(state, level, pos, player, hand, stack, new ItemStack(Items.rr), blockState -> blockState.c(LayeredCauldronBlock.f) == 3, SoundEffects.dn, hitDirection));
        CauldronInteraction.a(map3);
    }

    public static void a(Map<Item, CauldronInteraction> interactionsMap) {
        interactionsMap.put(Items.rq, CauldronInteraction::fillLavaInteraction);
        interactionsMap.put(Items.rp, CauldronInteraction::fillWaterInteraction);
        interactionsMap.put(Items.rr, CauldronInteraction::fillPowderSnowInteraction);
    }

    public static EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, ItemStack emptyStack, ItemStack filledStack, Predicate<IBlockData> statePredicate, SoundEffect fillSound) {
        return CauldronInteraction.fillBucket(state, level, pos, player, hand, emptyStack, filledStack, statePredicate, fillSound, null);
    }

    public static EnumInteractionResult fillBucket(IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, ItemStack emptyStack, ItemStack filledStack, Predicate<IBlockData> statePredicate, SoundEffect fillSound, @Nullable EnumDirection hitDirection) {
        if (!statePredicate.test(state)) {
            return EnumInteractionResult.f;
        }
        if (!level.C) {
            if (hitDirection != null) {
                PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent(level, player, pos, pos, hitDirection, emptyStack, filledStack.h(), hand);
                if (event.isCancelled()) {
                    return EnumInteractionResult.e;
                }
                ItemStack itemStack = filledStack = event.getItemStack() != null ? CraftItemStack.asNMSCopy(event.getItemStack()) : ItemStack.l;
            }
            if (!LayeredCauldronBlock.changeLevel(level, pos, Blocks.fS.m(), player, CauldronLevelChangeEvent.ChangeReason.BUCKET_FILL, false)) {
                return EnumInteractionResult.a;
            }
            Item item = emptyStack.h();
            player.a(hand, ItemLiquidUtil.a(emptyStack, player, filledStack));
            player.a(StatisticList.W);
            player.b(StatisticList.c.b(item));
            level.a(null, pos, fillSound, SoundCategory.e, 1.0f, 1.0f);
            level.a(null, GameEvent.y, pos);
        }
        return EnumInteractionResult.a;
    }

    public static EnumInteractionResult a(World level, BlockPosition pos, EntityHuman player, EnumHand hand, ItemStack filledStackl, IBlockData state, SoundEffect emptySound) {
        return CauldronInteraction.emptyBucket(level, pos, player, hand, filledStackl, state, emptySound, null);
    }

    public static EnumInteractionResult emptyBucket(World level, BlockPosition pos, EntityHuman player, EnumHand hand, ItemStack filledStackl, IBlockData state, SoundEffect emptySound, @Nullable EnumDirection hitDirection) {
        if (!level.C) {
            ItemStack output = new ItemStack(Items.ro);
            if (hitDirection != null) {
                PlayerBucketEmptyEvent event = CraftEventFactory.callPlayerBucketEmptyEvent(level, player, pos, pos, hitDirection, filledStackl, hand);
                if (event.isCancelled()) {
                    return EnumInteractionResult.e;
                }
                ItemStack itemStack = output = event.getItemStack() != null ? CraftItemStack.asNMSCopy(event.getItemStack()) : ItemStack.l;
            }
            if (!LayeredCauldronBlock.changeLevel(level, pos, state, player, CauldronLevelChangeEvent.ChangeReason.BUCKET_EMPTY, false)) {
                return EnumInteractionResult.a;
            }
            Item item = filledStackl.h();
            player.a(hand, ItemLiquidUtil.a(filledStackl, player, output));
            player.a(StatisticList.V);
            player.b(StatisticList.c.b(item));
            level.a(null, pos, emptySound, SoundCategory.e, 1.0f, 1.0f);
            level.a(null, GameEvent.z, pos);
        }
        return EnumInteractionResult.a;
    }

    private static EnumInteractionResult fillWaterInteraction(IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, ItemStack filledStack, EnumDirection hitDirection) {
        return CauldronInteraction.emptyBucket(level, pos, player, hand, filledStack, (IBlockData)Blocks.fT.m().b(LayeredCauldronBlock.f, 3), SoundEffects.dd, hitDirection);
    }

    private static EnumInteractionResult fillLavaInteraction(IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, ItemStack filledStack, EnumDirection hitDirection) {
        return CauldronInteraction.a(level, pos) ? EnumInteractionResult.c : CauldronInteraction.emptyBucket(level, pos, player, hand, filledStack, Blocks.fU.m(), SoundEffects.dg, hitDirection);
    }

    private static EnumInteractionResult fillPowderSnowInteraction(IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, ItemStack filledStack, EnumDirection hitDirection) {
        return CauldronInteraction.a(level, pos) ? EnumInteractionResult.c : CauldronInteraction.emptyBucket(level, pos, player, hand, filledStack, (IBlockData)Blocks.fV.m().b(LayeredCauldronBlock.f, 3), SoundEffects.dh, hitDirection);
    }

    private static EnumInteractionResult shulkerBoxInteraction(IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, ItemStack stack, EnumDirection hitDirection) {
        Block block = Block.a(stack.h());
        if (!(block instanceof BlockShulkerBox)) {
            return EnumInteractionResult.f;
        }
        if (!level.C) {
            if (!LayeredCauldronBlock.lowerFillLevel(state, level, pos, player, CauldronLevelChangeEvent.ChangeReason.SHULKER_WASH)) {
                return EnumInteractionResult.a;
            }
            ItemStack itemStack = stack.a(Blocks.lv, 1);
            player.a(hand, ItemLiquidUtil.a(stack, player, itemStack, false));
            player.a(StatisticList.Z);
        }
        return EnumInteractionResult.a;
    }

    private static EnumInteractionResult bannerInteraction(IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, ItemStack stack, EnumDirection hitDirection) {
        BannerPatternLayers bannerPatternLayers = stack.a(DataComponents.am, BannerPatternLayers.a);
        if (bannerPatternLayers.b().isEmpty()) {
            return EnumInteractionResult.f;
        }
        if (!level.C) {
            if (!LayeredCauldronBlock.lowerFillLevel(state, level, pos, player, CauldronLevelChangeEvent.ChangeReason.BANNER_WASH)) {
                return EnumInteractionResult.a;
            }
            ItemStack itemStack = stack.c(1);
            itemStack.b(DataComponents.am, bannerPatternLayers.a());
            player.a(hand, ItemLiquidUtil.a(stack, player, itemStack, false));
            player.a(StatisticList.Y);
        }
        return EnumInteractionResult.a;
    }

    private static EnumInteractionResult dyedItemIteration(IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, ItemStack stack, EnumDirection hitDirection) {
        if (!stack.a(TagsItem.bQ)) {
            return EnumInteractionResult.f;
        }
        if (!stack.c(DataComponents.K)) {
            return EnumInteractionResult.f;
        }
        if (!level.C) {
            if (!LayeredCauldronBlock.lowerFillLevel(state, level, pos, player, CauldronLevelChangeEvent.ChangeReason.ARMOR_WASH)) {
                return EnumInteractionResult.a;
            }
            stack.e(DataComponents.K);
            player.a(StatisticList.X);
        }
        return EnumInteractionResult.a;
    }

    private static boolean a(World level, BlockPosition pos) {
        Fluid fluidState = level.b_(pos.d());
        return fluidState.a(TagsFluid.a);
    }

    public record a(String a, Map<Item, CauldronInteraction> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "name;map", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "name;map", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "name;map", "a", "b"}, this, o2);
        }
    }
}

