/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftVector;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;

public class MinecartDispenseItemBehavior
extends DispenseBehaviorItem {
    private final DispenseBehaviorItem c = new DispenseBehaviorItem();
    private final EntityTypes<? extends EntityMinecartAbstract> d;

    public MinecartDispenseItemBehavior(EntityTypes<? extends EntityMinecartAbstract> entityType) {
        this.d = entityType;
    }

    @Override
    public net.minecraft.world.item.ItemStack a(SourceBlock blockSource, net.minecraft.world.item.ItemStack item) {
        double d3;
        EnumDirection direction = blockSource.d().c(BlockDispenser.b);
        WorldServer serverLevel = blockSource.b();
        Vec3D vec3 = blockSource.a();
        double d2 = vec3.a() + (double)direction.j() * 1.125;
        double d1 = Math.floor(vec3.b()) + (double)direction.k();
        double d22 = vec3.c() + (double)direction.l() * 1.125;
        BlockPosition blockPos = blockSource.c().a(direction);
        IBlockData blockState = serverLevel.a_(blockPos);
        if (blockState.a(TagsBlock.P)) {
            d3 = MinecartDispenseItemBehavior.a(blockState).b() ? 0.6 : 0.1;
        } else {
            if (!blockState.l()) {
                return this.c.dispense(blockSource, item);
            }
            IBlockData blockState1 = serverLevel.a_(blockPos.e());
            if (!blockState1.a(TagsBlock.P)) {
                return this.c.dispense(blockSource, item);
            }
            d3 = direction != EnumDirection.a && MinecartDispenseItemBehavior.a(blockState1).b() ? -0.4 : -0.9;
        }
        Vec3D vec31 = new Vec3D(d2, d1 + d3, d22);
        net.minecraft.world.item.ItemStack itemstack1 = item.c(1);
        CraftBlock block2 = CraftBlock.at(serverLevel, blockSource.c());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
        BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block2, (ItemStack)craftItem.clone(), CraftVector.toBukkit(vec31));
        serverLevel.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return item;
        }
        boolean shrink = true;
        if (!event.getItem().equals((Object)craftItem)) {
            shrink = false;
            net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            IDispenseBehavior dispenseItemBehavior = BlockDispenser.getDispenseBehavior(blockSource, eventStack);
            if (dispenseItemBehavior != IDispenseBehavior.b && dispenseItemBehavior != this) {
                dispenseItemBehavior.dispense(blockSource, eventStack);
                return item;
            }
        }
        itemstack1 = CraftItemStack.asNMSCopy(event.getItem());
        EntityMinecartAbstract abstractMinecart = EntityMinecartAbstract.a(serverLevel, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ(), this.d, EntitySpawnReason.o, itemstack1, null);
        if (abstractMinecart != null && serverLevel.b(abstractMinecart) && shrink) {
            item.h(1);
        }
        return item;
    }

    private static BlockPropertyTrackPosition a(IBlockData state) {
        BlockPropertyTrackPosition blockPropertyTrackPosition;
        Block block = state.b();
        if (block instanceof BlockMinecartTrackAbstract) {
            BlockMinecartTrackAbstract baseRailBlock = (BlockMinecartTrackAbstract)block;
            blockPropertyTrackPosition = state.c(baseRailBlock.c());
        } else {
            blockPropertyTrackPosition = BlockPropertyTrackPosition.a;
        }
        return blockPropertyTrackPosition;
    }

    @Override
    protected void a(SourceBlock blockSource) {
        blockSource.b().c(1000, blockSource.c(), 0);
    }
}

