/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.registries;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.registry.PaperRegistryAccess;
import io.papermc.paper.registry.PaperRegistryListenerManager;
import io.papermc.paper.registry.data.util.Conversions;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicates;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.DefaultedMappedRegistry;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.predicates.DataComponentPredicate;
import net.minecraft.core.component.predicates.DataComponentPredicates;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.BuiltinTestFunctions;
import net.minecraft.gametest.framework.GameTestHarnessHelper;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.network.chat.numbers.NumberFormatType;
import net.minecraft.network.chat.numbers.NumberFormatTypes;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.valueproviders.FloatProviderType;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.entity.variant.SpawnCondition;
import net.minecraft.world.entity.variant.SpawnConditions;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplays;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplays;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.enchantment.providers.EnchantmentProviderTypes;
import net.minecraft.world.level.biome.BiomeSources;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTypes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.DecoratedPotPattern;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGenerators;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverAbstract;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacers;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProviders;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacers;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBindings;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifierType;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProviders;
import org.apache.commons.lang3.Validate;
import org.bukkit.Registry;
import org.slf4j.Logger;

public class BuiltInRegistries {
    private static final Logger aG = LogUtils.getLogger();
    private static final Map<MinecraftKey, Supplier<?>> aH = Maps.newLinkedHashMap();
    private static final IRegistryWritable<IRegistryWritable<?>> aI = new RegistryMaterials(ResourceKey.a(Registries.a), Lifecycle.stable());
    public static final RegistryBlocks<GameEvent> a = BuiltInRegistries.a(Registries.H, "step", GameEvent::a);
    public static final IRegistry<SoundEffect> b = BuiltInRegistries.a(Registries.ap, (IRegistry<T> registry) -> SoundEffects.oj);
    public static final RegistryBlocks<FluidType> c = BuiltInRegistries.b(Registries.F, "empty", registry -> FluidTypes.a);
    public static final IRegistry<MobEffectList> d = BuiltInRegistries.a(Registries.W, MobEffects::a);
    public static final RegistryBlocks<Block> e = BuiltInRegistries.b(Registries.i, "air", registry -> Blocks.a);
    public static final RegistryBlocks<EntityTypes<?>> f = BuiltInRegistries.b(Registries.B, "pig", registry -> EntityTypes.aR);
    public static final RegistryBlocks<Item> g = BuiltInRegistries.b(Registries.K, "air", registry -> Items.a);
    public static final IRegistry<PotionRegistry> h = BuiltInRegistries.a(Registries.ae, Potions::a);
    public static final IRegistry<Particle<?>> i = BuiltInRegistries.a(Registries.Y, (IRegistry<T> registry) -> Particles.b);
    public static final IRegistry<TileEntityTypes<?>> j = BuiltInRegistries.b(Registries.e, registry -> TileEntityTypes.a);
    public static final IRegistry<MinecraftKey> k = BuiltInRegistries.a(Registries.p, (IRegistry<T> registry) -> StatisticList.E);
    public static final RegistryBlocks<ChunkStatus> l = BuiltInRegistries.a(Registries.l, "empty", (IRegistry<T> registry) -> ChunkStatus.c);
    public static final IRegistry<DefinedStructureRuleTestType<?>> m = BuiltInRegistries.a(Registries.al, (IRegistry<T> registry) -> DefinedStructureRuleTestType.a);
    public static final IRegistry<RuleBlockEntityModifierType<?>> n = BuiltInRegistries.a(Registries.ak, (IRegistry<T> registry) -> RuleBlockEntityModifierType.b);
    public static final IRegistry<PosRuleTestType<?>> o = BuiltInRegistries.a(Registries.ad, (IRegistry<T> registry) -> PosRuleTestType.a);
    public static final IRegistry<Containers<?>> p = BuiltInRegistries.a(Registries.V, (IRegistry<T> registry) -> Containers.i);
    public static final IRegistry<Recipes<?>> q = BuiltInRegistries.a(Registries.ai, (IRegistry<T> registry) -> Recipes.a);
    public static final IRegistry<RecipeSerializer<?>> r = BuiltInRegistries.a(Registries.ah, (IRegistry<T> registry) -> RecipeSerializer.b);
    public static final IRegistry<AttributeBase> s = BuiltInRegistries.a(Registries.c, GenericAttributes::a);
    public static final IRegistry<PositionSourceType<?>> t = BuiltInRegistries.a(Registries.ac, (IRegistry<T> registry) -> PositionSourceType.a);
    public static final IRegistry<ArgumentTypeInfo<?, ?>> u = BuiltInRegistries.a(Registries.m, ArgumentTypeInfos::a);
    public static final IRegistry<StatisticWrapper<?>> v = BuiltInRegistries.a(Registries.ar, (IRegistry<T> registry) -> StatisticList.c);
    public static final RegistryBlocks<VillagerType> w = BuiltInRegistries.a(Registries.aE, "plains", VillagerType::a);
    public static final RegistryBlocks<VillagerProfession> x = BuiltInRegistries.a(Registries.aD, "none", VillagerProfession::a);
    public static final IRegistry<VillagePlaceType> y = BuiltInRegistries.a(Registries.aa, PoiTypes::a);
    public static final RegistryBlocks<MemoryModuleType<?>> z = BuiltInRegistries.a(Registries.U, "dummy", (IRegistry<T> registry) -> MemoryModuleType.a);
    public static final RegistryBlocks<SensorType<?>> A = BuiltInRegistries.a(Registries.an, "dummy", (IRegistry<T> registry) -> SensorType.a);
    public static final IRegistry<Schedule> B = BuiltInRegistries.a(Registries.am, (IRegistry<T> registry) -> Schedule.c);
    public static final IRegistry<Activity> C = BuiltInRegistries.a(Registries.b, (IRegistry<T> registry) -> Activity.b);
    public static final IRegistry<LootEntryType> D = BuiltInRegistries.a(Registries.P, (IRegistry<T> registry) -> LootEntries.b);
    public static final IRegistry<LootItemFunctionType<?>> E = BuiltInRegistries.a(Registries.M, (IRegistry<T> registry) -> LootItemFunctions.e);
    public static final IRegistry<LootItemConditionType> F = BuiltInRegistries.a(Registries.L, (IRegistry<T> registry) -> LootItemConditions.a);
    public static final IRegistry<LootNumberProviderType> G = BuiltInRegistries.a(Registries.O, (IRegistry<T> registry) -> NumberProviders.b);
    public static final IRegistry<LootNbtProviderType> H = BuiltInRegistries.a(Registries.N, (IRegistry<T> registry) -> NbtProviders.c);
    public static final IRegistry<LootScoreProviderType> I = BuiltInRegistries.a(Registries.Q, (IRegistry<T> registry) -> ScoreboardNameProviders.c);
    public static final IRegistry<FloatProviderType<?>> J = BuiltInRegistries.a(Registries.E, (IRegistry<T> registry) -> FloatProviderType.a);
    public static final IRegistry<IntProviderType<?>> K = BuiltInRegistries.a(Registries.J, (IRegistry<T> registry) -> IntProviderType.a);
    public static final IRegistry<HeightProviderType<?>> L = BuiltInRegistries.a(Registries.I, (IRegistry<T> registry) -> HeightProviderType.a);
    public static final IRegistry<BlockPredicateType<?>> M = BuiltInRegistries.a(Registries.f, (IRegistry<T> registry) -> BlockPredicateType.k);
    public static final IRegistry<WorldGenCarverAbstract<?>> N = BuiltInRegistries.a(Registries.j, (IRegistry<T> registry) -> WorldGenCarverAbstract.a);
    public static final IRegistry<WorldGenerator<?>> O = BuiltInRegistries.a(Registries.D, (IRegistry<T> registry) -> WorldGenerator.J);
    public static final IRegistry<StructurePlacementType<?>> P = BuiltInRegistries.a(Registries.at, (IRegistry<T> registry) -> StructurePlacementType.a);
    public static final IRegistry<WorldGenFeatureStructurePieceType> Q = BuiltInRegistries.a(Registries.as, (IRegistry<T> registry) -> WorldGenFeatureStructurePieceType.c);
    public static final IRegistry<StructureType<?>> R = BuiltInRegistries.a(Registries.aw, (IRegistry<T> registry) -> StructureType.f);
    public static final IRegistry<PlacementModifierType<?>> S = BuiltInRegistries.a(Registries.Z, (IRegistry<T> registry) -> PlacementModifierType.f);
    public static final IRegistry<WorldGenFeatureStateProviders<?>> T = BuiltInRegistries.a(Registries.g, (IRegistry<T> registry) -> WorldGenFeatureStateProviders.a);
    public static final IRegistry<WorldGenFoilagePlacers<?>> U = BuiltInRegistries.a(Registries.G, (IRegistry<T> registry) -> WorldGenFoilagePlacers.a);
    public static final IRegistry<TrunkPlacers<?>> V = BuiltInRegistries.a(Registries.aC, (IRegistry<T> registry) -> TrunkPlacers.a);
    public static final IRegistry<RootPlacerType<?>> W = BuiltInRegistries.a(Registries.aj, (IRegistry<T> registry) -> RootPlacerType.a);
    public static final IRegistry<WorldGenFeatureTrees<?>> X = BuiltInRegistries.a(Registries.aB, (IRegistry<T> registry) -> WorldGenFeatureTrees.b);
    public static final IRegistry<FeatureSizeType<?>> Y = BuiltInRegistries.a(Registries.C, (IRegistry<T> registry) -> FeatureSizeType.a);
    public static final IRegistry<MapCodec<? extends WorldChunkManager>> Z = BuiltInRegistries.a(Registries.d, BiomeSources::a);
    public static final IRegistry<MapCodec<? extends ChunkGenerator>> aa = BuiltInRegistries.a(Registries.k, ChunkGenerators::a);
    public static final IRegistry<MapCodec<? extends SurfaceRules.f>> ab = BuiltInRegistries.a(Registries.S, SurfaceRules.f::a);
    public static final IRegistry<MapCodec<? extends SurfaceRules.o>> ac = BuiltInRegistries.a(Registries.T, SurfaceRules.o::a);
    public static final IRegistry<MapCodec<? extends DensityFunction>> ad = BuiltInRegistries.a(Registries.t, DensityFunctions::a);
    public static final IRegistry<MapCodec<? extends Block>> ae = BuiltInRegistries.a(Registries.h, BlockTypes::a);
    public static final IRegistry<DefinedStructureStructureProcessorType<?>> af = BuiltInRegistries.a(Registries.av, (IRegistry<T> registry) -> DefinedStructureStructureProcessorType.e);
    public static final IRegistry<WorldGenFeatureDefinedStructurePools<?>> ag = BuiltInRegistries.a(Registries.au, (IRegistry<T> registry) -> WorldGenFeatureDefinedStructurePools.d);
    public static final IRegistry<MapCodec<? extends PoolAliasBinding>> ah = BuiltInRegistries.a(Registries.ab, PoolAliasBindings::a);
    public static final IRegistry<DecoratedPotPattern> ai = BuiltInRegistries.a(Registries.s, DecoratedPotPatterns::a);
    public static final IRegistry<CreativeModeTab> aj = BuiltInRegistries.a(Registries.o, CreativeModeTabs::a);
    public static final IRegistry<CriterionTrigger<?>> ak = BuiltInRegistries.a(Registries.bj, CriterionTriggers::a);
    public static final IRegistry<NumberFormatType<?>> al = BuiltInRegistries.a(Registries.X, NumberFormatTypes::a);
    public static final IRegistry<DataComponentType<?>> am = BuiltInRegistries.a(Registries.r, DataComponents::a);
    public static final IRegistry<MapCodec<? extends EntitySubPredicate>> an = BuiltInRegistries.a(Registries.A, EntitySubPredicates::a);
    public static final IRegistry<DataComponentPredicate.b<?>> ao = BuiltInRegistries.a(Registries.q, DataComponentPredicates::a);
    public static final IRegistry<MapDecorationType> ap = BuiltInRegistries.a(Registries.R, MapDecorationTypes::a);
    public static final IRegistry<DataComponentType<?>> aq = BuiltInRegistries.a(Registries.u, EnchantmentEffectComponents::a);
    public static final IRegistry<MapCodec<? extends LevelBasedValue>> ar = BuiltInRegistries.a(Registries.w, LevelBasedValue::a);
    public static final IRegistry<MapCodec<? extends EnchantmentEntityEffect>> as = BuiltInRegistries.a(Registries.v, EnchantmentEntityEffect::a);
    public static final IRegistry<MapCodec<? extends EnchantmentLocationBasedEffect>> at = BuiltInRegistries.a(Registries.x, EnchantmentLocationBasedEffect::b);
    public static final IRegistry<MapCodec<? extends EnchantmentValueEffect>> au = BuiltInRegistries.a(Registries.z, EnchantmentValueEffect::a);
    public static final IRegistry<MapCodec<? extends EnchantmentProvider>> av = BuiltInRegistries.a(Registries.y, EnchantmentProviderTypes::a);
    public static final IRegistry<ConsumeEffect.a<?>> aw = BuiltInRegistries.a(Registries.n, (IRegistry<T> registry) -> ConsumeEffect.a.a);
    public static final IRegistry<RecipeDisplay.a<?>> ax = BuiltInRegistries.a(Registries.ag, RecipeDisplays::a);
    public static final IRegistry<SlotDisplay.i<?>> ay = BuiltInRegistries.a(Registries.ao, SlotDisplays::a);
    public static final IRegistry<RecipeBookCategory> az = BuiltInRegistries.a(Registries.af, RecipeBookCategories::a);
    public static final IRegistry<TicketType> aA = BuiltInRegistries.a(Registries.aA, (IRegistry<T> registry) -> TicketType.i);
    public static final IRegistry<MapCodec<? extends TestEnvironmentDefinition>> aB = BuiltInRegistries.a(Registries.ax, TestEnvironmentDefinition::a);
    public static final IRegistry<MapCodec<? extends GameTestInstance>> aC = BuiltInRegistries.a(Registries.az, GameTestInstance::a);
    public static final IRegistry<MapCodec<? extends SpawnCondition>> aD = BuiltInRegistries.a(Registries.aq, SpawnConditions::a);
    public static final IRegistry<Consumer<GameTestHarnessHelper>> aE = BuiltInRegistries.a(Registries.ay, BuiltinTestFunctions::a);
    public static final IRegistry<? extends IRegistry<?>> aF = aI;
    public static final Conversions BUILT_IN_CONVERSIONS = new Conversions(new RegistryOps.c(){

        @Override
        public <T> Optional<RegistryOps.b<T>> a(ResourceKey<? extends IRegistry<? extends T>> registryRef) {
            IRegistry registry = RegistryLayer.f.f(registryRef);
            return Optional.of(new RegistryOps.b(registry, registry, Lifecycle.experimental()));
        }
    });

    private static <T> IRegistry<T> a(ResourceKey<? extends IRegistry<T>> key, a<T> bootstrap) {
        return BuiltInRegistries.a(key, new RegistryMaterials(key, Lifecycle.stable(), false), bootstrap);
    }

    private static <T> IRegistry<T> b(ResourceKey<? extends IRegistry<T>> key, a<T> bootstrap) {
        return BuiltInRegistries.a(key, new RegistryMaterials(key, Lifecycle.stable(), true), bootstrap);
    }

    private static <T> RegistryBlocks<T> a(ResourceKey<? extends IRegistry<T>> key, String defaultKey, a<T> bootstrap) {
        return BuiltInRegistries.a(key, new DefaultedMappedRegistry(defaultKey, key, Lifecycle.stable(), false), bootstrap);
    }

    private static <T> RegistryBlocks<T> b(ResourceKey<? extends IRegistry<T>> key, String defaultKey, a<T> bootstrap) {
        return BuiltInRegistries.a(key, new DefaultedMappedRegistry(defaultKey, key, Lifecycle.stable(), true), bootstrap);
    }

    private static <T, R extends IRegistryWritable<T>> R a(ResourceKey<? extends IRegistry<T>> key, R registry, a<T> bootstrap) {
        DispenserRegistry.a(() -> "registry " + String.valueOf(key.a()));
        PaperRegistryAccess.instance().registerRegistry(registry.g(), registry);
        MinecraftKey resourceLocation = key.a();
        aH.put(resourceLocation, () -> bootstrap.run(registry));
        aI.a(key, registry, RegistrationInfo.a);
        return registry;
    }

    public static void a() {
        BuiltInRegistries.bootStrap(() -> {});
    }

    public static void bootStrap(Runnable runnable) {
        aF.n();
        BuiltInRegistries.b();
        runnable.run();
        BuiltInRegistries.c();
        BuiltInRegistries.b(aF);
    }

    private static void b() {
        try {
            Class.forName(Registry.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        aH.forEach((resourceLocation, supplier) -> {
            if (supplier.get() == null) {
                aG.error("Unable to bootstrap registry '{}'", resourceLocation);
            }
            PaperRegistryAccess.instance().lockReferenceHolders(ResourceKey.a(resourceLocation));
        });
    }

    private static void c() {
        aF.n();
        for (IRegistry iRegistry : aF) {
            BuiltInRegistries.c(iRegistry);
            PaperRegistryListenerManager.INSTANCE.runFreezeListeners(iRegistry.g(), BUILT_IN_CONVERSIONS);
            iRegistry.n();
        }
    }

    private static <T extends IRegistry<?>> void b(IRegistry<T> registry) {
        registry.forEach(registry1 -> {
            if (registry1.i().isEmpty()) {
                SystemUtils.b("Registry '" + String.valueOf(registry.b(registry1)) + "' was empty after loading");
            }
            if (registry1 instanceof RegistryBlocks) {
                MinecraftKey defaultKey = ((RegistryBlocks)registry1).b();
                Validate.notNull(registry1.a(defaultKey), (String)("Missing default of DefaultedMappedRegistry: " + String.valueOf(defaultKey)), (Object[])new Object[0]);
            }
        });
    }

    public static <T> HolderGetter<T> a(IRegistry<T> registry) {
        return ((IRegistryWritable)registry).p();
    }

    private static void c(IRegistry<?> registry) {
        ((RegistryMaterials)registry).o();
    }

    @FunctionalInterface
    static interface a<T> {
        public Object run(IRegistry<T> var1);
    }
}

