/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.info;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import org.slf4j.Logger;

public class BiomeParametersDumpReport
implements DebugReportProvider {
    private static final Logger d = LogUtils.getLogger();
    private final Path e;
    private final CompletableFuture<HolderLookup.a> f;
    private static final MapCodec<ResourceKey<BiomeBase>> g = ResourceKey.a(Registries.aG).fieldOf("biome");
    private static final Codec<Climate.c<ResourceKey<BiomeBase>>> h = Climate.c.a(g).fieldOf("biomes").codec();

    public BiomeParametersDumpReport(PackOutput output, CompletableFuture<HolderLookup.a> registries) {
        this.e = output.a(PackOutput.b.c).resolve("biome_parameters");
        this.f = registries;
    }

    @Override
    public CompletableFuture<?> a(CachedOutput output) {
        return this.f.thenCompose(lookupProvider -> {
            RegistryOps dynamicOps = lookupProvider.a(JsonOps.INSTANCE);
            ArrayList list = new ArrayList();
            MultiNoiseBiomeSourceParameterList.b().forEach((preset, parameters) -> list.add(BiomeParametersDumpReport.a(this.a(preset.b()), output, dynamicOps, h, parameters)));
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        });
    }

    private static <E> CompletableFuture<?> a(Path path, CachedOutput output, DynamicOps<JsonElement> ops, Encoder<E> encoder, E value) {
        Optional optional = encoder.encodeStart(ops, value).resultOrPartial(error -> d.error("Couldn't serialize element {}: {}", (Object)path, error));
        return optional.isPresent() ? DebugReportProvider.a(output, (JsonElement)optional.get(), path) : CompletableFuture.completedFuture(null);
    }

    private Path a(MinecraftKey location) {
        return this.e.resolve(location.b()).resolve(location.a() + ".json");
    }

    @Override
    public final String a() {
        return "Biome Parameters";
    }
}

