/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.info;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTypes;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class BlockListReport
implements DebugReportProvider {
    private final PackOutput d;
    private final CompletableFuture<HolderLookup.a> e;

    public BlockListReport(PackOutput output, CompletableFuture<HolderLookup.a> registries) {
        this.d = output;
        this.e = registries;
    }

    @Override
    public CompletableFuture<?> a(CachedOutput output) {
        Path path = this.d.a(PackOutput.b.c).resolve("blocks.json");
        return this.e.thenCompose(provider -> {
            JsonObject jsonObject = new JsonObject();
            RegistryOps registryOps = provider.a(JsonOps.INSTANCE);
            provider.e(Registries.i).c().forEach(reference -> {
                JsonObject jsonObject1 = new JsonObject();
                BlockStateList<Block, IBlockData> stateDefinition = ((Block)reference.a()).l();
                if (!stateDefinition.d().isEmpty()) {
                    JsonObject jsonObject2 = new JsonObject();
                    for (IBlockState iBlockState : stateDefinition.d()) {
                        JsonArray jsonArray = new JsonArray();
                        for (Comparable comparable : iBlockState.a()) {
                            jsonArray.add(SystemUtils.a(iBlockState, comparable));
                        }
                        jsonObject2.add(iBlockState.f(), (JsonElement)jsonArray);
                    }
                    jsonObject1.add("properties", (JsonElement)jsonObject2);
                }
                JsonArray jsonArray1 = new JsonArray();
                for (IBlockData iBlockData : stateDefinition.a()) {
                    JsonObject jsonObject3 = new JsonObject();
                    JsonObject jsonObject4 = new JsonObject();
                    for (IBlockState<?> property1 : stateDefinition.d()) {
                        jsonObject4.addProperty(property1.f(), SystemUtils.a(property1, iBlockData.c(property1)));
                    }
                    if (jsonObject4.size() > 0) {
                        jsonObject3.add("properties", (JsonElement)jsonObject4);
                    }
                    jsonObject3.addProperty("id", (Number)Block.j(iBlockData));
                    if (iBlockData == ((Block)reference.a()).m()) {
                        jsonObject3.addProperty("default", Boolean.valueOf(true));
                    }
                    jsonArray1.add((JsonElement)jsonObject3);
                }
                jsonObject1.add("states", (JsonElement)jsonArray1);
                String registeredName = reference.g();
                JsonElement jsonElement = (JsonElement)BlockTypes.a.codec().encodeStart((DynamicOps)registryOps, (Object)((Block)reference.a())).getOrThrow(string -> new AssertionError((Object)("Failed to serialize block " + registeredName + " (is type registered in BlockTypes?): " + string)));
                jsonObject1.add("definition", jsonElement);
                jsonObject.add(registeredName, (JsonElement)jsonObject1);
            });
            return DebugReportProvider.a(output, (JsonElement)jsonObject, path);
        });
    }

    @Override
    public final String a() {
        return "Block List";
    }
}

