/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.CriterionTriggerEnterBlock;
import net.minecraft.advancements.critereon.CriterionTriggerImpossible;
import net.minecraft.advancements.critereon.CriterionTriggerInventoryChanged;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SmithingTrimRecipeBuilder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.FurnaceRecipe;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeBlasting;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;

public abstract class RecipeProvider {
    protected final HolderLookup.a a;
    private final HolderGetter<Item> c;
    protected final RecipeOutput b;
    private static final Map<BlockFamily.b, FamilyRecipeProvider> d = ImmutableMap.builder().put((Object)BlockFamily.b.a, (recipeProvider, ingredient, result) -> recipeProvider.e(ingredient, RecipeItemStack.a(result))).put((Object)BlockFamily.b.b, (recipeProvider, ingredient, result) -> recipeProvider.b(RecipeCategory.a, ingredient, RecipeItemStack.a(result))).put((Object)BlockFamily.b.d, (recipeProvider, ingredient, result) -> recipeProvider.f(RecipeCategory.a, ingredient, RecipeItemStack.a(result))).put((Object)BlockFamily.b.e, (recipeProvider, ingredient, result) -> recipeProvider.a(ingredient, RecipeItemStack.a(result))).put((Object)BlockFamily.b.f, (recipeProvider, ingredient, result) -> recipeProvider.f(ingredient, RecipeItemStack.a(result))).put((Object)BlockFamily.b.g, (recipeProvider, ingredient, result) -> recipeProvider.f(ingredient, RecipeItemStack.a(result))).put((Object)BlockFamily.b.h, (recipeProvider, ingredient, result) -> recipeProvider.g(ingredient, RecipeItemStack.a(result))).put((Object)BlockFamily.b.i, (recipeProvider, ingredient, result) -> recipeProvider.g(ingredient, RecipeItemStack.a(result))).put((Object)BlockFamily.b.k, (recipeProvider, ingredient, result) -> recipeProvider.h(ingredient, RecipeItemStack.a(result))).put((Object)BlockFamily.b.l, (recipeProvider, ingredient, result) -> recipeProvider.a(RecipeCategory.a, ingredient, RecipeItemStack.a(result))).put((Object)BlockFamily.b.m, (recipeProvider, ingredient, result) -> recipeProvider.b(ingredient, RecipeItemStack.a(result))).put((Object)BlockFamily.b.n, (recipeProvider, ingredient, result) -> recipeProvider.c(RecipeCategory.c, ingredient, RecipeItemStack.a(result))).put((Object)BlockFamily.b.o, (recipeProvider, ingredient, result) -> recipeProvider.e(RecipeCategory.a, ingredient, RecipeItemStack.a(result))).put((Object)BlockFamily.b.p, (recipeProvider, ingredient, result) -> recipeProvider.c(ingredient, RecipeItemStack.a(result))).put((Object)BlockFamily.b.q, (recipeProvider, ingredient, result) -> recipeProvider.d(RecipeCategory.b, ingredient, RecipeItemStack.a(result))).build();

    protected RecipeProvider(HolderLookup.a registries, RecipeOutput output) {
        this.a = registries;
        this.c = registries.e(Registries.K);
        this.b = output;
    }

    protected abstract void a();

    protected void a(FeatureFlagSet enabledFeatures) {
        BlockFamilies.a().filter(BlockFamily::d).forEach(blockFamily -> this.a((BlockFamily)blockFamily, enabledFeatures));
    }

    protected void a(IMaterial result, IMaterial ingredient, @Nullable String group) {
        this.a(result, ingredient, group, 1);
    }

    protected void a(IMaterial result, IMaterial ingredient, @Nullable String group, int resultCount) {
        this.b(RecipeCategory.i, result, resultCount).b(ingredient).b(group).b(RecipeProvider.b(ingredient), this.a(ingredient)).a(this.b, RecipeProvider.p(result, ingredient));
    }

    protected void a(List<IMaterial> ingredients, RecipeCategory category, IMaterial result, float experience, int cookingTime, String group) {
        this.a(RecipeSerializer.o, FurnaceRecipe::new, ingredients, category, result, experience, cookingTime, group, "_from_smelting");
    }

    protected void b(List<IMaterial> ingredients, RecipeCategory category, IMaterial result, float experience, int cookingTime, String group) {
        this.a(RecipeSerializer.p, RecipeBlasting::new, ingredients, category, result, experience, cookingTime, group, "_from_blasting");
    }

    private <T extends RecipeCooking> void a(RecipeSerializer<T> serializer, RecipeCooking.a<T> recipeFactory, List<IMaterial> ingredients, RecipeCategory category, IMaterial result, float experience, int cookingTime, String group, String suffix) {
        for (IMaterial itemLike : ingredients) {
            SimpleCookingRecipeBuilder.a(RecipeItemStack.a(itemLike), category, result, experience, cookingTime, serializer, recipeFactory).b(group).b(RecipeProvider.b(itemLike), this.a(itemLike)).a(this.b, RecipeProvider.c(result) + suffix + "_" + RecipeProvider.c(itemLike));
        }
    }

    protected void a(Item ingredientItem, RecipeCategory category, Item resultItem) {
        SmithingTransformRecipeBuilder.a(RecipeItemStack.a((IMaterial)Items.yH), RecipeItemStack.a((IMaterial)ingredientItem), this.b(TagsItem.bi), category, resultItem).a("has_netherite_ingot", this.a(TagsItem.bi)).a(this.b, RecipeProvider.c(resultItem) + "_smithing");
    }

    protected void a(Item template, ResourceKey<TrimPattern> pattern, ResourceKey<IRecipe<?>> recipe) {
        Holder.c<TrimPattern> orThrow = this.a.e(Registries.bl).b(pattern);
        SmithingTrimRecipeBuilder.a(RecipeItemStack.a((IMaterial)template), this.b(TagsItem.bE), this.b(TagsItem.bF), orThrow, RecipeCategory.i).a("has_smithing_trim_template", this.a(template)).a(this.b, recipe);
    }

    protected void a(RecipeCategory category, IMaterial packed, IMaterial unpacked) {
        this.a(category, packed, 1).a(Character.valueOf('#'), unpacked).b("##").b("##").b(RecipeProvider.b(unpacked), this.a(unpacked)).a(this.b);
    }

    protected void a(RecipeCategory category, IMaterial packed, IMaterial unpacked, String criterionName) {
        this.b(category, packed).a(unpacked, 9).b(criterionName, this.a(unpacked)).a(this.b);
    }

    protected void b(RecipeCategory category, IMaterial packed, IMaterial unpacked) {
        this.a(category, packed, unpacked, RecipeProvider.b(unpacked));
    }

    protected void a(IMaterial planks, TagKey<Item> logs, int resultCount) {
        this.b(RecipeCategory.a, planks, resultCount).a(logs).b("planks").b("has_log", this.a(logs)).a(this.b);
    }

    protected void b(IMaterial planks, TagKey<Item> logs, int result) {
        this.b(RecipeCategory.a, planks, result).a(logs).b("planks").b("has_logs", this.a(logs)).a(this.b);
    }

    protected void a(IMaterial wood, IMaterial log) {
        this.a(RecipeCategory.a, wood, 3).a(Character.valueOf('#'), log).b("##").b("##").c("bark").b("has_log", this.a(log)).a(this.b);
    }

    protected void b(IMaterial boat, IMaterial material) {
        this.a(RecipeCategory.d, boat).a(Character.valueOf('#'), material).b("# #").b("###").c("boat").b("in_water", RecipeProvider.a(Blocks.J)).a(this.b);
    }

    protected void c(IMaterial boat, IMaterial material) {
        this.b(RecipeCategory.d, boat).b(Blocks.cG).b(material).b("chest_boat").b("has_boat", this.a(TagsItem.aT)).a(this.b);
    }

    private RecipeBuilder e(IMaterial button, RecipeItemStack material) {
        return this.b(RecipeCategory.c, button).a(material);
    }

    protected RecipeBuilder a(IMaterial door, RecipeItemStack material) {
        return this.a(RecipeCategory.c, door, 3).a(Character.valueOf('#'), material).b("##").b("##").b("##");
    }

    private RecipeBuilder f(IMaterial fence, RecipeItemStack material) {
        int i2 = fence == Blocks.fN ? 6 : 3;
        Item item = fence == Blocks.fN ? Items.vH : Items.qe;
        return this.a(RecipeCategory.b, fence, i2).a(Character.valueOf('W'), material).a(Character.valueOf('#'), item).b("W#W").b("W#W");
    }

    private RecipeBuilder g(IMaterial fenceGate, RecipeItemStack material) {
        return this.a(RecipeCategory.c, fenceGate).a(Character.valueOf('#'), Items.qe).a(Character.valueOf('W'), material).b("#W#").b("#W#");
    }

    protected void d(IMaterial pressurePlate, IMaterial material) {
        this.c(RecipeCategory.c, pressurePlate, RecipeItemStack.a(material)).a(RecipeProvider.b(material), this.a(material)).a(this.b);
    }

    private RecipeBuilder c(RecipeCategory category, IMaterial pressurePlate, RecipeItemStack material) {
        return this.a(category, pressurePlate).a(Character.valueOf('#'), material).b("##");
    }

    protected void c(RecipeCategory category, IMaterial slab, IMaterial material) {
        this.a(category, slab, RecipeItemStack.a(material)).a(RecipeProvider.b(material), this.a(material)).a(this.b);
    }

    protected RecipeBuilder a(RecipeCategory category, IMaterial slab, RecipeItemStack material) {
        return this.a(category, slab, 6).a(Character.valueOf('#'), material).b("###");
    }

    protected RecipeBuilder b(IMaterial stairs, RecipeItemStack material) {
        return this.a(RecipeCategory.a, stairs, 4).a(Character.valueOf('#'), material).b("#  ").b("## ").b("###");
    }

    protected RecipeBuilder c(IMaterial trapdoor, RecipeItemStack material) {
        return this.a(RecipeCategory.c, trapdoor, 2).a(Character.valueOf('#'), material).b("###").b("###");
    }

    private RecipeBuilder h(IMaterial sign, RecipeItemStack material) {
        return this.a(RecipeCategory.b, sign, 3).c("sign").a(Character.valueOf('#'), material).a(Character.valueOf('X'), Items.qe).b("###").b("###").b(" X ");
    }

    protected void e(IMaterial sign, IMaterial material) {
        this.a(RecipeCategory.b, sign, 6).c("hanging_sign").a(Character.valueOf('#'), material).a(Character.valueOf('X'), Items.go).b("X X").b("###").b("###").b("has_stripped_logs", this.a(material)).a(this.b);
    }

    protected void a(List<Item> dyes, List<Item> dyeableItems, String group) {
        this.a(dyes, dyeableItems, null, group, RecipeCategory.a);
    }

    protected void a(List<Item> dyes, List<Item> dyeableItems, @Nullable Item dye, String group, RecipeCategory category) {
        for (int i2 = 0; i2 < dyes.size(); ++i2) {
            Item item = dyes.get(i2);
            Item item1 = dyeableItems.get(i2);
            Stream<Item> stream = dyeableItems.stream().filter(item2 -> !item2.equals(item1));
            if (dye != null) {
                stream = Stream.concat(stream, Stream.of(dye));
            }
            this.b(category, (IMaterial)item1).b(item).a(RecipeItemStack.a(stream)).b(group).b("has_needed_dye", this.a(item)).a(this.b, "dye_" + RecipeProvider.c(item1));
        }
    }

    protected void f(IMaterial carpet, IMaterial material) {
        this.a(RecipeCategory.b, carpet, 3).a(Character.valueOf('#'), material).b("##").c("carpet").b(RecipeProvider.b(material), this.a(material)).a(this.b);
    }

    protected void g(IMaterial bed, IMaterial wool) {
        this.a(RecipeCategory.b, bed).a(Character.valueOf('#'), wool).a(Character.valueOf('X'), TagsItem.b).b("###").b("XXX").c("bed").b(RecipeProvider.b(wool), this.a(wool)).a(this.b);
    }

    protected void h(IMaterial banner, IMaterial material) {
        this.a(RecipeCategory.b, banner).a(Character.valueOf('#'), material).a(Character.valueOf('|'), Items.qe).b("###").b("###").b(" | ").c("banner").b(RecipeProvider.b(material), this.a(material)).a(this.b);
    }

    protected void i(IMaterial stainedGlass, IMaterial dye) {
        this.a(RecipeCategory.a, stainedGlass, 8).a(Character.valueOf('#'), Blocks.aX).a(Character.valueOf('X'), dye).b("###").b("#X#").b("###").c("stained_glass").b("has_glass", this.a(Blocks.aX)).a(this.b);
    }

    protected void j(IMaterial stainedGlassPane, IMaterial stainedGlass) {
        this.a(RecipeCategory.b, stainedGlassPane, 16).a(Character.valueOf('#'), stainedGlass).b("###").b("###").c("stained_glass_pane").b("has_glass", this.a(stainedGlass)).a(this.b);
    }

    protected void k(IMaterial stainedGlassPane, IMaterial dye) {
        this.a(RecipeCategory.b, stainedGlassPane, 8).a(Character.valueOf('#'), Blocks.fq).a(Character.valueOf('$'), dye).b("###").b("#$#").b("###").c("stained_glass_pane").b("has_glass_pane", this.a(Blocks.fq)).b(RecipeProvider.b(dye), this.a(dye)).a(this.b, RecipeProvider.p(stainedGlassPane, Blocks.fq));
    }

    protected void l(IMaterial terracotta, IMaterial dye) {
        this.a(RecipeCategory.a, terracotta, 8).a(Character.valueOf('#'), Blocks.jc).a(Character.valueOf('X'), dye).b("###").b("#X#").b("###").c("stained_terracotta").b("has_terracotta", this.a(Blocks.jc)).a(this.b);
    }

    protected void m(IMaterial concretePowder, IMaterial dye) {
        this.b(RecipeCategory.a, concretePowder, 8).b(dye).a(Blocks.L, 4).a(Blocks.O, 4).b("concrete_powder").b("has_sand", this.a(Blocks.L)).b("has_gravel", this.a(Blocks.O)).a(this.b);
    }

    protected void n(IMaterial candle, IMaterial dye) {
        this.b(RecipeCategory.b, candle).b(Blocks.qt).b(dye).b("dyed_candle").b(RecipeProvider.b(dye), this.a(dye)).a(this.b);
    }

    protected void d(RecipeCategory category, IMaterial wall, IMaterial material) {
        this.d(category, wall, RecipeItemStack.a(material)).a(RecipeProvider.b(material), this.a(material)).a(this.b);
    }

    private RecipeBuilder d(RecipeCategory category, IMaterial wall, RecipeItemStack material) {
        return this.a(category, wall, 6).a(Character.valueOf('#'), material).b("###").b("###");
    }

    protected void e(RecipeCategory category, IMaterial result, IMaterial material) {
        this.e(category, result, RecipeItemStack.a(material)).a(RecipeProvider.b(material), this.a(material)).a(this.b);
    }

    private RecipeBuilder e(RecipeCategory category, IMaterial result, RecipeItemStack material) {
        return this.a(category, result, 4).a(Character.valueOf('S'), material).b("SS").b("SS");
    }

    protected void f(RecipeCategory category, IMaterial cutResult, IMaterial material) {
        this.f(category, cutResult, RecipeItemStack.a(material)).b(RecipeProvider.b(material), this.a(material)).a(this.b);
    }

    private ShapedRecipeBuilder f(RecipeCategory category, IMaterial cutResult, RecipeItemStack material) {
        return this.a(category, cutResult, 4).a(Character.valueOf('#'), material).b("##").b("##");
    }

    protected void g(RecipeCategory category, IMaterial chiseledResult, IMaterial material) {
        this.b(category, chiseledResult, RecipeItemStack.a(material)).b(RecipeProvider.b(material), this.a(material)).a(this.b);
    }

    protected void h(RecipeCategory category, IMaterial result, IMaterial material) {
        this.a(category, result).a(Character.valueOf('#'), material).b("#").b("#").b(RecipeProvider.b(material), this.a(material)).a(this.b);
    }

    protected ShapedRecipeBuilder b(RecipeCategory category, IMaterial chiseledResult, RecipeItemStack material) {
        return this.a(category, chiseledResult).a(Character.valueOf('#'), material).b("#").b("#");
    }

    protected void i(RecipeCategory category, IMaterial result, IMaterial material) {
        this.a(category, result, material, 1);
    }

    protected void a(RecipeCategory category, IMaterial result, IMaterial material, int resultCount) {
        SingleItemRecipeBuilder.a(RecipeItemStack.a(material), category, result, resultCount).b(RecipeProvider.b(material), this.a(material)).a(this.b, RecipeProvider.p(result, material) + "_stonecutting");
    }

    private void q(IMaterial result, IMaterial ingredient) {
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(ingredient), RecipeCategory.a, result, 0.1f, 200).b(RecipeProvider.b(ingredient), this.a(ingredient)).a(this.b);
    }

    protected void a(RecipeCategory unpackedCategory, IMaterial unpacked, RecipeCategory packedCategory, IMaterial packed) {
        this.a(unpackedCategory, unpacked, packedCategory, packed, RecipeProvider.d(packed), null, RecipeProvider.d(unpacked), null);
    }

    protected void a(RecipeCategory unpackedCategory, IMaterial unpacked, RecipeCategory packedCategory, IMaterial packed, String packedName, String packedGroup) {
        this.a(unpackedCategory, unpacked, packedCategory, packed, packedName, packedGroup, RecipeProvider.d(unpacked), null);
    }

    protected void b(RecipeCategory unpackedCategory, IMaterial unpacked, RecipeCategory packedCategory, IMaterial packed, String unpackedName, String unpackedGroup) {
        this.a(unpackedCategory, unpacked, packedCategory, packed, RecipeProvider.d(packed), null, unpackedName, unpackedGroup);
    }

    private void a(RecipeCategory unpackedCategory, IMaterial unpacked, RecipeCategory packedCategory, IMaterial packed, String packedName, @Nullable String packedGroup, String unpackedName, @Nullable String unpackedGroup) {
        this.b(unpackedCategory, unpacked, 9).b(packed).b(unpackedGroup).b(RecipeProvider.b(packed), this.a(packed)).a(this.b, ResourceKey.a(Registries.bv, MinecraftKey.a(unpackedName)));
        this.a(packedCategory, packed).a(Character.valueOf('#'), unpacked).b("###").b("###").b("###").c(packedGroup).b(RecipeProvider.b(unpacked), this.a(unpacked)).a(this.b, ResourceKey.a(Registries.bv, MinecraftKey.a(packedName)));
    }

    protected void o(IMaterial template, IMaterial baseItem) {
        this.a(RecipeCategory.i, template, 2).a(Character.valueOf('#'), Items.pn).a(Character.valueOf('C'), baseItem).a(Character.valueOf('S'), template).b("#S#").b("#C#").b("###").b(RecipeProvider.b(template), this.a(template)).a(this.b);
    }

    protected void d(IMaterial template, RecipeItemStack baseItem) {
        this.a(RecipeCategory.i, template, 2).a(Character.valueOf('#'), Items.pn).a(Character.valueOf('C'), baseItem).a(Character.valueOf('S'), template).b("#S#").b("#C#").b("###").b(RecipeProvider.b(template), this.a(template)).a(this.b);
    }

    protected <T extends RecipeCooking> void a(String cookingMethod, RecipeSerializer<T> cookingSerializer, RecipeCooking.a<T> recipeFactory, int cookingTime) {
        this.a(cookingMethod, cookingSerializer, recipeFactory, cookingTime, Items.ti, Items.tj, 0.35f);
        this.a(cookingMethod, cookingSerializer, recipeFactory, cookingTime, Items.tk, Items.tl, 0.35f);
        this.a(cookingMethod, cookingSerializer, recipeFactory, cookingTime, Items.sh, Items.sl, 0.35f);
        this.a(cookingMethod, cookingSerializer, recipeFactory, cookingTime, Items.dX, Items.tf, 0.1f);
        this.a(cookingMethod, cookingSerializer, recipeFactory, cookingTime, Items.si, Items.sm, 0.35f);
        this.a(cookingMethod, cookingSerializer, recipeFactory, cookingTime, Items.vY, Items.vZ, 0.35f);
        this.a(cookingMethod, cookingSerializer, recipeFactory, cookingTime, Items.qL, Items.qM, 0.35f);
        this.a(cookingMethod, cookingSerializer, recipeFactory, cookingTime, Items.vq, Items.vr, 0.35f);
        this.a(cookingMethod, cookingSerializer, recipeFactory, cookingTime, Items.vL, Items.vM, 0.35f);
    }

    private <T extends RecipeCooking> void a(String cookingMethod, RecipeSerializer<T> cookingSerializer, RecipeCooking.a<T> recipeFactory, int cookingTime, IMaterial material, IMaterial result, float experience) {
        SimpleCookingRecipeBuilder.a(RecipeItemStack.a(material), RecipeCategory.g, result, experience, cookingTime, cookingSerializer, recipeFactory).b(RecipeProvider.b(material), this.a(material)).a(this.b, RecipeProvider.c(result) + "_from_" + cookingMethod);
    }

    protected void b(FeatureFlagSet requiredFeatures) {
        HoneycombItem.a.get().forEach((block, block1) -> {
            if (block1.k().a(requiredFeatures)) {
                this.b(RecipeCategory.a, (IMaterial)block1).b((IMaterial)block).b(Items.xL).b(RecipeProvider.c(block1)).b(RecipeProvider.b(block), this.a((IMaterial)block)).a(this.b, RecipeProvider.p(block1, Items.xL));
            }
        });
    }

    protected void a(Block grateBlock, Block material) {
        this.a(RecipeCategory.a, (IMaterial)grateBlock, 4).a(Character.valueOf('M'), material).b(" M ").b("M M").b(" M ").b(RecipeProvider.b(material), this.a(material)).a(this.b);
    }

    protected void b(Block bulbBlock, Block material) {
        this.a(RecipeCategory.c, (IMaterial)bulbBlock, 4).a(Character.valueOf('C'), material).a(Character.valueOf('R'), Items.ml).a(Character.valueOf('B'), Items.to).b(" C ").b("CBC").b(" R ").b(RecipeProvider.b(material), this.a(material)).a(this.b);
    }

    protected void a(Item flowerItem, SuspiciousEffectHolder effect) {
        ItemStack itemStack = new ItemStack(Items.xh.e(), 1, DataComponentPatch.a().a(DataComponents.T, effect.c()).a());
        this.a(RecipeCategory.g, itemStack).b(Items.ph).b(Items.dN).b(Items.dO).b(flowerItem).b("suspicious_stew").b(RecipeProvider.b(flowerItem), this.a(flowerItem)).a(this.b, RecipeProvider.c(itemStack.h()) + "_from_" + RecipeProvider.c(flowerItem));
    }

    protected void a(BlockFamily blockFamily, FeatureFlagSet requiredFeatures) {
        blockFamily.b().forEach((variant, block) -> {
            if (block.k().a(requiredFeatures)) {
                FamilyRecipeProvider familyRecipeProvider = d.get(variant);
                Block baseBlock = this.a(blockFamily, (BlockFamily.b)((Object)variant));
                if (familyRecipeProvider != null) {
                    RecipeBuilder recipeBuilder = familyRecipeProvider.create(this, (IMaterial)block, baseBlock);
                    blockFamily.e().ifPresent(string -> recipeBuilder.a(string + (String)(variant == BlockFamily.b.d ? "" : "_" + variant.a())));
                    recipeBuilder.a(blockFamily.f().orElseGet(() -> RecipeProvider.b(baseBlock)), this.a(baseBlock));
                    recipeBuilder.a(this.b);
                }
                if (variant == BlockFamily.b.c) {
                    this.q((IMaterial)block, baseBlock);
                }
            }
        });
    }

    private Block a(BlockFamily family, BlockFamily.b variant) {
        if (variant == BlockFamily.b.b) {
            if (!family.b().containsKey((Object)BlockFamily.b.l)) {
                throw new IllegalStateException("Slab is not defined for the family.");
            }
            return family.a(BlockFamily.b.l);
        }
        return family.a();
    }

    private static Criterion<CriterionTriggerEnterBlock.a> a(Block block) {
        return CriterionTriggers.e.a(new CriterionTriggerEnterBlock.a(Optional.empty(), Optional.of(block.p()), Optional.empty()));
    }

    private Criterion<CriterionTriggerInventoryChanged.a> a(CriterionConditionValue.IntegerRange count, IMaterial item) {
        return RecipeProvider.a(CriterionConditionItem.a.a().a(this.c, item).a(count));
    }

    protected Criterion<CriterionTriggerInventoryChanged.a> a(IMaterial itemLike) {
        return RecipeProvider.a(CriterionConditionItem.a.a().a(this.c, itemLike));
    }

    protected Criterion<CriterionTriggerInventoryChanged.a> a(TagKey<Item> tag) {
        return RecipeProvider.a(CriterionConditionItem.a.a().a(this.c, tag));
    }

    private static Criterion<CriterionTriggerInventoryChanged.a> a(CriterionConditionItem.a ... items) {
        return RecipeProvider.a((CriterionConditionItem[])Arrays.stream(items).map(CriterionConditionItem.a::b).toArray(CriterionConditionItem[]::new));
    }

    private static Criterion<CriterionTriggerInventoryChanged.a> a(CriterionConditionItem ... predicates) {
        return CriterionTriggers.f.a(new CriterionTriggerInventoryChanged.a(Optional.empty(), CriterionTriggerInventoryChanged.a.a.b, List.of(predicates)));
    }

    protected static String b(IMaterial itemLike) {
        return "has_" + RecipeProvider.c(itemLike);
    }

    protected static String c(IMaterial itemLike) {
        return BuiltInRegistries.g.b(itemLike.h()).a();
    }

    protected static String d(IMaterial itemLike) {
        return RecipeProvider.c(itemLike);
    }

    protected static String p(IMaterial result, IMaterial ingredient) {
        return RecipeProvider.c(result) + "_from_" + RecipeProvider.c(ingredient);
    }

    protected static String e(IMaterial itemLike) {
        return RecipeProvider.c(itemLike) + "_from_smelting";
    }

    protected static String f(IMaterial itemLike) {
        return RecipeProvider.c(itemLike) + "_from_blasting";
    }

    protected RecipeItemStack b(TagKey<Item> tag) {
        return RecipeItemStack.a(this.c.b(tag));
    }

    protected ShapedRecipeBuilder a(RecipeCategory category, IMaterial result) {
        return ShapedRecipeBuilder.a(this.c, category, result);
    }

    protected ShapedRecipeBuilder a(RecipeCategory category, IMaterial result, int count) {
        return ShapedRecipeBuilder.a(this.c, category, result, count);
    }

    protected ShapelessRecipeBuilder a(RecipeCategory category, ItemStack result) {
        return ShapelessRecipeBuilder.a(this.c, category, result);
    }

    protected ShapelessRecipeBuilder b(RecipeCategory category, IMaterial result) {
        return ShapelessRecipeBuilder.a(this.c, category, result);
    }

    protected ShapelessRecipeBuilder b(RecipeCategory category, IMaterial result, int count) {
        return ShapelessRecipeBuilder.a(this.c, category, result, count);
    }

    @FunctionalInterface
    static interface FamilyRecipeProvider {
        public RecipeBuilder create(RecipeProvider var1, IMaterial var2, IMaterial var3);
    }

    protected static abstract class b
    implements DebugReportProvider {
        private final PackOutput d;
        private final CompletableFuture<HolderLookup.a> e;

        protected b(PackOutput packOutput, CompletableFuture<HolderLookup.a> registries) {
            this.d = packOutput;
            this.e = registries;
        }

        @Override
        public final CompletableFuture<?> a(final CachedOutput output) {
            return this.e.thenCompose(provider -> {
                PackOutput.a pathProvider = this.d.a(Registries.bv);
                PackOutput.a pathProvider1 = this.d.a(Registries.bu);
                final HashSet set = Sets.newHashSet();
                final ArrayList list = new ArrayList();
                RecipeOutput recipeOutput = new RecipeOutput(){
                    final /* synthetic */ HolderLookup.a val$provider;
                    final /* synthetic */ PackOutput.a val$pathProvider;
                    final /* synthetic */ PackOutput.a val$pathProvider1;
                    {
                        this.val$provider = a2;
                        this.val$pathProvider = a3;
                        this.val$pathProvider1 = a4;
                    }

                    @Override
                    public void a(ResourceKey<IRecipe<?>> key, IRecipe<?> recipe, @Nullable AdvancementHolder advancement) {
                        if (!set.add(key)) {
                            throw new IllegalStateException("Duplicate recipe " + String.valueOf(key.a()));
                        }
                        this.a(key, recipe);
                        if (advancement != null) {
                            this.a(advancement);
                        }
                    }

                    @Override
                    public Advancement.SerializedAdvancement a() {
                        return Advancement.SerializedAdvancement.b().a(RecipeBuilder.a);
                    }

                    @Override
                    public void b() {
                        AdvancementHolder advancementHolder = Advancement.SerializedAdvancement.b().a("impossible", CriterionTriggers.b.a(new CriterionTriggerImpossible.a())).b(RecipeBuilder.a);
                        this.a(advancementHolder);
                    }

                    private void a(ResourceKey<IRecipe<?>> resourceKey, IRecipe<?> recipe) {
                        list.add(DebugReportProvider.a(output, this.val$provider, IRecipe.a, recipe, this.val$pathProvider.a(resourceKey.a())));
                    }

                    private void a(AdvancementHolder advancementHolder) {
                        list.add(DebugReportProvider.a(output, this.val$provider, Advancement.a, advancementHolder.b(), this.val$pathProvider1.a(advancementHolder.a())));
                    }
                };
                this.a((HolderLookup.a)provider, recipeOutput).a();
                return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
            });
        }

        protected abstract RecipeProvider a(HolderLookup.a var1, RecipeOutput var2);
    }
}

