/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.CriterionTriggerRecipeUnlocked;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.ShapelessRecipes;
import net.minecraft.world.level.IMaterial;

public class ShapelessRecipeBuilder
implements RecipeBuilder {
    private final HolderGetter<Item> b;
    private final RecipeCategory c;
    private final ItemStack d;
    private final List<RecipeItemStack> e = new ArrayList<RecipeItemStack>();
    private final Map<String, Criterion<?>> f = new LinkedHashMap();
    @Nullable
    private String g;

    private ShapelessRecipeBuilder(HolderGetter<Item> items, RecipeCategory category, ItemStack result) {
        this.b = items;
        this.c = category;
        this.d = result;
    }

    public static ShapelessRecipeBuilder a(HolderGetter<Item> items, RecipeCategory category, ItemStack result) {
        return new ShapelessRecipeBuilder(items, category, result);
    }

    public static ShapelessRecipeBuilder a(HolderGetter<Item> items, RecipeCategory category, IMaterial result) {
        return ShapelessRecipeBuilder.a(items, category, result, 1);
    }

    public static ShapelessRecipeBuilder a(HolderGetter<Item> items, RecipeCategory category, IMaterial result, int count) {
        return new ShapelessRecipeBuilder(items, category, result.h().m().c(count));
    }

    public ShapelessRecipeBuilder a(TagKey<Item> tag) {
        return this.a(RecipeItemStack.a(this.b.b(tag)));
    }

    public ShapelessRecipeBuilder b(IMaterial item) {
        return this.a(item, 1);
    }

    public ShapelessRecipeBuilder a(IMaterial item, int quantity) {
        for (int i2 = 0; i2 < quantity; ++i2) {
            this.a(RecipeItemStack.a(item));
        }
        return this;
    }

    public ShapelessRecipeBuilder a(RecipeItemStack ingredient) {
        return this.a(ingredient, 1);
    }

    public ShapelessRecipeBuilder a(RecipeItemStack ingredient, int quantity) {
        for (int i2 = 0; i2 < quantity; ++i2) {
            this.e.add(ingredient);
        }
        return this;
    }

    public ShapelessRecipeBuilder b(String name, Criterion<?> criterion) {
        this.f.put(name, criterion);
        return this;
    }

    public ShapelessRecipeBuilder b(@Nullable String groupName) {
        this.g = groupName;
        return this;
    }

    @Override
    public Item a() {
        return this.d.h();
    }

    @Override
    public void a(RecipeOutput output, ResourceKey<IRecipe<?>> resourceKey) {
        this.a(resourceKey);
        Advancement.SerializedAdvancement builder = output.a().a("has_the_recipe", CriterionTriggerRecipeUnlocked.a(resourceKey)).a(AdvancementRewards.a.c(resourceKey)).a(AdvancementRequirements.a.b);
        this.f.forEach(builder::a);
        ShapelessRecipes shapelessRecipe = new ShapelessRecipes(Objects.requireNonNullElse(this.g, ""), RecipeBuilder.a(this.c), this.d, this.e);
        output.a(resourceKey, shapelessRecipe, builder.b(resourceKey.a().f("recipes/" + this.c.a() + "/")));
    }

    private void a(ResourceKey<IRecipe<?>> recipe) {
        if (this.f.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipe.a()));
        }
    }
}

