/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;

public class GameTestHarnessStructures {
    public static final int a = 10;
    public static final String b = "Minecraft.Server/src/test/convertables/data";
    public static Path c = Paths.get("Minecraft.Server/src/test/convertables/data", new String[0]);

    public static EnumBlockRotation a(int rotationSteps) {
        switch (rotationSteps) {
            case 0: {
                return EnumBlockRotation.a;
            }
            case 1: {
                return EnumBlockRotation.b;
            }
            case 2: {
                return EnumBlockRotation.c;
            }
            case 3: {
                return EnumBlockRotation.d;
            }
        }
        throw new IllegalArgumentException("rotationSteps must be a value from 0-3. Got value " + rotationSteps);
    }

    public static int a(EnumBlockRotation rotation) {
        switch (rotation) {
            case a: {
                return 0;
            }
            case b: {
                return 1;
            }
            case c: {
                return 2;
            }
            case d: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unknown rotation value, don't know how many steps it represents: " + String.valueOf(rotation));
    }

    public static TestInstanceBlockEntity a(MinecraftKey id, BlockPosition pos, BaseBlockPosition size, EnumBlockRotation rotation, WorldServer level) {
        StructureBoundingBox structureBoundingBox = GameTestHarnessStructures.b(TestInstanceBlockEntity.a(pos), size, rotation);
        GameTestHarnessStructures.a(structureBoundingBox, level);
        level.b(pos, Blocks.pJ.m());
        TestInstanceBlockEntity testInstanceBlockEntity = (TestInstanceBlockEntity)level.c_(pos);
        ResourceKey<GameTestInstance> resourceKey = ResourceKey.a(Registries.bh, id);
        testInstanceBlockEntity.a(new TestInstanceBlockEntity.a(Optional.of(resourceKey), size, rotation, false, TestInstanceBlockEntity.b.a, Optional.empty()));
        return testInstanceBlockEntity;
    }

    public static void a(StructureBoundingBox boundingBox, WorldServer level) {
        int i2 = boundingBox.i() - 1;
        StructureBoundingBox boundingBox1 = new StructureBoundingBox(boundingBox.h() - 2, boundingBox.i() - 3, boundingBox.j() - 3, boundingBox.k() + 3, boundingBox.l() + 20, boundingBox.m() + 3);
        BlockPosition.a(boundingBox1).forEach(pos -> GameTestHarnessStructures.a(i2, pos, level));
        level.n().a(boundingBox1);
        level.a(boundingBox1);
        AxisAlignedBB aabb = AxisAlignedBB.a(boundingBox1);
        List<Entity> entitiesOfClass = level.a(Entity.class, aabb, entity -> !(entity instanceof EntityHuman));
        entitiesOfClass.forEach(entity -> entity.discard(EntityRemoveEvent.Cause.DISCARD));
    }

    public static BlockPosition a(BlockPosition pos, BaseBlockPosition offset, EnumBlockRotation rotation) {
        BlockPosition blockPos = pos.a(offset).b(-1, -1, -1);
        return DefinedStructure.a(blockPos, EnumBlockMirror.a, rotation, pos);
    }

    public static StructureBoundingBox b(BlockPosition pos, BaseBlockPosition offset, EnumBlockRotation rotation) {
        BlockPosition transformedFarCorner = GameTestHarnessStructures.a(pos, offset, rotation);
        StructureBoundingBox boundingBox = StructureBoundingBox.a(pos, transformedFarCorner);
        int min = Math.min(boundingBox.h(), boundingBox.k());
        int min1 = Math.min(boundingBox.j(), boundingBox.m());
        return boundingBox.a(pos.u() - min, 0, pos.w() - min1);
    }

    public static Optional<BlockPosition> a(BlockPosition pos, int radius, WorldServer level) {
        return GameTestHarnessStructures.c(pos, radius, level).filter(blockPos -> GameTestHarnessStructures.a(blockPos, pos, level)).findFirst();
    }

    public static Optional<BlockPosition> b(BlockPosition pos, int radius, WorldServer level) {
        Comparator<BlockPosition> comparator = Comparator.comparingInt(blockPos -> blockPos.k(pos));
        return GameTestHarnessStructures.c(pos, radius, level).min(comparator);
    }

    public static Stream<BlockPosition> c(BlockPosition pos, int radius, WorldServer level) {
        StructureBoundingBox boundingBoxAtGround = GameTestHarnessStructures.d(pos, radius, level);
        return BlockPosition.a(boundingBoxAtGround).filter(blockPos -> level.a_((BlockPosition)blockPos).a(Blocks.pJ)).map(BlockPosition::j);
    }

    private static StructureBoundingBox d(BlockPosition pos, int radius, WorldServer level) {
        BlockPosition blockPos = BlockPosition.a((double)pos.u(), (double)level.a(HeightMap.Type.b, pos).v(), (double)pos.w());
        return new StructureBoundingBox(blockPos).c(radius, 10, radius);
    }

    public static Stream<BlockPosition> a(BlockPosition pos, Entity entity, WorldServer level) {
        int i2 = 200;
        Vec3D eyePosition = entity.bD();
        Vec3D vec3 = eyePosition.e(entity.bS().c(200.0));
        return GameTestHarnessStructures.c(pos, 200, level).map(blockPos -> level.a((BlockPosition)blockPos, TileEntityTypes.U)).flatMap(Optional::stream).filter(blockEntity -> blockEntity.f().b(eyePosition, vec3).isPresent()).map(TileEntity::ax_).sorted(Comparator.comparing(pos::j)).limit(1L);
    }

    private static void a(int structureBlockY, BlockPosition pos, WorldServer serverLevel) {
        IBlockData blockState = pos.v() < structureBlockY ? Blocks.b.m() : Blocks.a.m();
        ArgumentTileLocation blockInput = new ArgumentTileLocation(blockState, Collections.emptySet(), null);
        blockInput.a(serverLevel, pos, 818);
        serverLevel.a(pos, blockState.b());
    }

    private static boolean a(BlockPosition structureBlockPos, BlockPosition posToTest, WorldServer serverLevel) {
        TestInstanceBlockEntity testInstanceBlockEntity;
        TileEntity tileEntity = serverLevel.c_(structureBlockPos);
        return tileEntity instanceof TestInstanceBlockEntity && (testInstanceBlockEntity = (TestInstanceBlockEntity)tileEntity).d().b(posToTest);
    }
}

