/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.Stopwatch;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.brigadier.StringReader;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.ReportType;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ResourceSelectorArgument;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestBatchFactory;
import net.minecraft.gametest.framework.GameTestHarnessBatch;
import net.minecraft.gametest.framework.GameTestHarnessCollector;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.StructureGridSpawner;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListenerLogger;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.debugchart.LocalSampleLogger;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldDataServer;
import org.bukkit.command.CommandSender;
import org.slf4j.Logger;

public class GameTestServer
extends MinecraftServer {
    private static final Logger l = LogUtils.getLogger();
    private static final int m = 20;
    private static final int n = 14999992;
    private static final Services o = new Services(null, ServicesKeySet.EMPTY, null, null);
    private static final FeatureFlagSet p = FeatureFlags.e.a().d(FeatureFlagSet.a(FeatureFlags.c, FeatureFlags.d));
    private final LocalSampleLogger q = new LocalSampleLogger(4);
    private final Optional<String> r;
    private final boolean s;
    private List<GameTestHarnessBatch> t = new ArrayList<GameTestHarnessBatch>();
    private final Stopwatch u = Stopwatch.createUnstarted();
    private static final WorldOptions v = new WorldOptions(0L, false, false);
    @Nullable
    private GameTestHarnessCollector w;

    public static GameTestServer a(Thread serverThread, Convertable.ConversionSession storageSource, ResourcePackRepository packRepository, Optional<String> testSelection, boolean verify) {
        packRepository.a();
        ArrayList<String> list = new ArrayList<String>(packRepository.c());
        list.remove("vanilla");
        list.addFirst("vanilla");
        WorldDataConfiguration worldDataConfiguration = new WorldDataConfiguration(new DataPackConfiguration(list, List.of()), p);
        WorldSettings levelSettings = new WorldSettings("Test Level", EnumGamemode.b, false, EnumDifficulty.c, true, new GameRules(p), worldDataConfiguration);
        WorldLoader.d packConfig = new WorldLoader.d(packRepository, worldDataConfiguration, false, true);
        WorldLoader.c initConfig = new WorldLoader.c(packConfig, CommandDispatcher.ServerType.b, 4);
        try {
            l.debug("Starting resource loading");
            Stopwatch stopwatch = Stopwatch.createStarted();
            WorldStem worldStem = (WorldStem)SystemUtils.c(executor -> WorldLoader.a(initConfig, (WorldLoader.a context) -> {
                IRegistry<WorldDimension> frozen = new RegistryMaterials<WorldDimension>(Registries.bq, Lifecycle.stable()).n();
                WorldDimensions.b complete = context.c().e(Registries.bo).b(WorldPresets.b).a().a().a(frozen);
                return new WorldLoader.b<WorldDataServer>(new WorldDataServer(levelSettings, v, complete.d(), complete.a()), complete.b());
            }, WorldStem::new, SystemUtils.h(), executor)).get();
            stopwatch.stop();
            l.debug("Finished resource loading after {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return new GameTestServer(serverThread, storageSource, packRepository, worldStem, testSelection, verify);
        }
        catch (Exception var12) {
            l.warn("Failed to load vanilla datapack, bit oops", (Throwable)var12);
            System.exit(-1);
            throw new IllegalStateException();
        }
    }

    private GameTestServer(Thread serverThread, Convertable.ConversionSession storageSource, ResourcePackRepository packRepository, WorldStem worldStem, Optional<String> testSelection, boolean verify) {
        super(null, null, serverThread, storageSource, packRepository, worldStem, Proxy.NO_PROXY, DataConverterRegistry.a(), o, WorldLoadListenerLogger::b);
        this.r = testSelection;
        this.s = verify;
    }

    @Override
    public boolean e() {
        this.a(new PlayerList(this, this, this.bb(), this.g, 1){

            @Override
            public void loadAndSaveFiles() {
                throw new UnsupportedOperationException("Should not be called in a GameTestServer");
            }
        });
        this.loadLevel("blah");
        WorldServer serverLevel = this.J();
        this.t = this.b(serverLevel);
        l.info("Started game test server");
        return true;
    }

    private List<GameTestHarnessBatch> b(WorldServer level) {
        GameTestBatchFactory.a testDecorator;
        List<Holder.c<GameTestInstance>> collection;
        IRegistry<GameTestInstance> registry = level.J_().f(Registries.bh);
        if (this.r.isPresent()) {
            collection = GameTestServer.a(level.J_(), this.r.get()).filter(reference -> !((GameTestInstance)reference.a()).i()).toList();
            if (this.s) {
                testDecorator = GameTestServer::a;
                l.info("Verify requested. Will run each test that matches {} {} times", (Object)this.r.get(), (Object)(100 * EnumBlockRotation.values().length));
            } else {
                testDecorator = GameTestBatchFactory.a;
                l.info("Will run tests matching {} ({} tests)", (Object)this.r.get(), (Object)collection.size());
            }
        } else {
            collection = registry.c().filter(reference -> !((GameTestInstance)reference.a()).i()).toList();
            testDecorator = GameTestBatchFactory.a;
        }
        return GameTestBatchFactory.a(collection, testDecorator, level);
    }

    private static Stream<GameTestHarnessInfo> a(Holder.c<GameTestInstance> test, WorldServer level) {
        Stream.Builder<GameTestHarnessInfo> builder = Stream.builder();
        for (EnumBlockRotation rotation : EnumBlockRotation.values()) {
            for (int i2 = 0; i2 < 100; ++i2) {
                builder.add(new GameTestHarnessInfo(test, rotation, level, RetryOptions.a()));
            }
        }
        return builder.build();
    }

    public static Stream<Holder.c<GameTestInstance>> a(IRegistryCustom registries, String selection) {
        return ResourceSelectorArgument.a(new StringReader(selection), registries.f(Registries.bh)).stream();
    }

    @Override
    public void a(BooleanSupplier hasTimeLeft) {
        super.a(hasTimeLeft);
        WorldServer serverLevel = this.J();
        if (!this.br()) {
            this.c(serverLevel);
        }
        if (serverLevel.ae() % 20L == 0L) {
            l.info(this.w.j());
        }
        if (this.w.i()) {
            this.a(false);
            l.info(this.w.j());
            GlobalTestReporter.a();
            l.info("========= {} GAME TESTS COMPLETE IN {} ======================", (Object)this.w.h(), (Object)this.u.stop());
            if (this.w.d()) {
                l.info("{} required tests failed :(", (Object)this.w.a());
                this.w.f().forEach(GameTestServer::a);
            } else {
                l.info("All {} required tests passed :)", (Object)this.w.h());
            }
            if (this.w.e()) {
                l.info("{} optional tests failed", (Object)this.w.b());
                this.w.g().forEach(GameTestServer::a);
            }
            l.info("====================================================");
        }
    }

    private static void a(GameTestHarnessInfo info) {
        if (info.u() != EnumBlockRotation.a) {
            l.info("   - {} with rotation {}: {}", new Object[]{info.b(), info.u().c(), info.n().a().getString()});
        } else {
            l.info("   - {}: {}", (Object)info.b(), (Object)info.n().a().getString());
        }
    }

    @Override
    public SampleLogger f() {
        return this.q;
    }

    @Override
    public boolean g() {
        return false;
    }

    @Override
    public void w_() {
        this.bA();
    }

    @Override
    public SystemReport a(SystemReport report) {
        report.a("Type", "Game test server");
        return report;
    }

    @Override
    public void i() {
        super.i();
        l.info("Game test server shutting down");
        System.exit(this.w != null ? this.w.a() : -1);
    }

    @Override
    public void a(CrashReport report) {
        super.a(report);
        l.error("Game test server crashed\n{}", (Object)report.a(ReportType.a));
        System.exit(1);
    }

    private void c(WorldServer serverLevel) {
        BlockPosition blockPos = new BlockPosition(serverLevel.A.a(-14999992, 14999992), -59, serverLevel.A.a(-14999992, 14999992));
        serverLevel.a(blockPos, 0.0f);
        GameTestHarnessRunner gameTestRunner = GameTestHarnessRunner.a.a(this.t, serverLevel).a((GameTestHarnessRunner.c)new StructureGridSpawner(blockPos, 8, false)).a();
        List<GameTestHarnessInfo> testInfos = gameTestRunner.a();
        this.w = new GameTestHarnessCollector(testInfos);
        l.info("{} tests are now running at position {}!", (Object)this.w.h(), (Object)blockPos.x());
        this.u.reset();
        this.u.start();
        gameTestRunner.b();
    }

    private boolean br() {
        return this.w != null;
    }

    @Override
    public boolean v_() {
        return false;
    }

    @Override
    public int k() {
        return 0;
    }

    @Override
    public int l() {
        return 4;
    }

    @Override
    public boolean m() {
        return false;
    }

    @Override
    public boolean n() {
        return false;
    }

    @Override
    public int o() {
        return 0;
    }

    @Override
    public boolean p() {
        return false;
    }

    @Override
    public boolean q() {
        return true;
    }

    @Override
    public boolean r() {
        return false;
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean a(GameProfile profile) {
        return false;
    }
}

