/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class DynamicOpsNBT
implements DynamicOps<NBTBase> {
    public static final DynamicOpsNBT a = new DynamicOpsNBT();

    private DynamicOpsNBT() {
    }

    public NBTBase a() {
        return NBTTagEnd.b;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <U> U a(DynamicOps<U> ops, NBTBase tag) {
        NBTBase nBTBase = tag;
        Objects.requireNonNull(nBTBase);
        NBTBase nBTBase2 = nBTBase;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NBTTagEnd.class, NBTTagByte.class, NBTTagShort.class, NBTTagInt.class, NBTTagLong.class, NBTTagFloat.class, NBTTagDouble.class, NBTTagByteArray.class, NBTTagString.class, NBTTagList.class, NBTTagCompound.class, NBTTagIntArray.class, NBTTagLongArray.class}, (Object)nBTBase2, n2)) {
            case 0: {
                NBTTagEnd endTag = (NBTTagEnd)nBTBase2;
                Object object = ops.empty();
                return (U)object;
            }
            case 1: {
                byte var34;
                NBTTagByte nBTTagByte = (NBTTagByte)nBTBase2;
                try {
                    byte by;
                    var34 = by = nBTTagByte.n();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Object object = ops.createByte(var34);
                return (U)object;
            }
            case 2: {
                short var35;
                NBTTagShort nBTTagShort = (NBTTagShort)nBTBase2;
                {
                    short s2;
                    var35 = s2 = nBTTagShort.n();
                }
                Object object = ops.createShort(var35);
                return (U)object;
            }
            case 3: {
                int var36;
                NBTTagInt nBTTagInt = (NBTTagInt)nBTBase2;
                {
                    int n3;
                    var36 = n3 = nBTTagInt.n();
                }
                Object object = ops.createInt(var36);
                return (U)object;
            }
            case 4: {
                long var37;
                NBTTagLong nBTTagLong = (NBTTagLong)nBTBase2;
                {
                    long l2;
                    var37 = l2 = nBTTagLong.n();
                }
                Object object = ops.createLong(var37);
                return (U)object;
            }
            case 5: {
                float var38;
                NBTTagFloat nBTTagFloat = (NBTTagFloat)nBTBase2;
                {
                    float f2;
                    var38 = f2 = nBTTagFloat.n();
                }
                Object object = ops.createFloat(var38);
                return (U)object;
            }
            case 6: {
                double var39;
                NBTTagDouble nBTTagDouble = (NBTTagDouble)nBTBase2;
                {
                    double d2;
                    var39 = d2 = nBTTagDouble.n();
                }
                Object object = ops.createDouble(var39);
                return (U)object;
            }
            case 7: {
                NBTTagByteArray byteArrayTag = (NBTTagByteArray)nBTBase2;
                Object object = ops.createByteList(ByteBuffer.wrap(byteArrayTag.e()));
                return (U)object;
            }
            case 8: {
                String var40;
                NBTTagString nBTTagString = (NBTTagString)nBTBase2;
                {
                    String string;
                    var40 = string = nBTTagString.k();
                }
                Object object = ops.createString(var40);
                return (U)object;
            }
            case 9: {
                NBTTagList listTag = (NBTTagList)nBTBase2;
                Object object = this.convertList(ops, listTag);
                return (U)object;
            }
            case 10: {
                NBTTagCompound compoundTag = (NBTTagCompound)nBTBase2;
                Object object = this.convertMap(ops, compoundTag);
                return (U)object;
            }
            case 11: {
                NBTTagIntArray intArrayTag = (NBTTagIntArray)nBTBase2;
                Object object = ops.createIntList(Arrays.stream(intArrayTag.g()));
                return (U)object;
            }
            case 12: {
                NBTTagLongArray longArrayTag = (NBTTagLongArray)nBTBase2;
                Object object = ops.createLongList(Arrays.stream(longArrayTag.g()));
                return (U)object;
            }
        }
        throw new MatchException(null, null);
    }

    public DataResult<Number> a(NBTBase tag) {
        return tag.o().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Not a number"));
    }

    public NBTBase a(Number data) {
        return NBTTagDouble.a(data.doubleValue());
    }

    public NBTBase a(byte data) {
        return NBTTagByte.a(data);
    }

    public NBTBase a(short data) {
        return NBTTagShort.a(data);
    }

    public NBTBase a(int data) {
        return NBTTagInt.a(data);
    }

    public NBTBase a(long data) {
        return NBTTagLong.a(data);
    }

    public NBTBase a(float data) {
        return NBTTagFloat.a(data);
    }

    public NBTBase a(double data) {
        return NBTTagDouble.a(data);
    }

    public NBTBase a(boolean data) {
        return NBTTagByte.a(data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataResult<String> b(NBTBase tag) {
        String var4;
        DataResult dataResult;
        if (!(tag instanceof NBTTagString)) {
            dataResult = DataResult.error(() -> "Not a string");
            return dataResult;
        }
        NBTTagString nBTTagString = (NBTTagString)tag;
        try {
            String string;
            var4 = string = nBTTagString.k();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        dataResult = DataResult.success((Object)var4);
        return dataResult;
    }

    public NBTBase a(String data) {
        return NBTTagString.a(data);
    }

    public DataResult<NBTBase> a(NBTBase list, NBTBase tag) {
        return DynamicOpsNBT.k(list).map(listCollector -> DataResult.success((Object)listCollector.a(tag).a())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(list), (Object)list));
    }

    public DataResult<NBTBase> a(NBTBase list, List<NBTBase> tags) {
        return DynamicOpsNBT.k(list).map(listCollector -> DataResult.success((Object)listCollector.a(tags).a())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(list), (Object)list));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataResult<NBTBase> a(NBTBase map, NBTBase key, NBTBase value) {
        NBTTagCompound nBTTagCompound;
        String compoundTag;
        if (!(map instanceof NBTTagCompound) && !(map instanceof NBTTagEnd)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(map), (Object)map);
        }
        if (!(key instanceof NBTTagString)) return DataResult.error(() -> "key is not a string: " + String.valueOf(key), (Object)map);
        NBTTagString nBTTagString = (NBTTagString)key;
        try {
            String string;
            String var10;
            compoundTag = var10 = (string = nBTTagString.k());
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (map instanceof NBTTagCompound) {
            NBTTagCompound compoundTagx = (NBTTagCompound)map;
            nBTTagCompound = compoundTagx.k();
        } else {
            nBTTagCompound = new NBTTagCompound();
        }
        NBTTagCompound compoundTag1 = nBTTagCompound;
        compoundTag1.a(compoundTag, value);
        return DataResult.success((Object)compoundTag1);
    }

    public DataResult<NBTBase> a(NBTBase map, MapLike<NBTBase> otherMap) {
        NBTTagCompound nBTTagCompound;
        if (!(map instanceof NBTTagCompound) && !(map instanceof NBTTagEnd)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(map), (Object)map);
        }
        if (map instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)map;
            nBTTagCompound = compoundTag.k();
        } else {
            nBTTagCompound = new NBTTagCompound();
        }
        NBTTagCompound compoundTag1 = nBTTagCompound;
        ArrayList list = new ArrayList();
        otherMap.entries().forEach(pair -> {
            NBTBase tag = (NBTBase)pair.getFirst();
            if (!(tag instanceof NBTTagString)) {
                list.add(tag);
                return;
            }
            NBTTagString $b$0 = (NBTTagString)tag;
            try {
                String patt1$temp;
                String string = patt1$temp = $b$0.k();
                compoundTag1.a(string, (NBTBase)pair.getSecond());
                return;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        });
        return !list.isEmpty() ? DataResult.error(() -> "some keys are not strings: " + String.valueOf(list), (Object)compoundTag1) : DataResult.success((Object)compoundTag1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataResult<NBTBase> a(NBTBase tag, Map<NBTBase, NBTBase> map) {
        DataResult dataResult;
        NBTTagCompound nBTTagCompound;
        if (!(tag instanceof NBTTagCompound) && !(tag instanceof NBTTagEnd)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(tag), (Object)tag);
        }
        if (tag instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)tag;
            nBTTagCompound = compoundTag.k();
        } else {
            nBTTagCompound = new NBTTagCompound();
        }
        NBTTagCompound compoundTag1 = nBTTagCompound;
        ArrayList<NBTBase> list = new ArrayList<NBTBase>();
        for (Map.Entry<NBTBase, NBTBase> entry : map.entrySet()) {
            NBTBase tag1 = entry.getKey();
            if (tag1 instanceof NBTTagString) {
                NBTTagString nBTTagString = (NBTTagString)tag1;
                try {
                    String string;
                    String var10 = string = nBTTagString.k();
                    compoundTag1.a(var10, entry.getValue());
                    continue;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            list.add(tag1);
        }
        if (!list.isEmpty()) {
            dataResult = DataResult.error(() -> "some keys are not strings: " + String.valueOf(list), (Object)compoundTag1);
            return dataResult;
        }
        dataResult = DataResult.success((Object)compoundTag1);
        return dataResult;
    }

    public DataResult<Stream<Pair<NBTBase, NBTBase>>> c(NBTBase map) {
        DataResult dataResult;
        if (map instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)map;
            dataResult = DataResult.success(compoundTag.g().stream().map(entry -> Pair.of((Object)this.a((String)entry.getKey()), (Object)((NBTBase)entry.getValue()))));
        } else {
            dataResult = DataResult.error(() -> "Not a map: " + String.valueOf(map));
        }
        return dataResult;
    }

    public DataResult<Consumer<BiConsumer<NBTBase, NBTBase>>> d(NBTBase map) {
        DataResult dataResult;
        if (map instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)map;
            dataResult = DataResult.success(biConsumer -> {
                for (Map.Entry<String, NBTBase> entry : compoundTag.g()) {
                    biConsumer.accept(this.a(entry.getKey()), entry.getValue());
                }
            });
        } else {
            dataResult = DataResult.error(() -> "Not a map: " + String.valueOf(map));
        }
        return dataResult;
    }

    public DataResult<MapLike<NBTBase>> e(NBTBase map) {
        DataResult dataResult;
        if (map instanceof NBTTagCompound) {
            final NBTTagCompound compoundTag = (NBTTagCompound)map;
            dataResult = DataResult.success((Object)new MapLike<NBTBase>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public NBTBase a(NBTBase tag) {
                    if (!(tag instanceof NBTTagString)) throw new UnsupportedOperationException("Cannot get map entry with non-string key: " + String.valueOf(tag));
                    NBTTagString nBTTagString = (NBTTagString)tag;
                    try {
                        String string;
                        String var4 = string = nBTTagString.k();
                        return compoundTag.a(var4);
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }

                @Nullable
                public NBTBase a(String string) {
                    return compoundTag.a(string);
                }

                public Stream<Pair<NBTBase, NBTBase>> entries() {
                    return compoundTag.g().stream().map(entry -> Pair.of((Object)DynamicOpsNBT.this.a((String)entry.getKey()), (Object)((NBTBase)entry.getValue())));
                }

                public String toString() {
                    return "MapLike[" + String.valueOf(compoundTag) + "]";
                }
            });
        } else {
            dataResult = DataResult.error(() -> "Not a map: " + String.valueOf(map));
        }
        return dataResult;
    }

    public NBTBase a(Stream<Pair<NBTBase, NBTBase>> data) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        data.forEach(pair -> {
            NBTBase tag = (NBTBase)pair.getFirst();
            NBTBase tag1 = (NBTBase)pair.getSecond();
            if (!(tag instanceof NBTTagString)) throw new UnsupportedOperationException("Cannot create map with non-string key: " + String.valueOf(tag));
            NBTTagString $b$0 = (NBTTagString)tag;
            try {
                String patt1$temp;
                String string = patt1$temp = $b$0.k();
                compoundTag.a(string, tag1);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        });
        return compoundTag;
    }

    public DataResult<Stream<NBTBase>> f(NBTBase tag) {
        DataResult dataResult;
        if (tag instanceof NBTList) {
            NBTList collectionTag = (NBTList)tag;
            dataResult = DataResult.success(collectionTag.stream());
        } else {
            dataResult = DataResult.error(() -> "Not a list");
        }
        return dataResult;
    }

    public DataResult<Consumer<Consumer<NBTBase>>> g(NBTBase tag) {
        DataResult dataResult;
        if (tag instanceof NBTList) {
            NBTList collectionTag = (NBTList)tag;
            dataResult = DataResult.success(collectionTag::forEach);
        } else {
            dataResult = DataResult.error(() -> "Not a list: " + String.valueOf(tag));
        }
        return dataResult;
    }

    public DataResult<ByteBuffer> h(NBTBase tag) {
        DataResult dataResult;
        if (tag instanceof NBTTagByteArray) {
            NBTTagByteArray byteArrayTag = (NBTTagByteArray)tag;
            dataResult = DataResult.success((Object)ByteBuffer.wrap(byteArrayTag.e()));
        } else {
            dataResult = super.getByteBuffer((Object)tag);
        }
        return dataResult;
    }

    public NBTBase a(ByteBuffer data) {
        ByteBuffer byteBuffer = data.duplicate().clear();
        byte[] bytes = new byte[data.capacity()];
        byteBuffer.get(0, bytes, 0, bytes.length);
        return new NBTTagByteArray(bytes);
    }

    public DataResult<IntStream> i(NBTBase tag) {
        DataResult dataResult;
        if (tag instanceof NBTTagIntArray) {
            NBTTagIntArray intArrayTag = (NBTTagIntArray)tag;
            dataResult = DataResult.success((Object)Arrays.stream(intArrayTag.g()));
        } else {
            dataResult = super.getIntStream((Object)tag);
        }
        return dataResult;
    }

    public NBTBase a(IntStream data) {
        return new NBTTagIntArray(data.toArray());
    }

    public DataResult<LongStream> j(NBTBase tag) {
        DataResult dataResult;
        if (tag instanceof NBTTagLongArray) {
            NBTTagLongArray longArrayTag = (NBTTagLongArray)tag;
            dataResult = DataResult.success((Object)Arrays.stream(longArrayTag.g()));
        } else {
            dataResult = super.getLongStream((Object)tag);
        }
        return dataResult;
    }

    public NBTBase a(LongStream data) {
        return new NBTTagLongArray(data.toArray());
    }

    public NBTBase b(Stream<NBTBase> data) {
        return new NBTTagList(data.collect(SystemUtils.b()));
    }

    public NBTBase a(NBTBase map, String removeKey) {
        if (map instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)map;
            NBTTagCompound compoundTag1 = compoundTag.k();
            compoundTag1.r(removeKey);
            return compoundTag1;
        }
        return map;
    }

    public String toString() {
        return "NBT";
    }

    public RecordBuilder<NBTBase> mapBuilder() {
        return new f(this);
    }

    private static Optional<d> k(NBTBase tag) {
        if (tag instanceof NBTTagEnd) {
            return Optional.of(new b());
        }
        if (tag instanceof NBTList) {
            NBTList collectionTag = (NBTList)tag;
            if (collectionTag.isEmpty()) {
                return Optional.of(new b());
            }
            NBTList nBTList = collectionTag;
            Objects.requireNonNull(nBTList);
            NBTList nBTList2 = nBTList;
            int n2 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NBTTagList.class, NBTTagByteArray.class, NBTTagIntArray.class, NBTTagLongArray.class}, (Object)nBTList2, n2)) {
                case 0 -> {
                    NBTTagList listTag = (NBTTagList)nBTList2;
                    yield Optional.of(new b(listTag));
                }
                case 1 -> {
                    NBTTagByteArray byteArrayTag = (NBTTagByteArray)nBTList2;
                    yield Optional.of(new a(byteArrayTag.e()));
                }
                case 2 -> {
                    NBTTagIntArray intArrayTag = (NBTTagIntArray)nBTList2;
                    yield Optional.of(new c(intArrayTag.g()));
                }
                case 3 -> {
                    NBTTagLongArray longArrayTag = (NBTTagLongArray)nBTList2;
                    yield Optional.of(new e(longArrayTag.g()));
                }
                default -> throw new MatchException(null, null);
            };
        }
        return Optional.empty();
    }

    class f
    extends RecordBuilder.AbstractStringBuilder<NBTBase, NBTTagCompound> {
        protected f(DynamicOpsNBT this$0) {
            super((DynamicOps)this$0);
        }

        protected NBTTagCompound a() {
            return new NBTTagCompound();
        }

        protected NBTTagCompound a(String key, NBTBase value, NBTTagCompound tag) {
            tag.a(key, value);
            return tag;
        }

        protected DataResult<NBTBase> a(NBTTagCompound compoundTag, NBTBase tag) {
            if (tag == null || tag == NBTTagEnd.b) {
                return DataResult.success((Object)compoundTag);
            }
            if (!(tag instanceof NBTTagCompound)) {
                return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(tag), (Object)tag);
            }
            NBTTagCompound compoundTag1 = (NBTTagCompound)tag;
            NBTTagCompound compoundTag2 = compoundTag1.k();
            for (Map.Entry<String, NBTBase> entry : compoundTag.g()) {
                compoundTag2.a(entry.getKey(), entry.getValue());
            }
            return DataResult.success((Object)compoundTag2);
        }
    }

    static class b
    implements d {
        private final NBTTagList a = new NBTTagList();

        b() {
        }

        b(NBTTagList list) {
            this.a.addAll(list);
        }

        public b(IntArrayList list) {
            list.forEach(i2 -> this.a.add(NBTTagInt.a(i2)));
        }

        public b(ByteArrayList list) {
            list.forEach(b2 -> this.a.add(NBTTagByte.a(b2)));
        }

        public b(LongArrayList list) {
            list.forEach(l2 -> this.a.add(NBTTagLong.a(l2)));
        }

        @Override
        public d a(NBTBase tag) {
            this.a.add(tag);
            return this;
        }

        @Override
        public NBTBase a() {
            return this.a;
        }
    }

    static class a
    implements d {
        private final ByteArrayList a = new ByteArrayList();

        public a(byte[] values) {
            this.a.addElements(0, values);
        }

        @Override
        public d a(NBTBase tag) {
            if (tag instanceof NBTTagByte) {
                NBTTagByte byteTag = (NBTTagByte)tag;
                this.a.add(byteTag.j());
                return this;
            }
            return new b(this.a).a(tag);
        }

        @Override
        public NBTBase a() {
            return new NBTTagByteArray(this.a.toByteArray());
        }
    }

    static class c
    implements d {
        private final IntArrayList a = new IntArrayList();

        public c(int[] values) {
            this.a.addElements(0, values);
        }

        @Override
        public d a(NBTBase tag) {
            if (tag instanceof NBTTagInt) {
                NBTTagInt intTag = (NBTTagInt)tag;
                this.a.add(intTag.h());
                return this;
            }
            return new b(this.a).a(tag);
        }

        @Override
        public NBTBase a() {
            return new NBTTagIntArray(this.a.toIntArray());
        }
    }

    static class e
    implements d {
        private final LongArrayList a = new LongArrayList();

        public e(long[] values) {
            this.a.addElements(0, values);
        }

        @Override
        public d a(NBTBase tag) {
            if (tag instanceof NBTTagLong) {
                NBTTagLong longTag = (NBTTagLong)tag;
                this.a.add(longTag.g());
                return this;
            }
            return new b(this.a).a(tag);
        }

        @Override
        public NBTBase a() {
            return new NBTTagLongArray(this.a.toLongArray());
        }
    }

    static interface d {
        public d a(NBTBase var1);

        default public d a(Iterable<NBTBase> tags) {
            d listCollector = this;
            for (NBTBase tag : tags) {
                listCollector = listCollector.a(tag);
            }
            return listCollector;
        }

        default public d a(Stream<NBTBase> tags) {
            return this.a(tags::iterator);
        }

        public NBTBase a();
    }
}

