/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public final class NBTTagByteArray
implements NBTList {
    private static final int b = 24;
    public static final NBTTagType<NBTTagByteArray> a = new NBTTagType.b<NBTTagByteArray>(){

        public NBTTagByteArray a(DataInput input, NBTReadLimiter accounter) throws IOException {
            return new NBTTagByteArray(1.d(input, accounter));
        }

        @Override
        public StreamTagVisitor.b a(DataInput input, StreamTagVisitor visitor, NBTReadLimiter accounter) throws IOException {
            return visitor.a(1.d(input, accounter));
        }

        private static byte[] d(DataInput input, NBTReadLimiter accounter) throws IOException {
            accounter.b(24L);
            int _int = input.readInt();
            Preconditions.checkArgument((_int < 0x1000000 ? 1 : 0) != 0);
            accounter.a(1L, _int);
            byte[] bytes = new byte[_int];
            input.readFully(bytes);
            return bytes;
        }

        @Override
        public void b(DataInput input, NBTReadLimiter accounter) throws IOException {
            input.skipBytes(input.readInt() * 1);
        }

        @Override
        public String a() {
            return "BYTE[]";
        }

        @Override
        public String b() {
            return "TAG_Byte_Array";
        }
    };
    private byte[] c;

    public NBTTagByteArray(byte[] data) {
        this.c = data;
    }

    @Override
    public void a(DataOutput output) throws IOException {
        output.writeInt(this.c.length);
        output.write(this.c);
    }

    @Override
    public int a() {
        return 24 + 1 * this.c.length;
    }

    @Override
    public byte b() {
        return 7;
    }

    public NBTTagType<NBTTagByteArray> c() {
        return a;
    }

    @Override
    public String toString() {
        StringTagVisitor stringTagVisitor = new StringTagVisitor();
        stringTagVisitor.a(this);
        return stringTagVisitor.a();
    }

    @Override
    public NBTBase d() {
        byte[] bytes = new byte[this.c.length];
        System.arraycopy(this.c, 0, bytes, 0, this.c.length);
        return new NBTTagByteArray(bytes);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof NBTTagByteArray && Arrays.equals(this.c, ((NBTTagByteArray)other).c);
    }

    public int hashCode() {
        return Arrays.hashCode(this.c);
    }

    @Override
    public void a(TagVisitor visitor) {
        visitor.a(this);
    }

    public byte[] e() {
        return this.c;
    }

    @Override
    public int size() {
        return this.c.length;
    }

    public NBTTagByte a(int index) {
        return NBTTagByte.a(this.c[index]);
    }

    @Override
    public boolean a(int index, NBTBase nbt) {
        if (nbt instanceof NBTNumber) {
            NBTNumber numericTag = (NBTNumber)nbt;
            this.c[index] = numericTag.j();
            return true;
        }
        return false;
    }

    @Override
    public boolean b(int index, NBTBase nbt) {
        if (nbt instanceof NBTNumber) {
            NBTNumber numericTag = (NBTNumber)nbt;
            this.c = ArrayUtils.add((byte[])this.c, (int)index, (byte)numericTag.j());
            return true;
        }
        return false;
    }

    public NBTTagByte b(int index) {
        byte b2 = this.c[index];
        this.c = ArrayUtils.remove((byte[])this.c, (int)index);
        return NBTTagByte.a(b2);
    }

    @Override
    public void clear() {
        this.c = new byte[0];
    }

    @Override
    public Optional<byte[]> f() {
        return Optional.of(this.c);
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor visitor) {
        return visitor.a(this.c);
    }
}

