/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.PrimitiveTag;
import net.minecraft.nbt.SnbtGrammar;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.TagVisitor;

public record NBTTagString(String b) implements PrimitiveTag
{
    private final String b;
    private static final int c = 36;
    public static final NBTTagType<NBTTagString> a = new NBTTagType.b<NBTTagString>(){

        public NBTTagString a(DataInput input, NBTReadLimiter accounter) throws IOException {
            return NBTTagString.a(1.d(input, accounter));
        }

        @Override
        public StreamTagVisitor.b a(DataInput input, StreamTagVisitor visitor, NBTReadLimiter accounter) throws IOException {
            return visitor.a(1.d(input, accounter));
        }

        private static String d(DataInput input, NBTReadLimiter nbtAccounter) throws IOException {
            nbtAccounter.b(36L);
            String utf = input.readUTF();
            nbtAccounter.a(2L, utf.length());
            return utf;
        }

        @Override
        public void b(DataInput input, NBTReadLimiter accounter) throws IOException {
            NBTTagString.a(input);
        }

        @Override
        public String a() {
            return "STRING";
        }

        @Override
        public String b() {
            return "TAG_String";
        }
    };
    private static final NBTTagString v = new NBTTagString("");
    private static final char w = '\"';
    private static final char x = '\'';
    private static final char y = '\\';
    private static final char z = '\u0000';

    public static void a(DataInput input) throws IOException {
        input.skipBytes(input.readUnsignedShort());
    }

    public static NBTTagString a(String data) {
        return data.isEmpty() ? v : new NBTTagString(data);
    }

    @Override
    public void a(DataOutput output) throws IOException {
        output.writeUTF(this.b);
    }

    @Override
    public int a() {
        return 36 + 2 * this.b.length();
    }

    @Override
    public byte b() {
        return 8;
    }

    public NBTTagType<NBTTagString> c() {
        return a;
    }

    @Override
    public String toString() {
        StringTagVisitor stringTagVisitor = new StringTagVisitor();
        stringTagVisitor.a(this);
        return stringTagVisitor.a();
    }

    public NBTTagString e() {
        return this;
    }

    @Override
    public Optional<String> p_() {
        return Optional.of(this.b);
    }

    @Override
    public void a(TagVisitor visitor) {
        visitor.a(this);
    }

    public static String b(String text) {
        StringBuilder stringBuilder = new StringBuilder();
        NBTTagString.a(text, stringBuilder);
        return stringBuilder.toString();
    }

    public static void a(String text, StringBuilder stringBuilder) {
        int len = stringBuilder.length();
        stringBuilder.append(' ');
        char c2 = '\u0000';
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c1 = text.charAt(i2);
            if (c1 == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (c1 != '\"' && c1 != '\'') {
                String string = SnbtGrammar.a(c1);
                if (string != null) {
                    stringBuilder.append('\\');
                    stringBuilder.append(string);
                    continue;
                }
                stringBuilder.append(c1);
                continue;
            }
            if (c2 == '\u0000') {
                c2 = (char)(c1 == '\"' ? 39 : 34);
            }
            if (c2 == c1) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c1);
        }
        if (c2 == '\u0000') {
            c2 = '\"';
        }
        stringBuilder.setCharAt(len, c2);
        stringBuilder.append(c2);
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor visitor) {
        return visitor.a(this.b);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NBTTagString.class, "value", "b"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NBTTagString.class, "value", "b"}, this, o2);
    }

    public String k() {
        return this.b;
    }
}

