/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedBytes;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.chars.CharList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.util.HexFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.nbt.SnbtOperations;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.DelayedException;
import net.minecraft.util.parsing.packrat.Dictionary;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;
import net.minecraft.util.parsing.packrat.Term;
import net.minecraft.util.parsing.packrat.commands.Grammar;
import net.minecraft.util.parsing.packrat.commands.GreedyPatternParseRule;
import net.minecraft.util.parsing.packrat.commands.GreedyPredicateParseRule;
import net.minecraft.util.parsing.packrat.commands.NumberRunParseRule;
import net.minecraft.util.parsing.packrat.commands.StringReaderTerms;
import net.minecraft.util.parsing.packrat.commands.UnquotedStringParseRule;

public class SnbtGrammar {
    private static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(number -> IChatBaseComponent.b("snbt.parser.number_parse_failure", number));
    static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(length -> IChatBaseComponent.b("snbt.parser.expected_hex_escape", length));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(codepoint -> IChatBaseComponent.b("snbt.parser.invalid_codepoint", codepoint));
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(operation -> IChatBaseComponent.b("snbt.parser.no_such_operation", operation));
    static final DelayedException<CommandSyntaxException> e = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.expected_integer_type")));
    private static final DelayedException<CommandSyntaxException> f = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.expected_float_type")));
    static final DelayedException<CommandSyntaxException> g = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.expected_non_negative_number")));
    private static final DelayedException<CommandSyntaxException> h = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.invalid_character_name")));
    static final DelayedException<CommandSyntaxException> i = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.invalid_array_element_type")));
    private static final DelayedException<CommandSyntaxException> j = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.invalid_unquoted_start")));
    private static final DelayedException<CommandSyntaxException> k = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.expected_unquoted_string")));
    private static final DelayedException<CommandSyntaxException> l = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.invalid_string_contents")));
    private static final DelayedException<CommandSyntaxException> m = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.expected_binary_numeral")));
    private static final DelayedException<CommandSyntaxException> n = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.undescore_not_allowed")));
    private static final DelayedException<CommandSyntaxException> o = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.expected_decimal_numeral")));
    private static final DelayedException<CommandSyntaxException> p = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.expected_hex_numeral")));
    private static final DelayedException<CommandSyntaxException> q = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.empty_key")));
    private static final DelayedException<CommandSyntaxException> r = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.leading_zero_not_allowed")));
    private static final DelayedException<CommandSyntaxException> s = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.infinity_not_allowed")));
    private static final HexFormat t = HexFormat.of().withUpperCase();
    private static final NumberRunParseRule u = new NumberRunParseRule((DelayedException)m, (DelayedException)n){

        @Override
        protected boolean a(char c2) {
            return switch (c2) {
                case '0', '1', '_' -> true;
                default -> false;
            };
        }
    };
    private static final NumberRunParseRule v = new NumberRunParseRule((DelayedException)o, (DelayedException)n){

        @Override
        protected boolean a(char c2) {
            return switch (c2) {
                case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_' -> true;
                default -> false;
            };
        }
    };
    private static final NumberRunParseRule w = new NumberRunParseRule((DelayedException)p, (DelayedException)n){

        @Override
        protected boolean a(char c2) {
            return switch (c2) {
                case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '_', 'a', 'b', 'c', 'd', 'e', 'f' -> true;
                default -> false;
            };
        }
    };
    private static final GreedyPredicateParseRule x = new GreedyPredicateParseRule(1, (DelayedException)l){

        @Override
        protected boolean a(char c2) {
            return switch (c2) {
                case '\"', '\'', '\\' -> false;
                default -> true;
            };
        }
    };
    private static final StringReaderTerms.a y = new StringReaderTerms.a(CharList.of()){

        @Override
        protected boolean a(char c2) {
            return SnbtGrammar.c(c2);
        }
    };
    private static final Pattern z = Pattern.compile("[-a-zA-Z0-9 ]+");

    static DelayedException<CommandSyntaxException> a(NumberFormatException numberFormatException) {
        return DelayedException.a(a, numberFormatException.getMessage());
    }

    @Nullable
    public static String a(char c2) {
        return switch (c2) {
            case '\b' -> "b";
            case '\t' -> "t";
            case '\n' -> "n";
            default -> {
                if (c2 < ' ') {
                    yield "x" + t.toHexDigits((byte)c2);
                }
                yield null;
            }
            case '\f' -> "f";
            case '\r' -> "r";
        };
    }

    private static boolean b(char c2) {
        return !SnbtGrammar.c(c2);
    }

    static boolean c(char c2) {
        return switch (c2) {
            case '+', '-', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' -> true;
            default -> false;
        };
    }

    static boolean a(String text) {
        return text.indexOf(95) != -1;
    }

    private static void a(StringBuilder stringBuilder, String text) {
        SnbtGrammar.a(stringBuilder, text, SnbtGrammar.a(text));
    }

    static void a(StringBuilder stringBuilder, String text, boolean removeUnderscores) {
        if (removeUnderscores) {
            for (char c2 : text.toCharArray()) {
                if (c2 == '_') continue;
                stringBuilder.append(c2);
            }
        } else {
            stringBuilder.append(text);
        }
    }

    static short a(String text, int radix) {
        int i2 = Integer.parseInt(text, radix);
        if (i2 >> 16 == 0) {
            return (short)i2;
        }
        throw new NumberFormatException("out of range: " + i2);
    }

    @Nullable
    private static <T> T a(DynamicOps<T> ops, e sign, @Nullable String wholePart, @Nullable String fractionPart, @Nullable f<String> exponentPart, @Nullable i suffix, ParseState<?> parseState) {
        StringBuilder stringBuilder = new StringBuilder();
        sign.a(stringBuilder);
        if (wholePart != null) {
            SnbtGrammar.a(stringBuilder, wholePart);
        }
        if (fractionPart != null) {
            stringBuilder.append('.');
            SnbtGrammar.a(stringBuilder, fractionPart);
        }
        if (exponentPart != null) {
            stringBuilder.append('e');
            exponentPart.a().a(stringBuilder);
            SnbtGrammar.a(stringBuilder, (String)exponentPart.b);
        }
        try {
            String string = stringBuilder.toString();
            i i2 = suffix;
            int n2 = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"FLOAT", "DOUBLE"}, (i)i2, n2)) {
                case -1 -> SnbtGrammar.b(ops, parseState, string);
                case 0 -> SnbtGrammar.a(ops, parseState, string);
                case 1 -> SnbtGrammar.b(ops, parseState, string);
                default -> {
                    parseState.b().a(parseState.g(), f);
                    yield null;
                }
            };
        }
        catch (NumberFormatException var11) {
            parseState.b().a(parseState.g(), SnbtGrammar.a(var11));
            return null;
        }
    }

    @Nullable
    private static <T> T a(DynamicOps<T> ops, ParseState<?> parseState, String value) {
        float f2 = Float.parseFloat(value);
        if (!Float.isFinite(f2)) {
            parseState.b().a(parseState.g(), s);
            return null;
        }
        return (T)ops.createFloat(f2);
    }

    @Nullable
    private static <T> T b(DynamicOps<T> ops, ParseState<?> parseState, String value) {
        double d2 = Double.parseDouble(value);
        if (!Double.isFinite(d2)) {
            parseState.b().a(parseState.g(), s);
            return null;
        }
        return (T)ops.createDouble(d2);
    }

    private static String a(List<String> list) {
        return switch (list.size()) {
            case 0 -> "";
            case 1 -> list.getFirst();
            default -> String.join((CharSequence)"", list);
        };
    }

    public static <T> Grammar<T> a(DynamicOps<T> ops) {
        Object object = ops.createBoolean(true);
        Object object1 = ops.createBoolean(false);
        Object object2 = ops.emptyMap();
        Object object3 = ops.emptyList();
        Dictionary<StringReader> dictionary = new Dictionary<StringReader>();
        Atom atom = Atom.a("sign");
        dictionary.a(atom, Term.b(Term.a(StringReaderTerms.a('+'), Term.a(atom, net.minecraft.nbt.SnbtGrammar$e.a)), Term.a(StringReaderTerms.a('-'), Term.a(atom, net.minecraft.nbt.SnbtGrammar$e.b))), scope -> (e)((Object)((Object)scope.b(atom))));
        Atom atom1 = Atom.a("integer_suffix");
        dictionary.a(atom1, Term.b(Term.a(StringReaderTerms.a('u', 'U'), Term.b(Term.a(StringReaderTerms.a('b', 'B'), Term.a(atom1, new d(net.minecraft.nbt.SnbtGrammar$g.b, net.minecraft.nbt.SnbtGrammar$i.c))), Term.a(StringReaderTerms.a('s', 'S'), Term.a(atom1, new d(net.minecraft.nbt.SnbtGrammar$g.b, net.minecraft.nbt.SnbtGrammar$i.d))), Term.a(StringReaderTerms.a('i', 'I'), Term.a(atom1, new d(net.minecraft.nbt.SnbtGrammar$g.b, net.minecraft.nbt.SnbtGrammar$i.e))), Term.a(StringReaderTerms.a('l', 'L'), Term.a(atom1, new d(net.minecraft.nbt.SnbtGrammar$g.b, net.minecraft.nbt.SnbtGrammar$i.f))))), Term.a(StringReaderTerms.a('s', 'S'), Term.b(Term.a(StringReaderTerms.a('b', 'B'), Term.a(atom1, new d(net.minecraft.nbt.SnbtGrammar$g.a, net.minecraft.nbt.SnbtGrammar$i.c))), Term.a(StringReaderTerms.a('s', 'S'), Term.a(atom1, new d(net.minecraft.nbt.SnbtGrammar$g.a, net.minecraft.nbt.SnbtGrammar$i.d))), Term.a(StringReaderTerms.a('i', 'I'), Term.a(atom1, new d(net.minecraft.nbt.SnbtGrammar$g.a, net.minecraft.nbt.SnbtGrammar$i.e))), Term.a(StringReaderTerms.a('l', 'L'), Term.a(atom1, new d(net.minecraft.nbt.SnbtGrammar$g.a, net.minecraft.nbt.SnbtGrammar$i.f))))), Term.a(StringReaderTerms.a('b', 'B'), Term.a(atom1, new d(null, net.minecraft.nbt.SnbtGrammar$i.c))), Term.a(StringReaderTerms.a('s', 'S'), Term.a(atom1, new d(null, net.minecraft.nbt.SnbtGrammar$i.d))), Term.a(StringReaderTerms.a('i', 'I'), Term.a(atom1, new d(null, net.minecraft.nbt.SnbtGrammar$i.e))), Term.a(StringReaderTerms.a('l', 'L'), Term.a(atom1, new d(null, net.minecraft.nbt.SnbtGrammar$i.f)))), scope -> (d)scope.b(atom1));
        Atom atom2 = Atom.a("binary_numeral");
        dictionary.a(atom2, u);
        Atom atom3 = Atom.a("decimal_numeral");
        dictionary.a(atom3, v);
        Atom atom4 = Atom.a("hex_numeral");
        dictionary.a(atom4, w);
        Atom atom5 = Atom.a("integer_literal");
        NamedRule namedRule = dictionary.a(atom5, Term.a(Term.a(dictionary.c(atom)), Term.b(Term.a(StringReaderTerms.a('0'), Term.c(), Term.b(Term.a(StringReaderTerms.a('x', 'X'), Term.c(), dictionary.c(atom4)), Term.a(StringReaderTerms.a('b', 'B'), dictionary.c(atom2)), Term.a(dictionary.c(atom3), Term.c(), Term.a(r)), Term.a(atom3, "0"))), dictionary.c(atom3)), Term.a(dictionary.c(atom1))), scope -> {
            d integerSuffix = scope.b(atom1, net.minecraft.nbt.SnbtGrammar$d.a);
            e sign = scope.b(atom, net.minecraft.nbt.SnbtGrammar$e.a);
            String string = (String)scope.a(atom3);
            if (string != null) {
                return new c(sign, net.minecraft.nbt.SnbtGrammar$b.b, string, integerSuffix);
            }
            String string1 = (String)scope.a(atom4);
            if (string1 != null) {
                return new c(sign, net.minecraft.nbt.SnbtGrammar$b.c, string1, integerSuffix);
            }
            String string2 = (String)scope.b(atom2);
            return new c(sign, net.minecraft.nbt.SnbtGrammar$b.a, string2, integerSuffix);
        });
        Atom atom6 = Atom.a("float_type_suffix");
        dictionary.a(atom6, Term.b(Term.a(StringReaderTerms.a('f', 'F'), Term.a(atom6, net.minecraft.nbt.SnbtGrammar$i.a)), Term.a(StringReaderTerms.a('d', 'D'), Term.a(atom6, net.minecraft.nbt.SnbtGrammar$i.b))), scope -> (i)((Object)((Object)scope.b(atom6))));
        Atom atom7 = Atom.a("float_exponent_part");
        dictionary.a(atom7, Term.a(StringReaderTerms.a('e', 'E'), Term.a(dictionary.c(atom)), dictionary.c(atom3)), scope -> new f<String>(scope.b(atom, net.minecraft.nbt.SnbtGrammar$e.a), (String)scope.b(atom3)));
        Atom atom8 = Atom.a("float_whole_part");
        Atom atom9 = Atom.a("float_fraction_part");
        Atom atom10 = Atom.a("float_literal");
        dictionary.a(atom10, Term.a(Term.a(dictionary.c(atom)), Term.b(Term.a(dictionary.a(atom3, atom8), StringReaderTerms.a('.'), Term.c(), Term.a(dictionary.a(atom3, atom9)), Term.a(dictionary.c(atom7)), Term.a(dictionary.c(atom6))), Term.a(StringReaderTerms.a('.'), Term.c(), dictionary.a(atom3, atom9), Term.a(dictionary.c(atom7)), Term.a(dictionary.c(atom6))), Term.a(dictionary.a(atom3, atom8), dictionary.c(atom7), Term.c(), Term.a(dictionary.c(atom6))), Term.a(dictionary.a(atom3, atom8), Term.a(dictionary.c(atom7)), dictionary.c(atom6)))), parseState -> {
            Scope scope = parseState.a();
            e sign = scope.b(atom, net.minecraft.nbt.SnbtGrammar$e.a);
            String string = (String)scope.a(atom8);
            String string1 = (String)scope.a(atom9);
            f signed = (f)scope.a(atom7);
            i typeSuffix = (i)((Object)((Object)scope.a(atom6)));
            return SnbtGrammar.a(ops, sign, string, string1, signed, typeSuffix, parseState);
        });
        Atom atom11 = Atom.a("string_hex_2");
        dictionary.a(atom11, new h(2));
        Atom atom12 = Atom.a("string_hex_4");
        dictionary.a(atom12, new h(4));
        Atom atom13 = Atom.a("string_hex_8");
        dictionary.a(atom13, new h(8));
        Atom atom14 = Atom.a("string_unicode_name");
        dictionary.a(atom14, new GreedyPatternParseRule(z, h));
        Atom atom15 = Atom.a("string_escape_sequence");
        dictionary.a(atom15, Term.b(Term.a(StringReaderTerms.a('b'), Term.a(atom15, "\b")), Term.a(StringReaderTerms.a('s'), Term.a(atom15, " ")), Term.a(StringReaderTerms.a('t'), Term.a(atom15, "\t")), Term.a(StringReaderTerms.a('n'), Term.a(atom15, "\n")), Term.a(StringReaderTerms.a('f'), Term.a(atom15, "\f")), Term.a(StringReaderTerms.a('r'), Term.a(atom15, "\r")), Term.a(StringReaderTerms.a('\\'), Term.a(atom15, "\\")), Term.a(StringReaderTerms.a('\''), Term.a(atom15, "'")), Term.a(StringReaderTerms.a('\"'), Term.a(atom15, "\"")), Term.a(StringReaderTerms.a('x'), dictionary.c(atom11)), Term.a(StringReaderTerms.a('u'), dictionary.c(atom12)), Term.a(StringReaderTerms.a('U'), dictionary.c(atom13)), Term.a(StringReaderTerms.a('N'), StringReaderTerms.a('{'), dictionary.c(atom14), StringReaderTerms.a('}'))), parseState -> {
            int i1;
            Scope scope = parseState.a();
            String string = (String)scope.b(new Atom[]{atom15});
            if (string != null) {
                return string;
            }
            String string1 = (String)scope.b(atom11, atom12, atom13);
            if (string1 != null) {
                int i2 = HexFormat.fromHexDigits(string1);
                if (!Character.isValidCodePoint(i2)) {
                    parseState.b().a(parseState.g(), DelayedException.a(c, String.format(Locale.ROOT, "U+%08X", i2)));
                    return null;
                }
                return Character.toString(i2);
            }
            String string2 = (String)scope.b(atom14);
            try {
                i1 = Character.codePointOf(string2);
            }
            catch (IllegalArgumentException var12x) {
                parseState.b().a(parseState.g(), h);
                return null;
            }
            return Character.toString(i1);
        });
        Atom atom16 = Atom.a("string_plain_contents");
        dictionary.a(atom16, x);
        Atom atom17 = Atom.a("string_chunks");
        Atom atom18 = Atom.a("string_contents");
        Atom atom19 = Atom.a("single_quoted_string_chunk");
        NamedRule namedRule1 = dictionary.a(atom19, Term.b(dictionary.a(atom16, atom18), Term.a(StringReaderTerms.a('\\'), dictionary.a(atom15, atom18)), Term.a(StringReaderTerms.a('\"'), Term.a(atom18, "\""))), scope -> (String)scope.b(atom18));
        Atom atom20 = Atom.a("single_quoted_string_contents");
        dictionary.a(atom20, Term.a(namedRule1, atom17), scope -> SnbtGrammar.a((List)scope.b(atom17)));
        Atom atom21 = Atom.a("double_quoted_string_chunk");
        NamedRule namedRule2 = dictionary.a(atom21, Term.b(dictionary.a(atom16, atom18), Term.a(StringReaderTerms.a('\\'), dictionary.a(atom15, atom18)), Term.a(StringReaderTerms.a('\''), Term.a(atom18, "'"))), scope -> (String)scope.b(atom18));
        Atom atom22 = Atom.a("double_quoted_string_contents");
        dictionary.a(atom22, Term.a(namedRule2, atom17), scope -> SnbtGrammar.a((List)scope.b(atom17)));
        Atom atom23 = Atom.a("quoted_string_literal");
        dictionary.a(atom23, Term.b(Term.a(StringReaderTerms.a('\"'), Term.c(), Term.a(dictionary.a(atom22, atom18)), StringReaderTerms.a('\"')), Term.a(StringReaderTerms.a('\''), Term.a(dictionary.a(atom20, atom18)), StringReaderTerms.a('\''))), scope -> (String)scope.b(atom18));
        Atom atom24 = Atom.a("unquoted_string");
        dictionary.a(atom24, new UnquotedStringParseRule(1, k));
        Atom atom25 = Atom.a("literal");
        Atom atom26 = Atom.a("arguments");
        dictionary.a(atom26, Term.a(dictionary.b(atom25), atom26, StringReaderTerms.a(',')), scope -> (List)scope.b(atom26));
        Atom atom27 = Atom.a("unquoted_string_or_builtin");
        dictionary.a(atom27, Term.a(dictionary.c(atom24), Term.a(Term.a(StringReaderTerms.a('('), dictionary.c(atom26), StringReaderTerms.a(')')))), parseState -> {
            Scope scope = parseState.a();
            String string = (String)scope.b(atom24);
            if (!string.isEmpty() && SnbtGrammar.b(string.charAt(0))) {
                List list = (List)scope.a(atom26);
                if (list != null) {
                    SnbtOperations.a builtinKey = new SnbtOperations.a(string, list.size());
                    SnbtOperations.b builtinOperation = SnbtOperations.c.get(builtinKey);
                    if (builtinOperation != null) {
                        return builtinOperation.a(ops, list, parseState);
                    }
                    parseState.b().a(parseState.g(), DelayedException.a(d, builtinKey.toString()));
                    return null;
                }
                if (string.equalsIgnoreCase("true")) {
                    return object;
                }
                return string.equalsIgnoreCase("false") ? object1 : ops.createString(string);
            }
            parseState.b().a(parseState.g(), SnbtOperations.d, j);
            return null;
        });
        Atom atom28 = Atom.a("map_key");
        dictionary.a(atom28, Term.b(dictionary.c(atom23), dictionary.c(atom24)), scope -> (String)scope.c(atom23, atom24));
        Atom atom29 = Atom.a("map_entry");
        NamedRule namedRule3 = dictionary.a(atom29, Term.a(dictionary.c(atom28), StringReaderTerms.a(':'), dictionary.c(atom25)), parseState -> {
            Scope scope = parseState.a();
            String string = (String)scope.b(atom28);
            if (string.isEmpty()) {
                parseState.b().a(parseState.g(), q);
                return null;
            }
            Object orThrow = scope.b(atom25);
            return Map.entry(string, orThrow);
        });
        Atom atom30 = Atom.a("map_entries");
        dictionary.a(atom30, Term.a(namedRule3, atom30, StringReaderTerms.a(',')), scope -> (List)scope.b(atom30));
        Atom atom31 = Atom.a("map_literal");
        dictionary.a(atom31, Term.a(StringReaderTerms.a('{'), Scope.increaseDepth(), dictionary.c(atom30), Scope.decreaseDepth(), StringReaderTerms.a('}')), scope -> {
            List list = (List)scope.b(atom30);
            if (list.isEmpty()) {
                return object2;
            }
            ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)list.size());
            for (Map.Entry entry : list) {
                builder.put(ops.createString((String)entry.getKey()), entry.getValue());
            }
            return ops.createMap((Map)builder.buildKeepingLast());
        });
        Atom atom32 = Atom.a("list_entries");
        dictionary.a(atom32, Term.a(dictionary.b(atom25), atom32, StringReaderTerms.a(',')), scope -> (List)scope.b(atom32));
        Atom atom33 = Atom.a("array_prefix");
        dictionary.a(atom33, Term.b(Term.a(StringReaderTerms.a('B'), Term.a(atom33, net.minecraft.nbt.SnbtGrammar$a.a)), Term.a(StringReaderTerms.a('L'), Term.a(atom33, net.minecraft.nbt.SnbtGrammar$a.c)), Term.a(StringReaderTerms.a('I'), Term.a(atom33, net.minecraft.nbt.SnbtGrammar$a.b))), scope -> (a)((Object)((Object)scope.b(atom33))));
        Atom atom34 = Atom.a("int_array_entries");
        dictionary.a(atom34, Term.a(namedRule, atom34, StringReaderTerms.a(',')), scope -> (List)scope.b(atom34));
        Atom atom35 = Atom.a("list_literal");
        dictionary.a(atom35, Term.a(StringReaderTerms.a('['), Scope.increaseDepth(), Term.b(Term.a(dictionary.c(atom33), StringReaderTerms.a(';'), dictionary.c(atom34)), dictionary.c(atom32)), Scope.decreaseDepth(), StringReaderTerms.a(']')), parseState -> {
            Scope scope = parseState.a();
            a arrayPrefix = (a)((Object)((Object)scope.a(atom33)));
            if (arrayPrefix != null) {
                List list = (List)scope.b(atom34);
                return list.isEmpty() ? arrayPrefix.a(ops) : arrayPrefix.a(ops, list, parseState);
            }
            List list = (List)scope.b(atom32);
            return list.isEmpty() ? object3 : ops.createList(list.stream());
        });
        NamedRule namedRule4 = dictionary.a(atom25, Term.b(Term.a(Term.b(y), Term.b(dictionary.a(atom10, atom25), dictionary.c(atom5))), Term.a(Term.b(StringReaderTerms.a('\"', '\'')), Term.c(), dictionary.c(atom23)), Term.a(Term.b(StringReaderTerms.a('{')), Term.c(), dictionary.a(atom31, atom25)), Term.a(Term.b(StringReaderTerms.a('[')), Term.c(), dictionary.a(atom35, atom25)), dictionary.a(atom27, atom25)), parseState -> {
            Scope scope = parseState.a();
            String string = (String)scope.a(atom23);
            if (string != null) {
                return ops.createString(string);
            }
            c integerLiteral = (c)scope.a(atom5);
            return integerLiteral != null ? integerLiteral.a(ops, parseState) : scope.b(atom25);
        });
        return new Grammar<Object>(dictionary, namedRule4);
    }

    static final class e
    extends Enum<e> {
        public static final /* enum */ e a = new e();
        public static final /* enum */ e b = new e();
        private static final /* synthetic */ e[] c;

        public static e[] values() {
            return (e[])c.clone();
        }

        public static e valueOf(String name) {
            return Enum.valueOf(e.class, name);
        }

        public void a(StringBuilder stringBuilder) {
            if (this == b) {
                stringBuilder.append("-");
            }
        }

        private static /* synthetic */ e[] a() {
            return new e[]{a, b};
        }

        static {
            c = net.minecraft.nbt.SnbtGrammar$e.a();
        }
    }

    record f<T>(e a, T b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{f.class, "sign;value", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{f.class, "sign;value", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{f.class, "sign;value", "a", "b"}, this, o2);
        }
    }

    static final class i
    extends Enum<i> {
        public static final /* enum */ i a = new i();
        public static final /* enum */ i b = new i();
        public static final /* enum */ i c = new i();
        public static final /* enum */ i d = new i();
        public static final /* enum */ i e = new i();
        public static final /* enum */ i f = new i();
        private static final /* synthetic */ i[] g;

        public static i[] values() {
            return (i[])g.clone();
        }

        public static i valueOf(String name) {
            return Enum.valueOf(i.class, name);
        }

        private static /* synthetic */ i[] a() {
            return new i[]{a, b, c, d, e, f};
        }

        static {
            g = net.minecraft.nbt.SnbtGrammar$i.a();
        }
    }

    static final class d
    extends Record {
        @Nullable
        private final g b;
        @Nullable
        private final i c;
        public static final d a = new d(null, null);

        d(@Nullable g signed, @Nullable i type) {
            this.b = signed;
            this.c = type;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "signed;type", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "signed;type", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "signed;type", "b", "c"}, this, o2);
        }

        @Nullable
        public g a() {
            return this.b;
        }

        @Nullable
        public i b() {
            return this.c;
        }
    }

    static final class g
    extends Enum<g> {
        public static final /* enum */ g a = new g();
        public static final /* enum */ g b = new g();
        private static final /* synthetic */ g[] c;

        public static g[] values() {
            return (g[])c.clone();
        }

        public static g valueOf(String name) {
            return Enum.valueOf(g.class, name);
        }

        private static /* synthetic */ g[] a() {
            return new g[]{a, b};
        }

        static {
            c = net.minecraft.nbt.SnbtGrammar$g.a();
        }
    }

    static class h
    extends GreedyPredicateParseRule {
        public h(int minSize) {
            super(minSize, minSize, DelayedException.a(b, String.valueOf(minSize)));
        }

        @Override
        protected boolean a(char c2) {
            return switch (c2) {
                case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'a', 'b', 'c', 'd', 'e', 'f' -> true;
                default -> false;
            };
        }
    }

    static abstract sealed class a
    extends Enum<a> {
        public static final /* enum */ a a = new a(net.minecraft.nbt.SnbtGrammar$i.c, new i[0]){
            private static final ByteBuffer d = ByteBuffer.wrap(new byte[0]);

            @Override
            public <T> T a(DynamicOps<T> ops) {
                return (T)ops.createByteList(d);
            }

            @Override
            @Nullable
            public <T> T a(DynamicOps<T> ops, List<c> values, ParseState<?> parseState) {
                ByteArrayList list = new ByteArrayList();
                for (c integerLiteral : values) {
                    Number number = this.a(integerLiteral, parseState);
                    if (number == null) {
                        return null;
                    }
                    list.add(number.byteValue());
                }
                return (T)ops.createByteList(ByteBuffer.wrap(list.toByteArray()));
            }
        };
        public static final /* enum */ a b = new a(net.minecraft.nbt.SnbtGrammar$i.e, new i[]{net.minecraft.nbt.SnbtGrammar$i.c, net.minecraft.nbt.SnbtGrammar$i.d}){

            @Override
            public <T> T a(DynamicOps<T> ops) {
                return (T)ops.createIntList(IntStream.empty());
            }

            @Override
            @Nullable
            public <T> T a(DynamicOps<T> ops, List<c> values, ParseState<?> parseState) {
                IntStream.Builder builder = IntStream.builder();
                for (c integerLiteral : values) {
                    Number number = this.a(integerLiteral, parseState);
                    if (number == null) {
                        return null;
                    }
                    builder.add(number.intValue());
                }
                return (T)ops.createIntList(builder.build());
            }
        };
        public static final /* enum */ a c = new a(net.minecraft.nbt.SnbtGrammar$i.f, new i[]{net.minecraft.nbt.SnbtGrammar$i.c, net.minecraft.nbt.SnbtGrammar$i.d, net.minecraft.nbt.SnbtGrammar$i.e}){

            @Override
            public <T> T a(DynamicOps<T> ops) {
                return (T)ops.createLongList(LongStream.empty());
            }

            @Override
            @Nullable
            public <T> T a(DynamicOps<T> ops, List<c> values, ParseState<?> parseState) {
                LongStream.Builder builder = LongStream.builder();
                for (c integerLiteral : values) {
                    Number number = this.a(integerLiteral, parseState);
                    if (number == null) {
                        return null;
                    }
                    builder.add(number.longValue());
                }
                return (T)ops.createLongList(builder.build());
            }
        };
        private final i d;
        private final Set<i> e;
        private static final /* synthetic */ a[] f;

        public static a[] values() {
            return (a[])f.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private a(i defaultType, i ... additionalTypes) {
            this.e = Set.of(additionalTypes);
            this.d = defaultType;
        }

        public boolean a(i suffix) {
            return suffix == this.d || this.e.contains((Object)suffix);
        }

        public abstract <T> T a(DynamicOps<T> var1);

        @Nullable
        public abstract <T> T a(DynamicOps<T> var1, List<c> var2, ParseState<?> var3);

        @Nullable
        protected Number a(c value, ParseState<?> parseState) {
            i typeSuffix = this.a(value.d);
            if (typeSuffix == null) {
                parseState.b().a(parseState.g(), i);
                return null;
            }
            return (Number)value.a(JavaOps.INSTANCE, typeSuffix, parseState);
        }

        @Nullable
        private i a(d suffix) {
            i typeSuffix = suffix.b();
            if (typeSuffix == null) {
                return this.d;
            }
            return !this.a(typeSuffix) ? null : typeSuffix;
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b, c};
        }

        static {
            f = net.minecraft.nbt.SnbtGrammar$a.a();
        }
    }

    record c(e a, b b, String c, d d) {
        private g e() {
            if (this.d.b != null) {
                return this.d.b;
            }
            return switch (this.b.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> net.minecraft.nbt.SnbtGrammar$g.b;
                case 1 -> net.minecraft.nbt.SnbtGrammar$g.a;
            };
        }

        private String a(e sign) {
            boolean flag = SnbtGrammar.a(this.c);
            if (sign != net.minecraft.nbt.SnbtGrammar$e.b && !flag) {
                return this.c;
            }
            StringBuilder stringBuilder = new StringBuilder();
            sign.a(stringBuilder);
            SnbtGrammar.a(stringBuilder, this.c, flag);
            return stringBuilder.toString();
        }

        @Nullable
        public <T> T a(DynamicOps<T> ops, ParseState<?> parseState) {
            return this.a(ops, Objects.requireNonNullElse(this.d.c, net.minecraft.nbt.SnbtGrammar$i.e), parseState);
        }

        @Nullable
        public <T> T a(DynamicOps<T> ops, i typeSuffix, ParseState<?> parseState) {
            boolean flag;
            boolean bl = flag = this.e() == net.minecraft.nbt.SnbtGrammar$g.a;
            if (!flag && this.a == net.minecraft.nbt.SnbtGrammar$e.b) {
                parseState.b().a(parseState.g(), g);
                return null;
            }
            String string = this.a(this.a);
            int i2 = switch (this.b.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 2;
                case 1 -> 10;
                case 2 -> 16;
            };
            try {
                if (flag) {
                    return (T)(switch (typeSuffix.ordinal()) {
                        case 2 -> ops.createByte(Byte.parseByte(string, i2));
                        case 3 -> ops.createShort(Short.parseShort(string, i2));
                        case 4 -> ops.createInt(Integer.parseInt(string, i2));
                        case 5 -> ops.createLong(Long.parseLong(string, i2));
                        default -> {
                            parseState.b().a(parseState.g(), e);
                            yield null;
                        }
                    });
                }
                return (T)(switch (typeSuffix.ordinal()) {
                    case 2 -> ops.createByte(UnsignedBytes.parseUnsignedByte((String)string, (int)i2));
                    case 3 -> ops.createShort(SnbtGrammar.a(string, i2));
                    case 4 -> ops.createInt(Integer.parseUnsignedInt(string, i2));
                    case 5 -> ops.createLong(Long.parseUnsignedLong(string, i2));
                    default -> {
                        parseState.b().a(parseState.g(), e);
                        yield null;
                    }
                });
            }
            catch (NumberFormatException var8) {
                parseState.b().a(parseState.g(), SnbtGrammar.a(var8));
                return null;
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "sign;base;digits;suffix", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "sign;base;digits;suffix", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "sign;base;digits;suffix", "a", "b", "c", "d"}, this, o2);
        }
    }

    static final class b
    extends Enum<b> {
        public static final /* enum */ b a = new b();
        public static final /* enum */ b b = new b();
        public static final /* enum */ b c = new b();
        private static final /* synthetic */ b[] d;

        public static b[] values() {
            return (b[])d.clone();
        }

        public static b valueOf(String name) {
            return Enum.valueOf(b.class, name);
        }

        private static /* synthetic */ b[] a() {
            return new b[]{a, b, c};
        }

        static {
            d = net.minecraft.nbt.SnbtGrammar$b.a();
        }
    }
}

