/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.minecraft.EnumChatFormat;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.slf4j.Logger;

public class TextComponentTagVisitor
implements TagVisitor {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 8;
    private static final int c = 64;
    private static final int d = 128;
    private static final EnumChatFormat e = EnumChatFormat.l;
    private static final EnumChatFormat f = EnumChatFormat.k;
    private static final EnumChatFormat g = EnumChatFormat.g;
    private static final EnumChatFormat h = EnumChatFormat.m;
    private static final Pattern i = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final String j = "[";
    private static final String k = "]";
    private static final String l = ";";
    private static final String m = " ";
    private static final String n = "{";
    private static final String o = "}";
    private static final String p = "\n";
    private static final String q = ": ";
    private static final String r = String.valueOf(',');
    private static final String s = r + "\n";
    private static final String t = r + " ";
    private static final IChatBaseComponent u = IChatBaseComponent.b("<...>").a(EnumChatFormat.h);
    private static final IChatBaseComponent v = IChatBaseComponent.b("b").a(h);
    private static final IChatBaseComponent w = IChatBaseComponent.b("s").a(h);
    private static final IChatBaseComponent x = IChatBaseComponent.b("I").a(h);
    private static final IChatBaseComponent y = IChatBaseComponent.b("L").a(h);
    private static final IChatBaseComponent z = IChatBaseComponent.b("f").a(h);
    private static final IChatBaseComponent A = IChatBaseComponent.b("d").a(h);
    private static final IChatBaseComponent B = IChatBaseComponent.b("B").a(h);
    private final String C;
    private int D;
    private int E;
    private final IChatMutableComponent F = IChatBaseComponent.i();

    public TextComponentTagVisitor(String indentation) {
        this.C = indentation;
    }

    public IChatBaseComponent a(NBTBase tag) {
        tag.a(this);
        return this.F;
    }

    @Override
    public void a(NBTTagString tag) {
        String string = NBTTagString.b(tag.k());
        String sub = string.substring(0, 1);
        IChatMutableComponent component = IChatBaseComponent.b(string.substring(1, string.length() - 1)).a(f);
        this.F.f(sub).b(component).f(sub);
    }

    @Override
    public void a(NBTTagByte tag) {
        this.F.b(IChatBaseComponent.b(String.valueOf(tag.n())).a(g)).b(v);
    }

    @Override
    public void a(NBTTagShort tag) {
        this.F.b(IChatBaseComponent.b(String.valueOf(tag.n())).a(g)).b(w);
    }

    @Override
    public void a(NBTTagInt tag) {
        this.F.b(IChatBaseComponent.b(String.valueOf(tag.n())).a(g));
    }

    @Override
    public void a(NBTTagLong tag) {
        this.F.b(IChatBaseComponent.b(String.valueOf(tag.n())).a(g)).b(y);
    }

    @Override
    public void a(NBTTagFloat tag) {
        this.F.b(IChatBaseComponent.b(String.valueOf(tag.n())).a(g)).b(z);
    }

    @Override
    public void a(NBTTagDouble tag) {
        this.F.b(IChatBaseComponent.b(String.valueOf(tag.n())).a(g)).b(A);
    }

    @Override
    public void a(NBTTagByteArray tag) {
        this.F.f(j).b(B).f(l);
        byte[] asByteArray = tag.e();
        for (int i2 = 0; i2 < asByteArray.length && i2 < 128; ++i2) {
            IChatMutableComponent mutableComponent = IChatBaseComponent.b(String.valueOf(asByteArray[i2])).a(g);
            this.F.f(m).b(mutableComponent).b(B);
            if (i2 == asByteArray.length - 1) continue;
            this.F.f(r);
        }
        if (asByteArray.length > 128) {
            this.F.b(u);
        }
        this.F.f(k);
    }

    @Override
    public void a(NBTTagIntArray tag) {
        this.F.f(j).b(x).f(l);
        int[] asIntArray = tag.g();
        for (int i2 = 0; i2 < asIntArray.length && i2 < 128; ++i2) {
            this.F.f(m).b(IChatBaseComponent.b(String.valueOf(asIntArray[i2])).a(g));
            if (i2 == asIntArray.length - 1) continue;
            this.F.f(r);
        }
        if (asIntArray.length > 128) {
            this.F.b(u);
        }
        this.F.f(k);
    }

    @Override
    public void a(NBTTagLongArray tag) {
        this.F.f(j).b(y).f(l);
        long[] asLongArray = tag.g();
        for (int i2 = 0; i2 < asLongArray.length && i2 < 128; ++i2) {
            IChatMutableComponent component = IChatBaseComponent.b(String.valueOf(asLongArray[i2])).a(g);
            this.F.f(m).b(component).b(y);
            if (i2 == asLongArray.length - 1) continue;
            this.F.f(r);
        }
        if (asLongArray.length > 128) {
            this.F.b(u);
        }
        this.F.f(k);
    }

    private static boolean b(NBTTagList tag) {
        if (tag.size() >= 8) {
            return false;
        }
        for (NBTBase tag1 : tag) {
            if (tag1 instanceof NBTNumber) continue;
            return true;
        }
        return false;
    }

    @Override
    public void a(NBTTagList tag) {
        if (tag.isEmpty()) {
            this.F.f("[]");
        } else if (this.E >= 64) {
            this.F.f(j).b(u).f(k);
        } else if (!TextComponentTagVisitor.b(tag)) {
            this.F.f(j);
            for (int i2 = 0; i2 < tag.size(); ++i2) {
                if (i2 != 0) {
                    this.F.f(t);
                }
                this.a(tag.c(i2), false);
            }
            this.F.f(k);
        } else {
            this.F.f(j);
            if (!this.C.isEmpty()) {
                this.F.f(p);
            }
            String repeated = Strings.repeat((String)this.C, (int)(this.D + 1));
            for (int i1 = 0; i1 < tag.size() && i1 < 128; ++i1) {
                this.F.f(repeated);
                this.a(tag.c(i1), true);
                if (i1 == tag.size() - 1) continue;
                this.F.f(this.C.isEmpty() ? t : s);
            }
            if (tag.size() > 128) {
                this.F.f(repeated).b(u);
            }
            if (!this.C.isEmpty()) {
                this.F.f(p + Strings.repeat((String)this.C, (int)this.D));
            }
            this.F.f(k);
        }
    }

    @Override
    public void a(NBTTagCompound tag) {
        if (tag.j()) {
            this.F.f("{}");
        } else if (this.E >= 64) {
            this.F.f(n).b(u).f(o);
        } else {
            this.F.f(n);
            Collection<String> collection = tag.e();
            if (a.isDebugEnabled()) {
                ArrayList list = Lists.newArrayList(tag.e());
                Collections.sort(list);
                collection = list;
            }
            if (!this.C.isEmpty()) {
                this.F.f(p);
            }
            String repeated = Strings.repeat((String)this.C, (int)(this.D + 1));
            Iterator<String> iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                this.F.f(repeated).b(TextComponentTagVisitor.a(string)).f(q);
                this.a(tag.a(string), true);
                if (!iterator.hasNext()) continue;
                this.F.f(this.C.isEmpty() ? t : s);
            }
            if (!this.C.isEmpty()) {
                this.F.f(p + Strings.repeat((String)this.C, (int)this.D));
            }
            this.F.f(o);
        }
    }

    private void a(NBTBase tag, boolean indent) {
        if (indent) {
            ++this.D;
        }
        ++this.E;
        try {
            tag.a(this);
        }
        finally {
            if (indent) {
                --this.D;
            }
            --this.E;
        }
    }

    protected static IChatBaseComponent a(String text) {
        if (i.matcher(text).matches()) {
            return IChatBaseComponent.b(text).a(e);
        }
        String string = NBTTagString.b(text);
        String sub = string.substring(0, 1);
        IChatMutableComponent component = IChatBaseComponent.b(string.substring(1, string.length() - 1)).a(e);
        return IChatBaseComponent.b(sub).b(component).f(sub);
    }

    @Override
    public void a(NBTTagEnd tag) {
    }
}

