/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.velocitypowered.natives.Native;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.util.MoreByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.zip.Deflater;
import javax.annotation.Nullable;
import net.minecraft.network.VarInt;

public class PacketCompressor
extends MessageToByteEncoder<ByteBuf> {
    @Nullable
    private final byte[] a;
    @Nullable
    private final Deflater b;
    @Nullable
    private final VelocityCompressor compressor;
    private int c;

    public PacketCompressor(int threshold) {
        this(null, threshold);
    }

    public PacketCompressor(@Nullable VelocityCompressor compressor, int threshold) {
        this.c = threshold;
        if (compressor == null) {
            this.a = new byte[8192];
            this.b = new Deflater();
        } else {
            this.a = null;
            this.b = null;
        }
        this.compressor = compressor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a(ChannelHandlerContext context, ByteBuf encodingByteBuf, ByteBuf byteBuf) throws Exception {
        int i2 = encodingByteBuf.readableBytes();
        if (i2 > 0x800000) {
            throw new IllegalArgumentException("Packet too big (is " + i2 + ", should be less than 8388608)");
        }
        if (i2 < this.c) {
            VarInt.a(byteBuf, 0);
            byteBuf.writeBytes(encodingByteBuf);
        } else {
            if (this.b != null) {
                byte[] bytes = new byte[i2];
                encodingByteBuf.readBytes(bytes);
                VarInt.a(byteBuf, bytes.length);
                this.b.setInput(bytes, 0, i2);
                this.b.finish();
                while (!this.b.finished()) {
                    int i1 = this.b.deflate(this.a);
                    byteBuf.writeBytes(this.a, 0, i1);
                }
                this.b.reset();
                return;
            }
            VarInt.a(byteBuf, i2);
            ByteBuf compatibleIn = MoreByteBufUtils.ensureCompatible((ByteBufAllocator)context.alloc(), (Native)this.compressor, (ByteBuf)encodingByteBuf);
            try {
                this.compressor.deflate(compatibleIn, byteBuf);
            }
            finally {
                compatibleIn.release();
            }
        }
    }

    public int a() {
        return this.c;
    }

    public void a(int threshold) {
        this.c = threshold;
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, ByteBuf msg, boolean preferDirect) throws Exception {
        if (this.compressor != null) {
            int initialBufferSize = msg.readableBytes() + 1;
            return MoreByteBufUtils.preferredBuffer((ByteBufAllocator)ctx.alloc(), (Native)this.compressor, (int)initialBufferSize);
        }
        return super.allocateBuffer(ctx, (Object)msg, preferDirect);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (this.compressor != null) {
            this.compressor.close();
        }
    }
}

