/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Locale;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ProtocolSwapHandler;
import net.minecraft.network.SkipPacketEncoderException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.slf4j.Logger;

public class PacketEncoder<T extends PacketListener>
extends MessageToByteEncoder<Packet<T>> {
    private static final Logger a = LogUtils.getLogger();
    private final ProtocolInfo<T> b;
    static final ThreadLocal<Locale> ADVENTURE_LOCALE = ThreadLocal.withInitial(() -> null);
    private static final int MAX_FINAL_PACKET_SIZE = 0x1FFFFF;
    private static final int MAX_PACKET_SIZE = 0x800000;

    public PacketEncoder(ProtocolInfo<T> protocolInfo) {
        this.b = protocolInfo;
    }

    protected void a(ChannelHandlerContext channelHandlerContext, Packet<T> packet, ByteBuf byteBuf) throws Exception {
        PacketType<Packet<T>> packetType = packet.a();
        try {
            ADVENTURE_LOCALE.set((Locale)channelHandlerContext.channel().attr(PaperAdventure.LOCALE_ATTRIBUTE).get());
            this.b.c().encode(byteBuf, packet);
            int i2 = byteBuf.readableBytes();
            if (a.isDebugEnabled()) {
                a.debug(NetworkManager.d, "OUT: [{}:{}] {} -> {} bytes", new Object[]{this.b.a().a(), packetType, packet.getClass().getName(), i2});
            }
            JvmProfiler.f.b(this.b.a(), packetType, channelHandlerContext.channel().remoteAddress(), i2);
        }
        catch (Throwable var9) {
            a.error("Error sending packet {}", packetType, (Object)var9);
            if (packet.c()) {
                throw new SkipPacketEncoderException(var9);
            }
            throw var9;
        }
        finally {
            int packetLength = byteBuf.readableBytes();
            if (packetLength > 0x800000 || packetLength > 0x1FFFFF && packet.hasLargePacketFallback()) {
                throw new PacketTooLargeException(packet, packetLength);
            }
            ProtocolSwapHandler.b(channelHandlerContext, packet);
        }
    }

    public static class PacketTooLargeException
    extends RuntimeException {
        private final Packet<?> packet;

        PacketTooLargeException(Packet<?> packet, int packetLength) {
            super("PacketTooLarge - " + packet.getClass().getSimpleName() + " is " + packetLength + ". Max is 8388608");
            this.packet = packet;
        }

        public Packet<?> getPacket() {
            return this.packet;
        }
    }
}

