/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;

public final class ChatHexColor {
    private static final String b = "#";
    public static final Codec<ChatHexColor> a = Codec.STRING.comapFlatMap(ChatHexColor::a, ChatHexColor::b);
    private static final Map<EnumChatFormat, ChatHexColor> c = (Map)Stream.of(EnumChatFormat.values()).filter(EnumChatFormat::e).collect(ImmutableMap.toImmutableMap(Function.identity(), formatting -> new ChatHexColor(formatting.f(), formatting.g(), (EnumChatFormat)formatting)));
    private static final Map<String, ChatHexColor> d = (Map)c.values().stream().collect(ImmutableMap.toImmutableMap(textColor -> textColor.f, Function.identity()));
    private final int e;
    @Nullable
    public final String f;
    @Nullable
    public final EnumChatFormat format;

    private ChatHexColor(int value, String name, EnumChatFormat format) {
        this.e = value & 0xFFFFFF;
        this.f = name;
        this.format = format;
    }

    private ChatHexColor(int value) {
        this.e = value & 0xFFFFFF;
        this.f = null;
        this.format = null;
    }

    public int a() {
        return this.e;
    }

    public String b() {
        return this.f != null ? this.f : this.c();
    }

    private String c() {
        return String.format(Locale.ROOT, "#%06X", this.e);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            ChatHexColor textColor = (ChatHexColor)other;
            return this.e == textColor.e;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.e, this.f);
    }

    public String toString() {
        return this.b();
    }

    @Nullable
    public static ChatHexColor a(EnumChatFormat formatting) {
        return c.get(formatting);
    }

    public static ChatHexColor a(int color) {
        return new ChatHexColor(color);
    }

    public static DataResult<ChatHexColor> a(String color) {
        if (color.startsWith(b)) {
            try {
                int i2 = Integer.parseInt(color.substring(1), 16);
                return i2 >= 0 && i2 <= 0xFFFFFF ? DataResult.success((Object)ChatHexColor.a(i2), (Lifecycle)Lifecycle.stable()) : DataResult.error(() -> "Color value out of range: " + color);
            }
            catch (NumberFormatException var2) {
                return DataResult.error(() -> "Invalid color value: " + color);
            }
        }
        ChatHexColor textColor = d.get(color);
        return textColor == null ? DataResult.error(() -> "Invalid color name: " + color) : DataResult.success((Object)textColor, (Lifecycle)Lifecycle.stable());
    }
}

