/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.papermc.paper.adventure.AdventureComponent;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ComponentSerialization {
    public static final Codec<IChatBaseComponent> a = Codec.recursive((String)"Component", ComponentSerialization::a);
    public static final StreamCodec<RegistryFriendlyByteBuf, IChatBaseComponent> b = ComponentSerialization.createTranslationAware(() -> NBTReadLimiter.a(0x200000L));
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<IChatBaseComponent>> c = b.a(ByteBufCodecs::a);
    public static final ThreadLocal<Boolean> DONT_RENDER_TRANSLATABLES = ThreadLocal.withInitial(() -> false);
    public static final StreamCodec<RegistryFriendlyByteBuf, IChatBaseComponent> d = ComponentSerialization.createTranslationAware(NBTReadLimiter::a);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<IChatBaseComponent>> e = d.a(ByteBufCodecs::a);
    public static final StreamCodec<ByteBuf, IChatBaseComponent> f = ByteBufCodecs.a(a);
    private static final Map<Locale, Codec<IChatBaseComponent>> LOCALIZED_CODECS = new ConcurrentHashMap<Locale, Codec<IChatBaseComponent>>();

    private static StreamCodec<RegistryFriendlyByteBuf, IChatBaseComponent> createTranslationAware(final Supplier<NBTReadLimiter> sizeTracker) {
        return new StreamCodec<RegistryFriendlyByteBuf, IChatBaseComponent>(){
            final StreamCodec<ByteBuf, NBTBase> streamCodec;
            {
                this.streamCodec = ByteBufCodecs.a(sizeTracker);
            }

            @Override
            public IChatBaseComponent decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
                NBTBase tag = (NBTBase)this.streamCodec.decode(registryFriendlyByteBuf);
                RegistryOps<NBTBase> registryOps = registryFriendlyByteBuf.H().a(DynamicOpsNBT.a);
                return (IChatBaseComponent)a.parse(registryOps, (Object)tag).getOrThrow(error -> new DecoderException("Failed to decode: " + error + " " + String.valueOf(tag)));
            }

            @Override
            public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, IChatBaseComponent object) {
                RegistryOps<NBTBase> registryOps = registryFriendlyByteBuf.H().a(DynamicOpsNBT.a);
                NBTBase tag = (NBTBase)(DONT_RENDER_TRANSLATABLES.get() != false ? a : ComponentSerialization.localizedCodec(registryFriendlyByteBuf.adventure$locale)).encodeStart(registryOps, (Object)object).getOrThrow(error -> new EncoderException("Failed to encode: " + error + " " + String.valueOf(object)));
                this.streamCodec.encode(registryFriendlyByteBuf, tag);
            }
        };
    }

    public static Codec<IChatBaseComponent> a(final int maxSize) {
        return new Codec<IChatBaseComponent>(){

            public <T> DataResult<Pair<IChatBaseComponent, T>> decode(DynamicOps<T> ops, T input) {
                return a.decode(ops, input).flatMap(pair -> this.isTooLarge(ops, (IChatBaseComponent)pair.getFirst()) ? DataResult.error(() -> "Component was too large: greater than max size " + maxSize) : DataResult.success((Object)pair));
            }

            public <T> DataResult<T> encode(IChatBaseComponent input, DynamicOps<T> ops, T value) {
                return a.encodeStart(ops, (Object)input);
            }

            private <T> boolean isTooLarge(DynamicOps<T> ops, IChatBaseComponent component) {
                DataResult dataResult = a.encodeStart(2.asJsonOps(ops), (Object)component);
                return dataResult.isSuccess() && ChatDeserializer.a((JsonElement)dataResult.getOrThrow(), maxSize);
            }

            private static <T> DynamicOps<JsonElement> asJsonOps(DynamicOps<T> ops) {
                Object object;
                if (ops instanceof RegistryOps) {
                    RegistryOps registryOps = (RegistryOps)ops;
                    object = registryOps.a(JsonOps.INSTANCE);
                } else {
                    object = JsonOps.INSTANCE;
                }
                return object;
            }
        };
    }

    private static IChatMutableComponent a(List<IChatBaseComponent> components) {
        IChatMutableComponent mutableComponent = components.get(0).f();
        for (int i2 = 1; i2 < components.size(); ++i2) {
            mutableComponent.b(components.get(i2));
        }
        return mutableComponent;
    }

    public static <T extends INamable, E> MapCodec<E> a(T[] types, Function<T, MapCodec<? extends E>> codecGetter, Function<E, T> typeGetter, String typeFieldName) {
        a<Object> mapCodec = new a<Object>(Stream.of(types).map(codecGetter).toList(), object -> (MapEncoder)codecGetter.apply((INamable)typeGetter.apply(object)));
        Codec codec = INamable.b(() -> types);
        MapCodec mapCodec1 = codec.dispatchMap(typeFieldName, typeGetter, codecGetter);
        b<Object> mapCodec2 = new b<Object>(typeFieldName, mapCodec1, mapCodec);
        return ExtraCodecs.a(mapCodec2, mapCodec1);
    }

    public static Codec<IChatBaseComponent> localizedCodec(@Nullable Locale locale) {
        if (locale == null) {
            return a;
        }
        return LOCALIZED_CODECS.computeIfAbsent(locale, loc -> Codec.recursive((String)"Component", selfCodec -> ComponentSerialization.createCodec((Codec<IChatBaseComponent>)selfCodec, loc)));
    }

    private static Codec<IChatBaseComponent> a(Codec<IChatBaseComponent> codec) {
        return ComponentSerialization.createCodec(codec, null);
    }

    private static Codec<IChatBaseComponent> createCodec(Codec<IChatBaseComponent> codec, final @javax.annotation.Nullable Locale locale) {
        Codec codec1;
        INamable[] types = new ComponentContents.a[]{LiteralContents.b, TranslatableContents.c, KeybindContents.b, ScoreContents.c, SelectorContents.b, NbtContents.b};
        MapCodec mapCodec = ComponentSerialization.a((INamable[])types, ComponentContents.a::a, ComponentContents::a, (String)"type");
        final Codec origCodec = codec1 = RecordCodecBuilder.create(instance -> instance.group((App)mapCodec.forGetter(IChatBaseComponent::b), (App)ExtraCodecs.b(codec.listOf()).optionalFieldOf("extra", List.of()).forGetter(IChatBaseComponent::c), (App)ChatModifier.ChatModifierSerializer.a.forGetter(IChatBaseComponent::a)).apply((Applicative)instance, IChatMutableComponent::new));
        codec1 = new Codec<IChatBaseComponent>(){

            public <T> DataResult<Pair<IChatBaseComponent, T>> decode(DynamicOps<T> ops, T input) {
                return origCodec.decode(ops, input);
            }

            public <T> DataResult<T> encode(IChatBaseComponent input, DynamicOps<T> ops, T prefix) {
                Component adventureComponent;
                if (input instanceof AdventureComponent) {
                    AdventureComponent adv = (AdventureComponent)input;
                    adventureComponent = adv.adventure$component();
                } else if (locale != null && input.b() instanceof TranslatableContents && PaperAdventure.hasAnyTranslations()) {
                    adventureComponent = PaperAdventure.asAdventure(input);
                } else {
                    return origCodec.encode((Object)input, ops, prefix);
                }
                return PaperAdventure.localizedCodec(locale).encode((Object)adventureComponent, ops, prefix);
            }

            public String toString() {
                return origCodec.toString() + "[AdventureComponentAware]";
            }
        };
        return Codec.either((Codec)Codec.either((Codec)Codec.STRING, ExtraCodecs.b(codec.listOf())), (Codec)codec1).xmap(either -> either.map(either1 -> either1.map(IChatBaseComponent::b, ComponentSerialization::a), component -> component), component -> {
            String string = component.d();
            return string != null ? Either.left(Either.left(string)) : Either.right(component);
        });
    }

    static class a<T>
    extends MapCodec<T> {
        private final List<MapCodec<? extends T>> a;
        private final Function<T, MapEncoder<? extends T>> b;

        public a(List<MapCodec<? extends T>> codecs, Function<T, MapEncoder<? extends T>> encoderGetter) {
            this.a = codecs;
            this.b = encoderGetter;
        }

        public <S> DataResult<T> decode(DynamicOps<S> ops, MapLike<S> input) {
            for (MapDecoder mapDecoder : this.a) {
                DataResult dataResult = mapDecoder.decode(ops, input);
                if (!dataResult.result().isPresent()) continue;
                return dataResult;
            }
            return DataResult.error(() -> "No matching codec found");
        }

        public <S> RecordBuilder<S> encode(T input, DynamicOps<S> ops, RecordBuilder<S> prefix) {
            MapEncoder<? extends T> mapEncoder = this.b.apply(input);
            return mapEncoder.encode(input, ops, prefix);
        }

        public <S> Stream<S> keys(DynamicOps<S> ops) {
            return this.a.stream().flatMap(mapCodec -> mapCodec.keys(ops)).distinct();
        }

        public String toString() {
            return "FuzzyCodec[" + String.valueOf(this.a) + "]";
        }
    }

    static class b<T>
    extends MapCodec<T> {
        private final String a;
        private final MapCodec<T> b;
        private final MapCodec<T> c;

        public b(String typeFieldName, MapCodec<T> typed, MapCodec<T> fuzzy) {
            this.a = typeFieldName;
            this.b = typed;
            this.c = fuzzy;
        }

        public <O> DataResult<T> decode(DynamicOps<O> ops, MapLike<O> input) {
            return input.get(this.a) != null ? this.b.decode(ops, input) : this.c.decode(ops, input);
        }

        public <O> RecordBuilder<O> encode(T input, DynamicOps<O> ops, RecordBuilder<O> prefix) {
            return this.c.encode(input, ops, prefix);
        }

        public <T1> Stream<T1> keys(DynamicOps<T1> ops) {
            return Stream.concat(this.b.keys(ops), this.c.keys(ops)).distinct();
        }
    }
}

