/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.security.SignatureException;
import java.time.Instant;
import java.util.Optional;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SignatureUpdater;

public final class SignedMessageBody
extends Record {
    private final String b;
    private final Instant c;
    private final long d;
    private final LastSeenMessages e;
    public static final MapCodec<SignedMessageBody> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("content").forGetter(SignedMessageBody::a), (App)ExtraCodecs.q.fieldOf("time_stamp").forGetter(SignedMessageBody::b), (App)Codec.LONG.fieldOf("salt").forGetter(SignedMessageBody::c), (App)LastSeenMessages.a.optionalFieldOf("last_seen", (Object)LastSeenMessages.b).forGetter(SignedMessageBody::d)).apply((Applicative)instance, SignedMessageBody::new));

    public SignedMessageBody(String content, Instant timeStamp, long salt, LastSeenMessages lastSeen) {
        this.b = content;
        this.c = timeStamp;
        this.d = salt;
        this.e = lastSeen;
    }

    public static SignedMessageBody a(String content) {
        return new SignedMessageBody(content, Instant.now(), 0L, LastSeenMessages.b);
    }

    public void a(SignatureUpdater.a output) throws SignatureException {
        output.update(Longs.toByteArray((long)this.d));
        output.update(Longs.toByteArray((long)this.c.getEpochSecond()));
        byte[] bytes = this.b.getBytes(StandardCharsets.UTF_8);
        output.update(Ints.toByteArray((int)bytes.length));
        output.update(bytes);
        this.e.a(output);
    }

    public a a(MessageSignatureCache signatureCache) {
        return new a(this.b, this.c, this.d, this.e.a(signatureCache));
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SignedMessageBody.class, "content;timeStamp;salt;lastSeen", "b", "c", "d", "e"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SignedMessageBody.class, "content;timeStamp;salt;lastSeen", "b", "c", "d", "e"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SignedMessageBody.class, "content;timeStamp;salt;lastSeen", "b", "c", "d", "e"}, this, o2);
    }

    public String a() {
        return this.b;
    }

    public Instant b() {
        return this.c;
    }

    public long c() {
        return this.d;
    }

    public LastSeenMessages d() {
        return this.e;
    }

    public record a(String a, Instant b, long c, LastSeenMessages.a d) {
        public a(PacketDataSerializer buffer) {
            this(buffer.d(256), buffer.t(), buffer.readLong(), new LastSeenMessages.a(buffer));
        }

        public void a(PacketDataSerializer buffer) {
            buffer.a(this.a, 256);
            buffer.a(this.b);
            buffer.b(this.c);
            this.d.a(buffer);
        }

        public Optional<SignedMessageBody> a(MessageSignatureCache signatureCache) {
            return this.d.a(signatureCache).map(lastSeenMessages -> new SignedMessageBody(this.a, this.b, this.c, (LastSeenMessages)lastSeenMessages));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "content;timeStamp;salt;lastSeen", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "content;timeStamp;salt;lastSeen", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "content;timeStamp;salt;lastSeen", "a", "b", "c", "d"}, this, o2);
        }
    }
}

