/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.locale.LocaleLanguage;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.TranslatableFormatException;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;

public class TranslatableContents
implements ComponentContents {
    public static final Object[] a = new Object[0];
    private static final Codec<Object> d = ExtraCodecs.b.validate(TranslatableContents::b);
    private static final Codec<Object> e = Codec.either(d, ComponentSerialization.a).xmap(arg -> arg.map(arg1 -> arg1, text -> Objects.requireNonNullElse(text.d(), text)), arg -> {
        Either<Object, Object> either;
        if (arg instanceof IChatBaseComponent) {
            IChatBaseComponent component = (IChatBaseComponent)arg;
            either = Either.right(component);
        } else {
            either = Either.left(arg);
        }
        return either;
    });
    public static final MapCodec<TranslatableContents> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("translate").forGetter(contents -> contents.h), (App)Codec.STRING.lenientOptionalFieldOf("fallback").forGetter(contents -> Optional.ofNullable(contents.i)), (App)e.listOf().optionalFieldOf("with").forGetter(contents -> TranslatableContents.a(contents.j))).apply((Applicative)instance, TranslatableContents::a));
    public static final ComponentContents.a<TranslatableContents> c = new ComponentContents.a<TranslatableContents>(b, "translatable");
    private static final IChatFormatted f = IChatFormatted.e("%");
    private static final IChatFormatted g = IChatFormatted.e("null");
    private final String h;
    @Nullable
    private final String i;
    private final Object[] j;
    @Nullable
    private LocaleLanguage k;
    private List<IChatFormatted> l = ImmutableList.of();
    private static final Pattern m = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public static DataResult<Object> b(@Nullable Object input) {
        return !TranslatableContents.a(input) ? DataResult.error(() -> "This value needs to be parsed as component") : DataResult.success((Object)input);
    }

    public static boolean a(@Nullable Object input) {
        return input instanceof Number || input instanceof Boolean || input instanceof String;
    }

    private static Optional<List<Object>> a(Object[] args) {
        return args.length == 0 ? Optional.empty() : Optional.of(Arrays.asList(args));
    }

    private static Object[] a(Optional<List<Object>> args) {
        return args.map(arg -> arg.isEmpty() ? a : arg.toArray()).orElse(a);
    }

    private static TranslatableContents a(String key, Optional<String> fallback, Optional<List<Object>> args) {
        return new TranslatableContents(key, fallback.orElse(null), TranslatableContents.a(args));
    }

    public TranslatableContents(String key, @Nullable String fallback, Object[] args) {
        this.h = key;
        this.i = fallback;
        this.j = args;
    }

    @Override
    public ComponentContents.a<?> a() {
        return c;
    }

    private void e() {
        LocaleLanguage instance = LocaleLanguage.a();
        if (instance != this.k) {
            this.k = instance;
            String string = this.i != null ? instance.a(this.h, this.i) : instance.a(this.h);
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                this.a(string, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                this.l = builder.build();
            }
            catch (TranslatableFormatException var4) {
                this.l = ImmutableList.of((Object)IChatFormatted.e(string));
            }
        }
    }

    private void a(String formatTemplate, Consumer<IChatFormatted> consumer) {
        Matcher matcher = m.matcher(formatTemplate);
        try {
            int i2 = 0;
            int i1 = 0;
            while (matcher.find(i1)) {
                String sub;
                int i22 = matcher.start();
                int i3 = matcher.end();
                if (i22 > i1) {
                    sub = formatTemplate.substring(i1, i22);
                    if (sub.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    consumer.accept(IChatFormatted.e(sub));
                }
                sub = matcher.group(2);
                String sub1 = formatTemplate.substring(i22, i3);
                if ("%".equals(sub) && "%%".equals(sub1)) {
                    consumer.accept(f);
                } else {
                    if (!"s".equals(sub)) {
                        throw new TranslatableFormatException(this, "Unsupported format: '" + sub1 + "'");
                    }
                    String string = matcher.group(1);
                    int i4 = string != null ? Integer.parseInt(string) - 1 : i2++;
                    consumer.accept(this.a(i4));
                }
                i1 = i3;
            }
            if (i1 < formatTemplate.length()) {
                String sub2 = formatTemplate.substring(i1);
                if (sub2.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                consumer.accept(IChatFormatted.e(sub2));
            }
        }
        catch (IllegalArgumentException var12) {
            throw new TranslatableFormatException(this, (Throwable)var12);
        }
    }

    private IChatFormatted a(int index) {
        if (index >= 0 && index < this.j.length) {
            Object object = this.j[index];
            if (object instanceof IChatBaseComponent) {
                IChatBaseComponent component = (IChatBaseComponent)object;
                return component;
            }
            return object == null ? g : IChatFormatted.e(object.toString());
        }
        throw new TranslatableFormatException(this, index);
    }

    @Override
    public <T> Optional<T> a(IChatFormatted.b<T> styledContentConsumer, ChatModifier style) {
        this.e();
        for (IChatFormatted formattedText : this.l) {
            Optional<T> optional = formattedText.a(styledContentConsumer, style);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> a(IChatFormatted.a<T> contentConsumer) {
        try {
            return this.visit(new TranslatableContentConsumer<T>(contentConsumer));
        }
        catch (IllegalArgumentException ignored) {
            return contentConsumer.accept("...");
        }
    }

    private <T> Optional<T> visit(TranslatableContentConsumer<T> contentConsumer) {
        this.e();
        for (IChatFormatted formattedText : this.l) {
            Optional<T> optional = formattedText.a(contentConsumer);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public IChatMutableComponent a(@Nullable CommandListenerWrapper nbtPathPattern, @Nullable Entity entity, int recursionDepth) throws CommandSyntaxException {
        Object[] objects = new Object[this.j.length];
        for (int i2 = 0; i2 < objects.length; ++i2) {
            Object object = this.j[i2];
            if (object instanceof IChatBaseComponent) {
                IChatBaseComponent component = (IChatBaseComponent)object;
                objects[i2] = ChatComponentUtils.a(nbtPathPattern, component, entity, recursionDepth);
                continue;
            }
            objects[i2] = object;
        }
        return IChatMutableComponent.a(new TranslatableContents(this.h, this.i, objects));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof TranslatableContents)) return false;
        TranslatableContents translatableContents = (TranslatableContents)other;
        if (!Objects.equals(this.h, translatableContents.h)) return false;
        if (!Objects.equals(this.i, translatableContents.i)) return false;
        if (!Arrays.equals(this.j, translatableContents.j)) return false;
        return true;
    }

    public int hashCode() {
        int hashCode = Objects.hashCode(this.h);
        hashCode = 31 * hashCode + Objects.hashCode(this.i);
        return 31 * hashCode + Arrays.hashCode(this.j);
    }

    public String toString() {
        return "translation{key='" + this.h + "'" + (String)(this.i != null ? ", fallback='" + this.i + "'" : "") + ", args=" + Arrays.toString(this.j) + "}";
    }

    public String b() {
        return this.h;
    }

    @Nullable
    public String c() {
        return this.i;
    }

    public Object[] d() {
        return this.j;
    }

    private static final class TranslatableContentConsumer<T>
    implements IChatFormatted.a<T> {
        private static final IllegalArgumentException NESTED_TOO_LONG = new IllegalArgumentException("Too long");
        private final IChatFormatted.a<T> visitor;
        private int visited;

        private TranslatableContentConsumer(IChatFormatted.a<T> visitor) {
            this.visitor = visitor;
        }

        @Override
        public Optional<T> accept(String asString) {
            if (this.visited++ > 32) {
                throw NESTED_TOO_LONG;
            }
            return this.visitor.accept(asString);
        }
    }
}

