/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.ClientboundPacketListener;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.BundleDelimiterPacket;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.BundlerInfo;
import net.minecraft.network.protocol.CodecModifier;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.ProtocolCodecBuilder;
import net.minecraft.network.protocol.SimpleUnboundProtocol;
import net.minecraft.network.protocol.UnboundProtocol;
import net.minecraft.util.Unit;

public class ProtocolInfoBuilder<T extends PacketListener, B extends ByteBuf, C> {
    final EnumProtocol a;
    final EnumProtocolDirection b;
    private final List<a<T, ?, B, C>> c = new ArrayList();
    @Nullable
    private BundlerInfo d;

    public ProtocolInfoBuilder(EnumProtocol protocol, EnumProtocolDirection flow) {
        this.a = protocol;
        this.b = flow;
    }

    public <P extends Packet<? super T>> ProtocolInfoBuilder<T, B, C> a(PacketType<P> type, StreamCodec<? super B, P> serializer) {
        this.c.add(new a(type, serializer, null));
        return this;
    }

    public <P extends Packet<? super T>> ProtocolInfoBuilder<T, B, C> a(PacketType<P> type, StreamCodec<? super B, P> serializer, CodecModifier<B, P, C> modifier) {
        this.c.add(new a(type, serializer, modifier));
        return this;
    }

    public <P extends BundlePacket<? super T>, D extends BundleDelimiterPacket<? super T>> ProtocolInfoBuilder<T, B, C> a(PacketType<P> type, Function<Iterable<Packet<? super T>>, P> bundler, D packet) {
        StreamCodec streamCodec = StreamCodec.a(packet);
        PacketType<BundleDelimiterPacket<? super T>> packetType = packet.a();
        this.c.add(new a(packetType, streamCodec, null));
        this.d = BundlerInfo.a(type, bundler, packet);
        return this;
    }

    StreamCodec<ByteBuf, Packet<? super T>> a(Function<ByteBuf, B> bufferFactory, List<a<T, ?, B, C>> entries, C context) {
        ProtocolCodecBuilder protocolCodecBuilder = new ProtocolCodecBuilder(this.b);
        for (a a2 : entries) {
            a2.a(protocolCodecBuilder, bufferFactory, context);
        }
        return protocolCodecBuilder.a();
    }

    private static ProtocolInfo.a a(final EnumProtocol protocol, final EnumProtocolDirection flow, final List<? extends a<?, ?, ?, ?>> entries) {
        return new ProtocolInfo.a(){

            @Override
            public EnumProtocol a() {
                return protocol;
            }

            @Override
            public EnumProtocolDirection b() {
                return flow;
            }

            @Override
            public void a(ProtocolInfo.a.a visitor) {
                for (int i2 = 0; i2 < entries.size(); ++i2) {
                    a codecEntry = (a)entries.get(i2);
                    visitor.accept(codecEntry.a, i2);
                }
            }
        };
    }

    public SimpleUnboundProtocol<T, B> a(final C context) {
        final List<a<T, ?, B, C>> list = List.copyOf(this.c);
        final BundlerInfo bundlerInfo = this.d;
        final ProtocolInfo.a details = ProtocolInfoBuilder.a(this.a, this.b, list);
        return new SimpleUnboundProtocol<T, B>(){

            @Override
            public ProtocolInfo<T> a(Function<ByteBuf, B> bufferFactory) {
                return new b(ProtocolInfoBuilder.this.a, ProtocolInfoBuilder.this.b, ProtocolInfoBuilder.this.a(bufferFactory, list, context), bundlerInfo);
            }

            @Override
            public ProtocolInfo.a a() {
                return details;
            }
        };
    }

    public UnboundProtocol<T, B, C> a() {
        final List<a<T, ?, B, C>> list = List.copyOf(this.c);
        final BundlerInfo bundlerInfo = this.d;
        final ProtocolInfo.a details = ProtocolInfoBuilder.a(this.a, this.b, list);
        return new UnboundProtocol<T, B, C>(){

            @Override
            public ProtocolInfo<T> a(Function<ByteBuf, B> bufferFactory, C context) {
                return new b(ProtocolInfoBuilder.this.a, ProtocolInfoBuilder.this.b, ProtocolInfoBuilder.this.a(bufferFactory, list, context), bundlerInfo);
            }

            @Override
            public ProtocolInfo.a a() {
                return details;
            }
        };
    }

    private static <L extends PacketListener, B extends ByteBuf> SimpleUnboundProtocol<L, B> a(EnumProtocol protocol, EnumProtocolDirection flow, Consumer<ProtocolInfoBuilder<L, B, Unit>> packetAdder) {
        ProtocolInfoBuilder protocolInfoBuilder = new ProtocolInfoBuilder(protocol, flow);
        packetAdder.accept(protocolInfoBuilder);
        return protocolInfoBuilder.a(Unit.a);
    }

    public static <T extends ServerboundPacketListener, B extends ByteBuf> SimpleUnboundProtocol<T, B> a(EnumProtocol protocol, Consumer<ProtocolInfoBuilder<T, B, Unit>> packetAdder) {
        return ProtocolInfoBuilder.a(protocol, EnumProtocolDirection.a, packetAdder);
    }

    public static <T extends ClientboundPacketListener, B extends ByteBuf> SimpleUnboundProtocol<T, B> b(EnumProtocol protocol, Consumer<ProtocolInfoBuilder<T, B, Unit>> packetAdder) {
        return ProtocolInfoBuilder.a(protocol, EnumProtocolDirection.b, packetAdder);
    }

    private static <L extends PacketListener, B extends ByteBuf, C> UnboundProtocol<L, B, C> b(EnumProtocol protocol, EnumProtocolDirection flow, Consumer<ProtocolInfoBuilder<L, B, C>> packetAdder) {
        ProtocolInfoBuilder protocolInfoBuilder = new ProtocolInfoBuilder(protocol, flow);
        packetAdder.accept(protocolInfoBuilder);
        return protocolInfoBuilder.a();
    }

    public static <T extends ServerboundPacketListener, B extends ByteBuf, C> UnboundProtocol<T, B, C> c(EnumProtocol protocol, Consumer<ProtocolInfoBuilder<T, B, C>> packetAdder) {
        return ProtocolInfoBuilder.b(protocol, EnumProtocolDirection.a, packetAdder);
    }

    public static <T extends ClientboundPacketListener, B extends ByteBuf, C> UnboundProtocol<T, B, C> d(EnumProtocol protocol, Consumer<ProtocolInfoBuilder<T, B, C>> packetAdder) {
        return ProtocolInfoBuilder.b(protocol, EnumProtocolDirection.b, packetAdder);
    }

    record a<T extends PacketListener, P extends Packet<? super T>, B extends ByteBuf, C>(PacketType<P> a, StreamCodec<? super B, P> b, @Nullable CodecModifier<B, P, C> c) {
        public void a(ProtocolCodecBuilder<ByteBuf, T> builder, Function<ByteBuf, B> bufferFactory, C context) {
            StreamCodec<Object, P> streamCodec = this.c != null ? this.c.apply(this.b, context) : this.b;
            StreamCodec<ByteBuf, P> streamCodec1 = streamCodec.b(bufferFactory);
            builder.a(this.a, streamCodec1);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "type;serializer;modifier", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "type;serializer;modifier", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "type;serializer;modifier", "a", "b", "c"}, this, o2);
        }
    }

    record b<L extends PacketListener>(EnumProtocol a, EnumProtocolDirection b, StreamCodec<ByteBuf, Packet<? super L>> c, @Nullable BundlerInfo d) implements ProtocolInfo<L>
    {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "id;flow;codec;bundlerInfo", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "id;flow;codec;bundlerInfo", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "id;flow;codec;bundlerInfo", "a", "b", "c", "d"}, this, o2);
        }
    }
}

