/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class ClientboundLightUpdatePacketData {
    private static final StreamCodec<ByteBuf, byte[]> a = ByteBufCodecs.a(2048);
    private final BitSet b;
    private final BitSet c;
    private final BitSet d;
    private final BitSet e;
    private final List<byte[]> f;
    private final List<byte[]> g;

    public ClientboundLightUpdatePacketData(ChunkCoordIntPair chunkPos, LevelLightEngine lightEngine, @Nullable BitSet skyLight, @Nullable BitSet blockLight) {
        this.b = new BitSet();
        this.c = new BitSet();
        this.d = new BitSet();
        this.e = new BitSet();
        this.f = Lists.newArrayList();
        this.g = Lists.newArrayList();
        for (int i2 = 0; i2 < lightEngine.c(); ++i2) {
            if (skyLight == null || skyLight.get(i2)) {
                this.a(chunkPos, lightEngine, EnumSkyBlock.a, i2, this.b, this.d, this.f);
            }
            if (blockLight != null && !blockLight.get(i2)) continue;
            this.a(chunkPos, lightEngine, EnumSkyBlock.b, i2, this.c, this.e, this.g);
        }
    }

    public ClientboundLightUpdatePacketData(PacketDataSerializer buffer, int x2, int z2) {
        this.b = buffer.w();
        this.c = buffer.w();
        this.d = buffer.w();
        this.e = buffer.w();
        this.f = buffer.a(a);
        this.g = buffer.a(a);
    }

    public void a(PacketDataSerializer buffer) {
        buffer.a(this.b);
        buffer.a(this.c);
        buffer.a(this.d);
        buffer.a(this.e);
        buffer.a(this.f, a);
        buffer.a(this.g, a);
    }

    private void a(ChunkCoordIntPair chunkPos, LevelLightEngine levelLightEngine, EnumSkyBlock lightLayer, int index, BitSet skyLight, BitSet blockLight, List<byte[]> updates) {
        NibbleArray dataLayerData = levelLightEngine.a(lightLayer).a(SectionPosition.a(chunkPos, levelLightEngine.d() + index));
        if (dataLayerData != null) {
            if (dataLayerData.d()) {
                blockLight.set(index);
            } else {
                skyLight.set(index);
                updates.add(dataLayerData.b().a());
            }
        }
    }

    public BitSet a() {
        return this.b;
    }

    public BitSet b() {
        return this.d;
    }

    public List<byte[]> c() {
        return this.f;
    }

    public BitSet d() {
        return this.c;
    }

    public BitSet e() {
        return this.e;
    }

    public List<byte[]> f() {
        return this.g;
    }
}

