/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.GameTestAddMarkerDebugPayload;
import net.minecraft.network.protocol.common.custom.GameTestClearMarkersDebugPayload;
import net.minecraft.network.protocol.common.custom.RedstoneWireOrientationsDebugPayload;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.memory.ExpirableMemory;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class PacketDebug {
    private static final Logger a = LogUtils.getLogger();

    public static void a(WorldServer level, BlockPosition pos, String text, int color, int lifetimeMillis) {
        PacketDebug.a(level, new GameTestAddMarkerDebugPayload(pos, color, text, lifetimeMillis));
    }

    public static void a(WorldServer level) {
        PacketDebug.a(level, new GameTestClearMarkersDebugPayload());
    }

    public static void a(WorldServer level, ChunkCoordIntPair chunkPos) {
    }

    public static void a(WorldServer level, BlockPosition pos) {
        PacketDebug.d(level, pos);
    }

    public static void b(WorldServer level, BlockPosition pos) {
        PacketDebug.d(level, pos);
    }

    public static void c(WorldServer level, BlockPosition pos) {
        PacketDebug.d(level, pos);
    }

    private static void d(WorldServer level, BlockPosition pos) {
    }

    public static void a(World level, EntityInsentient mob, @Nullable PathEntity path, float maxDistanceToWaypoint) {
    }

    public static void a(World level, BlockPosition pos) {
    }

    public static void a(World level, RedstoneWireOrientationsDebugPayload payload) {
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            PacketDebug.a(serverLevel, (CustomPacketPayload)payload);
        }
    }

    public static void a(GeneratorAccessSeed level, StructureStart structureStart) {
    }

    public static void a(World level, EntityInsentient mob, PathfinderGoalSelector goalSelector) {
    }

    public static void a(WorldServer level, Collection<Raid> raids) {
    }

    public static void a(EntityLiving livingEntity) {
    }

    public static void a(EntityBee bee) {
    }

    public static void a(Breeze breeze) {
    }

    public static void a(World level, Holder<GameEvent> gameEvent, Vec3D pos) {
    }

    public static void a(World level, GameEventListener gameEventListener) {
    }

    public static void a(World level, BlockPosition pos, IBlockData blockState, TileEntityBeehive hiveBlockEntity) {
    }

    private static List<String> a(EntityLiving entity, long gameTime) {
        Map<MemoryModuleType<?>, Optional<ExpirableMemory<?>>> memories = entity.ec().b();
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<MemoryModuleType<?>, Optional<ExpirableMemory<?>>> entry : memories.entrySet()) {
            Object string;
            MemoryModuleType<?> memoryModuleType = entry.getKey();
            Optional<ExpirableMemory<?>> optional = entry.getValue();
            if (optional.isPresent()) {
                ExpirableMemory<?> expirableValue = optional.get();
                Object value = expirableValue.c();
                if (memoryModuleType == MemoryModuleType.E) {
                    long l2 = gameTime - (Long)value;
                    string = l2 + " ticks ago";
                } else {
                    string = expirableValue.e() ? PacketDebug.a((WorldServer)entity.dV(), value) + " (ttl: " + expirableValue.b() + ")" : PacketDebug.a((WorldServer)entity.dV(), value);
                }
            } else {
                string = "-";
            }
            list.add(BuiltInRegistries.z.b(memoryModuleType).a() + ": " + (String)string);
        }
        list.sort(String::compareTo);
        return list;
    }

    private static String a(WorldServer level, @Nullable Object object) {
        if (object == null) {
            return "-";
        }
        if (object instanceof UUID) {
            return PacketDebug.a(level, level.b((UUID)object));
        }
        if (object instanceof EntityLiving) {
            Entity entity = (Entity)object;
            return DebugEntityNameGenerator.a(entity);
        }
        if (object instanceof INamableTileEntity) {
            return ((INamableTileEntity)object).ah().getString();
        }
        if (object instanceof MemoryTarget) {
            return PacketDebug.a(level, ((MemoryTarget)object).a());
        }
        if (object instanceof BehaviorPositionEntity) {
            return PacketDebug.a(level, ((BehaviorPositionEntity)object).c());
        }
        if (object instanceof GlobalPos) {
            return PacketDebug.a(level, (Object)((GlobalPos)object).b());
        }
        if (object instanceof BehaviorTarget) {
            return PacketDebug.a(level, (Object)((BehaviorTarget)object).b());
        }
        if (object instanceof DamageSource) {
            Entity entity = ((DamageSource)object).d();
            return entity == null ? object.toString() : PacketDebug.a(level, entity);
        }
        if (!(object instanceof Collection)) {
            return object.toString();
        }
        ArrayList list = Lists.newArrayList();
        for (Object object1 : (Iterable)object) {
            list.add(PacketDebug.a(level, object1));
        }
        return ((Object)list).toString();
    }

    private static void a(WorldServer level, CustomPacketPayload payload) {
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(payload);
        for (EntityPlayer serverPlayer : level.z()) {
            serverPlayer.f.b(packet);
        }
    }
}

