/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Queues;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;

public class PacketPlayOutCommands
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutCommands> a = Packet.a(PacketPlayOutCommands::a, PacketPlayOutCommands::new);
    private static final byte b = 3;
    private static final byte c = 4;
    private static final byte d = 8;
    private static final byte e = 16;
    private static final byte f = 0;
    private static final byte g = 1;
    private static final byte h = 2;
    private final int i;
    private final List<b> j;

    public PacketPlayOutCommands(RootCommandNode<ICompletionProvider> root) {
        Object2IntMap<CommandNode<ICompletionProvider>> map = PacketPlayOutCommands.a(root);
        this.j = PacketPlayOutCommands.a(map);
        this.i = map.getInt(root);
    }

    private PacketPlayOutCommands(PacketDataSerializer buffer) {
        this.j = buffer.a(PacketPlayOutCommands::b);
        this.i = buffer.l();
        PacketPlayOutCommands.a(this.j);
    }

    @Override
    private void a(PacketDataSerializer buffer) {
        buffer.a(this.j, (buffer1, value) -> value.a((PacketDataSerializer)((Object)buffer1)));
        buffer.c(this.i);
    }

    private static void a(List<b> entries, BiPredicate<b, IntSet> validator) {
        IntOpenHashSet set = new IntOpenHashSet((IntCollection)IntSets.fromTo((int)0, (int)entries.size()));
        while (!set.isEmpty()) {
            boolean flag = set.removeIf(arg_0 -> PacketPlayOutCommands.a(validator, entries, (IntSet)set, arg_0));
            if (flag) continue;
            throw new IllegalStateException("Server sent an impossible command tree");
        }
    }

    private static void a(List<b> entries) {
        PacketPlayOutCommands.a(entries, b::a);
        PacketPlayOutCommands.a(entries, b::b);
    }

    private static Object2IntMap<CommandNode<ICompletionProvider>> a(RootCommandNode<ICompletionProvider> rootNode) {
        CommandNode commandNode;
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        ArrayDeque arrayDeque = Queues.newArrayDeque();
        arrayDeque.add(rootNode);
        while ((commandNode = (CommandNode)arrayDeque.poll()) != null) {
            if (map.containsKey((Object)commandNode)) continue;
            int size = map.size();
            map.put((Object)commandNode, size);
            arrayDeque.addAll(commandNode.getChildren());
            if (commandNode.getRedirect() == null) continue;
            arrayDeque.add(commandNode.getRedirect());
        }
        return map;
    }

    private static List<b> a(Object2IntMap<CommandNode<ICompletionProvider>> nodes) {
        ObjectArrayList list = new ObjectArrayList(nodes.size());
        list.size(nodes.size());
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(nodes)) {
            list.set(entry.getIntValue(), (Object)PacketPlayOutCommands.a((CommandNode)entry.getKey(), nodes));
        }
        return list;
    }

    private static b b(PacketDataSerializer buffer) {
        byte _byte = buffer.readByte();
        int[] varIntArray = buffer.c();
        int i2 = (_byte & 8) != 0 ? buffer.l() : 0;
        e nodeStub = PacketPlayOutCommands.a(buffer, _byte);
        return new b(nodeStub, _byte, i2, varIntArray);
    }

    @Nullable
    private static e a(PacketDataSerializer buffer, byte flags) {
        int i2 = flags & 3;
        if (i2 == 2) {
            String utf = buffer.p();
            int varInt = buffer.l();
            ArgumentTypeInfo argumentTypeInfo = (ArgumentTypeInfo)BuiltInRegistries.u.a(varInt);
            if (argumentTypeInfo == null) {
                return null;
            }
            Object template = argumentTypeInfo.b(buffer);
            MinecraftKey resourceLocation = (flags & 0x10) != 0 ? buffer.q() : null;
            return new a(utf, (ArgumentTypeInfo.a<?>)template, resourceLocation);
        }
        if (i2 == 1) {
            String utf = buffer.p();
            return new c(utf);
        }
        return null;
    }

    private static b a(CommandNode<ICompletionProvider> node, Object2IntMap<CommandNode<ICompletionProvider>> nodes) {
        e nodeStub;
        int _int;
        int i2 = 0;
        if (node.getRedirect() != null) {
            i2 |= 8;
            _int = nodes.getInt(node.getRedirect());
        } else {
            _int = 0;
        }
        if (node.getCommand() != null) {
            i2 |= 4;
        }
        if (node instanceof RootCommandNode) {
            i2 |= 0;
            nodeStub = null;
        } else if (node instanceof ArgumentCommandNode) {
            ArgumentCommandNode argumentCommandNode = (ArgumentCommandNode)node;
            nodeStub = new a(argumentCommandNode);
            i2 |= 2;
            if (argumentCommandNode.getCustomSuggestions() != null) {
                i2 |= 0x10;
            }
        } else {
            if (!(node instanceof LiteralCommandNode)) {
                throw new UnsupportedOperationException("Unknown node type " + String.valueOf(node));
            }
            LiteralCommandNode literalCommandNode = (LiteralCommandNode)node;
            nodeStub = new c(literalCommandNode.getLiteral());
            i2 |= 1;
        }
        int[] ints = node.getChildren().stream().mapToInt(arg_0 -> nodes.getInt(arg_0)).toArray();
        return new b(nodeStub, i2, _int, ints);
    }

    @Override
    public PacketType<PacketPlayOutCommands> a() {
        return GamePacketTypes.r;
    }

    @Override
    public void a(PacketListenerPlayOut handler) {
        handler.a(this);
    }

    public RootCommandNode<ICompletionProvider> a(CommandBuildContext context) {
        return (RootCommandNode)new d(context, this.j).a(this.i);
    }

    private static /* synthetic */ boolean a(BiPredicate validator, List entries, IntSet set, int i2) {
        return validator.test((b)entries.get(i2), set);
    }

    static class b {
        @Nullable
        final e a;
        final int b;
        final int c;
        final int[] d;

        b(@Nullable e stub, int flags, int redirect, int[] children) {
            this.a = stub;
            this.b = flags;
            this.c = redirect;
            this.d = children;
        }

        public void a(PacketDataSerializer buffer) {
            buffer.l(this.b);
            buffer.a(this.d);
            if ((this.b & 8) != 0) {
                buffer.c(this.c);
            }
            if (this.a != null) {
                this.a.a(buffer);
            }
        }

        public boolean a(IntSet children) {
            return (this.b & 8) == 0 || !children.contains(this.c);
        }

        public boolean b(IntSet children) {
            for (int i2 : this.d) {
                if (!children.contains(i2)) continue;
                return false;
            }
            return true;
        }
    }

    static interface e {
        public ArgumentBuilder<ICompletionProvider, ?> a(CommandBuildContext var1);

        public void a(PacketDataSerializer var1);
    }

    static class a
    implements e {
        private final String a;
        private final ArgumentTypeInfo.a<?> b;
        @Nullable
        private final MinecraftKey c;

        @Nullable
        private static MinecraftKey a(@Nullable SuggestionProvider<ICompletionProvider> provider) {
            return provider != null ? CompletionProviders.a(provider) : null;
        }

        a(String id, ArgumentTypeInfo.a<?> argumentType, @Nullable MinecraftKey suggestionId) {
            this.a = id;
            this.b = argumentType;
            this.c = suggestionId;
        }

        public a(ArgumentCommandNode<ICompletionProvider, ?> argumentNode) {
            this(argumentNode.getName(), ArgumentTypeInfos.b(argumentNode.getType()), net.minecraft.network.protocol.game.PacketPlayOutCommands$a.a((SuggestionProvider<ICompletionProvider>)argumentNode.getCustomSuggestions()));
        }

        @Override
        public ArgumentBuilder<ICompletionProvider, ?> a(CommandBuildContext context) {
            Object argumentType = this.b.b(context);
            RequiredArgumentBuilder requiredArgumentBuilder = RequiredArgumentBuilder.argument((String)this.a, argumentType);
            if (this.c != null) {
                requiredArgumentBuilder.suggests(CompletionProviders.a(this.c));
            }
            return requiredArgumentBuilder;
        }

        @Override
        public void a(PacketDataSerializer buffer) {
            buffer.a(this.a);
            net.minecraft.network.protocol.game.PacketPlayOutCommands$a.a(buffer, this.b);
            if (this.c != null) {
                buffer.a(this.c);
            }
        }

        private static <A extends ArgumentType<?>> void a(PacketDataSerializer buffer, ArgumentTypeInfo.a<A> argumentInfoTemplate) {
            net.minecraft.network.protocol.game.PacketPlayOutCommands$a.a(buffer, argumentInfoTemplate.a(), argumentInfoTemplate);
        }

        private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.a<A>> void a(PacketDataSerializer buffer, ArgumentTypeInfo<A, T> argumentInfo, ArgumentTypeInfo.a<A> argumentInfoTemplate) {
            buffer.c(BuiltInRegistries.u.a(argumentInfo));
            argumentInfo.a(argumentInfoTemplate, buffer);
        }
    }

    static class c
    implements e {
        private final String a;

        c(String id) {
            this.a = id;
        }

        @Override
        public ArgumentBuilder<ICompletionProvider, ?> a(CommandBuildContext context) {
            return LiteralArgumentBuilder.literal((String)this.a);
        }

        @Override
        public void a(PacketDataSerializer buffer) {
            buffer.a(this.a);
        }
    }

    static class d {
        private final CommandBuildContext a;
        private final List<b> b;
        private final List<CommandNode<ICompletionProvider>> c;

        d(CommandBuildContext context, List<b> entries) {
            this.a = context;
            this.b = entries;
            ObjectArrayList list = new ObjectArrayList();
            list.size(entries.size());
            this.c = list;
        }

        public CommandNode<ICompletionProvider> a(int index) {
            Object commandNode1;
            CommandNode<ICompletionProvider> commandNode = this.c.get(index);
            if (commandNode != null) {
                return commandNode;
            }
            b entry = this.b.get(index);
            if (entry.a == null) {
                commandNode1 = new RootCommandNode();
            } else {
                ArgumentBuilder<ICompletionProvider, ?> argumentBuilder = entry.a.a(this.a);
                if ((entry.b & 8) != 0) {
                    argumentBuilder.redirect(this.a(entry.c));
                }
                if ((entry.b & 4) != 0) {
                    argumentBuilder.executes((Command<ICompletionProvider>)((Command)commandContext -> 0));
                }
                commandNode1 = argumentBuilder.build();
            }
            this.c.set(index, (CommandNode<ICompletionProvider>)commandNode1);
            for (int i2 : entry.d) {
                CommandNode<ICompletionProvider> commandNode2 = this.a(i2);
                if (commandNode2 instanceof RootCommandNode) continue;
                ((CommandNode)commandNode1).addChild(commandNode2);
            }
            return commandNode1;
        }
    }
}

