/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;

public class PacketPlayOutMultiBlockChange
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutMultiBlockChange> a = Packet.a(PacketPlayOutMultiBlockChange::a, PacketPlayOutMultiBlockChange::new);
    private static final int b = 12;
    private final SectionPosition c;
    private final short[] d;
    private final IBlockData[] e;

    public PacketPlayOutMultiBlockChange(SectionPosition sectionPos, ShortSet positions, ChunkSection section) {
        this.c = sectionPos;
        int size = positions.size();
        this.d = new short[size];
        this.e = new IBlockData[size];
        int i2 = 0;
        ShortIterator shortIterator = positions.iterator();
        while (shortIterator.hasNext()) {
            short s2;
            this.d[i2] = s2 = ((Short)shortIterator.next()).shortValue();
            this.e[i2] = section != null ? section.a(SectionPosition.a(s2), SectionPosition.b(s2), SectionPosition.c(s2)) : Blocks.a.m();
            ++i2;
        }
    }

    public PacketPlayOutMultiBlockChange(SectionPosition sectionposition, ShortSet shortset, IBlockData[] states) {
        this.c = sectionposition;
        this.d = shortset.toShortArray();
        this.e = states;
    }

    public PacketPlayOutMultiBlockChange(SectionPosition sectionPos, Short2ObjectMap<IBlockData> blockChanges) {
        this.c = sectionPos;
        this.d = blockChanges.keySet().toShortArray();
        this.e = (IBlockData[])blockChanges.values().toArray((Object[])new IBlockData[0]);
    }

    private PacketPlayOutMultiBlockChange(PacketDataSerializer buffer) {
        this.c = SectionPosition.a(buffer.readLong());
        int varInt = buffer.l();
        this.d = new short[varInt];
        this.e = new IBlockData[varInt];
        for (int i2 = 0; i2 < varInt; ++i2) {
            long varLong = buffer.m();
            this.d[i2] = (short)(varLong & 0xFFFL);
            this.e[i2] = Block.k.a((int)(varLong >>> 12));
        }
    }

    @Override
    private void a(PacketDataSerializer buffer) {
        buffer.b(this.c.s());
        buffer.c(this.d.length);
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            buffer.a((long)Block.j(this.e[i2]) << 12 | (long)this.d[i2]);
        }
    }

    @Override
    public PacketType<PacketPlayOutMultiBlockChange> a() {
        return GamePacketTypes.ar;
    }

    @Override
    public void a(PacketListenerPlayOut handler) {
        handler.a(this);
    }

    @Override
    public void a(BiConsumer<BlockPosition, IBlockData> consumer) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            short s2 = this.d[i2];
            mutableBlockPos.d(this.c.d(s2), this.c.e(s2), this.c.f(s2));
            consumer.accept(mutableBlockPos, this.e[i2]);
        }
    }
}

