/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.phys.Vec3D;

public class PacketPlayOutSpawnEntity
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutSpawnEntity> a = Packet.a(PacketPlayOutSpawnEntity::a, PacketPlayOutSpawnEntity::new);
    private static final double b = 8000.0;
    private static final double c = 3.9;
    private final int d;
    private final UUID e;
    private final EntityTypes<?> f;
    private final double g;
    private final double h;
    private final double i;
    private final int j;
    private final int k;
    private final int l;
    private final byte m;
    private final byte n;
    private final byte o;
    private final int p;

    public PacketPlayOutSpawnEntity(Entity entity, EntityTrackerEntry serverEntity) {
        this(entity, serverEntity, 0);
    }

    public PacketPlayOutSpawnEntity(Entity entity, EntityTrackerEntry serverEntity, int data) {
        this(entity.ao(), entity.cG(), entity.du().a(), entity.du().b(), entity.du().c(), serverEntity.d(), serverEntity.e(), entity.an(), data, serverEntity.c(), serverEntity.f());
    }

    public PacketPlayOutSpawnEntity(Entity entity, int data, BlockPosition pos) {
        this(entity.ao(), entity.cG(), pos.u(), pos.v(), pos.w(), entity.dN(), entity.dL(), entity.an(), data, entity.dy(), entity.cA());
    }

    public PacketPlayOutSpawnEntity(int id, UUID uuid, double x2, double y2, double z2, float xRot, float yRot, EntityTypes<?> type, int data, Vec3D deltaMovement, double yHeadRot) {
        this.d = id;
        this.e = uuid;
        this.g = x2;
        this.h = y2;
        this.i = z2;
        this.m = MathHelper.g(xRot);
        this.n = MathHelper.g(yRot);
        this.o = MathHelper.g((float)yHeadRot);
        this.f = type;
        this.p = data;
        this.j = (int)(MathHelper.a(deltaMovement.d, -3.9, 3.9) * 8000.0);
        this.k = (int)(MathHelper.a(deltaMovement.e, -3.9, 3.9) * 8000.0);
        this.l = (int)(MathHelper.a(deltaMovement.f, -3.9, 3.9) * 8000.0);
    }

    private PacketPlayOutSpawnEntity(RegistryFriendlyByteBuf buffer) {
        this.d = buffer.l();
        this.e = buffer.n();
        this.f = (EntityTypes)ByteBufCodecs.a(Registries.B).decode(buffer);
        this.g = buffer.readDouble();
        this.h = buffer.readDouble();
        this.i = buffer.readDouble();
        this.m = buffer.readByte();
        this.n = buffer.readByte();
        this.o = buffer.readByte();
        this.p = buffer.l();
        this.j = buffer.readShort();
        this.k = buffer.readShort();
        this.l = buffer.readShort();
    }

    @Override
    private void a(RegistryFriendlyByteBuf buffer) {
        buffer.c(this.d);
        buffer.a(this.e);
        ByteBufCodecs.a(Registries.B).encode(buffer, this.f);
        buffer.a(this.g);
        buffer.a(this.h);
        buffer.a(this.i);
        buffer.l(this.m);
        buffer.l(this.n);
        buffer.l(this.o);
        buffer.c(this.p);
        buffer.m(this.j);
        buffer.m(this.k);
        buffer.m(this.l);
    }

    @Override
    public PacketType<PacketPlayOutSpawnEntity> a() {
        return GamePacketTypes.c;
    }

    @Override
    public void a(PacketListenerPlayOut handler) {
        handler.a(this);
    }

    public int b() {
        return this.d;
    }

    public UUID e() {
        return this.e;
    }

    public EntityTypes<?> f() {
        return this.f;
    }

    public double g() {
        return this.g;
    }

    public double h() {
        return this.h;
    }

    public double i() {
        return this.i;
    }

    public double j() {
        return (double)this.j / 8000.0;
    }

    public double k() {
        return (double)this.k / 8000.0;
    }

    public double l() {
        return (double)this.l / 8000.0;
    }

    public float m() {
        return MathHelper.a(this.m);
    }

    public float n() {
        return MathHelper.a(this.n);
    }

    public float o() {
        return MathHelper.a(this.o);
    }

    public int p() {
        return this.p;
    }
}

