/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;

public final class RegistryFixedCodec<E>
implements Codec<Holder<E>> {
    private final ResourceKey<? extends IRegistry<E>> a;

    public static <E> RegistryFixedCodec<E> a(ResourceKey<? extends IRegistry<E>> registryKey) {
        return new RegistryFixedCodec<E>(registryKey);
    }

    private RegistryFixedCodec(ResourceKey<? extends IRegistry<E>> registryKey) {
        this.a = registryKey;
    }

    public <T> DataResult<T> a(Holder<E> holder, DynamicOps<T> ops, T value) {
        RegistryOps registryOps;
        Optional optional;
        if (ops instanceof RegistryOps && (optional = (registryOps = (RegistryOps)ops).a(this.a)).isPresent()) {
            if (!holder.a(optional.get())) {
                return DataResult.error(() -> "Element " + String.valueOf(holder) + " is not valid in current registry set");
            }
            return holder.d().map(resourceKey -> MinecraftKey.a.encode((Object)resourceKey.a(), ops, value), object -> DataResult.error(() -> "Elements from registry " + String.valueOf(this.a) + " can't be serialized to a value"));
        }
        return DataResult.error(() -> "Can't access registry " + String.valueOf(this.a));
    }

    public <T> DataResult<Pair<Holder<E>, T>> decode(DynamicOps<T> ops, T value) {
        RegistryOps registryOps;
        Optional optional;
        if (ops instanceof RegistryOps && (optional = (registryOps = (RegistryOps)ops).b(this.a)).isPresent()) {
            return MinecraftKey.a.decode(ops, value).flatMap(pair -> {
                MinecraftKey resourceLocation = (MinecraftKey)pair.getFirst();
                return ((HolderGetter)optional.get()).a(ResourceKey.a(this.a, resourceLocation)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Failed to get element " + String.valueOf(resourceLocation))).map(reference -> Pair.of((Object)reference, (Object)pair.getSecond())).setLifecycle(Lifecycle.stable());
            });
        }
        return DataResult.error(() -> "Can't access registry " + String.valueOf(this.a));
    }

    public String toString() {
        return "RegistryFixedCodec[" + String.valueOf(this.a) + "]";
    }
}

