/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class AdvancementDataWorld
extends ResourceDataJson<Advancement> {
    private static final Logger a = LogUtils.getLogger();
    public Map<MinecraftKey, AdvancementHolder> b = new HashMap<MinecraftKey, AdvancementHolder>();
    private AdvancementTree c = new AdvancementTree();
    private final HolderLookup.a d;

    public AdvancementDataWorld(HolderLookup.a registries) {
        super(registries, Advancement.a, Registries.bu);
        this.d = registries;
    }

    @Override
    protected void a(Map<MinecraftKey, Advancement> object, IResourceManager resourceManager, GameProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        object.forEach((resourceLocation, advancement) -> {
            if (SpigotConfig.disabledAdvancements != null && (SpigotConfig.disabledAdvancements.contains("*") || SpigotConfig.disabledAdvancements.contains(resourceLocation.toString()) || SpigotConfig.disabledAdvancements.contains(resourceLocation.b()))) {
                return;
            }
            this.a((MinecraftKey)resourceLocation, (Advancement)advancement);
            builder.put(resourceLocation, (Object)new AdvancementHolder((MinecraftKey)resourceLocation, (Advancement)advancement));
        });
        this.b = new HashMap<MinecraftKey, AdvancementHolder>((Map<MinecraftKey, AdvancementHolder>)builder.buildOrThrow());
        AdvancementTree advancementTree = new AdvancementTree();
        advancementTree.a(this.b.values());
        a.info("Loaded {} advancements", (Object)advancementTree.c().size());
        for (AdvancementNode advancementNode : advancementTree.b()) {
            if (!advancementNode.b().b().c().isPresent()) continue;
            TreeNodePosition.a(advancementNode);
        }
        this.c = advancementTree;
    }

    private void a(MinecraftKey location, Advancement advancement) {
        ProblemReporter.a collector = new ProblemReporter.a();
        advancement.a(collector, this.d);
        collector.b().ifPresent(string -> a.warn("Found validation problems in advancement {}: \n{}", (Object)location, string));
    }

    @Nullable
    public AdvancementHolder a(MinecraftKey location) {
        return this.b.get(location);
    }

    public AdvancementTree a() {
        return this.c;
    }

    public Collection<AdvancementHolder> b() {
        return this.b.values();
    }
}

