/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import io.papermc.paper.plugin.entrypoint.LaunchEntryPointHandler;
import io.papermc.paper.world.worldgen.OptionallyFlatBedrockConditionSource;
import java.io.PrintStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.SuppressForbidden;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.arguments.selector.options.PlayerSelector;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.LocaleLanguage;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.server.DebugOutputStream;
import net.minecraft.server.RedirectStream;
import net.minecraft.util.datafix.fixes.DataConverterFlattenData;
import net.minecraft.util.datafix.fixes.DataConverterMaterialId;
import net.minecraft.util.datafix.fixes.DataConverterSpawnEgg;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.BlockComposter;
import net.minecraft.world.level.block.BlockFire;
import net.minecraft.world.level.block.state.BlockBase;
import org.slf4j.Logger;

@SuppressForbidden(reason="System.out setup")
public class DispenserRegistry {
    public static final PrintStream a = System.out;
    private static volatile boolean c;
    private static final Logger d;
    public static final AtomicLong b;

    public static void a() {
        if (!c) {
            c = true;
            Instant instant = Instant.now();
            LaunchEntryPointHandler.enterBootstrappers();
            if (BuiltInRegistries.aF.i().isEmpty()) {
                throw new IllegalStateException("Unable to load registries");
            }
            BlockFire.b();
            BlockComposter.b();
            if (EntityTypes.a(EntityTypes.bT) == null) {
                throw new IllegalStateException("Failed loading EntityTypes");
            }
            PlayerSelector.a();
            IDispenseBehavior.a();
            CauldronInteraction.a();
            BuiltInRegistries.bootStrap(() -> OptionallyFlatBedrockConditionSource.bootstrap());
            CreativeModeTabs.a();
            DispenserRegistry.d();
            b.set(Duration.between(instant, Instant.now()).toMillis());
            for (int i2 = 0; i2 <= 15; ++i2) {
                DataConverterFlattenData.a(1008 + i2, new Dynamic<Map<String, Map<String, String>>>((DynamicOps<Map<String, Map<String, String>>>)JavaOps.INSTANCE, Map.of("Name", "minecraft:oak_sign", "Properties", Map.of("rotation", String.valueOf(i2)))).convert(DynamicOpsNBT.a), new Dynamic<Map<String, Map<String, String>>>((DynamicOps<Map<String, Map<String, String>>>)JavaOps.INSTANCE, Map.of("Name", "minecraft:standing_sign", "Properties", Map.of("rotation", String.valueOf(i2)))).convert(DynamicOpsNBT.a));
            }
            DataConverterFlattenData.a(1440, new Dynamic<Map<String, Map<String, String>>>((DynamicOps<Map<String, Map<String, String>>>)JavaOps.INSTANCE, Map.of("Name", "minecraft:portal", "Properties", Map.of("axis", "x"))).convert(DynamicOpsNBT.a), new Dynamic<Map<String, Map<String, String>>>((DynamicOps<Map<String, Map<String, String>>>)JavaOps.INSTANCE, Map.of("Name", "minecraft:portal", "Properties", Map.of("axis", "x"))).convert(DynamicOpsNBT.a));
            DataConverterMaterialId.a.put(409, (Object)"minecraft:prismarine_shard");
            DataConverterMaterialId.a.put(410, (Object)"minecraft:prismarine_crystals");
            DataConverterMaterialId.a.put(411, (Object)"minecraft:rabbit");
            DataConverterMaterialId.a.put(412, (Object)"minecraft:cooked_rabbit");
            DataConverterMaterialId.a.put(413, (Object)"minecraft:rabbit_stew");
            DataConverterMaterialId.a.put(414, (Object)"minecraft:rabbit_foot");
            DataConverterMaterialId.a.put(415, (Object)"minecraft:rabbit_hide");
            DataConverterMaterialId.a.put(416, (Object)"minecraft:armor_stand");
            DataConverterMaterialId.a.put(423, (Object)"minecraft:mutton");
            DataConverterMaterialId.a.put(424, (Object)"minecraft:cooked_mutton");
            DataConverterMaterialId.a.put(425, (Object)"minecraft:banner");
            DataConverterMaterialId.a.put(426, (Object)"minecraft:end_crystal");
            DataConverterMaterialId.a.put(427, (Object)"minecraft:spruce_door");
            DataConverterMaterialId.a.put(428, (Object)"minecraft:birch_door");
            DataConverterMaterialId.a.put(429, (Object)"minecraft:jungle_door");
            DataConverterMaterialId.a.put(430, (Object)"minecraft:acacia_door");
            DataConverterMaterialId.a.put(431, (Object)"minecraft:dark_oak_door");
            DataConverterMaterialId.a.put(432, (Object)"minecraft:chorus_fruit");
            DataConverterMaterialId.a.put(433, (Object)"minecraft:chorus_fruit_popped");
            DataConverterMaterialId.a.put(434, (Object)"minecraft:beetroot");
            DataConverterMaterialId.a.put(435, (Object)"minecraft:beetroot_seeds");
            DataConverterMaterialId.a.put(436, (Object)"minecraft:beetroot_soup");
            DataConverterMaterialId.a.put(437, (Object)"minecraft:dragon_breath");
            DataConverterMaterialId.a.put(438, (Object)"minecraft:splash_potion");
            DataConverterMaterialId.a.put(439, (Object)"minecraft:spectral_arrow");
            DataConverterMaterialId.a.put(440, (Object)"minecraft:tipped_arrow");
            DataConverterMaterialId.a.put(441, (Object)"minecraft:lingering_potion");
            DataConverterMaterialId.a.put(442, (Object)"minecraft:shield");
            DataConverterMaterialId.a.put(443, (Object)"minecraft:elytra");
            DataConverterMaterialId.a.put(444, (Object)"minecraft:spruce_boat");
            DataConverterMaterialId.a.put(445, (Object)"minecraft:birch_boat");
            DataConverterMaterialId.a.put(446, (Object)"minecraft:jungle_boat");
            DataConverterMaterialId.a.put(447, (Object)"minecraft:acacia_boat");
            DataConverterMaterialId.a.put(448, (Object)"minecraft:dark_oak_boat");
            DataConverterMaterialId.a.put(449, (Object)"minecraft:totem_of_undying");
            DataConverterMaterialId.a.put(450, (Object)"minecraft:shulker_shell");
            DataConverterMaterialId.a.put(452, (Object)"minecraft:iron_nugget");
            DataConverterMaterialId.a.put(453, (Object)"minecraft:knowledge_book");
            DataConverterSpawnEgg.a[23] = "Arrow";
        }
    }

    private static <T> void a(Iterable<T> objects, Function<T, String> objectToKeyFunction, Set<String> translationSet) {
        LocaleLanguage instance = LocaleLanguage.a();
        objects.forEach(object -> {
            String string = (String)objectToKeyFunction.apply(object);
            if (!instance.b(string)) {
                translationSet.add(string);
            }
        });
    }

    private static void a(final Set<String> translations) {
        final LocaleLanguage instance = LocaleLanguage.a();
        GameRules gameRules = new GameRules(FeatureFlags.e.a());
        gameRules.a(new GameRules.GameRuleVisitor(){

            @Override
            public <T extends GameRules.GameRuleValue<T>> void a(GameRules.GameRuleKey<T> key, GameRules.GameRuleDefinition<T> type) {
                if (!instance.b(key.b())) {
                    translations.add(key.a());
                }
            }
        });
    }

    public static Set<String> b() {
        TreeSet<String> set = new TreeSet<String>();
        DispenserRegistry.a(BuiltInRegistries.s, AttributeBase::c, set);
        DispenserRegistry.a(BuiltInRegistries.f, EntityTypes::g, set);
        DispenserRegistry.a(BuiltInRegistries.d, MobEffectList::f, set);
        DispenserRegistry.a(BuiltInRegistries.g, Item::j, set);
        DispenserRegistry.a(BuiltInRegistries.e, BlockBase::v, set);
        DispenserRegistry.a(BuiltInRegistries.k, resourceLocation -> "stat." + resourceLocation.toString().replace(':', '.'), set);
        DispenserRegistry.a(set);
        return set;
    }

    public static void a(Supplier<String> callSite) {
        if (!c) {
            throw DispenserRegistry.b(callSite);
        }
    }

    private static RuntimeException b(Supplier<String> callSite) {
        try {
            String string = callSite.get();
            return new IllegalArgumentException("Not bootstrapped (called from " + string + ")");
        }
        catch (Exception var3) {
            IllegalArgumentException runtimeException = new IllegalArgumentException("Not bootstrapped (failed to resolve location)");
            runtimeException.addSuppressed(var3);
            return runtimeException;
        }
    }

    public static void c() {
        DispenserRegistry.a(() -> "validate");
        if (SharedConstants.aV) {
            DispenserRegistry.b().forEach(string -> d.error("Missing translations: {}", string));
            CommandDispatcher.b();
        }
        AttributeDefaults.a();
    }

    private static void d() {
        if (d.isDebugEnabled()) {
            System.setErr(new DebugOutputStream("STDERR", System.err));
            System.setOut(new DebugOutputStream("STDOUT", a));
        } else {
            System.setErr(new RedirectStream("STDERR", System.err));
            System.setOut(new RedirectStream("STDOUT", a));
        }
    }

    public static void a(String message) {
        a.println(message);
    }

    static {
        d = LogUtils.getLogger();
        b = new AtomicLong(-1L);
    }
}

