/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.authlib.yggdrasil.ServicesKeyType;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import io.papermc.paper.configuration.PaperConfigurations;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.server.players.UserCache;
import net.minecraft.util.SignatureValidator;

public record Services(MinecraftSessionService a, ServicesKeySet b, GameProfileRepository c, UserCache d, @Nullable PaperConfigurations paperConfigurations) {
    private final MinecraftSessionService a;
    private final ServicesKeySet b;
    private final GameProfileRepository c;
    private final UserCache d;
    @Nullable
    private final PaperConfigurations paperConfigurations;
    public static final String e = "usercache.json";

    public Services(MinecraftSessionService sessionService, ServicesKeySet servicesKeySet, GameProfileRepository profileRepository, UserCache profileCache) {
        this(sessionService, servicesKeySet, profileRepository, profileCache, null);
    }

    public PaperConfigurations paperConfigurations() {
        return Objects.requireNonNull(this.paperConfigurations);
    }

    public static Services create(YggdrasilAuthenticationService authenticationService, File profileRepository, File userCacheFile, OptionSet optionSet) throws Exception {
        MinecraftSessionService minecraftSessionService = authenticationService.createMinecraftSessionService();
        GameProfileRepository gameProfileRepository = authenticationService.createProfileRepository();
        UserCache gameProfileCache = new UserCache(gameProfileRepository, userCacheFile);
        Path legacyConfigPath = ((File)optionSet.valueOf("paper-settings")).toPath();
        Path configDirPath = ((File)optionSet.valueOf("paper-settings-directory")).toPath();
        PaperConfigurations paperConfigurations = PaperConfigurations.setup(legacyConfigPath, configDirPath, profileRepository.toPath(), (File)optionSet.valueOf("spigot-settings"));
        return new Services(minecraftSessionService, authenticationService.getServicesKeySet(), gameProfileRepository, gameProfileCache, paperConfigurations);
    }

    @Nullable
    public SignatureValidator a() {
        return SignatureValidator.a(this.b, ServicesKeyType.PROFILE_KEY);
    }

    public boolean b() {
        return !this.b.keys(ServicesKeyType.PROFILE_KEY).isEmpty();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{Services.class, "sessionService;servicesKeySet;profileRepository;profileCache;paperConfigurations", "a", "b", "c", "d", "paperConfigurations"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Services.class, "sessionService;servicesKeySet;profileRepository;profileCache;paperConfigurations", "a", "b", "c", "d", "paperConfigurations"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Services.class, "sessionService;servicesKeySet;profileRepository;profileCache;paperConfigurations", "a", "b", "c", "d", "paperConfigurations"}, this, o2);
    }

    public MinecraftSessionService c() {
        return this.a;
    }

    public ServicesKeySet d() {
        return this.b;
    }

    public GameProfileRepository e() {
        return this.c;
    }

    public UserCache f() {
        return this.d;
    }
}

