/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;

public class CommandAdvancement {
    private static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(object -> (IChatBaseComponent)object);
    private static final Dynamic2CommandExceptionType b = new Dynamic2CommandExceptionType((criteriaName, criterion) -> IChatBaseComponent.b("commands.advancement.criterionNotFound", criteriaName, criterion));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("advancement").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("grant").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.d()).then(net.minecraft.commands.CommandDispatcher.a("only").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("advancement", ResourceKeyArgument.a(Registries.bu)).executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.a, CommandAdvancement.a((CommandContext<CommandListenerWrapper>)context, ResourceKeyArgument.e((CommandContext<CommandListenerWrapper>)context, "advancement"), Filter.a)))).then(net.minecraft.commands.CommandDispatcher.a("criterion", StringArgumentType.greedyString()).suggests((context, builder) -> ICompletionProvider.b(ResourceKeyArgument.e((CommandContext<CommandListenerWrapper>)context, "advancement").b().e().keySet(), builder)).executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.a, ResourceKeyArgument.e((CommandContext<CommandListenerWrapper>)context, "advancement"), StringArgumentType.getString((CommandContext)context, (String)"criterion"))))))).then(net.minecraft.commands.CommandDispatcher.a("from").then(net.minecraft.commands.CommandDispatcher.a("advancement", ResourceKeyArgument.a(Registries.bu)).executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.a, CommandAdvancement.a((CommandContext<CommandListenerWrapper>)context, ResourceKeyArgument.e((CommandContext<CommandListenerWrapper>)context, "advancement"), Filter.c)))))).then(net.minecraft.commands.CommandDispatcher.a("until").then(net.minecraft.commands.CommandDispatcher.a("advancement", ResourceKeyArgument.a(Registries.bu)).executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.a, CommandAdvancement.a((CommandContext<CommandListenerWrapper>)context, ResourceKeyArgument.e((CommandContext<CommandListenerWrapper>)context, "advancement"), Filter.d)))))).then(net.minecraft.commands.CommandDispatcher.a("through").then(net.minecraft.commands.CommandDispatcher.a("advancement", ResourceKeyArgument.a(Registries.bu)).executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.a, CommandAdvancement.a((CommandContext<CommandListenerWrapper>)context, ResourceKeyArgument.e((CommandContext<CommandListenerWrapper>)context, "advancement"), Filter.b)))))).then(net.minecraft.commands.CommandDispatcher.a("everything").executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.a, ((CommandListenerWrapper)context.getSource()).l().aD().b(), false)))))).then(net.minecraft.commands.CommandDispatcher.a("revoke").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.d()).then(net.minecraft.commands.CommandDispatcher.a("only").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("advancement", ResourceKeyArgument.a(Registries.bu)).executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.b, CommandAdvancement.a((CommandContext<CommandListenerWrapper>)context, ResourceKeyArgument.e((CommandContext<CommandListenerWrapper>)context, "advancement"), Filter.a)))).then(net.minecraft.commands.CommandDispatcher.a("criterion", StringArgumentType.greedyString()).suggests((context, builder) -> ICompletionProvider.b(ResourceKeyArgument.e((CommandContext<CommandListenerWrapper>)context, "advancement").b().e().keySet(), builder)).executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.b, ResourceKeyArgument.e((CommandContext<CommandListenerWrapper>)context, "advancement"), StringArgumentType.getString((CommandContext)context, (String)"criterion"))))))).then(net.minecraft.commands.CommandDispatcher.a("from").then(net.minecraft.commands.CommandDispatcher.a("advancement", ResourceKeyArgument.a(Registries.bu)).executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.b, CommandAdvancement.a((CommandContext<CommandListenerWrapper>)context, ResourceKeyArgument.e((CommandContext<CommandListenerWrapper>)context, "advancement"), Filter.c)))))).then(net.minecraft.commands.CommandDispatcher.a("until").then(net.minecraft.commands.CommandDispatcher.a("advancement", ResourceKeyArgument.a(Registries.bu)).executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.b, CommandAdvancement.a((CommandContext<CommandListenerWrapper>)context, ResourceKeyArgument.e((CommandContext<CommandListenerWrapper>)context, "advancement"), Filter.d)))))).then(net.minecraft.commands.CommandDispatcher.a("through").then(net.minecraft.commands.CommandDispatcher.a("advancement", ResourceKeyArgument.a(Registries.bu)).executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.b, CommandAdvancement.a((CommandContext<CommandListenerWrapper>)context, ResourceKeyArgument.e((CommandContext<CommandListenerWrapper>)context, "advancement"), Filter.b)))))).then(net.minecraft.commands.CommandDispatcher.a("everything").executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.b, ((CommandListenerWrapper)context.getSource()).l().aD().b())))))));
    }

    private static int a(CommandListenerWrapper source, Collection<EntityPlayer> targets, Action action, Collection<AdvancementHolder> advancements) throws CommandSyntaxException {
        return CommandAdvancement.a(source, targets, action, advancements, true);
    }

    private static int a(CommandListenerWrapper source, Collection<EntityPlayer> targets, Action action, Collection<AdvancementHolder> advancements, boolean grantEverything) throws CommandSyntaxException {
        int i2 = 0;
        for (EntityPlayer serverPlayer : targets) {
            i2 += action.a(serverPlayer, advancements, grantEverything);
        }
        if (i2 == 0) {
            if (advancements.size() == 1) {
                if (targets.size() == 1) {
                    throw a.create((Object)IChatBaseComponent.a(action.a() + ".one.to.one.failure", Advancement.a(advancements.iterator().next()), targets.iterator().next().P_()));
                }
                throw a.create((Object)IChatBaseComponent.a(action.a() + ".one.to.many.failure", Advancement.a(advancements.iterator().next()), targets.size()));
            }
            if (targets.size() == 1) {
                throw a.create((Object)IChatBaseComponent.a(action.a() + ".many.to.one.failure", advancements.size(), targets.iterator().next().P_()));
            }
            throw a.create((Object)IChatBaseComponent.a(action.a() + ".many.to.many.failure", advancements.size(), targets.size()));
        }
        if (advancements.size() == 1) {
            if (targets.size() == 1) {
                source.a(() -> IChatBaseComponent.a(action.a() + ".one.to.one.success", Advancement.a((AdvancementHolder)advancements.iterator().next()), ((EntityPlayer)targets.iterator().next()).P_()), true);
            } else {
                source.a(() -> IChatBaseComponent.a(action.a() + ".one.to.many.success", Advancement.a((AdvancementHolder)advancements.iterator().next()), targets.size()), true);
            }
        } else if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a(action.a() + ".many.to.one.success", advancements.size(), ((EntityPlayer)targets.iterator().next()).P_()), true);
        } else {
            source.a(() -> IChatBaseComponent.a(action.a() + ".many.to.many.success", advancements.size(), targets.size()), true);
        }
        return i2;
    }

    private static int a(CommandListenerWrapper source, Collection<EntityPlayer> targets, Action action, AdvancementHolder advancement, String criterionName) throws CommandSyntaxException {
        int i2 = 0;
        Advancement advancement1 = advancement.b();
        if (!advancement1.e().containsKey(criterionName)) {
            throw b.create((Object)Advancement.a(advancement), (Object)criterionName);
        }
        for (EntityPlayer serverPlayer : targets) {
            if (!action.a(serverPlayer, advancement, criterionName)) continue;
            ++i2;
        }
        if (i2 == 0) {
            if (targets.size() == 1) {
                throw a.create((Object)IChatBaseComponent.a(action.a() + ".criterion.to.one.failure", new Object[]{criterionName, Advancement.a(advancement), targets.iterator().next().P_()}));
            }
            throw a.create((Object)IChatBaseComponent.a(action.a() + ".criterion.to.many.failure", new Object[]{criterionName, Advancement.a(advancement), targets.size()}));
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a(action.a() + ".criterion.to.one.success", new Object[]{criterionName, Advancement.a(advancement), ((EntityPlayer)targets.iterator().next()).P_()}), true);
        } else {
            source.a(() -> IChatBaseComponent.a(action.a() + ".criterion.to.many.success", new Object[]{criterionName, Advancement.a(advancement), targets.size()}), true);
        }
        return i2;
    }

    private static List<AdvancementHolder> a(CommandContext<CommandListenerWrapper> context, AdvancementHolder advancement, Filter mode) {
        AdvancementTree advancementTree = ((CommandListenerWrapper)context.getSource()).l().aD().a();
        AdvancementNode advancementNode = advancementTree.a(advancement);
        if (advancementNode == null) {
            return List.of(advancement);
        }
        ArrayList<AdvancementHolder> list = new ArrayList<AdvancementHolder>();
        if (mode.f) {
            for (AdvancementNode advancementNode1 = advancementNode.c(); advancementNode1 != null; advancementNode1 = advancementNode1.c()) {
                list.add(advancementNode1.b());
            }
        }
        list.add(advancement);
        if (mode.g) {
            CommandAdvancement.a(advancementNode, list);
        }
        return list;
    }

    private static void a(AdvancementNode node, List<AdvancementHolder> output) {
        for (AdvancementNode advancementNode : node.e()) {
            output.add(advancementNode.b());
            CommandAdvancement.a(advancementNode, output);
        }
    }

    static abstract sealed class Action
    extends Enum<Action> {
        public static final /* enum */ Action a = new Action("grant"){

            @Override
            protected boolean a(EntityPlayer player, AdvancementHolder advancement) {
                AdvancementProgress orStartProgress = player.R().b(advancement);
                if (orStartProgress.a()) {
                    return false;
                }
                for (String string : orStartProgress.e()) {
                    player.R().a(advancement, string);
                }
                return true;
            }

            @Override
            protected boolean a(EntityPlayer player, AdvancementHolder advancement, String criterionName) {
                return player.R().a(advancement, criterionName);
            }
        };
        public static final /* enum */ Action b = new Action("revoke"){

            @Override
            protected boolean a(EntityPlayer player, AdvancementHolder advancement) {
                AdvancementProgress orStartProgress = player.R().b(advancement);
                if (!orStartProgress.b()) {
                    return false;
                }
                for (String string : orStartProgress.f()) {
                    player.R().b(advancement, string);
                }
                return true;
            }

            @Override
            protected boolean a(EntityPlayer player, AdvancementHolder advancement, String criterionName) {
                return player.R().b(advancement, criterionName);
            }
        };
        private final String c;
        private static final /* synthetic */ Action[] d;

        public static Action[] values() {
            return (Action[])d.clone();
        }

        public static Action valueOf(String name) {
            return Enum.valueOf(Action.class, name);
        }

        private Action(String key) {
            this.c = "commands.advancement." + key;
        }

        public int a(EntityPlayer player, Iterable<AdvancementHolder> advancements, boolean grantEverything) {
            int i2 = 0;
            if (!grantEverything) {
                player.R().a(player, true);
            }
            for (AdvancementHolder advancementHolder : advancements) {
                if (!this.a(player, advancementHolder)) continue;
                ++i2;
            }
            if (!grantEverything) {
                player.R().a(player, false);
            }
            return i2;
        }

        protected abstract boolean a(EntityPlayer var1, AdvancementHolder var2);

        protected abstract boolean a(EntityPlayer var1, AdvancementHolder var2, String var3);

        protected String a() {
            return this.c;
        }

        private static /* synthetic */ Action[] b() {
            return new Action[]{a, b};
        }

        static {
            d = Action.b();
        }
    }

    static final class Filter
    extends Enum<Filter> {
        public static final /* enum */ Filter a = new Filter(false, false);
        public static final /* enum */ Filter b = new Filter(true, true);
        public static final /* enum */ Filter c = new Filter(false, true);
        public static final /* enum */ Filter d = new Filter(true, false);
        public static final /* enum */ Filter e = new Filter(true, true);
        final boolean f;
        final boolean g;
        private static final /* synthetic */ Filter[] h;

        public static Filter[] values() {
            return (Filter[])h.clone();
        }

        public static Filter valueOf(String name) {
            return Enum.valueOf(Filter.class, name);
        }

        private Filter(boolean parents, boolean children) {
            this.f = parents;
            this.g = children;
        }

        private static /* synthetic */ Filter[] a() {
            return new Filter[]{a, b, c, d, e};
        }

        static {
            h = Filter.a();
        }
    }
}

