/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.InCommandFunction;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;

public class CommandClone {
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.clone.overlap"));
    private static final Dynamic2CommandExceptionType c = new Dynamic2CommandExceptionType((maxBlocks, specifiedBlocks) -> IChatBaseComponent.b("commands.clone.toobig", maxBlocks, specifiedBlocks));
    private static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.clone.failed"));
    public static final Predicate<ShapeDetectorBlock> a = blockInWorld -> !blockInWorld.a().l();

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("clone").requires(source -> source.c(2))).then(CommandClone.a(context, (CommandContext<CommandListenerWrapper> context1) -> ((CommandListenerWrapper)context1.getSource()).e()))).then(net.minecraft.commands.CommandDispatcher.a("from").then(net.minecraft.commands.CommandDispatcher.a("sourceDimension", ArgumentDimension.a()).then(CommandClone.a(context, (CommandContext<CommandListenerWrapper> context1) -> ArgumentDimension.a((CommandContext<CommandListenerWrapper>)context1, "sourceDimension")))))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandBuildContext buildContext, InCommandFunction<CommandContext<CommandListenerWrapper>, WorldServer> levelGetter) {
        return net.minecraft.commands.CommandDispatcher.a("begin", ArgumentPosition.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("end", ArgumentPosition.a()).then(CommandClone.a(buildContext, levelGetter, (CommandContext<CommandListenerWrapper> context) -> ((CommandListenerWrapper)context.getSource()).e()))).then(net.minecraft.commands.CommandDispatcher.a("to").then(net.minecraft.commands.CommandDispatcher.a("targetDimension", ArgumentDimension.a()).then(CommandClone.a(buildContext, levelGetter, (CommandContext<CommandListenerWrapper> context) -> ArgumentDimension.a((CommandContext<CommandListenerWrapper>)context, "targetDimension"))))));
    }

    private static c a(CommandContext<CommandListenerWrapper> context, WorldServer level, String name) throws CommandSyntaxException {
        BlockPosition loadedBlockPos = ArgumentPosition.a(context, level, name);
        return new c(level, loadedBlockPos);
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandBuildContext buildContext, InCommandFunction<CommandContext<CommandListenerWrapper>, WorldServer> sourceLevelGetter, InCommandFunction<CommandContext<CommandListenerWrapper>, WorldServer> destinationLevelGetter) {
        InCommandFunction<CommandContext<CommandListenerWrapper>, c> inCommandFunction = context -> CommandClone.a((CommandContext<CommandListenerWrapper>)context, (WorldServer)sourceLevelGetter.apply((CommandContext<CommandListenerWrapper>)context), "begin");
        InCommandFunction<CommandContext<CommandListenerWrapper>, c> inCommandFunction1 = context -> CommandClone.a((CommandContext<CommandListenerWrapper>)context, (WorldServer)sourceLevelGetter.apply((CommandContext<CommandListenerWrapper>)context), "end");
        InCommandFunction<CommandContext<CommandListenerWrapper>, c> inCommandFunction2 = context -> CommandClone.a((CommandContext<CommandListenerWrapper>)context, (WorldServer)destinationLevelGetter.apply((CommandContext<CommandListenerWrapper>)context), "destination");
        return CommandClone.a(buildContext, inCommandFunction, inCommandFunction1, inCommandFunction2, false, net.minecraft.commands.CommandDispatcher.a("destination", ArgumentPosition.a())).then(CommandClone.a(buildContext, inCommandFunction, inCommandFunction1, inCommandFunction2, true, net.minecraft.commands.CommandDispatcher.a("strict")));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandBuildContext buildContext, InCommandFunction<CommandContext<CommandListenerWrapper>, c> begin, InCommandFunction<CommandContext<CommandListenerWrapper>, c> end, InCommandFunction<CommandContext<CommandListenerWrapper>, c> destination, boolean strict, ArgumentBuilder<CommandListenerWrapper, ?> argumentBuilder) {
        return ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)argumentBuilder.executes((Command<CommandListenerWrapper>)((Command)context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (c)begin.apply(context), (c)end.apply(context), (c)destination.apply(context), block -> true, Mode.c, strict)))).then(CommandClone.a(begin, end, destination, (CommandContext<CommandListenerWrapper> context) -> block -> true, strict, net.minecraft.commands.CommandDispatcher.a("replace")))).then(CommandClone.a(begin, end, destination, (CommandContext<CommandListenerWrapper> context) -> a, strict, net.minecraft.commands.CommandDispatcher.a("masked")))).then(net.minecraft.commands.CommandDispatcher.a("filtered").then(CommandClone.a(begin, end, destination, (CommandContext<CommandListenerWrapper> context) -> ArgumentBlockPredicate.a((CommandContext<CommandListenerWrapper>)context, "filter"), strict, net.minecraft.commands.CommandDispatcher.a("filter", ArgumentBlockPredicate.a(buildContext)))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(InCommandFunction<CommandContext<CommandListenerWrapper>, c> begin, InCommandFunction<CommandContext<CommandListenerWrapper>, c> end, InCommandFunction<CommandContext<CommandListenerWrapper>, c> destination, InCommandFunction<CommandContext<CommandListenerWrapper>, Predicate<ShapeDetectorBlock>> filter, boolean strict, ArgumentBuilder<CommandListenerWrapper, ?> argumentBuilder) {
        return ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)argumentBuilder.executes((Command<CommandListenerWrapper>)((Command)context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (c)begin.apply(context), (c)end.apply(context), (c)destination.apply(context), (Predicate)filter.apply(context), Mode.c, strict)))).then(net.minecraft.commands.CommandDispatcher.a("force").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (c)begin.apply(context), (c)end.apply(context), (c)destination.apply(context), (Predicate)filter.apply(context), Mode.a, strict)))).then(net.minecraft.commands.CommandDispatcher.a("move").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (c)begin.apply(context), (c)end.apply(context), (c)destination.apply(context), (Predicate)filter.apply(context), Mode.b, strict)))).then(net.minecraft.commands.CommandDispatcher.a("normal").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (c)begin.apply(context), (c)end.apply(context), (c)destination.apply(context), (Predicate)filter.apply(context), Mode.c, strict)));
    }

    private static int a(CommandListenerWrapper source, c begin, c end, c destination, Predicate<ShapeDetectorBlock> filter, Mode mode, boolean strict) throws CommandSyntaxException {
        int _int;
        BlockPosition blockPos = begin.b();
        BlockPosition blockPos1 = end.b();
        StructureBoundingBox boundingBox = StructureBoundingBox.a(blockPos, blockPos1);
        BlockPosition blockPos2 = destination.b();
        BlockPosition blockPos3 = blockPos2.a(boundingBox.c());
        StructureBoundingBox boundingBox1 = StructureBoundingBox.a(blockPos2, blockPos3);
        WorldServer serverLevel = begin.a();
        WorldServer serverLevel1 = destination.a();
        if (!mode.a() && serverLevel == serverLevel1 && boundingBox1.a(boundingBox)) {
            throw b.create();
        }
        int i2 = boundingBox.d() * boundingBox.e() * boundingBox.f();
        if (i2 > (_int = source.e().O().d(GameRules.B))) {
            throw c.create((Object)_int, (Object)i2);
        }
        if (serverLevel.a(blockPos, blockPos1) && serverLevel1.a(blockPos2, blockPos3)) {
            int y2;
            int z2;
            if (serverLevel1.ak()) {
                throw d.create();
            }
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            LinkedList list3 = Lists.newLinkedList();
            BlockPosition blockPos4 = new BlockPosition(boundingBox1.h() - boundingBox.h(), boundingBox1.i() - boundingBox.i(), boundingBox1.j() - boundingBox.j());
            for (z2 = boundingBox.j(); z2 <= boundingBox.m(); ++z2) {
                for (y2 = boundingBox.i(); y2 <= boundingBox.l(); ++y2) {
                    for (int x2 = boundingBox.h(); x2 <= boundingBox.k(); ++x2) {
                        Object blockPos5 = new BlockPosition(x2, y2, z2);
                        BlockPosition blockPos6 = ((BlockPosition)blockPos5).a(blockPos4);
                        ShapeDetectorBlock blockInWorld = new ShapeDetectorBlock(serverLevel, (BlockPosition)blockPos5, false);
                        IBlockData state = blockInWorld.a();
                        if (!filter.test(blockInWorld)) continue;
                        TileEntity blockEntity = serverLevel.c_((BlockPosition)blockPos5);
                        if (blockEntity != null) {
                            a cloneBlockEntityInfo = new a(blockEntity.e(source.u()), blockEntity.r());
                            list1.add(new CommandCloneStoredTileEntity(blockPos6, state, cloneBlockEntityInfo));
                            list3.addLast(blockPos5);
                            continue;
                        }
                        if (!state.s() && !state.m(serverLevel, (BlockPosition)blockPos5)) {
                            list2.add(new CommandCloneStoredTileEntity(blockPos6, state, null));
                            list3.addFirst(blockPos5);
                            continue;
                        }
                        list.add(new CommandCloneStoredTileEntity(blockPos6, state, null));
                        list3.addLast(blockPos5);
                    }
                }
            }
            z2 = 2 | (strict ? 816 : 0);
            if (mode == Mode.b) {
                for (BlockPosition blockPos7 : list3) {
                    serverLevel.a(blockPos7, Blocks.iy.m(), z2 | 0x330);
                }
                y2 = strict ? z2 : 3;
                for (Object blockPos5 : list3) {
                    serverLevel.a((BlockPosition)blockPos5, Blocks.a.m(), y2);
                }
            }
            ArrayList list4 = Lists.newArrayList();
            list4.addAll(list);
            list4.addAll(list1);
            list4.addAll(list2);
            List list5 = Lists.reverse((List)list4);
            for (Iterator cloneBlockInfo : list5) {
                serverLevel1.a(((CommandCloneStoredTileEntity)((Object)cloneBlockInfo)).a, Blocks.iy.m(), z2 | 0x330);
            }
            int i1 = 0;
            for (CommandCloneStoredTileEntity cloneBlockInfo1 : list4) {
                if (!serverLevel1.a(cloneBlockInfo1.a, cloneBlockInfo1.b, z2)) continue;
                ++i1;
            }
            for (CommandCloneStoredTileEntity cloneBlockInfo1x : list1) {
                TileEntity blockEntity1 = serverLevel1.c_(cloneBlockInfo1x.a);
                if (cloneBlockInfo1x.c != null && blockEntity1 != null) {
                    blockEntity1.d(cloneBlockInfo1x.c.a, serverLevel1.J_());
                    blockEntity1.a(cloneBlockInfo1x.c.b);
                    blockEntity1.e();
                }
                serverLevel1.a(cloneBlockInfo1x.a, cloneBlockInfo1x.b, z2);
            }
            if (!strict) {
                for (CommandCloneStoredTileEntity cloneBlockInfo1x : list5) {
                    serverLevel1.a(cloneBlockInfo1x.a, cloneBlockInfo1x.b.b());
                }
            }
            serverLevel1.n().a(serverLevel.n(), boundingBox, blockPos4);
            if (i1 == 0) {
                throw d.create();
            }
            int i22 = i1;
            source.a(() -> IChatBaseComponent.a("commands.clone.success", i22), true);
            return i1;
        }
        throw ArgumentPosition.a.create();
    }

    record c(WorldServer a, BlockPosition b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "dimension;position", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "dimension;position", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "dimension;position", "a", "b"}, this, o2);
        }
    }

    static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode a = new Mode(true);
        public static final /* enum */ Mode b = new Mode(true);
        public static final /* enum */ Mode c = new Mode(false);
        private final boolean d;
        private static final /* synthetic */ Mode[] e;

        public static Mode[] values() {
            return (Mode[])e.clone();
        }

        public static Mode valueOf(String name) {
            return Enum.valueOf(Mode.class, name);
        }

        private Mode(boolean canOverlap) {
            this.d = canOverlap;
        }

        public boolean a() {
            return this.d;
        }

        private static /* synthetic */ Mode[] b() {
            return new Mode[]{a, b, c};
        }

        static {
            e = Mode.b();
        }
    }

    record a(NBTTagCompound a, DataComponentMap b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "tag;components", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "tag;components", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "tag;components", "a", "b"}, this, o2);
        }
    }

    record CommandCloneStoredTileEntity(BlockPosition a, IBlockData b, @Nullable a c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{CommandCloneStoredTileEntity.class, "pos;state;blockEntityInfo", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CommandCloneStoredTileEntity.class, "pos;state;blockEntityInfo", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CommandCloneStoredTileEntity.class, "pos;state;blockEntityInfo", "a", "b", "c"}, this, o2);
        }
    }
}

