/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.CommandReload;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;

public class CommandDatapack {
    private static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(pack -> IChatBaseComponent.b("commands.datapack.unknown", pack));
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(pack -> IChatBaseComponent.b("commands.datapack.enable.failed", pack));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(pack -> IChatBaseComponent.b("commands.datapack.disable.failed", pack));
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(object -> IChatBaseComponent.b("commands.datapack.disable.failed.feature", object));
    private static final Dynamic2CommandExceptionType e = new Dynamic2CommandExceptionType((object, object1) -> IChatBaseComponent.b("commands.datapack.enable.failed.no_flags", object, object1));
    private static final SuggestionProvider<CommandListenerWrapper> f = (commandContext, suggestionsBuilder) -> ICompletionProvider.b(((CommandListenerWrapper)commandContext.getSource()).l().aF().e().stream().map(StringArgumentType::escapeIfRequired), suggestionsBuilder);
    private static final SuggestionProvider<CommandListenerWrapper> g = (commandContext, suggestionsBuilder) -> {
        ResourcePackRepository packRepository = ((CommandListenerWrapper)commandContext.getSource()).l().aF();
        Collection<String> selectedIds = packRepository.e();
        FeatureFlagSet featureFlagSet = ((CommandListenerWrapper)commandContext.getSource()).v();
        return ICompletionProvider.b(packRepository.d().stream().filter(pack -> pack.e().a(featureFlagSet)).map(ResourcePackLoader::g).filter(string -> !selectedIds.contains(string)).map(StringArgumentType::escapeIfRequired), suggestionsBuilder);
    };

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("datapack").requires(commandSourceStack -> commandSourceStack.c(2))).then(net.minecraft.commands.CommandDispatcher.a("enable").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("name", StringArgumentType.string()).suggests(g).executes(context -> CommandDatapack.a((CommandListenerWrapper)context.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "name", true), (List<ResourcePackLoader> enabledPacks, ResourcePackLoader packToEnable) -> packToEnable.k().a(enabledPacks, packToEnable, ResourcePackLoader::h, false)))).then(net.minecraft.commands.CommandDispatcher.a("after").then(net.minecraft.commands.CommandDispatcher.a("existing", StringArgumentType.string()).suggests(f).executes(context -> CommandDatapack.a((CommandListenerWrapper)context.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "name", true), (List<ResourcePackLoader> enabledPacks, ResourcePackLoader packToEnable) -> enabledPacks.add(enabledPacks.indexOf(CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "existing", false)) + 1, packToEnable)))))).then(net.minecraft.commands.CommandDispatcher.a("before").then(net.minecraft.commands.CommandDispatcher.a("existing", StringArgumentType.string()).suggests(f).executes(context -> CommandDatapack.a((CommandListenerWrapper)context.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "name", true), (List<ResourcePackLoader> enabledPacks, ResourcePackLoader packToEnable) -> enabledPacks.add(enabledPacks.indexOf(CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "existing", false)), packToEnable)))))).then(net.minecraft.commands.CommandDispatcher.a("last").executes(context -> CommandDatapack.a((CommandListenerWrapper)context.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "name", true), List::add)))).then(net.minecraft.commands.CommandDispatcher.a("first").executes(context -> CommandDatapack.a((CommandListenerWrapper)context.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "name", true), (List<ResourcePackLoader> enabledPacks, ResourcePackLoader packToEnable) -> enabledPacks.add(0, packToEnable))))))).then(net.minecraft.commands.CommandDispatcher.a("disable").then(net.minecraft.commands.CommandDispatcher.a("name", StringArgumentType.string()).suggests(f).executes(context -> CommandDatapack.a((CommandListenerWrapper)context.getSource(), CommandDatapack.a((CommandContext<CommandListenerWrapper>)context, "name", false)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("list").executes(context -> CommandDatapack.a((CommandListenerWrapper)context.getSource()))).then(net.minecraft.commands.CommandDispatcher.a("available").executes(context -> CommandDatapack.b((CommandListenerWrapper)context.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("enabled").executes(context -> CommandDatapack.c((CommandListenerWrapper)context.getSource()))))));
    }

    private static int a(CommandListenerWrapper source, ResourcePackLoader pack, a priorityCallback) throws CommandSyntaxException {
        ResourcePackRepository packRepository = source.l().aF();
        ArrayList list = Lists.newArrayList(packRepository.g());
        priorityCallback.apply(list, pack);
        source.a(() -> IChatBaseComponent.a("commands.datapack.modify.enable", pack.a(true)), true);
        CommandReload.a(list.stream().map(ResourcePackLoader::g).collect(Collectors.toList()), source);
        return list.size();
    }

    private static int a(CommandListenerWrapper source, ResourcePackLoader pack) {
        ResourcePackRepository packRepository = source.l().aF();
        ArrayList list = Lists.newArrayList(packRepository.g());
        list.remove(pack);
        source.a(() -> IChatBaseComponent.a("commands.datapack.modify.disable", pack.a(true)), true);
        CommandReload.a(list.stream().map(ResourcePackLoader::g).collect(Collectors.toList()), source);
        return list.size();
    }

    private static int a(CommandListenerWrapper source) {
        return CommandDatapack.c(source) + CommandDatapack.b(source);
    }

    private static int b(CommandListenerWrapper source) {
        ResourcePackRepository packRepository = source.l().aF();
        packRepository.a();
        Collection<ResourcePackLoader> selectedPacks = packRepository.g();
        Collection<ResourcePackLoader> availablePacks = packRepository.d();
        FeatureFlagSet featureFlagSet = source.v();
        List<ResourcePackLoader> list = availablePacks.stream().filter(pack -> !selectedPacks.contains(pack) && pack.e().a(featureFlagSet)).toList();
        if (list.isEmpty()) {
            source.a(() -> IChatBaseComponent.c("commands.datapack.list.available.none"), false);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.datapack.list.available.success", list.size(), ChatComponentUtils.b(list, (T pack) -> pack.a(false))), false);
        }
        return list.size();
    }

    private static int c(CommandListenerWrapper source) {
        ResourcePackRepository packRepository = source.l().aF();
        packRepository.a();
        Collection<ResourcePackLoader> selectedPacks = packRepository.g();
        if (selectedPacks.isEmpty()) {
            source.a(() -> IChatBaseComponent.c("commands.datapack.list.enabled.none"), false);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.datapack.list.enabled.success", selectedPacks.size(), ChatComponentUtils.b(selectedPacks, (T pack) -> pack.a(true))), false);
        }
        return selectedPacks.size();
    }

    private static ResourcePackLoader a(CommandContext<CommandListenerWrapper> context, String name, boolean enabling) throws CommandSyntaxException {
        String string = StringArgumentType.getString(context, (String)name);
        ResourcePackRepository packRepository = ((CommandListenerWrapper)context.getSource()).l().aF();
        ResourcePackLoader pack = packRepository.c(string);
        if (pack == null) {
            throw a.create((Object)string);
        }
        boolean flag = packRepository.g().contains(pack);
        if (enabling && flag) {
            throw b.create((Object)string);
        }
        if (!enabling && !flag) {
            throw c.create((Object)string);
        }
        FeatureFlagSet featureFlagSet = ((CommandListenerWrapper)context.getSource()).v();
        FeatureFlagSet requestedFeatures = pack.e();
        if (!enabling && !requestedFeatures.b() && pack.l() == PackSource.d) {
            throw d.create((Object)string);
        }
        if (!requestedFeatures.a(featureFlagSet)) {
            throw e.create((Object)string, (Object)FeatureFlags.a(featureFlagSet, requestedFeatures));
        }
        return pack;
    }

    static interface a {
        public void apply(List<ResourcePackLoader> var1, ResourcePackLoader var2) throws CommandSyntaxException;
    }
}

