/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.InCommandFunction;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;

public class CommandFill {
    private static final Dynamic2CommandExceptionType a = new Dynamic2CommandExceptionType((maxBlocks, specifiedBlocks) -> IChatBaseComponent.b("commands.fill.toobig", maxBlocks, specifiedBlocks));
    static final ArgumentTileLocation b = new ArgumentTileLocation(Blocks.a.m(), Collections.emptySet(), null);
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.fill.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("fill").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("from", ArgumentPosition.a()).then(net.minecraft.commands.CommandDispatcher.a("to", ArgumentPosition.a()).then(((ArgumentBuilder)CommandFill.a(buildContext, net.minecraft.commands.CommandDispatcher.a("block", ArgumentTile.a(buildContext)), (CommandContext<CommandListenerWrapper> context) -> ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "from"), (CommandContext<CommandListenerWrapper> context) -> ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "to"), (CommandContext<CommandListenerWrapper> context) -> ArgumentTile.a((CommandContext<CommandListenerWrapper>)context, "block"), context -> null).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("replace").executes(context -> CommandFill.a((CommandListenerWrapper)context.getSource(), StructureBoundingBox.a(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "from"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "to")), ArgumentTile.a((CommandContext<CommandListenerWrapper>)context, "block"), Mode.a, null, false))).then(CommandFill.a(buildContext, net.minecraft.commands.CommandDispatcher.a("filter", ArgumentBlockPredicate.a(buildContext)), (CommandContext<CommandListenerWrapper> context) -> ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "from"), (CommandContext<CommandListenerWrapper> context) -> ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "to"), (CommandContext<CommandListenerWrapper> context) -> ArgumentTile.a((CommandContext<CommandListenerWrapper>)context, "block"), context -> ArgumentBlockPredicate.a((CommandContext<CommandListenerWrapper>)context, "filter"))))).then(net.minecraft.commands.CommandDispatcher.a("keep").executes(context -> CommandFill.a((CommandListenerWrapper)context.getSource(), StructureBoundingBox.a(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "from"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "to")), ArgumentTile.a((CommandContext<CommandListenerWrapper>)context, "block"), Mode.a, (ShapeDetectorBlock block) -> block.c().v(block.d()), false))))))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandBuildContext buildContext, ArgumentBuilder<CommandListenerWrapper, ?> argumentBuilder, InCommandFunction<CommandContext<CommandListenerWrapper>, BlockPosition> from, InCommandFunction<CommandContext<CommandListenerWrapper>, BlockPosition> to, InCommandFunction<CommandContext<CommandListenerWrapper>, ArgumentTileLocation> block, d<CommandContext<CommandListenerWrapper>, Predicate<ShapeDetectorBlock>> filter) {
        return ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)argumentBuilder.executes((Command<CommandListenerWrapper>)((Command)context -> CommandFill.a((CommandListenerWrapper)context.getSource(), StructureBoundingBox.a((BaseBlockPosition)from.apply(context), (BaseBlockPosition)to.apply(context)), (ArgumentTileLocation)block.apply(context), Mode.a, (Predicate)filter.apply(context), false)))).then(net.minecraft.commands.CommandDispatcher.a("outline").executes(context -> CommandFill.a((CommandListenerWrapper)context.getSource(), StructureBoundingBox.a((BaseBlockPosition)from.apply(context), (BaseBlockPosition)to.apply(context)), (ArgumentTileLocation)block.apply(context), Mode.b, (Predicate)filter.apply(context), false)))).then(net.minecraft.commands.CommandDispatcher.a("hollow").executes(context -> CommandFill.a((CommandListenerWrapper)context.getSource(), StructureBoundingBox.a((BaseBlockPosition)from.apply(context), (BaseBlockPosition)to.apply(context)), (ArgumentTileLocation)block.apply(context), Mode.c, (Predicate)filter.apply(context), false)))).then(net.minecraft.commands.CommandDispatcher.a("destroy").executes(context -> CommandFill.a((CommandListenerWrapper)context.getSource(), StructureBoundingBox.a((BaseBlockPosition)from.apply(context), (BaseBlockPosition)to.apply(context)), (ArgumentTileLocation)block.apply(context), Mode.d, (Predicate)filter.apply(context), false)))).then(net.minecraft.commands.CommandDispatcher.a("strict").executes(context -> CommandFill.a((CommandListenerWrapper)context.getSource(), StructureBoundingBox.a((BaseBlockPosition)from.apply(context), (BaseBlockPosition)to.apply(context)), (ArgumentTileLocation)block.apply(context), Mode.a, (Predicate)filter.apply(context), true)));
    }

    private static int a(CommandListenerWrapper source, StructureBoundingBox box, ArgumentTileLocation block, Mode mode, @Nullable Predicate<ShapeDetectorBlock> filter, boolean strict) throws CommandSyntaxException {
        int _int;
        int i2 = box.d() * box.e() * box.f();
        if (i2 > (_int = source.e().O().d(GameRules.B))) {
            throw a.create((Object)_int, (Object)i2);
        }
        ArrayList list = Lists.newArrayList();
        WorldServer level = source.e();
        if (level.ak()) {
            throw c.create();
        }
        int i1 = 0;
        for (BlockPosition blockPos : BlockPosition.b(box.h(), box.i(), box.j(), box.k(), box.l(), box.m())) {
            ArgumentTileLocation blockInput;
            if (filter != null && !filter.test(new ShapeDetectorBlock(level, blockPos, true))) continue;
            boolean flag = false;
            if (mode.f.affect(level, blockPos)) {
                flag = true;
            }
            if ((blockInput = mode.e.filter(box, blockPos, block, level)) == null) {
                if (!flag) continue;
                ++i1;
                continue;
            }
            if (!blockInput.a(level, blockPos, 2 | (strict ? 816 : 256))) {
                if (!flag) continue;
                ++i1;
                continue;
            }
            if (!strict) {
                list.add(blockPos.j());
            }
            ++i1;
        }
        for (BlockPosition blockPosx : list) {
            Block block1 = level.a_(blockPosx).b();
            level.a(blockPosx, block1);
        }
        if (i1 == 0) {
            throw c.create();
        }
        int i22 = i1;
        source.a(() -> IChatBaseComponent.a("commands.fill.success", i22), true);
        return i1;
    }

    @FunctionalInterface
    static interface d<T, R> {
        @Nullable
        public R apply(T var1) throws CommandSyntaxException;
    }

    static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode a = new Mode(net.minecraft.server.commands.CommandFill$a.a, net.minecraft.server.commands.CommandFill$b.a);
        public static final /* enum */ Mode b = new Mode(net.minecraft.server.commands.CommandFill$a.a, (area, blockPos, newBlock, level) -> blockPos.u() != area.h() && blockPos.u() != area.k() && blockPos.v() != area.i() && blockPos.v() != area.l() && blockPos.w() != area.j() && blockPos.w() != area.m() ? null : newBlock);
        public static final /* enum */ Mode c = new Mode(net.minecraft.server.commands.CommandFill$a.a, (area, blockPos, newBlock, level) -> blockPos.u() != area.h() && blockPos.u() != area.k() && blockPos.v() != area.i() && blockPos.v() != area.l() && blockPos.w() != area.j() && blockPos.w() != area.m() ? b : newBlock);
        public static final /* enum */ Mode d = new Mode((level, pos) -> level.b(pos, true), net.minecraft.server.commands.CommandFill$b.a);
        public final b e;
        public final a f;
        private static final /* synthetic */ Mode[] g;

        public static Mode[] values() {
            return (Mode[])g.clone();
        }

        public static Mode valueOf(String name) {
            return Enum.valueOf(Mode.class, name);
        }

        private Mode(a affector, b filter) {
            this.f = affector;
            this.e = filter;
        }

        private static /* synthetic */ Mode[] a() {
            return new Mode[]{a, b, c, d};
        }

        static {
            g = Mode.a();
        }
    }

    @FunctionalInterface
    public static interface a {
        public static final a a = (level, pos) -> false;

        public boolean affect(WorldServer var1, BlockPosition var2);
    }

    @FunctionalInterface
    public static interface b {
        public static final b a = (box, pos, block, level) -> block;

        @Nullable
        public ArgumentTileLocation filter(StructureBoundingBox var1, BlockPosition var2, ArgumentTileLocation var3, WorldServer var4);
    }
}

