/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.base.Joiner;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2I;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.BlockPosition2D;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;

public class CommandForceload {
    private static final int a = 256;
    private static final Dynamic2CommandExceptionType b = new Dynamic2CommandExceptionType((maxChunks, specifiedChunks) -> IChatBaseComponent.b("commands.forceload.toobig", maxChunks, specifiedChunks));
    private static final Dynamic2CommandExceptionType c = new Dynamic2CommandExceptionType((chunkPos, level) -> IChatBaseComponent.b("commands.forceload.query.failure", chunkPos, level));
    private static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.forceload.added.failure"));
    private static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.forceload.removed.failure"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("forceload").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("add").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("from", ArgumentVec2I.a()).executes(context -> CommandForceload.a((CommandListenerWrapper)context.getSource(), ArgumentVec2I.a((CommandContext<CommandListenerWrapper>)context, "from"), ArgumentVec2I.a((CommandContext<CommandListenerWrapper>)context, "from"), true))).then(net.minecraft.commands.CommandDispatcher.a("to", ArgumentVec2I.a()).executes(context -> CommandForceload.a((CommandListenerWrapper)context.getSource(), ArgumentVec2I.a((CommandContext<CommandListenerWrapper>)context, "from"), ArgumentVec2I.a((CommandContext<CommandListenerWrapper>)context, "to"), true)))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("remove").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("from", ArgumentVec2I.a()).executes(context -> CommandForceload.a((CommandListenerWrapper)context.getSource(), ArgumentVec2I.a((CommandContext<CommandListenerWrapper>)context, "from"), ArgumentVec2I.a((CommandContext<CommandListenerWrapper>)context, "from"), false))).then(net.minecraft.commands.CommandDispatcher.a("to", ArgumentVec2I.a()).executes(context -> CommandForceload.a((CommandListenerWrapper)context.getSource(), ArgumentVec2I.a((CommandContext<CommandListenerWrapper>)context, "from"), ArgumentVec2I.a((CommandContext<CommandListenerWrapper>)context, "to"), false))))).then(net.minecraft.commands.CommandDispatcher.a("all").executes(context -> CommandForceload.b((CommandListenerWrapper)context.getSource()))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("query").executes(context -> CommandForceload.a((CommandListenerWrapper)context.getSource()))).then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentVec2I.a()).executes(context -> CommandForceload.a((CommandListenerWrapper)context.getSource(), ArgumentVec2I.a((CommandContext<CommandListenerWrapper>)context, "pos")))))));
    }

    private static int a(CommandListenerWrapper source, BlockPosition2D pos) throws CommandSyntaxException {
        ChunkCoordIntPair chunkPos = pos.a();
        WorldServer level = source.e();
        ResourceKey<World> resourceKey = level.aj();
        boolean flag = level.y().contains(chunkPos.a());
        if (flag) {
            source.a(() -> IChatBaseComponent.a("commands.forceload.query.success", IChatBaseComponent.a(chunkPos), IChatBaseComponent.a(resourceKey.a())), false);
            return 1;
        }
        throw c.create((Object)chunkPos, (Object)resourceKey.a());
    }

    private static int a(CommandListenerWrapper source) {
        WorldServer level = source.e();
        ResourceKey<World> resourceKey = level.aj();
        LongSet forceLoadedChunks = level.y();
        int size = forceLoadedChunks.size();
        if (size > 0) {
            String string = Joiner.on((String)", ").join(forceLoadedChunks.stream().sorted().map(ChunkCoordIntPair::new).map(ChunkCoordIntPair::toString).iterator());
            if (size == 1) {
                source.a(() -> IChatBaseComponent.a("commands.forceload.list.single", IChatBaseComponent.a(resourceKey.a()), string), false);
            } else {
                source.a(() -> IChatBaseComponent.a("commands.forceload.list.multiple", size, IChatBaseComponent.a(resourceKey.a()), string), false);
            }
        } else {
            source.b(IChatBaseComponent.a("commands.forceload.added.none", IChatBaseComponent.a(resourceKey.a())));
        }
        return size;
    }

    private static int b(CommandListenerWrapper source) {
        WorldServer level = source.e();
        ResourceKey<World> resourceKey = level.aj();
        LongSet forceLoadedChunks = level.y();
        forceLoadedChunks.forEach(packedChunkPos -> level.a(ChunkCoordIntPair.a(packedChunkPos), ChunkCoordIntPair.b(packedChunkPos), false));
        source.a(() -> IChatBaseComponent.a("commands.forceload.removed.all", IChatBaseComponent.a(resourceKey.a())), true);
        return 0;
    }

    private static int a(CommandListenerWrapper source, BlockPosition2D from, BlockPosition2D to, boolean add) throws CommandSyntaxException {
        int min = Math.min(from.c(), to.c());
        int min1 = Math.min(from.d(), to.d());
        int max = Math.max(from.c(), to.c());
        int max1 = Math.max(from.d(), to.d());
        if (min >= -30000000 && min1 >= -30000000 && max < 30000000 && max1 < 30000000) {
            int sectionPosCoord3;
            int sectionPosCoord = SectionPosition.a(min);
            int sectionPosCoord1 = SectionPosition.a(min1);
            int sectionPosCoord2 = SectionPosition.a(max);
            long l2 = ((long)(sectionPosCoord2 - sectionPosCoord) + 1L) * ((long)((sectionPosCoord3 = SectionPosition.a(max1)) - sectionPosCoord1) + 1L);
            if (l2 > 256L) {
                throw b.create((Object)256, (Object)l2);
            }
            WorldServer level = source.e();
            ResourceKey<World> resourceKey = level.aj();
            ChunkCoordIntPair chunkPos = null;
            int i2 = 0;
            for (int i1 = sectionPosCoord; i1 <= sectionPosCoord2; ++i1) {
                for (int i22 = sectionPosCoord1; i22 <= sectionPosCoord3; ++i22) {
                    boolean flag = level.a(i1, i22, add);
                    if (!flag) continue;
                    ++i2;
                    if (chunkPos != null) continue;
                    chunkPos = new ChunkCoordIntPair(i1, i22);
                }
            }
            ChunkCoordIntPair chunkPos1 = chunkPos;
            int i2x = i2;
            if (i2x == 0) {
                throw (add ? d : e).create();
            }
            if (i2x == 1) {
                source.a(() -> IChatBaseComponent.a("commands.forceload." + (add ? "added" : "removed") + ".single", IChatBaseComponent.a(chunkPos1), IChatBaseComponent.a(resourceKey.a())), true);
            } else {
                ChunkCoordIntPair chunkPos2 = new ChunkCoordIntPair(sectionPosCoord, sectionPosCoord1);
                ChunkCoordIntPair chunkPos3 = new ChunkCoordIntPair(sectionPosCoord2, sectionPosCoord3);
                source.a(() -> IChatBaseComponent.a("commands.forceload." + (add ? "added" : "removed") + ".multiple", i2x, IChatBaseComponent.a(resourceKey.a()), IChatBaseComponent.a(chunkPos2), IChatBaseComponent.a(chunkPos3)), true);
            }
            return i2x;
        }
        throw ArgumentPosition.b.create();
    }
}

