/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.time.Duration;
import java.util.Optional;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.slf4j.Logger;

public class CommandLocate {
    private static final Logger a = LogUtils.getLogger();
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(structureType -> IChatBaseComponent.b("commands.locate.structure.not_found", structureType));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(structureType -> IChatBaseComponent.b("commands.locate.structure.invalid", structureType));
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(biomeType -> IChatBaseComponent.b("commands.locate.biome.not_found", biomeType));
    private static final DynamicCommandExceptionType e = new DynamicCommandExceptionType(biomeType -> IChatBaseComponent.b("commands.locate.poi.not_found", biomeType));
    private static final int f = 100;
    private static final int g = 6400;
    private static final int h = 32;
    private static final int i = 64;
    private static final int j = 256;

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("locate").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("structure").then(net.minecraft.commands.CommandDispatcher.a("structure", ResourceOrTagKeyArgument.a(Registries.be)).executes(context1 -> CommandLocate.a((CommandListenerWrapper)context1.getSource(), ResourceOrTagKeyArgument.a((CommandContext<CommandListenerWrapper>)context1, "structure", Registries.be, c)))))).then(net.minecraft.commands.CommandDispatcher.a("biome").then(net.minecraft.commands.CommandDispatcher.a("biome", ResourceOrTagArgument.a(context, Registries.aG)).executes(context1 -> CommandLocate.a((CommandListenerWrapper)context1.getSource(), ResourceOrTagArgument.a((CommandContext<CommandListenerWrapper>)context1, "biome", Registries.aG)))))).then(net.minecraft.commands.CommandDispatcher.a("poi").then(net.minecraft.commands.CommandDispatcher.a("poi", ResourceOrTagArgument.a(context, Registries.aa)).executes(context1 -> CommandLocate.b((CommandListenerWrapper)context1.getSource(), ResourceOrTagArgument.a((CommandContext<CommandListenerWrapper>)context1, "poi", Registries.aa)))))));
    }

    private static Optional<? extends HolderSet.b<Structure>> a(ResourceOrTagKeyArgument.c<Structure> structure, IRegistry<Structure> structureRegistry) {
        return structure.a().map(structureKey -> structureRegistry.a((ResourceKey)structureKey).map(structureHolder -> HolderSet.a(structureHolder)), structureRegistry::a);
    }

    private static int a(CommandListenerWrapper source, ResourceOrTagKeyArgument.c<Structure> structure) throws CommandSyntaxException {
        IRegistry<Structure> registry = source.e().J_().f(Registries.be);
        HolderSet holderSet = CommandLocate.a(structure, registry).orElseThrow(() -> c.create((Object)structure.b()));
        BlockPosition blockPos = BlockPosition.a(source.d());
        WorldServer level = source.e();
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)SystemUtils.d);
        Pair<BlockPosition, Holder<Structure>> pair = level.m().g().a(level, holderSet, blockPos, 100, false);
        stopwatch.stop();
        if (pair == null) {
            throw b.create((Object)structure.b());
        }
        return CommandLocate.a(source, structure, blockPos, pair, "commands.locate.structure.success", false, stopwatch.elapsed());
    }

    private static int a(CommandListenerWrapper source, ResourceOrTagArgument.c<BiomeBase> biome) throws CommandSyntaxException {
        BlockPosition blockPos = BlockPosition.a(source.d());
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)SystemUtils.d);
        Pair<BlockPosition, Holder<BiomeBase>> pair = source.e().a(biome, blockPos, 6400, 32, 64);
        stopwatch.stop();
        if (pair == null) {
            throw d.create((Object)biome.b());
        }
        return CommandLocate.a(source, biome, blockPos, pair, "commands.locate.biome.success", true, stopwatch.elapsed());
    }

    private static int b(CommandListenerWrapper source, ResourceOrTagArgument.c<VillagePlaceType> poiType) throws CommandSyntaxException {
        BlockPosition blockPos = BlockPosition.a(source.d());
        WorldServer level = source.e();
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)SystemUtils.d);
        Optional<Pair<Holder<VillagePlaceType>, BlockPosition>> optional = level.A().e(poiType, blockPos, 256, VillagePlace.Occupancy.c);
        stopwatch.stop();
        if (optional.isEmpty()) {
            throw e.create((Object)poiType.b());
        }
        return CommandLocate.a(source, poiType, blockPos, optional.get().swap(), "commands.locate.poi.success", false, stopwatch.elapsed());
    }

    public static int a(CommandListenerWrapper source, ResourceOrTagArgument.c<?> result, BlockPosition sourcePosition, Pair<BlockPosition, ? extends Holder<?>> resultWithPosition, String translationKey, boolean absoluteY, Duration duration) {
        String string = result.a().map(reference -> result.b(), named -> result.b() + " (" + ((Holder)resultWithPosition.getSecond()).g() + ")");
        return CommandLocate.a(source, sourcePosition, resultWithPosition, translationKey, absoluteY, string, duration);
    }

    public static int a(CommandListenerWrapper source, ResourceOrTagKeyArgument.c<?> result, BlockPosition sourcePosition, Pair<BlockPosition, ? extends Holder<?>> resultWithPosition, String translationKey, boolean absoluteY, Duration duration) {
        String string = result.a().map(resourceKey -> resourceKey.a().toString(), tagKey -> "#" + String.valueOf(tagKey.b()) + " (" + ((Holder)resultWithPosition.getSecond()).g() + ")");
        return CommandLocate.a(source, sourcePosition, resultWithPosition, translationKey, absoluteY, string, duration);
    }

    private static int a(CommandListenerWrapper source, BlockPosition sourcePosition, Pair<BlockPosition, ? extends Holder<?>> resultWithoutPosition, String translationKey, boolean absoluteY, String elementName, Duration duration) {
        BlockPosition blockPos = (BlockPosition)resultWithoutPosition.getFirst();
        int i2 = absoluteY ? MathHelper.d(MathHelper.c((float)sourcePosition.j(blockPos))) : MathHelper.d(CommandLocate.a(sourcePosition.u(), sourcePosition.w(), blockPos.u(), blockPos.w()));
        String string = absoluteY ? String.valueOf(blockPos.v()) : "~";
        IChatMutableComponent component = ChatComponentUtils.a(IChatBaseComponent.a("chat.coordinates", blockPos.u(), string, blockPos.w())).a(style -> style.a(EnumChatFormat.k).a(new ChatClickable.SuggestCommand("/tp @s " + blockPos.u() + " " + string + " " + blockPos.w())).a(new ChatHoverable.e(IChatBaseComponent.c("chat.coordinates.tooltip"))));
        source.a(() -> IChatBaseComponent.a(translationKey, new Object[]{elementName, component, i2}), false);
        a.info("Locating element " + elementName + " took " + duration.toMillis() + " ms");
        return i2;
    }

    private static float a(int x1, int z1, int x2, int z2) {
        int i2 = x2 - x1;
        int i1 = z2 - z1;
        return (float)Math.hypot(i2, i1);
    }
}

