/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.phys.Vec3D;

public class CommandPlaySound {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.playsound.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        RequiredArgumentBuilder requiredArgumentBuilder = (RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sound", ArgumentMinecraftKeyRegistered.a()).suggests(CompletionProviders.b).executes(commandContext -> CommandPlaySound.a((CommandListenerWrapper)commandContext.getSource(), CommandPlaySound.a(((CommandListenerWrapper)commandContext.getSource()).i()), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)commandContext, "sound"), SoundCategory.a, ((CommandListenerWrapper)commandContext.getSource()).d(), 1.0f, 1.0f, 0.0f));
        for (SoundCategory soundSource : SoundCategory.values()) {
            requiredArgumentBuilder.then(CommandPlaySound.a(soundSource));
        }
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("playsound").requires(commandSourceStack -> commandSourceStack.c(2))).then((ArgumentBuilder)requiredArgumentBuilder)));
    }

    private static LiteralArgumentBuilder<CommandListenerWrapper> a(SoundCategory category) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a(category.a()).executes(context -> CommandPlaySound.a((CommandListenerWrapper)context.getSource(), CommandPlaySound.a(((CommandListenerWrapper)context.getSource()).i()), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "sound"), category, ((CommandListenerWrapper)context.getSource()).d(), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.d()).executes(context -> CommandPlaySound.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "sound"), category, ((CommandListenerWrapper)context.getSource()).d(), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos", ArgumentVec3.a()).executes(context -> CommandPlaySound.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "sound"), category, ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context, "pos"), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("volume", FloatArgumentType.floatArg((float)0.0f)).executes(context -> CommandPlaySound.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "sound"), category, ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context, "pos"), ((Float)context.getArgument("volume", Float.class)).floatValue(), 1.0f, 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pitch", FloatArgumentType.floatArg((float)0.0f, (float)2.0f)).executes(commandContext -> CommandPlaySound.a((CommandListenerWrapper)commandContext.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)commandContext, "targets"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)commandContext, "sound"), category, ArgumentVec3.a((CommandContext<CommandListenerWrapper>)commandContext, "pos"), ((Float)commandContext.getArgument("volume", Float.class)).floatValue(), ((Float)commandContext.getArgument("pitch", Float.class)).floatValue(), 0.0f))).then(net.minecraft.commands.CommandDispatcher.a("minVolume", FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(commandContext -> CommandPlaySound.a((CommandListenerWrapper)commandContext.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)commandContext, "targets"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)commandContext, "sound"), category, ArgumentVec3.a((CommandContext<CommandListenerWrapper>)commandContext, "pos"), ((Float)commandContext.getArgument("volume", Float.class)).floatValue(), ((Float)commandContext.getArgument("pitch", Float.class)).floatValue(), ((Float)commandContext.getArgument("minVolume", Float.class)).floatValue())))))));
    }

    private static Collection<EntityPlayer> a(@Nullable EntityPlayer player) {
        return player != null ? List.of(player) : List.of();
    }

    private static int a(CommandListenerWrapper source, Collection<EntityPlayer> targets, MinecraftKey sound, SoundCategory category, Vec3D pos, float volume, float pitch, float minVolume) throws CommandSyntaxException {
        Holder<SoundEffect> holder = Holder.a(SoundEffect.a(sound));
        double d2 = MathHelper.l(holder.a().a(volume));
        int i2 = 0;
        long randomLong = source.e().G_().g();
        for (EntityPlayer serverPlayer : targets) {
            double d1 = pos.d - serverPlayer.dA();
            double d22 = pos.e - serverPlayer.dC();
            double d3 = pos.f - serverPlayer.dG();
            double d4 = d1 * d1 + d22 * d22 + d3 * d3;
            Vec3D vec3 = pos;
            float f2 = volume;
            if (d4 > d2) {
                if (minVolume <= 0.0f) continue;
                double squareRoot = Math.sqrt(d4);
                vec3 = new Vec3D(serverPlayer.dA() + d1 / squareRoot * 2.0, serverPlayer.dC() + d22 / squareRoot * 2.0, serverPlayer.dG() + d3 / squareRoot * 2.0);
                f2 = minVolume;
            }
            serverPlayer.f.b(new PacketPlayOutNamedSoundEffect(holder, category, vec3.a(), vec3.b(), vec3.c(), f2, pitch, randomLong));
            ++i2;
        }
        if (i2 == 0) {
            throw a.create();
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.playsound.success.single", IChatBaseComponent.a(sound), ((EntityPlayer)targets.iterator().next()).P_()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.playsound.success.multiple", IChatBaseComponent.a(sound), targets.size()), true);
        }
        return i2;
    }
}

