/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentNBTTag;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class CommandSummon {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.summon.failed"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.summon.failed.uuid"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.summon.invalidPosition"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("summon").requires(source -> source.c(2))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("entity", ResourceArgument.a(context, Registries.B)).suggests(CompletionProviders.c).executes(context1 -> CommandSummon.b((CommandListenerWrapper)context1.getSource(), ResourceArgument.e((CommandContext<CommandListenerWrapper>)context1, "entity"), ((CommandListenerWrapper)context1.getSource()).d(), new NBTTagCompound(), true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos", ArgumentVec3.a()).executes(context1 -> CommandSummon.b((CommandListenerWrapper)context1.getSource(), ResourceArgument.e((CommandContext<CommandListenerWrapper>)context1, "entity"), ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context1, "pos"), new NBTTagCompound(), true))).then(net.minecraft.commands.CommandDispatcher.a("nbt", ArgumentNBTTag.a()).executes(context1 -> CommandSummon.b((CommandListenerWrapper)context1.getSource(), ResourceArgument.e((CommandContext<CommandListenerWrapper>)context1, "entity"), ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context1, "pos"), ArgumentNBTTag.a(context1, "nbt"), false)))))));
    }

    public static Entity a(CommandListenerWrapper source, Holder.c<EntityTypes<?>> type, Vec3D pos, NBTTagCompound tag, boolean randomizeProperties) throws CommandSyntaxException {
        BlockPosition blockPos = BlockPosition.a(pos);
        if (!World.l(blockPos)) {
            throw c.create();
        }
        NBTTagCompound compoundTag = tag.l();
        compoundTag.a("id", type.h().a().toString());
        WorldServer level = source.e();
        Entity entity = EntityTypes.a(compoundTag, (World)level, EntitySpawnReason.n, entity1 -> {
            entity1.b(pos.d, pos.e, pos.f, entity1.dL(), entity1.dN());
            entity1.spawnReason = CreatureSpawnEvent.SpawnReason.COMMAND;
            return entity1;
        });
        if (entity == null) {
            throw a.create();
        }
        if (randomizeProperties && entity instanceof EntityInsentient) {
            ((EntityInsentient)entity).a((WorldAccess)source.e(), source.e().d_(entity.dv()), EntitySpawnReason.n, null);
        }
        if (!level.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.COMMAND)) {
            throw b.create();
        }
        return entity;
    }

    private static int b(CommandListenerWrapper source, Holder.c<EntityTypes<?>> type, Vec3D pos, NBTTagCompound tag, boolean randomizeProperties) throws CommandSyntaxException {
        Entity entity = CommandSummon.a(source, type, pos, tag, randomizeProperties);
        source.a(() -> IChatBaseComponent.a("commands.summon.success", entity.P_()), true);
        return 1;
    }
}

