/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.LookAt;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class CommandTeleport {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.teleport.invalidPosition"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        LiteralCommandNode<CommandListenerWrapper> literalCommandNode = dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("teleport").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("location", ArgumentVec3.a()).executes(context -> CommandTeleport.a((CommandListenerWrapper)context.getSource(), Collections.singleton(((CommandListenerWrapper)context.getSource()).g()), ((CommandListenerWrapper)context.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)context, "location"), null, null)))).then(net.minecraft.commands.CommandDispatcher.a("destination", ArgumentEntity.a()).executes(context -> CommandTeleport.a((CommandListenerWrapper)context.getSource(), Collections.singleton(((CommandListenerWrapper)context.getSource()).g()), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "destination"))))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("location", ArgumentVec3.a()).executes(context -> CommandTeleport.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ((CommandListenerWrapper)context.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)context, "location"), null, null))).then(net.minecraft.commands.CommandDispatcher.a("rotation", ArgumentRotation.a()).executes(context -> CommandTeleport.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ((CommandListenerWrapper)context.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)context, "location"), ArgumentRotation.a((CommandContext<CommandListenerWrapper>)context, "rotation"), null)))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("facing").then(net.minecraft.commands.CommandDispatcher.a("entity").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("facingEntity", ArgumentEntity.a()).executes(context -> CommandTeleport.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ((CommandListenerWrapper)context.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)context, "location"), null, new LookAt.a(ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "facingEntity"), ArgumentAnchor.Anchor.a)))).then(net.minecraft.commands.CommandDispatcher.a("facingAnchor", ArgumentAnchor.a()).executes(context -> CommandTeleport.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ((CommandListenerWrapper)context.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)context, "location"), null, new LookAt.a(ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "facingEntity"), ArgumentAnchor.a((CommandContext<CommandListenerWrapper>)context, "facingAnchor")))))))).then(net.minecraft.commands.CommandDispatcher.a("facingLocation", ArgumentVec3.a()).executes(context -> CommandTeleport.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ((CommandListenerWrapper)context.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)context, "location"), null, new LookAt.b(ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context, "facingLocation")))))))).then(net.minecraft.commands.CommandDispatcher.a("destination", ArgumentEntity.a()).executes(context -> CommandTeleport.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "destination")))))));
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("tp").requires(source -> source.c(2))).redirect(literalCommandNode)));
    }

    private static int a(CommandListenerWrapper source, Collection<? extends net.minecraft.world.entity.Entity> targets, net.minecraft.world.entity.Entity destination) throws CommandSyntaxException {
        for (net.minecraft.world.entity.Entity entity : targets) {
            CommandTeleport.a(source, entity, (WorldServer)destination.dV(), destination.dA(), destination.dC(), destination.dG(), EnumSet.noneOf(Relative.class), destination.dL(), destination.dN(), null);
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.teleport.success.entity.single", ((net.minecraft.world.entity.Entity)targets.iterator().next()).P_(), destination.P_()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.teleport.success.entity.multiple", targets.size(), destination.P_()), true);
        }
        return targets.size();
    }

    private static int a(CommandListenerWrapper source, Collection<? extends net.minecraft.world.entity.Entity> targets, WorldServer level, IVectorPosition position, @Nullable IVectorPosition rotation, @Nullable LookAt lookAt) throws CommandSyntaxException {
        Vec3D position1 = position.a(source);
        Vec2F vec2 = rotation == null ? null : rotation.b(source);
        for (net.minecraft.world.entity.Entity entity : targets) {
            Set<Relative> relatives = CommandTeleport.a(position, rotation, entity.dV().aj() == level.aj());
            if (vec2 == null) {
                CommandTeleport.a(source, entity, level, position1.d, position1.e, position1.f, relatives, entity.dL(), entity.dN(), lookAt);
                continue;
            }
            CommandTeleport.a(source, entity, level, position1.d, position1.e, position1.f, relatives, vec2.k, vec2.j, lookAt);
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.teleport.success.location.single", ((net.minecraft.world.entity.Entity)targets.iterator().next()).P_(), CommandTeleport.a(position1.d), CommandTeleport.a(position1.e), CommandTeleport.a(position1.f)), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.teleport.success.location.multiple", targets.size(), CommandTeleport.a(position1.d), CommandTeleport.a(position1.e), CommandTeleport.a(position1.f)), true);
        }
        return targets.size();
    }

    private static Set<Relative> a(IVectorPosition position, @Nullable IVectorPosition rotation, boolean absolute) {
        EnumSet<Relative> set = EnumSet.noneOf(Relative.class);
        if (position.a()) {
            set.add(Relative.f);
            if (absolute) {
                set.add(Relative.a);
            }
        }
        if (position.b()) {
            set.add(Relative.g);
            if (absolute) {
                set.add(Relative.b);
            }
        }
        if (position.c()) {
            set.add(Relative.h);
            if (absolute) {
                set.add(Relative.c);
            }
        }
        if (rotation == null || rotation.a()) {
            set.add(Relative.e);
        }
        if (rotation == null || rotation.b()) {
            set.add(Relative.d);
        }
        return set;
    }

    private static String a(double value) {
        return String.format(Locale.ROOT, "%f", value);
    }

    private static void a(CommandListenerWrapper source, net.minecraft.world.entity.Entity target, WorldServer level, double x2, double y2, double z2, Set<Relative> relatives, float yRot, float xRot, @Nullable LookAt lookAt) throws CommandSyntaxException {
        boolean result;
        BlockPosition blockPos = BlockPosition.a(x2, y2, z2);
        if (!World.l(blockPos)) {
            throw a.create();
        }
        double d2 = relatives.contains((Object)Relative.a) ? x2 - target.dA() : x2;
        double d1 = relatives.contains((Object)Relative.b) ? y2 - target.dC() : y2;
        double d22 = relatives.contains((Object)Relative.c) ? z2 - target.dG() : z2;
        float f2 = relatives.contains((Object)Relative.d) ? yRot - target.dL() : yRot;
        float f1 = relatives.contains((Object)Relative.e) ? xRot - target.dN() : xRot;
        float f22 = MathHelper.h(f2);
        float f3 = MathHelper.h(f1);
        if (target instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)target;
            result = player.teleportTo(level, d2, d1, d22, relatives, f22, f3, true, PlayerTeleportEvent.TeleportCause.COMMAND);
        } else {
            Location to = new Location((org.bukkit.World)level.getWorld(), d2, d1, d22, f22, f3);
            EntityTeleportEvent event = new EntityTeleportEvent((Entity)target.getBukkitEntity(), target.getBukkitEntity().getLocation(), to);
            level.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled() || event.getTo() == null) {
                return;
            }
            to = event.getTo();
            d2 = to.getX();
            d1 = to.getY();
            d22 = to.getZ();
            f22 = to.getYaw();
            f3 = to.getPitch();
            level = ((CraftWorld)to.getWorld()).getHandle();
            result = target.a(level, d2, d1, d22, relatives, f22, f3, true);
        }
        if (result) {
            EntityLiving livingEntity;
            if (lookAt != null) {
                lookAt.perform(source, target);
            }
            if (!(target instanceof EntityLiving) || !(livingEntity = (EntityLiving)target).fJ()) {
                target.i(target.dy().d(1.0, 0.0, 1.0));
                target.d(true);
            }
            if (target instanceof EntityCreature) {
                EntityCreature pathfinderMob = (EntityCreature)target;
                pathfinderMob.N().m();
            }
        }
    }
}

