/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import org.apache.commons.lang3.mutable.MutableInt;

public class FillBiomeCommand {
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.pos.unloaded"));
    private static final Dynamic2CommandExceptionType b = new Dynamic2CommandExceptionType((maxBlocks, specifiedBlocks) -> IChatBaseComponent.b("commands.fillbiome.toobig", maxBlocks, specifiedBlocks));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("fillbiome").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("from", ArgumentPosition.a()).then(net.minecraft.commands.CommandDispatcher.a("to", ArgumentPosition.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("biome", ResourceArgument.a(context, Registries.aG)).executes(context1 -> FillBiomeCommand.a((CommandListenerWrapper)context1.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "from"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "to"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context1, "biome", Registries.aG), (Holder<BiomeBase> biome) -> true))).then(net.minecraft.commands.CommandDispatcher.a("replace").then(net.minecraft.commands.CommandDispatcher.a("filter", ResourceOrTagArgument.a(context, Registries.aG)).executes(context1 -> FillBiomeCommand.a((CommandListenerWrapper)context1.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "from"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context1, "to"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context1, "biome", Registries.aG), ResourceOrTagArgument.a((CommandContext<CommandListenerWrapper>)context1, "filter", Registries.aG)::test)))))))));
    }

    private static int a(int value) {
        return QuartPos.c(QuartPos.a(value));
    }

    private static BlockPosition a(BlockPosition pos) {
        return new BlockPosition(FillBiomeCommand.a(pos.u()), FillBiomeCommand.a(pos.v()), FillBiomeCommand.a(pos.w()));
    }

    private static BiomeResolver a(MutableInt biomeEntries, IChunkAccess chunk, StructureBoundingBox targetRegion, Holder<BiomeBase> replacementBiome, Predicate<Holder<BiomeBase>> filter) {
        return (x2, y2, z2, sampler) -> {
            int blockPosX = QuartPos.c(x2);
            int blockPosY = QuartPos.c(y2);
            int blockPosZ = QuartPos.c(z2);
            Holder<BiomeBase> noiseBiome = chunk.getNoiseBiome(x2, y2, z2);
            if (targetRegion.d(blockPosX, blockPosY, blockPosZ) && filter.test(noiseBiome)) {
                biomeEntries.increment();
                return replacementBiome;
            }
            return noiseBiome;
        };
    }

    public static Either<Integer, CommandSyntaxException> a(WorldServer level, BlockPosition from, BlockPosition to, Holder<BiomeBase> biome) {
        return FillBiomeCommand.a(level, from, to, biome, biome1 -> true, message -> {});
    }

    public static Either<Integer, CommandSyntaxException> a(WorldServer level, BlockPosition from, BlockPosition to, Holder<BiomeBase> biome, Predicate<Holder<BiomeBase>> filter, Consumer<Supplier<IChatBaseComponent>> messageOutput) {
        int _int;
        BlockPosition blockPos1;
        BlockPosition blockPos = FillBiomeCommand.a(from);
        StructureBoundingBox boundingBox = StructureBoundingBox.a(blockPos, blockPos1 = FillBiomeCommand.a(to));
        int i2 = boundingBox.d() * boundingBox.e() * boundingBox.f();
        if (i2 > (_int = level.O().d(GameRules.B))) {
            return Either.right(b.create((Object)_int, (Object)i2));
        }
        ArrayList<IChunkAccess> list = new ArrayList<IChunkAccess>();
        for (int sectionPosMinZ = SectionPosition.a(boundingBox.j()); sectionPosMinZ <= SectionPosition.a(boundingBox.m()); ++sectionPosMinZ) {
            for (int sectionPosMinX = SectionPosition.a(boundingBox.h()); sectionPosMinX <= SectionPosition.a(boundingBox.k()); ++sectionPosMinX) {
                IChunkAccess chunk = level.a(sectionPosMinX, sectionPosMinZ, ChunkStatus.n, false);
                if (chunk == null) {
                    return Either.right(a.create());
                }
                list.add(chunk);
            }
        }
        MutableInt mutableInt = new MutableInt(0);
        for (IChunkAccess chunk : list) {
            chunk.a(FillBiomeCommand.a(mutableInt, chunk, boundingBox, biome, filter), level.m().i().b());
            chunk.i();
        }
        level.m().a.b(list);
        messageOutput.accept(() -> IChatBaseComponent.a("commands.fillbiome.success.count", mutableInt.getValue(), boundingBox.h(), boundingBox.i(), boundingBox.j(), boundingBox.k(), boundingBox.l(), boundingBox.m()));
        return Either.left(mutableInt.getValue());
    }

    private static int a(CommandListenerWrapper source, BlockPosition from, BlockPosition to, Holder.c<BiomeBase> biome, Predicate<Holder<BiomeBase>> filter) throws CommandSyntaxException {
        Either<Integer, CommandSyntaxException> either = FillBiomeCommand.a(source.e(), from, to, biome, filter, supplier -> source.a((Supplier<IChatBaseComponent>)supplier, true));
        Optional<CommandSyntaxException> optional = either.right();
        if (optional.isPresent()) {
            throw optional.get();
        }
        return either.left().get();
    }
}

