/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Optional;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.TemplateMirrorArgument;
import net.minecraft.commands.arguments.TemplateRotationArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.bukkit.event.world.AsyncStructureGenerateEvent;

public class PlaceCommand {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.place.feature.failed"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.place.jigsaw.failed"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.place.structure.failed"));
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(template -> IChatBaseComponent.b("commands.place.template.invalid", template));
    private static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.place.template.failed"));
    private static final SuggestionProvider<CommandListenerWrapper> f = (context, builder) -> {
        StructureTemplateManager structureManager = ((CommandListenerWrapper)context.getSource()).e().r();
        return ICompletionProvider.a(structureManager.a(), builder);
    };

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("place").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("feature").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("feature", ResourceKeyArgument.a(Registries.aL)).executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ResourceKeyArgument.a((CommandContext<CommandListenerWrapper>)context, "feature"), BlockPosition.a(((CommandListenerWrapper)context.getSource()).d())))).then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ResourceKeyArgument.a((CommandContext<CommandListenerWrapper>)context, "feature"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"))))))).then(net.minecraft.commands.CommandDispatcher.a("jigsaw").then(net.minecraft.commands.CommandDispatcher.a("pool", ResourceKeyArgument.a(Registries.bf)).then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentMinecraftKeyRegistered.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("max_depth", IntegerArgumentType.integer((int)1, (int)20)).executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ResourceKeyArgument.c((CommandContext<CommandListenerWrapper>)context, "pool"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"max_depth"), BlockPosition.a(((CommandListenerWrapper)context.getSource()).d())))).then(net.minecraft.commands.CommandDispatcher.a("position", ArgumentPosition.a()).executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ResourceKeyArgument.c((CommandContext<CommandListenerWrapper>)context, "pool"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"max_depth"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "position"))))))))).then(net.minecraft.commands.CommandDispatcher.a("structure").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("structure", ResourceKeyArgument.a(Registries.be)).executes(context -> PlaceCommand.b((CommandListenerWrapper)context.getSource(), ResourceKeyArgument.b((CommandContext<CommandListenerWrapper>)context, "structure"), BlockPosition.a(((CommandListenerWrapper)context.getSource()).d())))).then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).executes(context -> PlaceCommand.b((CommandListenerWrapper)context.getSource(), ResourceKeyArgument.b((CommandContext<CommandListenerWrapper>)context, "structure"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"))))))).then(net.minecraft.commands.CommandDispatcher.a("template").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("template", ArgumentMinecraftKeyRegistered.a()).suggests(f).executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "template"), BlockPosition.a(((CommandListenerWrapper)context.getSource()).d()), EnumBlockRotation.a, EnumBlockMirror.a, 1.0f, 0, false))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "template"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), EnumBlockRotation.a, EnumBlockMirror.a, 1.0f, 0, false))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("rotation", TemplateRotationArgument.a()).executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "template"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), TemplateRotationArgument.a((CommandContext<CommandListenerWrapper>)context, "rotation"), EnumBlockMirror.a, 1.0f, 0, false))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("mirror", TemplateMirrorArgument.a()).executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "template"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), TemplateRotationArgument.a((CommandContext<CommandListenerWrapper>)context, "rotation"), TemplateMirrorArgument.a((CommandContext<CommandListenerWrapper>)context, "mirror"), 1.0f, 0, false))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("integrity", FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "template"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), TemplateRotationArgument.a((CommandContext<CommandListenerWrapper>)context, "rotation"), TemplateMirrorArgument.a((CommandContext<CommandListenerWrapper>)context, "mirror"), FloatArgumentType.getFloat((CommandContext)context, (String)"integrity"), 0, false))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("seed", IntegerArgumentType.integer()).executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "template"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), TemplateRotationArgument.a((CommandContext<CommandListenerWrapper>)context, "rotation"), TemplateMirrorArgument.a((CommandContext<CommandListenerWrapper>)context, "mirror"), FloatArgumentType.getFloat((CommandContext)context, (String)"integrity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), false))).then(net.minecraft.commands.CommandDispatcher.a("strict").executes(context -> PlaceCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "template"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), TemplateRotationArgument.a((CommandContext<CommandListenerWrapper>)context, "rotation"), TemplateMirrorArgument.a((CommandContext<CommandListenerWrapper>)context, "mirror"), FloatArgumentType.getFloat((CommandContext)context, (String)"integrity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), true))))))))))));
    }

    public static int a(CommandListenerWrapper source, Holder.c<WorldGenFeatureConfigured<?, ?>> feature, BlockPosition pos) throws CommandSyntaxException {
        WorldServer level = source.e();
        WorldGenFeatureConfigured<?, ?> configuredFeature = feature.a();
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(pos);
        PlaceCommand.a(level, new ChunkCoordIntPair(chunkPos.h - 1, chunkPos.i - 1), new ChunkCoordIntPair(chunkPos.h + 1, chunkPos.i + 1));
        if (!configuredFeature.a(level, level.m().g(), level.G_(), pos)) {
            throw a.create();
        }
        String string = feature.h().a().toString();
        source.a(() -> IChatBaseComponent.a("commands.place.feature.success", new Object[]{string, pos.u(), pos.v(), pos.w()}), true);
        return 1;
    }

    public static int a(CommandListenerWrapper source, Holder<WorldGenFeatureDefinedStructurePoolTemplate> templatePool, MinecraftKey target, int maxDepth, BlockPosition pos) throws CommandSyntaxException {
        WorldServer level = source.e();
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(pos);
        PlaceCommand.a(level, chunkPos, chunkPos);
        if (!WorldGenFeatureDefinedStructureJigsawPlacement.a(level, templatePool, target, maxDepth, pos, false)) {
            throw b.create();
        }
        source.a(() -> IChatBaseComponent.a("commands.place.jigsaw.success", pos.u(), pos.v(), pos.w()), true);
        return 1;
    }

    public static int b(CommandListenerWrapper source, Holder.c<Structure> structure, BlockPosition pos) throws CommandSyntaxException {
        WorldServer level = source.e();
        Structure structure1 = structure.a();
        ChunkGenerator generator = level.m().g();
        StructureStart structureStart = structure1.a(structure, level.aj(), source.u(), generator, generator.d(), level.m().i(), level.r(), level.E(), new ChunkCoordIntPair(pos), 0, level, holder -> true);
        if (!structureStart.b()) {
            throw c.create();
        }
        structureStart.generationEventCause = AsyncStructureGenerateEvent.Cause.COMMAND;
        StructureBoundingBox boundingBox = structureStart.a();
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(SectionPosition.a(boundingBox.h()), SectionPosition.a(boundingBox.j()));
        ChunkCoordIntPair chunkPos1 = new ChunkCoordIntPair(SectionPosition.a(boundingBox.k()), SectionPosition.a(boundingBox.m()));
        PlaceCommand.a(level, chunkPos, chunkPos1);
        ChunkCoordIntPair.a(chunkPos, chunkPos1).forEach(chunkPos2 -> structureStart.a(level, level.b(), generator, level.G_(), new StructureBoundingBox(chunkPos2.d(), level.K_(), chunkPos2.e(), chunkPos2.f(), level.ao() + 1, chunkPos2.g()), (ChunkCoordIntPair)chunkPos2));
        String string = structure.h().a().toString();
        source.a(() -> IChatBaseComponent.a("commands.place.structure.success", new Object[]{string, pos.u(), pos.v(), pos.w()}), true);
        return 1;
    }

    public static int a(CommandListenerWrapper source, MinecraftKey template, BlockPosition pos, EnumBlockRotation rotation, EnumBlockMirror mirror, float integrity, int seed, boolean strict) throws CommandSyntaxException {
        boolean flag;
        Optional<DefinedStructure> optional;
        WorldServer level = source.e();
        StructureTemplateManager structureManager = level.r();
        try {
            optional = structureManager.b(template);
        }
        catch (ResourceKeyInvalidException var14) {
            throw d.create((Object)template);
        }
        if (optional.isEmpty()) {
            throw d.create((Object)template);
        }
        DefinedStructure structureTemplate = optional.get();
        PlaceCommand.a(level, new ChunkCoordIntPair(pos), new ChunkCoordIntPair(pos.a(structureTemplate.a())));
        DefinedStructureInfo structurePlaceSettings = new DefinedStructureInfo().a(mirror).a(rotation).b(strict);
        if (integrity < 1.0f) {
            structurePlaceSettings.b().a(new DefinedStructureProcessorRotation(integrity)).a(TileEntityStructure.b(seed));
        }
        if (!(flag = structureTemplate.a(level, pos, pos, structurePlaceSettings, TileEntityStructure.b(seed), 2 | (strict ? 816 : 0)))) {
            throw e.create();
        }
        source.a(() -> IChatBaseComponent.a("commands.place.template.success", IChatBaseComponent.a(template), pos.u(), pos.v(), pos.w()), true);
        return 1;
    }

    private static void a(WorldServer level, ChunkCoordIntPair start, ChunkCoordIntPair end) throws CommandSyntaxException {
        if (ChunkCoordIntPair.a(start, end).filter(chunkPos -> !level.p(chunkPos.l())).findAny().isPresent()) {
            throw ArgumentPosition.a.create();
        }
    }
}

