/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.Vec3D;

public class RaidCommand {
    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("raid").requires(source -> source.c(3))).then(net.minecraft.commands.CommandDispatcher.a("start").then(net.minecraft.commands.CommandDispatcher.a("omenlvl", IntegerArgumentType.integer((int)0)).executes(context1 -> RaidCommand.b((CommandListenerWrapper)context1.getSource(), IntegerArgumentType.getInteger((CommandContext)context1, (String)"omenlvl")))))).then(net.minecraft.commands.CommandDispatcher.a("stop").executes(context1 -> RaidCommand.c((CommandListenerWrapper)context1.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("check").executes(context1 -> RaidCommand.d((CommandListenerWrapper)context1.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("sound").then(net.minecraft.commands.CommandDispatcher.a("type", ArgumentChatComponent.a(context)).executes(context1 -> RaidCommand.a((CommandListenerWrapper)context1.getSource(), ArgumentChatComponent.b((CommandContext<CommandListenerWrapper>)context1, "type")))))).then(net.minecraft.commands.CommandDispatcher.a("spawnleader").executes(context1 -> RaidCommand.b((CommandListenerWrapper)context1.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("setomen").then(net.minecraft.commands.CommandDispatcher.a("level", IntegerArgumentType.integer((int)0)).executes(context1 -> RaidCommand.a((CommandListenerWrapper)context1.getSource(), IntegerArgumentType.getInteger((CommandContext)context1, (String)"level")))))).then(net.minecraft.commands.CommandDispatcher.a("glow").executes(context1 -> RaidCommand.a((CommandListenerWrapper)context1.getSource())))));
    }

    private static int a(CommandListenerWrapper source) throws CommandSyntaxException {
        Raid raid = RaidCommand.a(source.h());
        if (raid != null) {
            for (EntityRaider raider : raid.h()) {
                raider.a(new MobEffect(MobEffects.x, 1000, 1));
            }
        }
        return 1;
    }

    private static int a(CommandListenerWrapper source, int level) throws CommandSyntaxException {
        Raid raid = RaidCommand.a(source.h());
        if (raid != null) {
            int maxRaidOmenLevel = raid.k();
            if (level > maxRaidOmenLevel) {
                source.b(IChatBaseComponent.b("Sorry, the max raid omen level you can set is " + maxRaidOmenLevel));
            } else {
                int raidOmenLevel = raid.l();
                raid.a(level);
                source.a(() -> IChatBaseComponent.b("Changed village's raid omen level from " + raidOmenLevel + " to " + level), false);
            }
        } else {
            source.b(IChatBaseComponent.b("No raid found here"));
        }
        return 1;
    }

    private static int b(CommandListenerWrapper source) {
        source.a(() -> IChatBaseComponent.b("Spawned a raid captain"), false);
        EntityRaider raider = EntityTypes.aU.a(source.e(), EntitySpawnReason.n);
        if (raider == null) {
            source.b(IChatBaseComponent.b("Pillager failed to spawn"));
            return 0;
        }
        raider.w(true);
        raider.a(EnumItemSlot.f, Raid.a(source.u().f(Registries.aF)));
        raider.a_(source.d().d, source.d().e, source.d().f);
        raider.a((WorldAccess)source.e(), source.e().d_(BlockPosition.a(source.d())), EntitySpawnReason.n, null);
        source.e().a_(raider);
        return 1;
    }

    private static int a(CommandListenerWrapper source, @Nullable IChatBaseComponent type) {
        if (type != null && type.getString().equals("local")) {
            WorldServer level = source.e();
            Vec3D vec3 = source.d().b(5.0, 0.0, 0.0);
            level.a(null, vec3.d, vec3.e, vec3.f, SoundEffects.vQ, SoundCategory.g, 2.0f, 1.0f, level.A.g());
        }
        return 1;
    }

    private static int b(CommandListenerWrapper source, int badOmenLevel) throws CommandSyntaxException {
        EntityPlayer playerOrException = source.h();
        BlockPosition blockPos = playerOrException.dv();
        if (playerOrException.x().e(blockPos)) {
            source.b(IChatBaseComponent.b("Raid already started close by"));
            return -1;
        }
        PersistentRaid raids = playerOrException.x().B();
        Raid raid = raids.a(playerOrException, playerOrException.dv());
        if (raid != null) {
            raid.a(badOmenLevel);
            raids.f();
            source.a(() -> IChatBaseComponent.b("Created a raid in your local village"), false);
        } else {
            source.b(IChatBaseComponent.b("Failed to create a raid in your local village"));
        }
        return 1;
    }

    private static int c(CommandListenerWrapper source) throws CommandSyntaxException {
        EntityPlayer playerOrException = source.h();
        BlockPosition blockPos = playerOrException.dv();
        Raid raidAt = playerOrException.x().d(blockPos);
        if (raidAt != null) {
            raidAt.m();
            source.a(() -> IChatBaseComponent.b("Stopped raid"), false);
            return 1;
        }
        source.b(IChatBaseComponent.b("No raid here"));
        return -1;
    }

    private static int d(CommandListenerWrapper source) throws CommandSyntaxException {
        Raid raid = RaidCommand.a(source.h());
        if (raid != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Found a started raid! ");
            source.a(() -> IChatBaseComponent.b(stringBuilder.toString()), false);
            StringBuilder stringBuilder1 = new StringBuilder();
            stringBuilder1.append("Num groups spawned: ");
            stringBuilder1.append(raid.j());
            stringBuilder1.append(" Raid omen level: ");
            stringBuilder1.append(raid.l());
            stringBuilder1.append(" Num mobs: ");
            stringBuilder1.append(raid.p());
            stringBuilder1.append(" Raid health: ");
            stringBuilder1.append(raid.o());
            stringBuilder1.append(" / ");
            stringBuilder1.append(raid.g());
            source.a(() -> IChatBaseComponent.b(stringBuilder1.toString()), false);
            return 1;
        }
        source.b(IChatBaseComponent.b("Found no started raids"));
        return 0;
    }

    @Nullable
    private static Raid a(EntityPlayer player) {
        return player.x().d(player.dv());
    }
}

