/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.SimpleThreadUnsafeRandom;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.world.ChunkSystemServerChunkCache;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.slf4j.Logger;

public class ChunkProviderServer
extends IChunkProvider
implements ChunkSystemServerChunkCache {
    private static final Logger b = LogUtils.getLogger();
    private final ChunkMapDistance c;
    private final WorldServer d;
    public final Thread e;
    final LightEngineThreaded f;
    public final a g;
    public final PlayerChunkMap a;
    private final WorldPersistentData h;
    private final TicketStorage i;
    private long j;
    public boolean k = true;
    public boolean l = true;
    private static final int m = 4;
    private final long[] n = new long[4];
    private final ChunkStatus[] o = new ChunkStatus[4];
    private final IChunkAccess[] p = new IChunkAccess[4];
    private final List<Chunk> q = new ObjectArrayList();
    private final Set<PlayerChunk> r = new ReferenceOpenHashSet();
    @Nullable
    @VisibleForDebug
    private SpawnerCreature.d s;
    private final ConcurrentLong2ReferenceChainedHashTable<Chunk> fullChunks = new ConcurrentLong2ReferenceChainedHashTable();
    long chunkFutureAwaitCounter;
    private final SimpleThreadUnsafeRandom shuffleRandom = new SimpleThreadUnsafeRandom(0L);

    public int getFullChunksCount() {
        return this.fullChunks.size();
    }

    @Override
    public final void moonrise$setFullChunk(int chunkX, int chunkZ, Chunk chunk) {
        long key = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        if (chunk == null) {
            this.fullChunks.remove(key);
        } else {
            this.fullChunks.put(key, (Object)chunk);
        }
    }

    @Override
    public final Chunk moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return (Chunk)this.fullChunks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    private IChunkAccess syncLoad(int chunkX, int chunkZ, ChunkStatus toStatus) {
        IChunkAccess ret;
        ChunkTaskScheduler chunkTaskScheduler = this.d.moonrise$getChunkTaskScheduler();
        CompletableFuture completable = new CompletableFuture();
        chunkTaskScheduler.scheduleChunkLoad(chunkX, chunkZ, toStatus, true, Priority.BLOCKING, completable::complete);
        if (!completable.isDone() && chunkTaskScheduler.hasShutdown()) {
            throw new IllegalStateException("Chunk system has shut down, cannot process chunk requests in world '" + WorldUtil.getWorldName(this.d) + "' at (" + chunkX + "," + chunkZ + ") status: " + String.valueOf(toStatus));
        }
        if (TickThread.isTickThreadFor((World)this.d, chunkX, chunkZ)) {
            ChunkTaskScheduler.pushChunkWait(this.d, chunkX, chunkZ);
            this.g.b(completable::isDone);
            ChunkTaskScheduler.popChunkWait();
        }
        if ((ret = (IChunkAccess)completable.join()) == null) {
            throw new IllegalStateException("Chunk not loaded when requested");
        }
        return ret;
    }

    private IChunkAccess getChunkFallback(int chunkX, int chunkZ, ChunkStatus toStatus, boolean load) {
        Chunk loading;
        IChunkAccess ifPresent;
        ChunkTaskScheduler chunkTaskScheduler = this.d.moonrise$getChunkTaskScheduler();
        ChunkHolderManager chunkHolderManager = chunkTaskScheduler.chunkHolderManager;
        NewChunkHolder currentChunk = chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        IChunkAccess iChunkAccess = ifPresent = currentChunk == null ? null : currentChunk.getChunkIfPresent(toStatus);
        if (ifPresent != null && (toStatus != ChunkStatus.n || currentChunk.isFullChunkReady())) {
            return ifPresent;
        }
        PlatformHooks platformHooks = PlatformHooks.get();
        if (platformHooks.hasCurrentlyLoadingChunk() && currentChunk != null && (loading = platformHooks.getCurrentlyLoadingChunk(currentChunk.vanillaChunkHolder)) != null && TickThread.isTickThread()) {
            return loading;
        }
        return load ? this.syncLoad(chunkX, chunkZ, toStatus) : null;
    }

    private void iterateTickingChunksFaster() {
        WorldServer world = this.d;
        int randomTickSpeed = world.O().d(GameRules.p);
        ReferenceList<Chunk> entityTickingChunks = world.moonrise$getEntityTickingChunks();
        Chunk[] raw = entityTickingChunks.getRawDataUnchecked();
        int size = entityTickingChunks.size();
        Objects.checkFromToIndex(0, size, raw.length);
        for (int i2 = 0; i2 < size; ++i2) {
            world.a(raw[i2], randomTickSpeed);
            if ((i2 & 7) != 0) continue;
            this.d.p().moonrise$executeMidTickTasks();
        }
    }

    public ChunkProviderServer(WorldServer level, Convertable.ConversionSession levelStorageAccess, DataFixer fixerUpper, StructureTemplateManager structureManager, Executor dispatcher, ChunkGenerator generator, int viewDistance, int simulationDistance, boolean sync, WorldLoadListener progressListener, ChunkStatusUpdateListener chunkStatusListener, Supplier<WorldPersistentData> overworldDataStorage) {
        this.d = level;
        this.g = new a(level);
        this.e = Thread.currentThread();
        Path path = levelStorageAccess.a(level.aj()).resolve("data");
        try {
            FileUtils.c(path);
        }
        catch (IOException var15) {
            b.error("Failed to create dimension data storage directory", (Throwable)var15);
        }
        this.h = new WorldPersistentData(new PersistentBase.a(level), path, fixerUpper, level.J_());
        this.i = this.h.a(TicketStorage.b);
        this.a = new PlayerChunkMap(level, levelStorageAccess, fixerUpper, structureManager, dispatcher, this.g, this, generator, progressListener, chunkStatusListener, overworldDataStorage, this.i, viewDistance, sync);
        this.f = this.a.d();
        this.c = this.a.j();
        this.c.b(simulationDistance);
        this.s();
    }

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        PlayerChunk chunk = this.a.a(ChunkCoordIntPair.c(chunkX, chunkZ));
        if (chunk == null) {
            return false;
        }
        return chunk.getFullChunkNow() != null;
    }

    @Nullable
    public IChunkAccess getChunkAtImmediately(int x2, int z2) {
        PlayerChunk holder = this.a.b(ChunkCoordIntPair.c(x2, z2));
        if (holder == null) {
            return null;
        }
        return holder.p();
    }

    public void addTicketAtLevel(TicketType ticketType, ChunkCoordIntPair chunkPos, int ticketLevel) {
        this.i.a(new Ticket(ticketType, ticketLevel), chunkPos);
    }

    public void removeTicketAtLevel(TicketType ticketType, ChunkCoordIntPair chunkPos, int ticketLevel) {
        this.i.b(new Ticket(ticketType, ticketLevel), chunkPos);
    }

    @Nullable
    public Chunk getChunkAtIfCachedImmediately(int x2, int z2) {
        long k2 = ChunkCoordIntPair.c(x2, z2);
        PlayerChunk playerChunk = this.b(k2);
        if (playerChunk == null) {
            return null;
        }
        return playerChunk.getFullChunkNowUnchecked();
    }

    @Nullable
    public Chunk getChunkAtIfLoadedImmediately(int x2, int z2) {
        return (Chunk)this.fullChunks.get(ChunkCoordIntPair.c(x2, z2));
    }

    public LightEngineThreaded a() {
        return this.f;
    }

    @Nullable
    private PlayerChunk b(long chunkPos) {
        return this.a.b(chunkPos);
    }

    public int b() {
        return this.a.h();
    }

    private void a(long chunkPos, @Nullable IChunkAccess chunk, ChunkStatus chunkStatus) {
        for (int i2 = 3; i2 > 0; --i2) {
            this.n[i2] = this.n[i2 - 1];
            this.o[i2] = this.o[i2 - 1];
            this.p[i2] = this.p[i2 - 1];
        }
        this.n[0] = chunkPos;
        this.o[0] = chunkStatus;
        this.p[0] = chunk;
    }

    @Override
    @Nullable
    public IChunkAccess a(int x2, int z2, ChunkStatus chunkStatus, boolean requireChunk) {
        if (chunkStatus == ChunkStatus.n) {
            Chunk ret = (Chunk)this.fullChunks.get(CoordinateUtils.getChunkKey(x2, z2));
            if (ret != null) {
                return ret;
            }
            return requireChunk ? this.getChunkFallback(x2, z2, chunkStatus, requireChunk) : null;
        }
        return this.getChunkFallback(x2, z2, chunkStatus, requireChunk);
    }

    @Override
    @Nullable
    public Chunk a(int chunkX, int chunkZ) {
        Chunk ret = (Chunk)this.fullChunks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (!PlatformHooks.get().hasCurrentlyLoadingChunk()) {
            return ret;
        }
        if (ret != null || !TickThread.isTickThread()) {
            return ret;
        }
        NewChunkHolder holder = this.d.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (holder == null) {
            return ret;
        }
        return PlatformHooks.get().getCurrentlyLoadingChunk(holder.vanillaChunkHolder);
    }

    private void s() {
        Arrays.fill(this.n, ChunkCoordIntPair.c);
        Arrays.fill(this.o, null);
        Arrays.fill(this.p, null);
    }

    public CompletableFuture<ChunkResult<IChunkAccess>> b(int x2, int z2, ChunkStatus chunkStatus, boolean requireChunk) {
        CompletionStage<ChunkResult<IChunkAccess>> chunkFutureMainThread;
        boolean flag;
        boolean bl = flag = Thread.currentThread() == this.e;
        if (flag) {
            chunkFutureMainThread = this.c(x2, z2, chunkStatus, requireChunk);
            this.g.b(() -> chunkFutureMainThread.isDone());
        } else {
            chunkFutureMainThread = CompletableFuture.supplyAsync(() -> this.c(x2, z2, chunkStatus, requireChunk), this.g).thenCompose(future -> future);
        }
        return chunkFutureMainThread;
    }

    private CompletableFuture<ChunkResult<IChunkAccess>> c(int x2, int z2, ChunkStatus chunkStatus, boolean requireChunk) {
        IChunkAccess ifPresent;
        boolean needsFullScheduling;
        TickThread.ensureTickThread((World)this.d, x2, z2, "Scheduling chunk load off-main");
        int minLevel = ChunkLevel.a(chunkStatus);
        NewChunkHolder chunkHolder = this.d.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(x2, z2);
        boolean bl = needsFullScheduling = chunkStatus == ChunkStatus.n && (chunkHolder == null || !chunkHolder.getChunkStatus().a(FullChunkStatus.b));
        if ((chunkHolder == null || chunkHolder.getTicketLevel() > minLevel || needsFullScheduling) && !requireChunk) {
            return GenerationChunkHolder.c;
        }
        IChunkAccess iChunkAccess = ifPresent = chunkHolder == null ? null : chunkHolder.getChunkIfPresent(chunkStatus);
        if (needsFullScheduling || ifPresent == null) {
            CompletableFuture<ChunkResult<IChunkAccess>> ret = new CompletableFuture<ChunkResult<IChunkAccess>>();
            Consumer<IChunkAccess> complete = chunk -> {
                if (chunk == null) {
                    ret.complete(GenerationChunkHolder.b);
                } else {
                    ret.complete(ChunkResult.a(chunk));
                }
            };
            this.d.moonrise$getChunkTaskScheduler().scheduleChunkLoad(x2, z2, chunkStatus, true, Priority.HIGHER, complete);
            return ret;
        }
        return CompletableFuture.completedFuture(ChunkResult.a(ifPresent));
    }

    @Override
    public boolean b(int x2, int z2) {
        return this.a(x2, z2) != null;
    }

    @Override
    @Nullable
    public LightChunk c(int chunkX, int chunkZ) {
        NewChunkHolder newChunkHolder = this.d.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (newChunkHolder == null) {
            return null;
        }
        return newChunkHolder.getChunkIfPresentUnchecked(ChunkStatus.k.c());
    }

    public World c() {
        return this.d;
    }

    public boolean d() {
        return this.g.B();
    }

    public boolean t() {
        return this.d.moonrise$getChunkTaskScheduler().chunkHolderManager.processTicketUpdates();
    }

    public boolean a(long chunkPos) {
        NewChunkHolder newChunkHolder = this.d.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return newChunkHolder != null && newChunkHolder.isTickingReady();
    }

    public void a(boolean flush) {
        this.a.a(flush);
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) throws IOException {
        this.h.close();
        this.d.moonrise$getChunkTaskScheduler().chunkHolderManager.close(save, true);
    }

    public void purgeUnload() {
    }

    @Override
    public void a(BooleanSupplier hasTimeLeft, boolean tickChunks) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("purge");
        if (this.d.u().i() || !tickChunks || this.d.spigotConfig.unloadFrozenChunks) {
            this.i.c();
        }
        this.t();
        profilerFiller.b("chunks");
        if (tickChunks) {
            this.d.moonrise$getPlayerChunkLoader().tick();
            this.u();
            this.a.l();
        }
        profilerFiller.b("unload");
        this.a.a(hasTimeLeft);
        profilerFiller.c();
        this.s();
    }

    private void u() {
        long gameTime = this.d.ae();
        long l2 = gameTime - this.j;
        this.j = gameTime;
        if (!this.d.ak()) {
            GameProfilerFiller profilerFiller = Profiler.a();
            profilerFiller.a("pollingChunks");
            if (this.d.u().i()) {
                profilerFiller.a("tickingChunks");
                this.a(profilerFiller, l2);
                profilerFiller.c();
            }
            this.a(profilerFiller);
            profilerFiller.c();
        }
    }

    private void a(GameProfilerFiller profiler) {
        profiler.a("broadcast");
        for (PlayerChunk chunkHolder : this.r) {
            Chunk tickingChunk = chunkHolder.e();
            if (tickingChunk == null) continue;
            chunkHolder.a(tickingChunk);
        }
        this.r.clear();
        profiler.c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(GameProfilerFiller profiler, long timeInhabited) {
        List<EnumCreatureType> filteredSpawningCategories;
        SpawnerCreature.d spawnState;
        profiler.b("naturalSpawnCount");
        int naturalSpawnChunkCount = this.c.a();
        if ((this.l || this.k) && this.d.paperConfig().entities.spawning.perPlayerMobSpawns) {
            for (EntityPlayer player : this.d.I) {
                for (int ii = 0; ii < EntityPlayer.MOBCATEGORY_TOTAL_ENUMS; ++ii) {
                    player.mobCounts[ii] = 0;
                    int newBackoff = player.mobBackoffCounts[ii] - 1;
                    if (newBackoff < 0) {
                        newBackoff = 0;
                    }
                    player.mobBackoffCounts[ii] = newBackoff;
                }
            }
            spawnState = SpawnerCreature.createState(naturalSpawnChunkCount, this.d.C(), this::a, null, true);
        } else {
            spawnState = SpawnerCreature.createState(naturalSpawnChunkCount, this.d.C(), this::a, !this.d.paperConfig().entities.spawning.perPlayerMobSpawns ? new LocalMobCapCalculator(this.a) : null, false);
        }
        this.s = spawnState;
        profiler.b("spawnAndTick");
        boolean _boolean = this.d.O().c(GameRules.f) && !this.d.z().isEmpty();
        int _int = this.d.O().d(GameRules.p);
        if (_boolean && (this.k || this.l)) {
            for (EntityPlayer entityPlayer : this.d.z()) {
                int chunkRange = Math.min(this.d.spigotConfig.mobSpawnRange, entityPlayer.getBukkitEntity().getViewDistance());
                chunkRange = Math.min(chunkRange, 8);
                entityPlayer.playerNaturallySpawnedEvent = new PlayerNaturallySpawnCreaturesEvent((Player)entityPlayer.getBukkitEntity(), (byte)chunkRange);
                entityPlayer.playerNaturallySpawnedEvent.callEvent();
            }
            boolean flag = this.d.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) != 0L && this.d.C_().c() % this.d.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) == 0L;
            filteredSpawningCategories = SpawnerCreature.getFilteredSpawningCategories(spawnState, this.l, this.k, flag, this.d);
        } else {
            filteredSpawningCategories = List.of();
        }
        List<Chunk> list = this.q;
        try {
            profiler.a("filteringSpawningChunks");
            this.a.a(list);
            profiler.b("shuffleSpawningChunks");
            this.shuffleRandom.b(this.d.A.g());
            if (!this.d.paperConfig().entities.spawning.perPlayerMobSpawns) {
                SystemUtils.c(list, this.shuffleRandom);
            }
            profiler.b("tickSpawningChunks");
            for (Chunk levelChunk : list) {
                this.a(levelChunk, timeInhabited, filteredSpawningCategories, spawnState);
            }
        }
        finally {
            list.clear();
        }
        profiler.b("tickTickingChunks");
        this.iterateTickingChunksFaster();
        profiler.c();
        profiler.b("customSpawners");
        if (_boolean) {
            this.d.a(this.k, this.l);
        }
    }

    private void a(Chunk chunk, long timeInhabited, List<EnumCreatureType> spawnCategories, SpawnerCreature.d spawnState) {
        ChunkCoordIntPair pos = chunk.f();
        chunk.b(timeInhabited);
        this.d.a(chunk);
        if (!spawnCategories.isEmpty() && this.d.E_().a(pos)) {
            SpawnerCreature.a(this.d, chunk, spawnState, spawnCategories);
        }
    }

    private void a(long chunkPos, Consumer<Chunk> fullChunkGetter) {
        Chunk fullChunk = (Chunk)this.fullChunks.get(chunkPos);
        if (fullChunk != null) {
            fullChunkGetter.accept(fullChunk);
        }
    }

    @Override
    public String e() {
        return Integer.toString(this.j());
    }

    @VisibleForTesting
    public int f() {
        return this.g.by();
    }

    public ChunkGenerator g() {
        return this.a.a();
    }

    public ChunkGeneratorStructureState h() {
        return this.a.b();
    }

    public RandomState i() {
        return this.a.c();
    }

    @Override
    public int j() {
        return this.a.i();
    }

    public void a(BlockPosition pos) {
        int sectionPosZ;
        int sectionPosX = SectionPosition.a(pos.u());
        PlayerChunk visibleChunkIfPresent = this.b(ChunkCoordIntPair.c(sectionPosX, sectionPosZ = SectionPosition.a(pos.w())));
        if (visibleChunkIfPresent != null && visibleChunkIfPresent.a(pos)) {
            this.r.add(visibleChunkIfPresent);
        }
    }

    @Override
    public void a(EnumSkyBlock type, SectionPosition pos) {
        this.g.execute(() -> {
            PlayerChunk visibleChunkIfPresent = this.b(pos.r().a());
            if (visibleChunkIfPresent != null && visibleChunkIfPresent.a(type, pos.b())) {
                this.r.add(visibleChunkIfPresent);
            }
        });
    }

    public void a(Ticket ticket, ChunkCoordIntPair chunkPos) {
        this.i.a(ticket, chunkPos);
    }

    public void a(TicketType ticket, ChunkCoordIntPair chunkPos, int radius) {
        this.i.a(ticket, chunkPos, radius);
    }

    public void b(TicketType ticket, ChunkCoordIntPair chunkPos, int radius) {
        this.i.b(ticket, chunkPos, radius);
    }

    @Override
    public boolean a(ChunkCoordIntPair chunkPos, boolean add) {
        return this.i.a(chunkPos, add);
    }

    @Override
    public LongSet k() {
        return this.i.e();
    }

    public void a(EntityPlayer player) {
        if (!player.dQ()) {
            this.a.a(player);
        }
    }

    public void a(Entity entity) {
        this.a.b(entity);
    }

    public void b(Entity entity) {
        this.a.a(entity);
    }

    public void a(Entity entity, Packet<?> packet) {
        this.a.b(entity, packet);
    }

    public void b(Entity entity, Packet<?> packet) {
        this.a.a(entity, packet);
    }

    public void a(int viewDistance) {
        this.a.a(viewDistance);
    }

    public void setSendViewDistance(int viewDistance) {
        this.d.moonrise$getPlayerChunkLoader().setSendDistance(viewDistance);
    }

    public void b(int simulationDistance) {
        this.c.b(simulationDistance);
    }

    @Override
    public void b(boolean spawnSettings) {
        this.setSpawnSettings(spawnSettings, this.l);
    }

    public void setSpawnSettings(boolean spawnSettings, boolean spawnFriendlies) {
        this.k = spawnSettings;
        this.l = spawnFriendlies;
    }

    public String a(ChunkCoordIntPair chunkPos) {
        return this.a.a(chunkPos);
    }

    public WorldPersistentData l() {
        return this.h;
    }

    public VillagePlace m() {
        return this.a.m();
    }

    public ChunkScanAccess n() {
        return this.a.p();
    }

    @Nullable
    @VisibleForDebug
    public SpawnerCreature.d o() {
        return this.s;
    }

    public void p() {
        this.i.d();
    }

    public void a(PlayerChunk chunkHolder) {
        if (chunkHolder.i()) {
            this.r.add(chunkHolder);
        }
    }

    private static /* synthetic */ boolean lambda$purgeUnload$3() {
        return true;
    }

    public final class a
    extends IAsyncTaskHandler<Runnable> {
        a(World level) {
            super("Chunk source main thread executor for " + String.valueOf(level.aj().a()));
        }

        @Override
        public void b(BooleanSupplier isDone) {
            super.b(() -> MinecraftServer.z() && isDone.getAsBoolean());
        }

        @Override
        public Runnable f(Runnable runnable) {
            return runnable;
        }

        @Override
        protected boolean e(Runnable runnable) {
            return true;
        }

        @Override
        protected boolean ax() {
            return true;
        }

        @Override
        protected Thread ay() {
            return ChunkProviderServer.this.e;
        }

        @Override
        protected void d(Runnable task) {
            Profiler.a().f("runTask");
            super.d(task);
        }

        @Override
        public boolean B() {
            ChunkProviderServer serverChunkCache = ChunkProviderServer.this;
            if (serverChunkCache.t()) {
                return true;
            }
            return super.B() | serverChunkCache.d.moonrise$getChunkTaskScheduler().executeMainThreadTask();
        }
    }
}

