/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.patches.chunk_system.player.ChunkSystemServerPlayer;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.event.player.PlayerClientOptionsChangeEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.event.player.PlayerStartSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerStopSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerTeleportEndGatewayEvent;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.HashCode;
import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.player.PlayerInventorySlotChangeEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.translation.Translator;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerRotationPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetCursorItemPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWindowData;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.HashOps;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHorse;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.RemoteSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemCooldownPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockEndGateway;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.EndGateway;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftEndGateway;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftDimensionUtil;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.MainHand;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EntityPlayer
extends EntityHuman
implements ChunkSystemServerPlayer {
    private static final Logger cq = LogUtils.getLogger();
    public long lastSave = MinecraftServer.currentTick;
    private static final int cr = 32;
    private static final int cs = 10;
    private static final int ct = 25;
    public static final double a = 1.0;
    public static final double b = 3.0;
    public static final int c = 2;
    public static final String d = "ender_pearls";
    public static final String e = "ender_pearl_dimension";
    private static final AttributeModifier cu = new AttributeModifier(MinecraftKey.b("creative_mode_block_range"), 0.5, AttributeModifier.Operation.a);
    private static final AttributeModifier cv = new AttributeModifier(MinecraftKey.b("creative_mode_entity_range"), 2.0, AttributeModifier.Operation.a);
    private static final IChatBaseComponent cw = IChatBaseComponent.c("block.minecraft.set_spawn");
    private static final boolean cx = false;
    private static final boolean cy = false;
    public PlayerConnection f;
    public final MinecraftServer g;
    public final PlayerInteractManager h;
    private final AdvancementDataPlayer cz;
    private final ServerStatisticManager cA;
    private float cB = Float.MIN_VALUE;
    private int cC = Integer.MIN_VALUE;
    private int cD = Integer.MIN_VALUE;
    private int cE = Integer.MIN_VALUE;
    private int cF = Integer.MIN_VALUE;
    private int cG = Integer.MIN_VALUE;
    private float cH = -1.0E8f;
    private int cI = -99999999;
    private boolean cJ = true;
    public int cK = -99999999;
    private EnumChatVisibility cL = EnumChatVisibility.a;
    public ParticleStatus cM = ParticleStatus.a;
    private boolean cN = true;
    private long cO = SystemUtils.c();
    @Nullable
    private net.minecraft.world.entity.Entity cP;
    public boolean cQ;
    public boolean i = false;
    private final RecipeBookServer cR;
    @Nullable
    private Vec3D cS;
    private int cT;
    private boolean cU;
    private int cV = 2;
    public String cW = null;
    public Locale adventure$locale = Locale.US;
    @Nullable
    private Vec3D cX;
    @Nullable
    private Vec3D cY;
    @Nullable
    private Vec3D cZ;
    private SectionPosition da = SectionPosition.a(0, 0, 0);
    private ChunkTrackingView db = ChunkTrackingView.a;
    @Nullable
    private RespawnConfig dc;
    private final ITextFilter dd;
    private boolean de;
    private boolean df;
    private boolean dg = false;
    public WardenSpawnTracker dh = new WardenSpawnTracker();
    @Nullable
    private BlockPosition di;
    private Vec3D dj = Vec3D.c;
    private Input dk = Input.b;
    private final Set<EntityEnderPearl> dl = new HashSet<EntityEnderPearl>();
    public final ContainerSynchronizer dm = new ContainerSynchronizer(){
        private final LoadingCache<TypedDataComponent<?>, Integer> b = CacheBuilder.newBuilder().maximumSize(256L).build(new CacheLoader<TypedDataComponent<?>, Integer>(){
            private final DynamicOps<HashCode> b;
            {
                this.b = EntityPlayer.this.dX().a(HashOps.c);
            }

            public Integer a(TypedDataComponent<?> typedDataComponent) {
                return ((HashCode)typedDataComponent.a(this.b).getOrThrow(string -> new IllegalArgumentException("Failed to hash " + String.valueOf(typedDataComponent) + ": " + string))).asInt();
            }
        });

        @Override
        public void a(Container container, List<ItemStack> items, ItemStack carried, int[] remoteDataSlots) {
            EntityPlayer.this.f.b(new PacketPlayOutWindowItems(container.l, container.k(), items, carried));
            for (int i2 = 0; i2 < remoteDataSlots.length; ++i2) {
                this.b(container, i2, remoteDataSlots[i2]);
            }
        }

        @Override
        public void sendOffHandSlotChange() {
            EntityPlayer.this.f.b(new PacketPlayOutSetSlot(EntityPlayer.this.bQ.l, EntityPlayer.this.bQ.k(), 45, EntityPlayer.this.bQ.b(45).g().v()));
        }

        @Override
        public EntityPlayer player() {
            return EntityPlayer.this;
        }

        @Override
        public void a(Container container, int slot, ItemStack itemStack) {
            EntityPlayer.this.f.b(new PacketPlayOutSetSlot(container.l, container.k(), slot, itemStack));
        }

        @Override
        public void a(Container containerMenu, ItemStack stack) {
            EntityPlayer.this.f.b(new ClientboundSetCursorItemPacket(stack));
        }

        @Override
        public void a(Container container, int id, int value) {
            this.b(container, id, value);
        }

        private void b(Container container, int id, int value) {
            EntityPlayer.this.f.b(new PacketPlayOutWindowData(container.l, id, value));
        }

        @Override
        public RemoteSlot a() {
            return new RemoteSlot.a(arg_0 -> this.b.getUnchecked(arg_0), EntityPlayer.this.getBukkitEntity().simplifyContainerDesyncCheck());
        }
    };
    private final ICrafting dn = new ICrafting(){

        @Override
        public void a(Container containerToSend, int dataSlotIndex, ItemStack stack) {
            Slot slot = containerToSend.b(dataSlotIndex);
            if (!(slot instanceof SlotResult) && slot.c == EntityPlayer.this.gj()) {
                CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.gj(), stack);
            }
        }

        @Override
        public void slotChanged(Container containerToSend, int dataSlotIndex, ItemStack oldStack, ItemStack stack) {
            Slot slot = containerToSend.b(dataSlotIndex);
            if (!(slot instanceof SlotResult) && slot.c == EntityPlayer.this.gj()) {
                if (PlayerInventorySlotChangeEvent.getHandlerList().getRegisteredListeners().length == 0) {
                    CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.gj(), stack);
                    return;
                }
                PlayerInventorySlotChangeEvent event = new PlayerInventorySlotChangeEvent((Player)EntityPlayer.this.getBukkitEntity(), dataSlotIndex, CraftItemStack.asBukkitCopy(oldStack), CraftItemStack.asBukkitCopy(stack));
                event.callEvent();
                if (event.shouldTriggerAdvancements()) {
                    CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.gj(), stack);
                }
            }
        }

        @Override
        public void a(Container containerMenu, int dataSlotIndex, int value) {
        }
    };
    @Nullable
    private RemoteChatSession do;
    @Nullable
    public final Object j;
    private final ICommandListener dp = new ICommandListener(){

        @Override
        public boolean x_() {
            return EntityPlayer.this.x().O().c(GameRules.q);
        }

        @Override
        public boolean y_() {
            return true;
        }

        @Override
        public boolean c() {
            return true;
        }

        @Override
        public void a(IChatBaseComponent component) {
            EntityPlayer.this.a(component);
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
            return EntityPlayer.this.getBukkitEntity();
        }
    };
    private int dq;
    public boolean k;
    private int containerUpdateDelay;
    public long loginTime;
    public int patrolSpawnDelay;
    public boolean queueHealthUpdatePacket;
    @Nullable
    public PacketPlayOutUpdateHealth queuedHealthUpdatePacket;
    public static final int MOBCATEGORY_TOTAL_ENUMS = EnumCreatureType.values().length;
    public final int[] mobCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public final int[] mobBackoffCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public CraftPlayer.TransferCookieConnection transferCookieConnection;
    public String displayName;
    public Component adventure$displayName;
    @Nullable
    public IChatBaseComponent listName;
    public int listOrder = 0;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public boolean supressTrackerForLogin = false;
    public boolean isRealPlayer;
    @Nullable
    public PlayerNaturallySpawnCreaturesEvent playerNaturallySpawnedEvent;
    @Nullable
    public String clientBrandName = null;
    @Nullable
    public PlayerQuitEvent.QuitReason quitReason = null;
    private RegionizedPlayerChunkLoader.PlayerChunkLoaderData chunkLoader;
    private final RegionizedPlayerChunkLoader.ViewDistanceHolder viewDistanceHolder = new RegionizedPlayerChunkLoader.ViewDistanceHolder();
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    @Nullable
    public WeatherType weatherType = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;

    @Override
    public final boolean moonrise$isRealPlayer() {
        return this.isRealPlayer;
    }

    @Override
    public final void moonrise$setRealPlayer(boolean real) {
        this.isRealPlayer = real;
    }

    @Override
    public final RegionizedPlayerChunkLoader.PlayerChunkLoaderData moonrise$getChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public final void moonrise$setChunkLoader(RegionizedPlayerChunkLoader.PlayerChunkLoaderData loader) {
        this.chunkLoader = loader;
    }

    @Override
    public final RegionizedPlayerChunkLoader.ViewDistanceHolder moonrise$getViewDistanceHolder() {
        return this.viewDistanceHolder;
    }

    public EntityPlayer(MinecraftServer server, WorldServer level, GameProfile gameProfile, ClientInformation clientInformation) {
        super(level, level.aa(), level.ab(), gameProfile);
        this.dd = server.a(this);
        this.h = server.b(this);
        this.cR = new RecipeBookServer((recipe, output) -> server.aI().a(recipe, output));
        this.g = server;
        this.cA = server.ag().getPlayerStats(this);
        this.cz = server.ag().g(this);
        this.updateOptionsNoEvents(clientInformation);
        this.j = null;
        this.displayName = this.cI();
        this.adventure$displayName = Component.text((String)this.cI());
        this.bukkitPickUpLoot = true;
        this.maxHealthCache = this.eU();
    }

    @Override
    public BlockPosition a(WorldServer level, BlockPosition pos) {
        AxisAlignedBB aabb = this.a(EntityPose.a).a(Vec3D.c);
        BlockPosition blockPos = pos;
        if (level.F_().g() && level.L.k() != EnumGamemode.c) {
            long l2;
            long l1;
            int max = Math.max(0, this.g.a(level));
            int floor = MathHelper.a(level.E_().b(pos.u(), pos.w()));
            if (floor < max) {
                max = floor;
            }
            if (floor <= 1) {
                max = 1;
            }
            int i2 = (l1 = (l2 = (long)(max * 2 + 1)) * l2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l1;
            int coprime = this.t(i2);
            int randomInt = RandomSource.a().a(i2);
            for (int i1 = 0; i1 < i2; ++i1) {
                int i22 = (randomInt + coprime * i1) % i2;
                int i3 = i22 % (max * 2 + 1);
                int i4 = i22 / (max * 2 + 1);
                int i5 = pos.u() + i3 - max;
                int i6 = pos.w() + i4 - max;
                try {
                    blockPos = WorldProviderNormal.a(level, i5, i6);
                    if (blockPos == null || !this.a(level, aabb.c(blockPos.c()))) continue;
                    return blockPos;
                }
                catch (Exception var25) {
                    int i7 = i1;
                    int i8 = max;
                    CrashReport crashReport = CrashReport.a(var25, "Searching for spawn");
                    CrashReportSystemDetails crashReportCategory = crashReport.a("Spawn Lookup");
                    crashReportCategory.a("Origin", pos::toString);
                    crashReportCategory.a("Radius", () -> Integer.toString(i8));
                    crashReportCategory.a("Candidate", () -> "[" + i5 + "," + i6 + "]");
                    crashReportCategory.a("Progress", () -> i7 + " out of " + i2);
                    throw new ReportedException(crashReport);
                }
            }
            blockPos = pos;
        }
        while (!this.a(level, aabb.c(blockPos.c())) && blockPos.v() < level.ao()) {
            blockPos = blockPos.d();
        }
        while (this.a(level, aabb.c(blockPos.e().c())) && blockPos.v() > level.K_() + 1) {
            blockPos = blockPos.e();
        }
        return blockPos;
    }

    private boolean a(WorldServer level, AxisAlignedBB collisionBox) {
        return level.a((net.minecraft.world.entity.Entity)this, collisionBox, true);
    }

    private int t(int spawnArea) {
        return spawnArea <= 16 ? spawnArea - 1 : 17;
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.dh = compound.a("warden_spawn_tracker", WardenSpawnTracker.a).orElseGet(WardenSpawnTracker::new);
        this.cY = compound.a("entered_nether_pos", Vec3D.a).orElse(null);
        this.i = compound.b("seenCredits", false);
        this.cR.a(compound.n("recipeBook"), (ResourceKey<IRecipe<?>> key) -> this.g.aI().b((ResourceKey<IRecipe<?>>)key).isPresent());
        this.getBukkitEntity().readExtraData(compound);
        if (this.fR()) {
            this.fS();
        }
        this.dc = compound.a("respawn", RespawnConfig.a).orElse(null);
        this.dg = compound.b("spawn_extra_particles_on_fall", false);
        this.di = compound.a("raid_omen_position", BlockPosition.a).orElse(null);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("warden_spawn_tracker", WardenSpawnTracker.a, this.dh);
        this.p(compound);
        compound.a("seenCredits", this.i);
        compound.b("entered_nether_pos", Vec3D.a, this.cY);
        this.m(compound);
        compound.a("recipeBook", this.cR.b());
        compound.a("Dimension", this.dV().aj().a().toString());
        compound.b("respawn", RespawnConfig.a, this.dc);
        compound.a("spawn_extra_particles_on_fall", this.dg);
        compound.b("raid_omen_position", BlockPosition.a, this.di);
        this.n(compound);
        this.getBukkitEntity().setExtraData(compound);
    }

    private void m(NBTTagCompound tag) {
        net.minecraft.world.entity.Entity rootVehicle = this.df();
        net.minecraft.world.entity.Entity vehicle = this.dk();
        boolean persistVehicle = true;
        if (vehicle != null) {
            for (net.minecraft.world.entity.Entity topVehicle = vehicle; topVehicle != null; topVehicle = topVehicle.dk()) {
                if (topVehicle.persist) continue;
                persistVehicle = false;
                break;
            }
        }
        if (persistVehicle && vehicle != null && rootVehicle != this && rootVehicle.de() && !rootVehicle.dQ()) {
            NBTTagCompound compoundTag = new NBTTagCompound();
            NBTTagCompound compoundTag1 = new NBTTagCompound();
            rootVehicle.g(compoundTag1);
            compoundTag.a("Attach", UUIDUtil.a, vehicle.cG());
            compoundTag.a("Entity", compoundTag1);
            tag.a("RootVehicle", compoundTag);
        }
    }

    public void c(NBTTagCompound tag) {
        Optional<NBTTagCompound> compound = tag.m("RootVehicle");
        if (!compound.isEmpty()) {
            WorldServer serverLevel = this.x();
            net.minecraft.world.entity.Entity entity = EntityTypes.a(compound.get().n("Entity"), (net.minecraft.world.level.World)serverLevel, EntitySpawnReason.r, entity2 -> !serverLevel.addWithUUID((net.minecraft.world.entity.Entity)entity2, CreatureSpawnEvent.SpawnReason.MOUNT) ? null : entity2);
            if (entity != null) {
                UUID uuid = compound.get().a("Attach", UUIDUtil.a).orElse(null);
                if (entity.cG().equals(uuid)) {
                    this.a(entity, true);
                } else {
                    for (net.minecraft.world.entity.Entity entity1 : entity.dc()) {
                        if (!entity1.cG().equals(uuid)) continue;
                        this.a(entity1, true);
                        break;
                    }
                }
                if (!this.bY()) {
                    cq.warn("Couldn't reattach entity to player");
                    entity.discard(null);
                    for (net.minecraft.world.entity.Entity entity1x : entity.dc()) {
                        entity1x.discard(null);
                    }
                }
            }
        }
    }

    private void n(NBTTagCompound tag) {
        if (!this.dl.isEmpty()) {
            NBTTagList listTag = new NBTTagList();
            for (EntityEnderPearl thrownEnderpearl : this.dl) {
                if (thrownEnderpearl.dV().paperConfig().misc.legacyEnderPearlBehavior) continue;
                if (thrownEnderpearl.dQ()) {
                    cq.warn("Trying to save removed ender pearl, skipping");
                    continue;
                }
                NBTTagCompound compoundTag = new NBTTagCompound();
                thrownEnderpearl.g(compoundTag);
                compoundTag.a(e, net.minecraft.world.level.World.h, thrownEnderpearl.dV().aj());
                listTag.add(compoundTag);
            }
            tag.a(d, listTag);
        }
    }

    public void d(NBTTagCompound tag) {
        tag.o(d).ifPresent(listTag -> listTag.j().forEach(this::o));
    }

    private void o(NBTTagCompound tag) {
        Optional<ResourceKey<net.minecraft.world.level.World>> optional = tag.a(e, net.minecraft.world.level.World.h);
        if (!optional.isEmpty()) {
            WorldServer level = this.x().p().a(optional.get());
            if (level != null) {
                net.minecraft.world.entity.Entity entity = EntityTypes.a(tag, (net.minecraft.world.level.World)level, EntitySpawnReason.r, entity1 -> !level.c((net.minecraft.world.entity.Entity)entity1) ? null : entity1);
                if (entity != null) {
                    EntityPlayer.a(level, entity.dx());
                } else {
                    cq.warn("Failed to spawn player ender pearl in level ({}), skipping", optional.get());
                }
            } else {
                cq.warn("Trying to load ender pearl without level ({}) being loaded, skipping", optional.get());
            }
        }
    }

    public void spawnIn(WorldServer level) {
        if (level == null) {
            throw new IllegalArgumentException("level can't be null");
        }
        this.a((net.minecraft.world.level.World)level);
        this.h.a(level);
    }

    public void a(int experiencePoints) {
        float f2 = this.gt();
        float f1 = (f2 - 1.0f) / f2;
        this.ch = MathHelper.a((float)experiencePoints / f2, 0.0f, f1);
        this.cK = -1;
    }

    public void b(int level) {
        this.cf = level;
        this.cK = -1;
    }

    @Override
    public void c(int levels) {
        super.c(levels);
        this.cK = -1;
    }

    @Override
    public void a(ItemStack enchantedItem, int cost) {
        super.a(enchantedItem, cost);
        this.cK = -1;
    }

    public void a(Container menu) {
        menu.a(this.dn);
        menu.a(this.dm);
    }

    public void c() {
        this.a(this.bQ);
    }

    @Override
    public void f_() {
        super.f_();
        this.f.b(ClientboundPlayerCombatEnterPacket.a);
    }

    @Override
    public void O_() {
        super.O_();
        this.f.b(new ClientboundPlayerCombatEndPacket(this.eS()));
    }

    @Override
    public void a(IBlockData state) {
        CriterionTriggers.e.a(this, state);
    }

    @Override
    protected ItemCooldown f() {
        return new ItemCooldownPlayer(this);
    }

    @Override
    public void g() {
        net.minecraft.world.entity.Entity camera;
        if (this.joining) {
            this.joining = false;
        }
        this.gL();
        this.h.a();
        this.dh.a();
        if (this.aj > 0) {
            --this.aj;
        }
        if (--this.containerUpdateDelay <= 0) {
            this.bR.d();
            this.containerUpdateDelay = this.dV().paperConfig().tickRates.containerUpdate;
        }
        if (this.bR != this.bQ && (this.fg() || !this.bR.b(this))) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.bR = this.bQ;
        }
        if ((camera = this.K()) != this) {
            if (camera.bJ()) {
                this.a(camera.dA(), camera.dC(), camera.dG(), camera.dL(), camera.dN());
                this.x().m().a(this);
                if (this.fZ()) {
                    this.d((net.minecraft.world.entity.Entity)this);
                }
            } else {
                this.d((net.minecraft.world.entity.Entity)this);
            }
        }
        CriterionTriggers.x.a(this);
        if (this.cS != null) {
            CriterionTriggers.v.a(this, this.cS, this.af - this.cT);
        }
        this.k();
        this.l();
        this.gT();
        this.cz.a(this, true);
    }

    private void gT() {
        AttributeModifiable attribute1;
        AttributeModifiable attribute = this.g(GenericAttributes.g);
        if (attribute != null) {
            if (this.gz()) {
                attribute.a(cu);
            } else {
                attribute.e(cu);
            }
        }
        if ((attribute1 = this.g(GenericAttributes.j)) != null) {
            if (this.gz()) {
                attribute1.a(cv);
            } else {
                attribute1.e(cv);
            }
        }
    }

    public void h() {
        try {
            if (this.valid && !this.ak() || !this.do()) {
                super.g();
            }
            for (int i2 = 0; i2 < this.gj().b(); ++i2) {
                ItemStack item = this.gj().a(i2);
                if (item.f()) continue;
                this.i(item);
            }
            if (this.eG() != this.cH || this.cI != this.bS.a() || this.bS.c() == 0.0f != this.cJ) {
                this.f.b(new PacketPlayOutUpdateHealth(this.getBukkitEntity().getScaledHealth(), this.bS.a(), this.bS.c()));
                this.cH = this.eG();
                this.cI = this.bS.a();
                boolean bl = this.cJ = this.bS.c() == 0.0f;
            }
            if (this.eG() + this.fw() != this.cB) {
                this.cB = this.eG() + this.fw();
                this.a(IScoreboardCriteria.h, MathHelper.f(this.cB));
            }
            if (this.bS.a() != this.cC) {
                this.cC = this.bS.a();
                this.a(IScoreboardCriteria.i, MathHelper.f((float)this.cC));
            }
            if (this.cs() != this.cD) {
                this.cD = this.cs();
                this.a(IScoreboardCriteria.j, MathHelper.f((float)this.cD));
            }
            if (this.eR() != this.cE) {
                this.cE = this.eR();
                this.a(IScoreboardCriteria.k, MathHelper.f((float)this.cE));
            }
            if (this.cg != this.cG) {
                this.cG = this.cg;
                this.a(IScoreboardCriteria.l, MathHelper.f((float)this.cG));
            }
            if (this.maxHealthCache != (double)this.eU()) {
                this.getBukkitEntity().updateScaledHealth();
            }
            if (this.cf != this.cF) {
                this.cF = this.cf;
                this.a(IScoreboardCriteria.m, MathHelper.f((float)this.cF));
            }
            if (this.cg != this.cK) {
                this.cK = this.cg;
                this.f.b(new PacketPlayOutExperience(this.ch, this.cg, this.cf));
            }
            if (this.af % 20 == 0) {
                CriterionTriggers.q.a(this);
            }
            if (this.oldLevel == -1) {
                this.oldLevel = this.cf;
            }
            if (this.oldLevel != this.cf) {
                CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.cf);
                this.oldLevel = this.cf;
            }
            if (this.getBukkitEntity().hasClientWorldBorder()) {
                ((CraftWorldBorder)this.getBukkitEntity().getWorldBorder()).getHandle().s();
            }
        }
        catch (Throwable var4) {
            CrashReport crashReport = CrashReport.a(var4, "Ticking player");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Player being ticked");
            this.a(crashReportCategory);
            throw new ReportedException(crashReport);
        }
    }

    private void i(ItemStack stack) {
        Packet<?> updatePacket;
        MapId mapId = stack.a(DataComponents.M);
        WorldMap savedData = ItemWorldMap.a(mapId, this.dV());
        if (savedData != null && (updatePacket = savedData.a(mapId, this)) != null) {
            this.f.b(updatePacket);
        }
    }

    @Override
    protected void i() {
        if (this.dV().an() == EnumDifficulty.a && this.x().O().c(GameRules.l)) {
            if (this.af % 20 == 0) {
                float saturationLevel;
                if (this.eG() < this.eU()) {
                    this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
                }
                if ((saturationLevel = this.bS.c()) < 20.0f) {
                    this.bS.b(saturationLevel + 1.0f);
                }
            }
            if (this.af % 10 == 0 && this.bS.b()) {
                this.bS.a(this.bS.a() + 1);
            }
        }
    }

    @Override
    public void j() {
        if (this.eG() > 0.0f && this.cX != null) {
            CriterionTriggers.X.a(this, this.cX);
        }
        this.cX = null;
        super.j();
    }

    public void k() {
        if (this.Z > 0.0 && this.cX == null) {
            this.cX = this.dt();
            if (this.cm != null && this.cm.e <= this.cX.e) {
                CriterionTriggers.ae.a(this, this.cm, this.cn);
            }
        }
    }

    public void l() {
        if (this.dk() != null && this.dk().bv()) {
            if (this.cZ == null) {
                this.cZ = this.dt();
            } else {
                CriterionTriggers.Y.a(this, this.cZ);
            }
        }
        if (!(this.cZ == null || this.dk() != null && this.dk().bv())) {
            this.cZ = null;
        }
    }

    private void a(IScoreboardCriteria criteria, int points) {
        this.dV().getCraftServer().getScoreboardManager().forAllObjectives(criteria, this, score -> score.a(points));
    }

    private static boolean shouldKeepDeathEventItem(PlayerDeathEvent event, ItemStack item) {
        List itemsToKeep = event.getItemsToKeep();
        if (EnchantmentManager.a(item, EnchantmentEffectComponents.D) || itemsToKeep.isEmpty() || item.f()) {
            return false;
        }
        org.bukkit.inventory.ItemStack bukkitStack = item.getBukkitStack();
        Iterator iterator = itemsToKeep.iterator();
        while (iterator.hasNext()) {
            org.bukkit.inventory.ItemStack itemStack = (org.bukkit.inventory.ItemStack)iterator.next();
            if (!bukkitStack.equals((Object)itemStack)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public void a(DamageSource cause) {
        TextComponent apiDeathMessage;
        boolean keepInventory;
        boolean _boolean;
        boolean showDeathMessage = _boolean = this.x().O().c(GameRules.o);
        if (this.dQ()) {
            return;
        }
        ArrayList<Entity.DefaultDrop> loot = new ArrayList<Entity.DefaultDrop>(this.gj().b());
        boolean bl = keepInventory = this.x().O().c(GameRules.e) || this.ak();
        if (!keepInventory) {
            for (ItemStack item : this.gj().getContents()) {
                if (item.f() || EnchantmentManager.a(item, EnchantmentEffectComponents.D)) continue;
                loot.add(new Entity.DefaultDrop(item, stack -> this.drop((ItemStack)stack, true, false, false, null)));
            }
        }
        if (this.ep() && this.x().O().c(GameRules.g)) {
            this.b(this.x(), cause, this.bb > 0);
            loot.addAll(this.drops);
            this.drops.clear();
        }
        IChatBaseComponent defaultMessage = this.eS().a();
        String deathmessage = defaultMessage.getString();
        this.keepLevel = keepInventory;
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent(this, cause, loot, PaperAdventure.asAdventure(defaultMessage), keepInventory);
        if (event.isCancelled()) {
            if (this.eG() <= 0.0f) {
                this.d((float)event.getReviveHealth());
            }
            return;
        }
        ((net.minecraft.world.entity.Entity)this).a(GameEvent.p);
        if (this.bR != this.bQ) {
            this.closeContainer(InventoryCloseEvent.Reason.DEATH);
        }
        Object object = apiDeathMessage = event.deathMessage() != null ? event.deathMessage() : Component.empty();
        if (apiDeathMessage != null && apiDeathMessage != Component.empty() && showDeathMessage) {
            IChatBaseComponent deathMessage = PaperAdventure.asVanilla((Component)apiDeathMessage);
            this.f.a(new ClientboundPlayerCombatKillPacket(this.ao(), deathMessage), PacketSendListener.a(() -> {
                int i2 = 256;
                String string = deathMessage.a(256);
                IChatMutableComponent component = IChatBaseComponent.a("death.attack.message_too_long", IChatBaseComponent.b(string).a(EnumChatFormat.o));
                IChatMutableComponent component1 = IChatBaseComponent.a("death.attack.even_more_magic", this.P_()).a(style -> style.a(new ChatHoverable.e(component)));
                return new ClientboundPlayerCombatKillPacket(this.ao(), component1);
            }));
            ScoreboardTeam team = this.cq();
            if (team == null || ((ScoreboardTeamBase)team).l() == ScoreboardTeamBase.EnumNameTagVisibility.a) {
                this.g.ag().a(deathMessage, false);
            } else if (((ScoreboardTeamBase)team).l() == ScoreboardTeamBase.EnumNameTagVisibility.c) {
                this.g.ag().a((EntityHuman)this, deathMessage);
            } else if (((ScoreboardTeamBase)team).l() == ScoreboardTeamBase.EnumNameTagVisibility.d) {
                this.g.ag().b(this, deathMessage);
            }
        } else {
            this.f.b(new ClientboundPlayerCombatKillPacket(this.ao(), CommonComponents.a));
        }
        this.gy();
        if (this.x().O().c(GameRules.P)) {
            this.gU();
        }
        if (event.shouldDropExperience()) {
            this.b(this.x(), cause.d());
        }
        if (!event.getKeepInventory()) {
            for (int i2 = 0; i2 < this.gj().i().size(); ++i2) {
                if (EntityPlayer.shouldKeepDeathEventItem(event, this.gj().i().get(i2))) continue;
                this.gj().i().set(i2, ItemStack.l);
            }
            for (EnumItemSlot value : EnumItemSlot.j) {
                if (!this.gj().k.has(value) || EntityPlayer.shouldKeepDeathEventItem(event, this.gj().k.a(value))) continue;
                this.gj().k.a(value, ItemStack.l);
            }
            if (!event.getItemsToKeep().isEmpty()) {
                for (org.bukkit.inventory.ItemStack itemStack : event.getItemsToKeep()) {
                    event.getEntity().getInventory().addItem(new org.bukkit.inventory.ItemStack[]{itemStack});
                }
            }
        }
        this.d((net.minecraft.world.entity.Entity)this);
        this.dV().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.e, this, ScoreAccess::b);
        EntityLiving killCredit = this.eT();
        if (killCredit != null) {
            this.b(StatisticList.h.b(killCredit.an()));
            killCredit.a((net.minecraft.world.entity.Entity)this, cause);
            this.e(killCredit);
        }
        this.dV().a((net.minecraft.world.entity.Entity)this, (byte)3);
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aF();
        this.k(0);
        this.c(false);
        this.eS().c();
        ((EntityHuman)this).a(Optional.of(GlobalPos.a(this.dV().aj(), this.dv())));
        this.v(false);
    }

    private void gU() {
        AxisAlignedBB aabb = new AxisAlignedBB(this.dv()).c(32.0, 10.0, 32.0);
        this.dV().a(EntityInsentient.class, aabb, IEntitySelector.f).stream().filter(mob -> mob instanceof IEntityAngerable).forEach(mob -> ((IEntityAngerable)((Object)mob)).a_(this.x(), this));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, DamageSource damageSource) {
        if (entity != this) {
            super.a(entity, damageSource);
            this.dV().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.g, this, ScoreAccess::b);
            if (entity instanceof EntityHuman) {
                this.a(StatisticList.Q);
                this.dV().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.f, this, ScoreAccess::b);
            } else {
                this.a(StatisticList.O);
            }
            this.a((ScoreHolder)this, (ScoreHolder)entity, IScoreboardCriteria.n);
            this.a((ScoreHolder)entity, (ScoreHolder)this, IScoreboardCriteria.o);
            CriterionTriggers.c.a(this, entity, damageSource);
        }
    }

    private void a(ScoreHolder scoreHolder, ScoreHolder teamMember, IScoreboardCriteria[] crtieria) {
        int id;
        ScoreboardTeam playersTeam = this.gA().e(teamMember.cI());
        if (playersTeam != null && (id = playersTeam.o().b()) >= 0 && id < crtieria.length) {
            this.dV().getCraftServer().getScoreboardManager().forAllObjectives(crtieria[id], scoreHolder, ScoreAccess::b);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        EntityHuman player1;
        EntityArrow abstractArrow;
        net.minecraft.world.entity.Entity entity;
        EntityHuman player;
        if (this.a(level, damageSource)) {
            return false;
        }
        net.minecraft.world.entity.Entity entity2 = damageSource.d();
        if (entity2 instanceof EntityHuman && !this.a(player = (EntityHuman)entity2) || entity2 instanceof EntityArrow && (entity = (abstractArrow = (EntityArrow)entity2).p()) instanceof EntityHuman && !this.a(player1 = (EntityHuman)entity)) {
            return false;
        }
        this.queueHealthUpdatePacket = true;
        boolean damaged = super.a(level, damageSource, amount);
        this.queueHealthUpdatePacket = false;
        if (this.queuedHealthUpdatePacket != null) {
            this.f.b(this.queuedHealthUpdatePacket);
            this.queuedHealthUpdatePacket = null;
        }
        return damaged;
    }

    @Override
    public boolean a(EntityHuman other) {
        return this.gV() && super.a(other);
    }

    private boolean gV() {
        return this.dV().pvpMode;
    }

    @Nullable
    public TeleportTransition findRespawnPositionAndUseSpawnBlock(boolean useCharge, TeleportTransition.a postTeleportTransition, @Nullable PlayerRespawnEvent.RespawnReason respawnReason) {
        TeleportTransition teleportTransition;
        boolean isBedSpawn = false;
        boolean isAnchorSpawn = false;
        RespawnConfig respawnConfig = this.S();
        WorldServer level = this.g.a(RespawnConfig.b(respawnConfig));
        if (level != null && respawnConfig != null) {
            Optional<RespawnPosAngle> optional = EntityPlayer.a(level, respawnConfig, useCharge);
            if (optional.isPresent()) {
                RespawnPosAngle respawnPosAngle = optional.get();
                isBedSpawn = respawnPosAngle.isBedSpawn();
                isAnchorSpawn = respawnPosAngle.isAnchorSpawn();
                teleportTransition = new TeleportTransition(level, respawnPosAngle.a(), Vec3D.c, respawnPosAngle.b(), 0.0f, postTeleportTransition);
            } else {
                teleportTransition = TeleportTransition.a(this.g.J(), this, postTeleportTransition);
            }
        } else {
            teleportTransition = new TeleportTransition(this.g.J(), this, postTeleportTransition);
        }
        if (respawnReason == null) {
            return teleportTransition;
        }
        CraftPlayer respawnPlayer = this.getBukkitEntity();
        Location location = CraftLocation.toBukkit(teleportTransition.c(), (World)teleportTransition.b().getWorld(), teleportTransition.e(), teleportTransition.f());
        PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent((Player)respawnPlayer, location, isBedSpawn, isAnchorSpawn, teleportTransition.g(), respawnReason);
        this.dV().getCraftServer().getPluginManager().callEvent((Event)respawnEvent);
        if (this.f.isDisconnected()) {
            return null;
        }
        location = respawnEvent.getRespawnLocation();
        return new TeleportTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3(location), teleportTransition.d(), location.getYaw(), location.getPitch(), teleportTransition.g(), teleportTransition.h(), teleportTransition.i(), teleportTransition.j(), teleportTransition.cause());
    }

    public static Optional<RespawnPosAngle> a(WorldServer level, RespawnConfig respawnConfig, boolean useCharge) {
        BlockPosition blockPos = respawnConfig.c;
        float f2 = respawnConfig.d;
        boolean flag = respawnConfig.e;
        IBlockData blockState = level.a_(blockPos);
        Block block = blockState.b();
        if (block instanceof BlockRespawnAnchor && (flag || blockState.c(BlockRespawnAnchor.d) > 0) && BlockRespawnAnchor.a(level)) {
            Optional<Vec3D> optional = BlockRespawnAnchor.a(EntityTypes.bT, level, blockPos);
            if (!flag && useCharge && optional.isPresent()) {
                level.a(blockPos, (IBlockData)blockState.b(BlockRespawnAnchor.d, blockState.c(BlockRespawnAnchor.d) - 1), 3);
            }
            return optional.map(pos -> RespawnPosAngle.of(pos, blockPos, false, true));
        }
        if (block instanceof BlockBed && BlockBed.a(level)) {
            return BlockBed.a(EntityTypes.bT, (ICollisionAccess)level, blockPos, blockState.c(BlockFacingHorizontal.e), f2).map(pos -> RespawnPosAngle.of(pos, blockPos, true, false));
        }
        if (!flag) {
            return Optional.empty();
        }
        boolean isPossibleToRespawnInThis = block.a(blockState);
        IBlockData blockState1 = level.a_(blockPos.d());
        boolean isPossibleToRespawnInThis1 = blockState1.b().a(blockState1);
        return isPossibleToRespawnInThis && isPossibleToRespawnInThis1 ? Optional.of(new RespawnPosAngle(new Vec3D((double)blockPos.u() + 0.5, (double)blockPos.v() + 0.1, (double)blockPos.w() + 0.5), f2, false, false)) : Optional.empty();
    }

    public void m() {
        this.al();
        this.x().a(this, Entity.RemovalReason.e);
        if (!this.k) {
            this.k = true;
            this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.f, 0.0f));
            this.i = true;
        }
    }

    @Nullable
    public EntityPlayer a(TeleportTransition teleportTransition) {
        TileEntity tileEntity;
        if (this.fR()) {
            return null;
        }
        if (this.dQ()) {
            return null;
        }
        if (teleportTransition.g()) {
            this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
        }
        WorldServer level = teleportTransition.b();
        WorldServer serverLevel = this.x();
        ResourceKey<WorldDimension> resourceKey = serverLevel.getTypeKey();
        Location enter = this.getBukkitEntity().getLocation();
        PositionMoveRotation absolutePosition = PositionMoveRotation.a(PositionMoveRotation.a(this), PositionMoveRotation.a(teleportTransition), teleportTransition.i());
        Location exit = CraftLocation.toBukkit(absolutePosition.a(), (World)level.getWorld(), absolutePosition.c(), absolutePosition.d());
        PlayerTeleportEvent tpEvent = new PlayerTeleportEvent((Player)this.getBukkitEntity(), enter, exit.clone(), teleportTransition.cause());
        if (this.as != null && this.as.a((BlockEndGateway)Blocks.ll) && (tileEntity = this.x().c_(this.as.c())) instanceof TileEntityEndGateway) {
            TileEntityEndGateway theEndGatewayBlockEntity = (TileEntityEndGateway)tileEntity;
            tpEvent = new PlayerTeleportEndGatewayEvent((Player)this.getBukkitEntity(), enter, exit.clone(), (EndGateway)new CraftEndGateway((World)this.x().getWorld(), theEndGatewayBlockEntity));
        }
        Bukkit.getServer().getPluginManager().callEvent((Event)tpEvent);
        Location newExit = tpEvent.getTo();
        if (tpEvent.isCancelled() || newExit == null) {
            return null;
        }
        if (!newExit.equals((Object)exit)) {
            level = ((CraftWorld)newExit.getWorld()).getHandle();
            teleportTransition = new TeleportTransition(level, CraftLocation.toVec3(newExit), Vec3D.c, newExit.getYaw(), newExit.getPitch(), teleportTransition.g(), teleportTransition.h(), Set.of(), teleportTransition.j(), teleportTransition.cause());
        }
        if (!teleportTransition.h()) {
            this.aa();
        }
        if (level != null && level.aj() == serverLevel.aj()) {
            this.f.internalTeleport(PositionMoveRotation.a(teleportTransition), teleportTransition.i());
            this.f.l();
            teleportTransition.j().onTransition(this);
            return this;
        }
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("moving");
        if (level != null && resourceKey == WorldDimension.b && level.getTypeKey() == WorldDimension.c) {
            this.cY = this.dt();
        }
        profilerFiller.c();
        profilerFiller.a("placing");
        this.cQ = true;
        WorldData worlddata = level.C_();
        this.f.b(new PacketPlayOutRespawn(this.b(level), 3));
        this.f.b(new PacketPlayOutServerDifficulty(worlddata.q(), worlddata.r()));
        PlayerList playerList = this.g.ag();
        playerList.e(this);
        serverLevel.a(this, Entity.RemovalReason.e);
        this.dS();
        this.a(level);
        this.f.internalTeleport(PositionMoveRotation.a(teleportTransition), teleportTransition.i());
        this.f.l();
        level.d(this);
        profilerFiller.c();
        this.g(serverLevel);
        this.fF();
        this.f.b(new PacketPlayOutAbilities(this.gk()));
        playerList.a(this, level);
        playerList.f(this);
        playerList.d(this);
        teleportTransition.j().onTransition(this);
        this.cK = -1;
        this.cH = -1.0f;
        this.cI = -1;
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((Player)this.getBukkitEntity(), (World)serverLevel.getWorld());
        this.dV().getCraftServer().getPluginManager().callEvent((Event)changeEvent);
        if (this.fG()) {
            this.fF();
        }
        return this;
    }

    @Override
    @Nullable
    public CraftPortalEvent callPortalEvent(net.minecraft.world.entity.Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        Location enter = this.getBukkitEntity().getLocation();
        PlayerPortalEvent event = new PlayerPortalEvent((Player)this.getBukkitEntity(), enter, exit, cause, searchRadius, true, creationRadius);
        event.callEvent();
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    @Override
    public void a(float yRot, float xRot) {
        this.f.b(new ClientboundPlayerRotationPacket(yRot, xRot));
    }

    public void g(WorldServer level) {
        ResourceKey<net.minecraft.world.level.World> resourceKey = level.aj();
        ResourceKey<net.minecraft.world.level.World> resourceKey1 = this.dV().aj();
        ResourceKey<net.minecraft.world.level.World> maindimensionkey = CraftDimensionUtil.getMainDimensionKey(level);
        ResourceKey<net.minecraft.world.level.World> maindimensionkey1 = CraftDimensionUtil.getMainDimensionKey(this.dV());
        if (GlobalConfiguration.get().misc.strictAdvancementDimensionCheck) {
            maindimensionkey = resourceKey;
            maindimensionkey1 = resourceKey1;
        }
        CriterionTriggers.w.a(this, maindimensionkey, maindimensionkey1);
        if (maindimensionkey != resourceKey || maindimensionkey1 != resourceKey1) {
            CriterionTriggers.w.a(this, resourceKey, resourceKey1);
        }
        if (maindimensionkey == net.minecraft.world.level.World.j && maindimensionkey1 == net.minecraft.world.level.World.i && this.cY != null) {
            CriterionTriggers.D.a(this, this.cY);
        }
        if (maindimensionkey1 != net.minecraft.world.level.World.j) {
            this.cY = null;
        }
    }

    @Override
    public boolean a(EntityPlayer player) {
        return player.ak() ? this.K() == this : !this.ak() && super.a(player);
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, int quantity) {
        super.a(entity, quantity);
        this.bR.d();
    }

    private Either<EntityHuman.EnumBedResult, Unit> getBedResult(BlockPosition at, EnumDirection direction) {
        if (this.fR() || !this.bJ()) {
            return Either.left(EntityHuman.EnumBedResult.e);
        }
        if (!this.dV().F_().j() && !this.dV().F_().l()) {
            return Either.left(EntityHuman.EnumBedResult.a);
        }
        if (!this.a(at, direction)) {
            return Either.left(EntityHuman.EnumBedResult.c);
        }
        if (this.b(at, direction)) {
            return Either.left(EntityHuman.EnumBedResult.d);
        }
        this.setRespawnPosition(new RespawnConfig(this.dV().aj(), at, this.dL(), false), true, PlayerSetSpawnEvent.Cause.BED);
        if (this.dV().V()) {
            return Either.left(EntityHuman.EnumBedResult.b);
        }
        if (!this.gz()) {
            double d2 = 8.0;
            double d1 = 5.0;
            Vec3D vec3 = Vec3D.c(at);
            List<EntityMonster> entitiesOfClass = this.dV().a(EntityMonster.class, new AxisAlignedBB(vec3.a() - 8.0, vec3.b() - 5.0, vec3.c() - 8.0, vec3.a() + 8.0, vec3.b() + 5.0, vec3.c() + 8.0), (? super T monster) -> monster.a(this.x(), this));
            if (!entitiesOfClass.isEmpty()) {
                return Either.left(EntityHuman.EnumBedResult.f);
            }
        }
        return Either.right(Unit.a);
    }

    @Override
    public Either<EntityHuman.EnumBedResult, Unit> startSleepInBed(BlockPosition at, boolean force) {
        EnumDirection direction = this.dV().a_(at).c(BlockFacingHorizontal.e);
        Either<EntityHuman.EnumBedResult, Unit> bedResult = this.getBedResult(at, direction);
        if (bedResult.left().orElse(null) == EntityHuman.EnumBedResult.e) {
            return bedResult;
        }
        if (force) {
            bedResult = Either.right(Unit.a);
        }
        if ((bedResult = CraftEventFactory.callPlayerBedEnterEvent(this, at, bedResult)).left().isPresent()) {
            return bedResult;
        }
        Either<EntityHuman.EnumBedResult, Unit> either = super.startSleepInBed(at, force).ifRight(unit -> {
            this.a(StatisticList.ap);
            CriterionTriggers.r.a(this);
        });
        if (!this.x().e()) {
            this.a(IChatBaseComponent.c("sleep.not_possible"), true);
        }
        ((WorldServer)this.dV()).f();
        return either;
    }

    @Override
    public void b(BlockPosition pos) {
        this.a(StatisticList.i.b(StatisticList.n));
        super.b(pos);
    }

    private boolean a(BlockPosition pos, EnumDirection direction) {
        return this.i(pos) || this.i(pos.a(direction.g()));
    }

    private boolean i(BlockPosition pos) {
        Vec3D vec3 = Vec3D.c(pos);
        return Math.abs(this.dA() - vec3.a()) <= 3.0 && Math.abs(this.dC() - vec3.b()) <= 2.0 && Math.abs(this.dG() - vec3.c()) <= 3.0;
    }

    private boolean b(BlockPosition pos, EnumDirection direction) {
        BlockPosition blockPos = pos.d();
        return !this.h(blockPos) || !this.h(blockPos.a(direction.g()));
    }

    @Override
    public void a(boolean wakeImmediately, boolean updateLevelForSleepingPlayers) {
        if (!this.fR()) {
            return;
        }
        CraftBlock bed = CraftBlock.at(this.dV(), this.fP().orElse(this.dv()));
        PlayerBedLeaveEvent event = new PlayerBedLeaveEvent((Player)this.getBukkitEntity(), (org.bukkit.block.Block)bed, true);
        if (!event.callEvent()) {
            return;
        }
        if (this.fR()) {
            this.x().m().a(this, new PacketPlayOutAnimation(this, 2));
        }
        super.a(wakeImmediately, updateLevelForSleepingPlayers);
        if (this.f != null) {
            this.f.teleport(this.dA(), this.dC(), this.dG(), this.dL(), this.dN(), PlayerTeleportEvent.TeleportCause.EXIT_BED);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource) {
        return super.a(level, damageSource) || this.P() && !damageSource.a(DamageTypes.m) || !this.gK() || !this.dV().paperConfig().collisions.allowPlayerCrammingDamage && damageSource.a(DamageTypes.h);
    }

    @Override
    protected void b(WorldServer level, BlockPosition pos) {
        if (!this.ak()) {
            super.b(level, pos);
        }
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
        if (this.dg && onGround && this.Z > 0.0) {
            Vec3D vec3 = pos.b().b(0.0, 0.5, 0.0);
            int i2 = (int)MathHelper.a(50.0 * this.Z, 0.0, 200.0);
            this.x().a(new ParticleParamBlock(Particles.b, state), vec3.d, vec3.e, vec3.f, i2, (double)0.3f, (double)0.3f, (double)0.3f, (double)0.15f);
            this.dg = false;
        }
        super.a(y2, onGround, state, pos);
    }

    @Override
    public void b_(@Nullable net.minecraft.world.entity.Entity entity) {
        super.b_(entity);
        this.cm = this.dt();
        this.cn = entity;
        this.w(entity != null && entity.an() == EntityTypes.bI);
    }

    @Override
    protected void n() {
        if (this.dV().u().i()) {
            super.n();
        }
    }

    @Override
    public void a(TileEntitySign signEntity, boolean isFrontText) {
        this.f.b(new PacketPlayOutBlockChange(this.dV(), signEntity.ax_()));
        this.f.b(new PacketPlayOutOpenSignEditor(signEntity.ax_(), isFrontText));
    }

    public int nextContainerCounter() {
        this.dq = this.dq % 100 + 1;
        return this.dq;
    }

    @Override
    public OptionalInt a(@Nullable ITileInventory menu) {
        if (menu == null) {
            return OptionalInt.empty();
        }
        this.nextContainerCounter();
        Container abstractContainerMenu = menu.createMenu(this.dq, this.gj(), this);
        IChatBaseComponent title = null;
        if (abstractContainerMenu != null) {
            abstractContainerMenu.setTitle(menu.P_());
            boolean cancelled = false;
            Pair<Component, Container> result = CraftEventFactory.callInventoryOpenEventWithTitle(this, abstractContainerMenu, cancelled);
            abstractContainerMenu = (Container)result.getSecond();
            title = PaperAdventure.asVanilla((Component)result.getFirst());
            if (abstractContainerMenu == null && !cancelled) {
                if (menu instanceof IInventory) {
                    IInventory container = (IInventory)((Object)menu);
                    container.c(this);
                } else if (menu instanceof BlockChest.DoubleInventory) {
                    BlockChest.DoubleInventory doubleInventory = (BlockChest.DoubleInventory)menu;
                    doubleInventory.container.c(this);
                } else if (!this.bP.b((TileEntityEnderChest)null)) {
                    this.bP.c(this);
                }
                return OptionalInt.empty();
            }
        }
        if (abstractContainerMenu == null) {
            if (this.ak()) {
                this.a(IChatBaseComponent.c("container.spectatorCantOpen").a(EnumChatFormat.m), true);
            }
            return OptionalInt.empty();
        }
        this.bR = abstractContainerMenu;
        if (!this.fg()) {
            this.f.b(new PacketPlayOutOpenWindow(abstractContainerMenu.l, abstractContainerMenu.a(), Objects.requireNonNullElseGet(title, abstractContainerMenu::getTitle)));
        }
        this.a(abstractContainerMenu);
        return OptionalInt.of(this.dq);
    }

    @Override
    public void a(int containerId, MerchantRecipeList offers, int level, int xp, boolean flag, boolean flag1) {
        this.f.b(new PacketPlayOutOpenWindowMerchant(containerId, offers, level, xp, flag, flag1));
    }

    @Override
    public void a(EntityHorseAbstract horse, IInventory inventory) {
        this.nextContainerCounter();
        Container container = new ContainerHorse(this.dq, this.gj(), inventory, horse, horse.ab_());
        container.setTitle(horse.P_());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            inventory.c(this);
            return;
        }
        if (this.bR != this.bQ) {
            this.closeContainer(InventoryCloseEvent.Reason.OPEN_NEW);
        }
        int inventoryColumns = horse.ab_();
        this.f.b(new PacketPlayOutOpenWindowHorse(this.dq, inventoryColumns, horse.ao()));
        this.bR = container;
        this.a(this.bR);
    }

    @Override
    public void a(ItemStack stack, EnumHand hand) {
        if (stack.c(DataComponents.V)) {
            if (WrittenBookContent.a(stack, this.z(), this)) {
                this.bR.d();
            }
            this.f.b(new PacketPlayOutOpenBook(hand));
        }
    }

    @Override
    public void a(TileEntityCommand commandBlock) {
        this.f.b(PacketPlayOutTileEntityData.a(commandBlock, TileEntity::e));
    }

    @Override
    public void o() {
        this.closeContainer(InventoryCloseEvent.Reason.UNKNOWN);
    }

    @Override
    public void closeContainer(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.f.b(new PacketPlayOutCloseWindow(this.bR.l));
        this.p();
    }

    @Override
    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.f.b(new PacketPlayOutCloseWindow(this.bR.l));
        this.bR = this.bQ;
    }

    @Override
    public void p() {
        this.bR.a(this);
        this.bQ.a(this.bR);
        this.bR = this.bQ;
    }

    @Override
    public void q() {
        double x2 = this.dA();
        double y2 = this.dC();
        double z2 = this.dG();
        super.q();
        this.q(this.dA() - x2, this.dC() - y2, this.dG() - z2);
    }

    public void a(double dx, double dy, double dz) {
        if (!this.bY() && !EntityPlayer.r(dx, dy, dz)) {
            if (this.cj()) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                if (rounded > 0) {
                    this.a(StatisticList.C, rounded);
                    this.causeFoodExhaustion(this.dV().spigotConfig.swimMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.SWIM);
                }
            } else if (((net.minecraft.world.entity.Entity)this).a(TagsFluid.a)) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                if (rounded > 0) {
                    this.a(StatisticList.w, rounded);
                    this.causeFoodExhaustion(this.dV().spigotConfig.swimMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_UNDERWATER);
                }
            } else if (this.bi()) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (rounded > 0) {
                    this.a(StatisticList.s, rounded);
                    this.causeFoodExhaustion(this.dV().spigotConfig.swimMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_ON_WATER);
                }
            } else if (this.k_()) {
                if (dy > 0.0) {
                    this.a(StatisticList.u, (int)Math.round(dy * 100.0));
                }
            } else if (this.aH()) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (rounded > 0) {
                    if (this.ci()) {
                        this.a(StatisticList.r, rounded);
                        this.causeFoodExhaustion(this.dV().spigotConfig.sprintMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.SPRINT);
                    } else if (this.ch()) {
                        this.a(StatisticList.q, rounded);
                        this.causeFoodExhaustion(this.dV().spigotConfig.otherMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.CROUCH);
                    } else {
                        this.a(StatisticList.p, rounded);
                        this.causeFoodExhaustion(this.dV().spigotConfig.otherMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK);
                    }
                }
            } else if (this.fJ()) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                this.a(StatisticList.B, rounded);
            } else {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (rounded > 25) {
                    this.a(StatisticList.v, rounded);
                }
            }
        }
    }

    private void q(double dx, double dy, double dz) {
        if (this.bY() && !EntityPlayer.r(dx, dy, dz)) {
            int rounded = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
            net.minecraft.world.entity.Entity vehicle = this.dk();
            if (vehicle instanceof EntityMinecartAbstract) {
                this.a(StatisticList.x, rounded);
            } else if (vehicle instanceof AbstractBoat) {
                this.a(StatisticList.y, rounded);
            } else if (vehicle instanceof EntityPig) {
                this.a(StatisticList.z, rounded);
            } else if (vehicle instanceof EntityHorseAbstract) {
                this.a(StatisticList.A, rounded);
            } else if (vehicle instanceof EntityStrider) {
                this.a(StatisticList.D, rounded);
            }
        }
    }

    private static boolean r(double dx, double dy, double dz) {
        return dx == 0.0 && dy == 0.0 && dz == 0.0;
    }

    @Override
    public void a(Statistic<?> stat, int amount) {
        this.cA.b(this, stat, amount);
        this.dV().getCraftServer().getScoreboardManager().forAllObjectives(stat, this, score -> score.b(amount));
    }

    @Override
    public void a(Statistic<?> stat) {
        this.cA.a(this, stat, 0);
        this.dV().getCraftServer().getScoreboardManager().forAllObjectives(stat, this, ScoreAccess::c);
    }

    @Override
    public int a(Collection<RecipeHolder<?>> recipes) {
        return this.cR.a(recipes, this);
    }

    @Override
    public void a(RecipeHolder<?> recipe, List<ItemStack> items) {
        CriterionTriggers.ac.a(this, recipe.a(), items);
    }

    @Override
    public void b(List<ResourceKey<IRecipe<?>>> recipes) {
        List<RecipeHolder<?>> list = recipes.stream().flatMap(key -> this.g.aI().b((ResourceKey<IRecipe<?>>)key).stream()).collect(Collectors.toList());
        this.a((Collection<RecipeHolder<?>>)list);
    }

    @Override
    public int b(Collection<RecipeHolder<?>> recipes) {
        return this.cR.b(recipes, this);
    }

    @Override
    public void r() {
        super.r();
        this.a(StatisticList.E);
        if (this.ci()) {
            this.causeFoodExhaustion(this.dV().spigotConfig.jumpSprintExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(this.dV().spigotConfig.jumpWalkExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void d(int xpPoints) {
        super.d(xpPoints);
        this.cK = -1;
    }

    public void s() {
        this.cU = true;
        this.bN();
        if (this.bY() && this.dk() instanceof EntityPlayer) {
            this.bO();
        }
        if (this.fR()) {
            this.a(true, false);
        }
    }

    public boolean t() {
        return this.cU;
    }

    public void u() {
        this.cH = -1.0E8f;
        this.cK = -1;
    }

    @Override
    public void a(IChatBaseComponent chatComponent, boolean actionBar) {
        this.b(chatComponent, actionBar);
    }

    @Override
    public void v() {
        if (!this.bm.f() && this.fz()) {
            this.f.b(new PacketPlayOutEntityStatus(this, 9));
            super.v();
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor anchor, Vec3D target) {
        super.a(anchor, target);
        this.f.b(new PacketPlayOutLookAt(anchor, target.d, target.e, target.f));
    }

    public void a(ArgumentAnchor.Anchor fromAnchor, net.minecraft.world.entity.Entity entity, ArgumentAnchor.Anchor toAnchor) {
        Vec3D vec3 = toAnchor.a(entity);
        super.a(fromAnchor, vec3);
        this.f.b(new PacketPlayOutLookAt(fromAnchor, entity, toAnchor));
    }

    public void a(EntityPlayer that, boolean keepEverything) {
        this.dh = that.dh;
        this.do = that.do;
        this.h.a(that.h.b(), that.h.c());
        this.w();
        if (keepEverything) {
            this.fa().b(that.fa());
            this.d(that.eG());
            this.bS = that.bS;
            for (MobEffect mobEffect : that.eD()) {
            }
            this.gj().a(that.gj());
            this.cf = that.cf;
            this.cg = that.cg;
            this.ch = that.ch;
            this.q(that.gd());
            this.as = that.as;
        } else {
            this.fa().b(that.fa());
            if (this.x().O().c(GameRules.e) || that.ak()) {
                this.gj().a(that.gj());
                this.cf = that.cf;
                this.cg = that.cg;
                this.ch = that.ch;
                this.q(that.gd());
            }
        }
        this.ci = that.ci;
        this.bP = that.bP;
        this.ar().a(EntityHuman.bK, that.ar().a(EntityHuman.bK));
        this.cK = -1;
        this.cH = -1.0f;
        this.cI = -1;
        this.i = that.i;
        this.cY = that.cY;
        this.db = that.db;
        this.k(that.gC());
        this.l(that.gD());
        ((EntityHuman)this).a(that.gJ());
    }

    @Override
    protected void a(MobEffect effectInstance, @Nullable net.minecraft.world.entity.Entity entity) {
        super.a(effectInstance, entity);
        this.f.b(new PacketPlayOutEntityEffect(this.ao(), effectInstance, true));
        if (effectInstance.a(MobEffects.y)) {
            this.cT = this.af;
            this.cS = this.dt();
        }
        CriterionTriggers.B.a(this, entity);
    }

    @Override
    protected void a(MobEffect effectInstance, boolean forced, @Nullable net.minecraft.world.entity.Entity entity) {
        super.a(effectInstance, forced, entity);
        this.f.b(new PacketPlayOutEntityEffect(this.ao(), effectInstance, false));
        CriterionTriggers.B.a(this, entity);
    }

    @Override
    protected void c(Collection<MobEffect> effects) {
        super.c(effects);
        for (MobEffect mobEffectInstance : effects) {
            this.f.b(new PacketPlayOutRemoveEntityEffect(this.ao(), mobEffectInstance.c()));
            if (!mobEffectInstance.a(MobEffects.y)) continue;
            this.cS = null;
        }
        CriterionTriggers.B.a(this, (net.minecraft.world.entity.Entity)null);
    }

    @Override
    public void b(double x2, double y2, double z2) {
        this.f.a(new PositionMoveRotation(new Vec3D(x2, y2, z2), Vec3D.c, 0.0f, 0.0f), Relative.a(Relative.l, Relative.k));
    }

    @Override
    public void c(double dx, double dy, double dz) {
        this.f.a(new PositionMoveRotation(new Vec3D(dx, dy, dz), Vec3D.c, 0.0f, 0.0f), Relative.j);
    }

    @Override
    public boolean teleportTo(WorldServer level, double x2, double y2, double z2, Set<Relative> relativeMovements, float yaw, float pitch, boolean setCamera, PlayerTeleportEvent.TeleportCause cause) {
        boolean flag;
        if (this.fR()) {
            this.a(true, true);
        }
        if (setCamera) {
            this.d((net.minecraft.world.entity.Entity)this);
        }
        if (flag = super.teleportTo(level, x2, y2, z2, relativeMovements, yaw, pitch, setCamera, cause)) {
            this.r(relativeMovements.contains((Object)Relative.d) ? this.cA() + yaw : yaw);
        }
        return flag;
    }

    @Override
    public void d(double x2, double y2, double z2) {
        super.d(x2, y2, z2);
        this.f.l();
    }

    @Override
    public void b(net.minecraft.world.entity.Entity entityHit) {
        this.x().m().a(this, new PacketPlayOutAnimation(entityHit, 4));
    }

    @Override
    public void c(net.minecraft.world.entity.Entity entityHit) {
        this.x().m().a(this, new PacketPlayOutAnimation(entityHit, 5));
    }

    @Override
    public void w() {
        if (this.f != null) {
            this.f.b(new PacketPlayOutAbilities(this.gk()));
            this.J();
        }
    }

    public WorldServer x() {
        return (WorldServer)this.dV();
    }

    public boolean a(EnumGamemode gameMode) {
        PlayerGameModeChangeEvent event = this.setGameMode(gameMode, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        return event == null ? false : event.isCancelled();
    }

    @Nullable
    public PlayerGameModeChangeEvent setGameMode(EnumGamemode gameMode, PlayerGameModeChangeEvent.Cause cause, @Nullable Component message) {
        boolean isSpectator = this.ak();
        PlayerGameModeChangeEvent event = this.h.changeGameModeForPlayer(gameMode, cause, message);
        if (event == null || event.isCancelled()) {
            return null;
        }
        this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.e, gameMode.a()));
        if (gameMode == EnumGamemode.d) {
            this.gy();
            this.bO();
            EnchantmentManager.a(this);
        } else {
            this.d((net.minecraft.world.entity.Entity)this);
            if (isSpectator) {
                EnchantmentManager.a(this.x(), (EntityLiving)this);
            }
        }
        this.w();
        this.fx();
        return event;
    }

    @Override
    @Nonnull
    public EnumGamemode a() {
        return this.h.b();
    }

    public ICommandListener y() {
        return this.dp;
    }

    public CommandListenerWrapper z() {
        return new CommandListenerWrapper(this.y(), this.dt(), this.bT(), this.x(), this.F(), this.ah().getString(), this.P_(), this.g, this);
    }

    public void a(IChatBaseComponent mesage) {
        this.b(mesage, false);
    }

    public void b(IChatBaseComponent message, boolean overlay) {
        if (this.x(overlay)) {
            this.f.a(new ClientboundSystemChatPacket(message, overlay), PacketSendListener.a(() -> {
                if (this.x(false)) {
                    int i2 = 256;
                    String string = message.a(256);
                    IChatMutableComponent component = IChatBaseComponent.b(string).a(EnumChatFormat.o);
                    return new ClientboundSystemChatPacket(IChatBaseComponent.a("multiplayer.message_not_delivered", component).a(EnumChatFormat.m), false);
                }
                return null;
            }));
        }
    }

    public void a(OutgoingChatMessage message, boolean filtered, ChatMessageType.a boundType) {
        this.sendChatMessage(message, filtered, boundType, null);
    }

    public void sendChatMessage(OutgoingChatMessage message, boolean filtered, ChatMessageType.a boundType, @Nullable IChatBaseComponent unsigned) {
        if (this.gX()) {
            message.sendToPlayer(this, filtered, boundType, unsigned);
        }
    }

    public String A() {
        String string;
        SocketAddress socketAddress = this.f.m();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            string = InetAddresses.toAddrString((InetAddress)inetSocketAddress.getAddress());
        } else {
            string = "<unknown>";
        }
        return string;
    }

    public void a(ClientInformation clientInformation) {
        PlayerChangedMainHandEvent event;
        new PlayerClientOptionsChangeEvent((Player)this.getBukkitEntity(), (Map)SystemUtils.a(new IdentityHashMap(), (? super T map) -> {
            map.put(ClientOption.LOCALE, clientInformation.b());
            map.put(ClientOption.VIEW_DISTANCE, clientInformation.c());
            map.put(ClientOption.CHAT_VISIBILITY, ClientOption.ChatVisibility.valueOf((String)clientInformation.d().name()));
            map.put(ClientOption.CHAT_COLORS_ENABLED, clientInformation.e());
            map.put(ClientOption.SKIN_PARTS, new PaperSkinParts(clientInformation.f()));
            map.put(ClientOption.MAIN_HAND, clientInformation.g() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            map.put(ClientOption.TEXT_FILTERING_ENABLED, clientInformation.h());
            map.put(ClientOption.ALLOW_SERVER_LISTINGS, clientInformation.i());
            map.put(ClientOption.PARTICLE_VISIBILITY, ClientOption.ParticleVisibility.valueOf((String)clientInformation.j().name()));
        })).callEvent();
        if (this.fy() != clientInformation.g()) {
            event = new PlayerChangedMainHandEvent((Player)this.getBukkitEntity(), clientInformation.g() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            this.g.server.getPluginManager().callEvent((Event)event);
        }
        if (this.cW == null || !this.cW.equals(clientInformation.b())) {
            event = new PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), clientInformation.b());
            this.g.server.getPluginManager().callEvent((Event)event);
        }
        this.updateOptionsNoEvents(clientInformation);
    }

    public void updateOptionsNoEvents(ClientInformation clientInformation) {
        this.cW = clientInformation.b();
        this.adventure$locale = Objects.requireNonNullElse(Translator.parseLocale((String)this.cW), Locale.US);
        this.cV = clientInformation.c();
        this.cL = clientInformation.d();
        this.cN = clientInformation.e();
        this.de = clientInformation.h();
        this.df = clientInformation.i();
        this.cM = clientInformation.j();
        this.ar().a(EntityHuman.bK, (byte)clientInformation.f());
        this.ar().a(EntityHuman.bL, (byte)clientInformation.g().b());
    }

    public ClientInformation B() {
        byte i2 = this.ar().a(EntityHuman.bK);
        EnumMainHand humanoidArm = EnumMainHand.d.apply(this.ar().a(EntityHuman.bL).byteValue());
        return new ClientInformation(this.cW, this.cV, this.cL, this.cN, i2, humanoidArm, this.de, this.df, this.cM);
    }

    public boolean C() {
        return this.cN;
    }

    public EnumChatVisibility D() {
        return this.cL;
    }

    private boolean x(boolean overlay) {
        return this.cL != EnumChatVisibility.c || overlay;
    }

    private boolean gX() {
        return this.cL == EnumChatVisibility.a;
    }

    public int E() {
        return this.cV;
    }

    public void a(ServerPing serverStatus) {
        this.f.b(new ClientboundServerDataPacket(serverStatus.a(), serverStatus.d().map(ServerPing.a::a)));
    }

    @Override
    public int F() {
        return this.g.c(this.gi());
    }

    @Override
    public void G() {
        this.cO = SystemUtils.c();
    }

    public ServerStatisticManager H() {
        return this.cA;
    }

    public RecipeBookServer I() {
        return this.cR;
    }

    @Override
    protected void J() {
        if (this.ak()) {
            this.eB();
            this.k(true);
        } else {
            super.J();
        }
    }

    public net.minecraft.world.entity.Entity K() {
        return this.cP == null ? this : this.cP;
    }

    public void d(@Nullable net.minecraft.world.entity.Entity entityToSpectate) {
        net.minecraft.world.entity.Entity camera = this.K();
        net.minecraft.world.entity.Entity entity = this.cP = entityToSpectate == null ? this : entityToSpectate;
        if (camera != this.cP) {
            net.minecraft.world.level.World world;
            if (this.cP == this) {
                PlayerStopSpectatingEntityEvent playerStopSpectatingEntityEvent = new PlayerStopSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)camera.getBukkitEntity());
                if (!playerStopSpectatingEntityEvent.callEvent()) {
                    this.cP = camera;
                    return;
                }
            } else {
                PlayerStartSpectatingEntityEvent playerStartSpectatingEntityEvent = new PlayerStartSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)camera.getBukkitEntity(), (Entity)entityToSpectate.getBukkitEntity());
                if (!playerStartSpectatingEntityEvent.callEvent()) {
                    this.cP = camera;
                    return;
                }
            }
            if ((world = this.cP.dV()) instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                this.teleportTo(serverLevel, this.cP.dA(), this.cP.dC(), this.cP.dG(), Set.of(), this.dL(), this.dN(), false, PlayerTeleportEvent.TeleportCause.SPECTATE);
            }
            if (entityToSpectate != null) {
                this.x().m().a(this);
            }
            this.f.b(new PacketPlayOutCamera(this.cP));
            this.f.l();
        }
    }

    @Override
    protected void L() {
        if (!this.cQ) {
            super.L();
        }
    }

    @Override
    public void e(net.minecraft.world.entity.Entity targetEntity) {
        if (this.ak()) {
            this.d(targetEntity);
        } else {
            super.e(targetEntity);
        }
    }

    public long M() {
        return this.cO;
    }

    @Nullable
    public IChatBaseComponent N() {
        return this.listName;
    }

    public int O() {
        return this.listOrder;
    }

    @Override
    public void a(EnumHand hand) {
        super.a(hand);
        this.gF();
    }

    public boolean P() {
        return this.cQ;
    }

    public void Q() {
        this.cQ = false;
    }

    public AdvancementDataPlayer R() {
        return this.cz;
    }

    @Nullable
    public RespawnConfig S() {
        return this.dc;
    }

    public void b(EntityPlayer player) {
        this.a(player.dc, false);
    }

    public void a(@Nullable RespawnConfig respawnConfig, boolean displayInChat) {
        this.setRespawnPosition(respawnConfig, displayInChat, PlayerSetSpawnEvent.Cause.UNKNOWN);
    }

    public boolean setRespawnPosition(@Nullable RespawnConfig respawnConfig, boolean displayInChat, PlayerSetSpawnEvent.Cause cause) {
        Location spawnLoc = null;
        boolean actuallyDisplayInChat = false;
        if (respawnConfig != null) {
            actuallyDisplayInChat = displayInChat && !respawnConfig.a(this.dc);
            spawnLoc = CraftLocation.toBukkit(respawnConfig.b(), (net.minecraft.world.level.World)this.cV().a(respawnConfig.a()));
            spawnLoc.setYaw(respawnConfig.c());
        }
        PlayerSpawnChangeEvent dumbEvent = new PlayerSpawnChangeEvent((Player)this.getBukkitEntity(), spawnLoc, respawnConfig != null && respawnConfig.d(), cause == PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN ? PlayerSpawnChangeEvent.Cause.RESET : PlayerSpawnChangeEvent.Cause.valueOf((String)cause.name()));
        dumbEvent.callEvent();
        PlayerSetSpawnEvent event = new PlayerSetSpawnEvent((Player)this.getBukkitEntity(), cause, dumbEvent.getNewSpawn(), dumbEvent.isForced(), actuallyDisplayInChat, actuallyDisplayInChat ? PaperAdventure.asAdventure(cw) : null);
        event.setCancelled(dumbEvent.isCancelled());
        if (!event.callEvent()) {
            return false;
        }
        if (event.getLocation() != null) {
            respawnConfig = new RespawnConfig(((CraftWorld)event.getLocation().getWorld()).getHandle().aj(), CraftLocation.toBlockPosition(event.getLocation()), event.getLocation().getYaw(), event.isForced());
            if (event.willNotifyPlayer() && event.getNotification() != null) {
                this.a(PaperAdventure.asVanilla(event.getNotification()));
            }
        }
        this.dc = respawnConfig;
        return true;
    }

    public SectionPosition T() {
        return this.da;
    }

    public void a(SectionPosition sectionPos) {
        this.da = sectionPos;
    }

    public ChunkTrackingView U() {
        return this.db;
    }

    public void a(ChunkTrackingView chunkTrackingView) {
        this.db = chunkTrackingView;
    }

    @Override
    public void a(SoundEffect sound, SoundCategory source, float volume, float pitch) {
        this.f.b(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.b.e(sound), source, this.dA(), this.dC(), this.dG(), volume, pitch, this.ae.g()));
    }

    @Override
    public EntityItem drop(ItemStack droppedItem, boolean dropAround, boolean traceItem, boolean callEvent, @Nullable Consumer<Item> entityOperation) {
        WorldMap mapData;
        ItemStack itemStack;
        EntityItem itemEntity = super.drop(droppedItem, dropAround, traceItem, callEvent, entityOperation);
        ItemStack itemStack2 = itemStack = itemEntity != null ? itemEntity.e() : ItemStack.l;
        if (traceItem && !itemStack.f()) {
            this.a(StatisticList.f.b(itemStack.h()), droppedItem.M());
            this.a(StatisticList.F);
        }
        if (itemStack.a(Items.tc) && (mapData = ItemWorldMap.b(itemStack, this.dV())) != null) {
            mapData.a(this, itemStack);
        }
        return itemEntity;
    }

    public ITextFilter V() {
        return this.dd;
    }

    public void a(WorldServer level) {
        this.a((net.minecraft.world.level.World)level);
        this.h.a(level);
    }

    @Nullable
    private static EnumGamemode a(@Nullable NBTTagCompound tag, String key) {
        return tag != null ? (EnumGamemode)tag.a(key, EnumGamemode.g).orElse(null) : null;
    }

    private EnumGamemode b(@Nullable EnumGamemode gameType) {
        EnumGamemode forcedGameType = this.g.bd();
        if (forcedGameType != null) {
            return forcedGameType;
        }
        return gameType != null ? gameType : this.g.u();
    }

    public void e(@Nullable NBTTagCompound tag) {
        if (this.g.bd() != null && this.g.bd() != EntityPlayer.a(tag, "playerGameType")) {
            if (new PlayerGameModeChangeEvent((Player)this.getBukkitEntity(), GameMode.getByValue((int)this.g.u().a()), PlayerGameModeChangeEvent.Cause.DEFAULT_GAMEMODE, null).callEvent()) {
                this.h.a(this.g.bd(), EnumGamemode.e);
            } else {
                this.h.a(EntityPlayer.a(tag, "playerGameType"), EntityPlayer.a(tag, "previousPlayerGameType"));
            }
            return;
        }
        this.h.a(this.b(EntityPlayer.a(tag, "playerGameType")), EntityPlayer.a(tag, "previousPlayerGameType"));
    }

    private void p(NBTTagCompound tag) {
        tag.a("playerGameType", EnumGamemode.g, this.h.b());
        EnumGamemode previousGameModeForPlayer = this.h.c();
        tag.b("previousPlayerGameType", EnumGamemode.g, previousGameModeForPlayer);
    }

    @Override
    public boolean W() {
        return this.de;
    }

    public boolean c(EntityPlayer player) {
        return player != this && (this.de || player.de);
    }

    @Override
    public boolean c(WorldServer level, BlockPosition pos) {
        return super.c(level, pos) && level.a((net.minecraft.world.entity.Entity)this, pos);
    }

    @Override
    protected void a(ItemStack usingItem) {
        CriterionTriggers.W.a(this, usingItem);
        super.a(usingItem);
    }

    public boolean a(boolean dropStack) {
        PlayerInventory inventory = this.gj();
        ItemStack itemStack = inventory.a(dropStack);
        this.bR.b(inventory, inventory.f()).ifPresent(slot -> this.bR.a(slot, inventory.g()));
        return this.a(itemStack, false, true) != null;
    }

    @Override
    public void b(ItemStack stack) {
        if (!this.gj().g(stack)) {
            this.a(stack, false);
        }
    }

    public boolean X() {
        return this.df;
    }

    @Override
    public Optional<WardenSpawnTracker> Y() {
        return Optional.of(this.dh);
    }

    public void b(boolean spawnExtraParticlesOnFall) {
        this.dg = spawnExtraParticlesOnFall;
    }

    @Override
    public void a(EntityItem itemEntity) {
        super.a(itemEntity);
        net.minecraft.world.entity.Entity owner = itemEntity.p();
        if (owner != null) {
            CriterionTriggers.S.a(this, itemEntity.e(), owner);
        }
    }

    public void a(RemoteChatSession chatSession) {
        this.do = chatSession;
    }

    @Nullable
    public RemoteChatSession Z() {
        return this.do != null && this.do.b() ? null : this.do;
    }

    @Override
    public void a(double xDistance, double zDistance) {
        this.cl = (float)(MathHelper.d(zDistance, xDistance) * 180.0 / 3.1415927410125732 - (double)this.dL());
        this.f.b(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean a(net.minecraft.world.entity.Entity vehicle, boolean force) {
        if (super.a(vehicle, force)) {
            vehicle.j(this);
            this.f.a(new PositionMoveRotation(this.dt(), Vec3D.c, 0.0f, 0.0f), Relative.k);
            if (vehicle instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)vehicle;
                this.g.ag().a(livingEntity, this.f);
            }
            this.f.b(new PacketPlayOutMount(vehicle));
            return true;
        }
        return false;
    }

    @Override
    public void aa() {
        this.removeVehicle(false);
    }

    @Override
    public void removeVehicle(boolean suppressCancellation) {
        net.minecraft.world.entity.Entity vehicle = this.dk();
        super.removeVehicle(suppressCancellation);
        if (vehicle instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)vehicle;
            for (MobEffect mobEffectInstance : livingEntity.eD()) {
                this.f.b(new PacketPlayOutRemoveEntityEffect(vehicle.ao(), mobEffectInstance.c()));
            }
        }
        if (vehicle != null) {
            this.f.b(new PacketPlayOutMount(vehicle));
        }
    }

    public CommonPlayerSpawnInfo b(WorldServer level) {
        return new CommonPlayerSpawnInfo(level.ai(), level.aj(), BiomeManager.a(level.E()), this.h.b(), this.h.c(), level.ak(), level.D(), this.gJ(), this.az(), level.P());
    }

    public void c(BlockPosition raidOmenPosition) {
        this.di = raidOmenPosition;
    }

    public void ab() {
        this.di = null;
    }

    @Nullable
    public BlockPosition ac() {
        return this.di;
    }

    @Override
    public Vec3D ad() {
        net.minecraft.world.entity.Entity vehicle = this.dk();
        return vehicle != null && vehicle.cW() != this ? vehicle.ad() : this.dj;
    }

    public void a(Vec3D knownMovement) {
        this.dj = knownMovement;
    }

    @Override
    protected float a(net.minecraft.world.entity.Entity entity, float damage, DamageSource damageSource) {
        return EnchantmentManager.a(this.x(), this.dZ(), entity, damageSource, damage);
    }

    @Override
    public void a(net.minecraft.world.item.Item item, EnumItemSlot slot) {
        super.a(item, slot);
        this.b(StatisticList.d.b(item));
    }

    public Input ae() {
        return this.dk;
    }

    public void a(Input lastClientInput) {
        this.dk = lastClientInput;
    }

    public Vec3D af() {
        float f2;
        float f3 = this.dk.c() == this.dk.d() ? 0.0f : (f2 = this.dk.c() ? 1.0f : -1.0f);
        float f1 = this.dk.a() == this.dk.b() ? 0.0f : (this.dk.a() ? 1.0f : -1.0f);
        return EntityPlayer.a(new Vec3D(f2, 0.0, f1), 1.0f, this.dL());
    }

    public void a(EntityEnderPearl enderPearl) {
        this.dl.add(enderPearl);
    }

    public void b(EntityEnderPearl enderPearl) {
        this.dl.remove(enderPearl);
    }

    public Set<EntityEnderPearl> ag() {
        return this.dl;
    }

    public long c(EntityEnderPearl enderPearl) {
        net.minecraft.world.level.World world = enderPearl.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            ChunkCoordIntPair chunkPos = enderPearl.dx();
            this.a(enderPearl);
            serverLevel.i();
            return EntityPlayer.a(serverLevel, chunkPos) - 1L;
        }
        return 0L;
    }

    public static long a(WorldServer level, ChunkCoordIntPair pos) {
        if (!level.paperConfig().misc.legacyEnderPearlBehavior) {
            level.m().a(TicketType.h, pos, 2);
        }
        return TicketType.h.d();
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.dV().af() + this.timeOffset;
        }
        return this.dV().af() - this.dV().af() % 24000L + this.timeOffset;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weatherType != null) {
            return;
        }
        if (plugin) {
            this.weatherType = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.d, 0.0f));
        } else {
            this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.c, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weatherType == null) {
            if (oldRain != newRain) {
                this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weatherType == WeatherType.DOWNFALL || this.weatherType == null) {
                this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, newThunder));
            } else {
                this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weatherType == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weatherType == WeatherType.DOWNFALL ? (this.pluginRainPosition += 0.01f) : (this.pluginRainPosition -= 0.01f);
        this.pluginRainPosition = MathHelper.a(this.pluginRainPosition, 0.0f, 1.0f);
    }

    public void resetPlayerWeather() {
        this.weatherType = null;
        this.setPlayerWeather(this.dV().C_().i() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.cI() + " at " + this.dA() + "," + this.dC() + "," + this.dG() + ")";
    }

    public void forceSetPositionRotation(double x2, double y2, double z2, float yaw, float pitch) {
        this.b(x2, y2, z2, yaw, pitch);
        this.f.l();
    }

    @Override
    public boolean fg() {
        return super.fg() || this.f != null && this.f.isDisconnected();
    }

    @Override
    public Scoreboard gA() {
        return this.getBukkitEntity().getScoreboard().getHandle();
    }

    public void reset() {
        float exp = 0.0f;
        if (this.keepLevel) {
            exp = this.ch;
            this.newTotalExp = this.cg;
            this.newLevel = this.cf;
        }
        this.d(this.eU());
        this.fF();
        this.j(this.cr());
        this.h(0);
        this.Z = 0.0;
        this.bS = new FoodMetaData();
        this.cf = this.newLevel;
        this.cg = this.newTotalExp;
        this.ch = 0.0f;
        this.aP = 0;
        this.setArrowCount(0, true);
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        ((EntityLiving)this).bK = true;
        this.bR = this.bQ;
        this.ba = null;
        ((EntityLiving)this).bL = null;
        ((EntityLiving)this).bG = new CombatTracker(this);
        this.cK = -1;
        if (this.keepLevel) {
            this.ch = exp;
        } else {
            this.d(this.newExp);
        }
        this.keepLevel = false;
        this.n(0.0, 0.0, 0.0);
        ((EntityLiving)this).bY = false;
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)super.getBukkitEntity();
    }

    public static final class RespawnConfig
    extends Record {
        private final ResourceKey<net.minecraft.world.level.World> b;
        private final BlockPosition c;
        private final float d;
        private final boolean e;
        public static final Codec<RespawnConfig> a = RecordCodecBuilder.create(instance -> instance.group((App)net.minecraft.world.level.World.h.optionalFieldOf("dimension", net.minecraft.world.level.World.i).forGetter(RespawnConfig::a), (App)BlockPosition.a.fieldOf("pos").forGetter(RespawnConfig::b), (App)Codec.FLOAT.optionalFieldOf("angle", (Object)Float.valueOf(0.0f)).forGetter(RespawnConfig::c), (App)Codec.BOOL.optionalFieldOf("forced", (Object)false).forGetter(RespawnConfig::d)).apply((Applicative)instance, RespawnConfig::new));

        public RespawnConfig(ResourceKey<net.minecraft.world.level.World> dimension, BlockPosition pos, float angle, boolean forced) {
            this.b = dimension;
            this.c = pos;
            this.d = angle;
            this.e = forced;
        }

        static ResourceKey<net.minecraft.world.level.World> b(@Nullable RespawnConfig respawnConfig) {
            return respawnConfig != null ? respawnConfig.a() : net.minecraft.world.level.World.i;
        }

        public boolean a(@Nullable RespawnConfig respawnConfig) {
            return respawnConfig != null && this.b == respawnConfig.b && this.c.equals(respawnConfig.c);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RespawnConfig.class, "dimension;pos;angle;forced", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RespawnConfig.class, "dimension;pos;angle;forced", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RespawnConfig.class, "dimension;pos;angle;forced", "b", "c", "d", "e"}, this, o2);
        }

        public ResourceKey<net.minecraft.world.level.World> a() {
            return this.b;
        }

        public BlockPosition b() {
            return this.c;
        }

        public float c() {
            return this.d;
        }

        public boolean d() {
            return this.e;
        }
    }

    public record RespawnPosAngle(Vec3D a, float b, boolean isBedSpawn, boolean isAnchorSpawn) {
        public static RespawnPosAngle of(Vec3D position, BlockPosition towardsPos, boolean isBedSpawn, boolean isAnchorSpawn) {
            return new RespawnPosAngle(position, RespawnPosAngle.b(position, towardsPos), isBedSpawn, isAnchorSpawn);
        }

        private static float b(Vec3D position, BlockPosition towardsPos) {
            Vec3D vec3 = Vec3D.c(towardsPos).d(position).d();
            return (float)MathHelper.d(MathHelper.d(vec3.f, vec3.d) * 180.0 / 3.1415927410125732 - 90.0);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this, o2);
        }
    }
}

